// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/registry/module/v1/module.proto

package modulev1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The visibility of a Module, currently either public or private.
type ModuleVisibility int32

const (
	ModuleVisibility_MODULE_VISIBILITY_UNSPECIFIED ModuleVisibility = 0
	// MODULE_VISIBILITY_PUBLIC says that the module is publicly available.
	ModuleVisibility_MODULE_VISIBILITY_PUBLIC ModuleVisibility = 1
	// MODULE_VISIBILITY_PRIVATE says that the module is private.
	ModuleVisibility_MODULE_VISIBILITY_PRIVATE ModuleVisibility = 2
)

// Enum value maps for ModuleVisibility.
var (
	ModuleVisibility_name = map[int32]string{
		0: "MODULE_VISIBILITY_UNSPECIFIED",
		1: "MODULE_VISIBILITY_PUBLIC",
		2: "MODULE_VISIBILITY_PRIVATE",
	}
	ModuleVisibility_value = map[string]int32{
		"MODULE_VISIBILITY_UNSPECIFIED": 0,
		"MODULE_VISIBILITY_PUBLIC":      1,
		"MODULE_VISIBILITY_PRIVATE":     2,
	}
)

func (x ModuleVisibility) Enum() *ModuleVisibility {
	p := new(ModuleVisibility)
	*p = x
	return p
}

func (x ModuleVisibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModuleVisibility) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1_module_proto_enumTypes[0].Descriptor()
}

func (ModuleVisibility) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1_module_proto_enumTypes[0]
}

func (x ModuleVisibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModuleVisibility.Descriptor instead.
func (ModuleVisibility) EnumDescriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_module_proto_rawDescGZIP(), []int{0}
}

// The state of a Module, currently either active or deprecated.
type ModuleState int32

const (
	ModuleState_MODULE_STATE_UNSPECIFIED ModuleState = 0
	// MODULE_STATE_ACTIVE says that the Module is currently active.
	ModuleState_MODULE_STATE_ACTIVE ModuleState = 1
	// MODULE_STATE_DEPRECATED says that the Module has been deprecated and should not longer be
	// used.
	ModuleState_MODULE_STATE_DEPRECATED ModuleState = 2
)

// Enum value maps for ModuleState.
var (
	ModuleState_name = map[int32]string{
		0: "MODULE_STATE_UNSPECIFIED",
		1: "MODULE_STATE_ACTIVE",
		2: "MODULE_STATE_DEPRECATED",
	}
	ModuleState_value = map[string]int32{
		"MODULE_STATE_UNSPECIFIED": 0,
		"MODULE_STATE_ACTIVE":      1,
		"MODULE_STATE_DEPRECATED":  2,
	}
)

func (x ModuleState) Enum() *ModuleState {
	p := new(ModuleState)
	*p = x
	return p
}

func (x ModuleState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModuleState) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1_module_proto_enumTypes[1].Descriptor()
}

func (ModuleState) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1_module_proto_enumTypes[1]
}

func (x ModuleState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModuleState.Descriptor instead.
func (ModuleState) EnumDescriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_module_proto_rawDescGZIP(), []int{1}
}

// A module within the BSR.
type Module struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the Module.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The time the Module was created on the BSR.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last time the Module was updated on the BSR.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The name of the Module.
	//
	// Unique within a given User or Organization.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The id of the User or Organization that owns the Module.
	OwnerId string `protobuf:"bytes,5,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// The Module's visibility, either public or private.
	Visibility ModuleVisibility `protobuf:"varint,6,opt,name=visibility,proto3,enum=buf.registry.module.v1.ModuleVisibility" json:"visibility,omitempty"`
	// The Module state, either active or deprecated.
	State ModuleState `protobuf:"varint,7,opt,name=state,proto3,enum=buf.registry.module.v1.ModuleState" json:"state,omitempty"`
	// The configurable description of the Module.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	// The configurable URL in the description of the Module,
	Url string `protobuf:"bytes,9,opt,name=url,proto3" json:"url,omitempty"`
	// The name of the default Label of the Module.
	//
	// This Label may not yet exist. When a Module is created, it has no Commits, and Labels
	// must have a Commit, so this Label is not created when a Module is created. Additionally,
	// a User may modify the name of the default Label without this Label yet being created.
	//
	// This could also be the name of an archived Label.
	DefaultLabelName string `protobuf:"bytes,10,opt,name=default_label_name,json=defaultLabelName,proto3" json:"default_label_name,omitempty"`
}

func (x *Module) Reset() {
	*x = Module{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_module_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Module) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Module) ProtoMessage() {}

func (x *Module) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Module.ProtoReflect.Descriptor instead.
func (*Module) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_module_proto_rawDescGZIP(), []int{0}
}

func (x *Module) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Module) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Module) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Module) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Module) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *Module) GetVisibility() ModuleVisibility {
	if x != nil {
		return x.Visibility
	}
	return ModuleVisibility_MODULE_VISIBILITY_UNSPECIFIED
}

func (x *Module) GetState() ModuleState {
	if x != nil {
		return x.State
	}
	return ModuleState_MODULE_STATE_UNSPECIFIED
}

func (x *Module) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Module) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Module) GetDefaultLabelName() string {
	if x != nil {
		return x.DefaultLabelName
	}
	return ""
}

// ModuleRef is a reference to a Module, either an id or a fully-qualified name.
//
// This is used in requests.
type ModuleRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*ModuleRef_Id
	//	*ModuleRef_Name_
	Value isModuleRef_Value `protobuf_oneof:"value"`
}

func (x *ModuleRef) Reset() {
	*x = ModuleRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_module_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModuleRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleRef) ProtoMessage() {}

func (x *ModuleRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModuleRef.ProtoReflect.Descriptor instead.
func (*ModuleRef) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_module_proto_rawDescGZIP(), []int{1}
}

func (m *ModuleRef) GetValue() isModuleRef_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *ModuleRef) GetId() string {
	if x, ok := x.GetValue().(*ModuleRef_Id); ok {
		return x.Id
	}
	return ""
}

func (x *ModuleRef) GetName() *ModuleRef_Name {
	if x, ok := x.GetValue().(*ModuleRef_Name_); ok {
		return x.Name
	}
	return nil
}

type isModuleRef_Value interface {
	isModuleRef_Value()
}

type ModuleRef_Id struct {
	// The id of the Module.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type ModuleRef_Name_ struct {
	// The fully-qualified name of the Module.
	Name *ModuleRef_Name `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*ModuleRef_Id) isModuleRef_Value() {}

func (*ModuleRef_Name_) isModuleRef_Value() {}

// The fully-qualified name of a Module within a BSR instance.
//
// A Name uniquely identifies a Module.
// This is used for requests when a caller only has the module name and not the ID.
type ModuleRef_Name struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the owner of the Module, either a User or Organization.
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the Module.
	Module string `protobuf:"bytes,2,opt,name=module,proto3" json:"module,omitempty"`
}

func (x *ModuleRef_Name) Reset() {
	*x = ModuleRef_Name{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_module_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModuleRef_Name) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleRef_Name) ProtoMessage() {}

func (x *ModuleRef_Name) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModuleRef_Name.ProtoReflect.Descriptor instead.
func (*ModuleRef_Name) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_module_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ModuleRef_Name) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *ModuleRef_Name) GetModule() string {
	if x != nil {
		return x.Module
	}
	return ""
}

var File_buf_registry_module_v1_module_proto protoreflect.FileDescriptor

var file_buf_registry_module_v1_module_proto_rawDesc = []byte{
	0x0a, 0x23, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x33, 0x62,
	0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xa6, 0x04, 0x0a, 0x06, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xba, 0x48, 0x08, 0xc8, 0x01, 0x01, 0x72,
	0x03, 0x88, 0x02, 0x01, 0x52, 0x02, 0x69, 0x64, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01,
	0x01, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x06,
	0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x09, 0xba, 0x48, 0x06, 0x72, 0x04, 0x10, 0x02, 0x18, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x26, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x0b, 0xba, 0x48, 0x08, 0xc8, 0x01, 0x01, 0x72, 0x03, 0x88, 0x02, 0x01,
	0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x55, 0x0a, 0x0a, 0x76, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x56, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x0b, 0xba, 0x48, 0x08, 0xc8, 0x01, 0x01, 0x82,
	0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x0b, 0xba, 0x48, 0x08, 0xc8, 0x01, 0x01, 0x82, 0x01, 0x02, 0x10,
	0x01, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba,
	0x48, 0x05, 0x72, 0x03, 0x18, 0xde, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0e, 0xba, 0x48, 0x0b, 0xd8, 0x01, 0x01, 0x72, 0x06, 0x18, 0xff, 0x01, 0x88, 0x01,
	0x01, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x39, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xba, 0x48, 0x08, 0xc8, 0x01, 0x01, 0x72, 0x03, 0x18, 0xfa, 0x01, 0x52,
	0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x3a, 0x06, 0xea, 0xc5, 0x2b, 0x02, 0x10, 0x01, 0x22, 0xca, 0x01, 0x0a, 0x09, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x12, 0x1a, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x88, 0x02, 0x01, 0x48, 0x00, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x1a, 0x4b, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0xba, 0x48, 0x07, 0xc8, 0x01, 0x01,
	0x72, 0x02, 0x18, 0x20, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x06, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xba, 0x48, 0x06,
	0x72, 0x04, 0x10, 0x02, 0x18, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x3a, 0x06,
	0xea, 0xc5, 0x2b, 0x02, 0x08, 0x01, 0x42, 0x0e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x05, 0xba, 0x48, 0x02, 0x08, 0x01, 0x2a, 0x72, 0x0a, 0x10, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x1d, 0x4d, 0x4f,
	0x44, 0x55, 0x4c, 0x45, 0x5f, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a,
	0x18, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c, 0x49,
	0x54, 0x59, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x4d,
	0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59,
	0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x02, 0x2a, 0x61, 0x0a, 0x0b, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x4f, 0x44,
	0x55, 0x4c, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x4d, 0x4f, 0x44, 0x55, 0x4c,
	0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01,
	0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x42, 0x57, 0x5a,
	0x55, 0x62, 0x75, 0x66, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67,
	0x6f, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_registry_module_v1_module_proto_rawDescOnce sync.Once
	file_buf_registry_module_v1_module_proto_rawDescData = file_buf_registry_module_v1_module_proto_rawDesc
)

func file_buf_registry_module_v1_module_proto_rawDescGZIP() []byte {
	file_buf_registry_module_v1_module_proto_rawDescOnce.Do(func() {
		file_buf_registry_module_v1_module_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_registry_module_v1_module_proto_rawDescData)
	})
	return file_buf_registry_module_v1_module_proto_rawDescData
}

var file_buf_registry_module_v1_module_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_buf_registry_module_v1_module_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_buf_registry_module_v1_module_proto_goTypes = []any{
	(ModuleVisibility)(0),         // 0: buf.registry.module.v1.ModuleVisibility
	(ModuleState)(0),              // 1: buf.registry.module.v1.ModuleState
	(*Module)(nil),                // 2: buf.registry.module.v1.Module
	(*ModuleRef)(nil),             // 3: buf.registry.module.v1.ModuleRef
	(*ModuleRef_Name)(nil),        // 4: buf.registry.module.v1.ModuleRef.Name
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_buf_registry_module_v1_module_proto_depIdxs = []int32{
	5, // 0: buf.registry.module.v1.Module.create_time:type_name -> google.protobuf.Timestamp
	5, // 1: buf.registry.module.v1.Module.update_time:type_name -> google.protobuf.Timestamp
	0, // 2: buf.registry.module.v1.Module.visibility:type_name -> buf.registry.module.v1.ModuleVisibility
	1, // 3: buf.registry.module.v1.Module.state:type_name -> buf.registry.module.v1.ModuleState
	4, // 4: buf.registry.module.v1.ModuleRef.name:type_name -> buf.registry.module.v1.ModuleRef.Name
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1_module_proto_init() }
func file_buf_registry_module_v1_module_proto_init() {
	if File_buf_registry_module_v1_module_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_buf_registry_module_v1_module_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Module); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_module_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ModuleRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_module_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ModuleRef_Name); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_buf_registry_module_v1_module_proto_msgTypes[1].OneofWrappers = []any{
		(*ModuleRef_Id)(nil),
		(*ModuleRef_Name_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_registry_module_v1_module_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_module_v1_module_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1_module_proto_depIdxs,
		EnumInfos:         file_buf_registry_module_v1_module_proto_enumTypes,
		MessageInfos:      file_buf_registry_module_v1_module_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1_module_proto = out.File
	file_buf_registry_module_v1_module_proto_rawDesc = nil
	file_buf_registry_module_v1_module_proto_goTypes = nil
	file_buf_registry_module_v1_module_proto_depIdxs = nil
}
