package domdebugger

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"
	"strings"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/runtime"
)

// DOMBreakpointType DOM breakpoint type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#type-DOMBreakpointType
type DOMBreakpointType string

// String returns the DOMBreakpointType as string value.
func (t DOMBreakpointType) String() string {
	return string(t)
}

// DOMBreakpointType values.
const (
	DOMBreakpointTypeSubtreeModified   DOMBreakpointType = "subtree-modified"
	DOMBreakpointTypeAttributeModified DOMBreakpointType = "attribute-modified"
	DOMBreakpointTypeNodeRemoved       DOMBreakpointType = "node-removed"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *DOMBreakpointType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch DOMBreakpointType(s) {
	case DOMBreakpointTypeSubtreeModified:
		*t = DOMBreakpointTypeSubtreeModified
	case DOMBreakpointTypeAttributeModified:
		*t = DOMBreakpointTypeAttributeModified
	case DOMBreakpointTypeNodeRemoved:
		*t = DOMBreakpointTypeNodeRemoved
	default:
		return fmt.Errorf("unknown DOMBreakpointType value: %v", s)
	}
	return nil
}

// CSPViolationType cSP Violation type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#type-CSPViolationType
type CSPViolationType string

// String returns the CSPViolationType as string value.
func (t CSPViolationType) String() string {
	return string(t)
}

// CSPViolationType values.
const (
	CSPViolationTypeTrustedtypeSinkViolation   CSPViolationType = "trustedtype-sink-violation"
	CSPViolationTypeTrustedtypePolicyViolation CSPViolationType = "trustedtype-policy-violation"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *CSPViolationType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch CSPViolationType(s) {
	case CSPViolationTypeTrustedtypeSinkViolation:
		*t = CSPViolationTypeTrustedtypeSinkViolation
	case CSPViolationTypeTrustedtypePolicyViolation:
		*t = CSPViolationTypeTrustedtypePolicyViolation
	default:
		return fmt.Errorf("unknown CSPViolationType value: %v", s)
	}
	return nil
}

// EventListener object event listener.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOMDebugger#type-EventListener
type EventListener struct {
	Type            string                `json:"type"`                               // EventListener's type.
	UseCapture      bool                  `json:"useCapture"`                         // EventListener's useCapture.
	Passive         bool                  `json:"passive"`                            // EventListener's passive flag.
	Once            bool                  `json:"once"`                               // EventListener's once flag.
	ScriptID        runtime.ScriptID      `json:"scriptId"`                           // Script id of the handler code.
	LineNumber      int64                 `json:"lineNumber"`                         // Line number in the script (0-based).
	ColumnNumber    int64                 `json:"columnNumber"`                       // Column number in the script (0-based).
	Handler         *runtime.RemoteObject `json:"handler,omitempty,omitzero"`         // Event handler function value.
	OriginalHandler *runtime.RemoteObject `json:"originalHandler,omitempty,omitzero"` // Event original handler function value.
	BackendNodeID   cdp.BackendNodeID     `json:"backendNodeId,omitempty,omitzero"`   // Node the listener is added to (if any).
}
