# Changelog

## [v0.22.0](https://github.com/go-swagger/go-swagger/tree/v0.22.0) (2020-02-02)

[Full Changelog](https://github.com/go-swagger/go-swagger/compare/v0.21.0...v0.22.0)

**Implemented enhancements:**

- Enable x-go-name in parameters [\#2167](https://github.com/go-swagger/go-swagger/issues/2167)
- How to generate a model with  JSON ',string' directive for an int64 properties? [\#2144](https://github.com/go-swagger/go-swagger/issues/2144)
- Swagger tags starting with integer make formatting errors in operations [\#2111](https://github.com/go-swagger/go-swagger/issues/2111)
- Swagger Tags interfere with imported packages [\#2057](https://github.com/go-swagger/go-swagger/issues/2057)
- Issue generating servers which have 'api' in their name [\#1971](https://github.com/go-swagger/go-swagger/issues/1971)
- Support go modules [\#1724](https://github.com/go-swagger/go-swagger/issues/1724)
- generate spec: json.RawMessage doesn't represent the intent. [\#1622](https://github.com/go-swagger/go-swagger/issues/1622)
- Generated code don't pass on go vet [\#1573](https://github.com/go-swagger/go-swagger/issues/1573)
- Could Client be a concrete implementation of an interface? [\#1138](https://github.com/go-swagger/go-swagger/issues/1138)
- Unable to override operations package name [\#1049](https://github.com/go-swagger/go-swagger/issues/1049)

**Fixed bugs:**

- Build fails due to duplicate methods [\#2199](https://github.com/go-swagger/go-swagger/issues/2199)
- Enum value "" generating code that does not compile [\#2139](https://github.com/go-swagger/go-swagger/issues/2139)
- byte type string causes "models/test\_swagger.go:43:6: k declared and not used" [\#2136](https://github.com/go-swagger/go-swagger/issues/2136)
- x-omitempty handling is incorrect with $ref [\#2116](https://github.com/go-swagger/go-swagger/issues/2116)
- Flatten \(and generate\) fails intermittently [\#2092](https://github.com/go-swagger/go-swagger/issues/2092)
- panic: Invalid schema provided to SchemaValidator: object has no key "default" [\#2063](https://github.com/go-swagger/go-swagger/issues/2063)
- Data Race between Serve\(\) and Shutdown\(\) [\#1943](https://github.com/go-swagger/go-swagger/issues/1943)
- doc.go fails to compile when passed a certain invalid mime-type [\#1663](https://github.com/go-swagger/go-swagger/issues/1663)
- Multiple media parameters on producers generate code that does not compile [\#1377](https://github.com/go-swagger/go-swagger/issues/1377)

**Closed issues:**

- Swagger adds to a spec not exported parameters fields [\#2164](https://github.com/go-swagger/go-swagger/issues/2164)
- generate client library: definition "" contains duplicate properties: \[\] \(or crash when --skip-validation\) [\#2156](https://github.com/go-swagger/go-swagger/issues/2156)
- model will not be generate if it's used as a map's value type in response body [\#2145](https://github.com/go-swagger/go-swagger/issues/2145)
- How do I specify the json body parameters within the Go code for "swagger:operation" like I do for "swagger:route"? [\#2134](https://github.com/go-swagger/go-swagger/issues/2134)
- why `generate operation` is required name option? [\#2123](https://github.com/go-swagger/go-swagger/issues/2123)
- Endless loop in `swagger generate spec` [\#2122](https://github.com/go-swagger/go-swagger/issues/2122)
- Add ability for server pre-shutdown hook [\#2108](https://github.com/go-swagger/go-swagger/issues/2108)
- File type in form-data  [\#2105](https://github.com/go-swagger/go-swagger/issues/2105)
- add parameters on router [\#2104](https://github.com/go-swagger/go-swagger/issues/2104)
-  unrecognized import path "dmitri.shuralyov.com/gpu/mtl" [\#2094](https://github.com/go-swagger/go-swagger/issues/2094)
- docs/guideline is outdated [\#2091](https://github.com/go-swagger/go-swagger/issues/2091)
- generated code can not pass gofmt  [\#2089](https://github.com/go-swagger/go-swagger/issues/2089)
- faq\_model.md link to more info about date is broken [\#2088](https://github.com/go-swagger/go-swagger/issues/2088)
- v0.21.0 not published on bintray [\#2085](https://github.com/go-swagger/go-swagger/issues/2085)
- Please create a new release [\#2080](https://github.com/go-swagger/go-swagger/issues/2080)
- Randomly getting peer connection reset error with the generated client [\#1954](https://github.com/go-swagger/go-swagger/issues/1954)
- swagger generate server exception [\#1882](https://github.com/go-swagger/go-swagger/issues/1882)
- Please add GPG Public Key to deb repo [\#1812](https://github.com/go-swagger/go-swagger/issues/1812)

**Merged pull requests:**

- \#2199 Remove the duplicate `withEnum` functions inside `scan` package [\#2200](https://github.com/go-swagger/go-swagger/pull/2200) ([sam016](https://github.com/sam016))
- regen samples [\#2196](https://github.com/go-swagger/go-swagger/pull/2196) ([fredbi](https://github.com/fredbi))
- updated go.mod with go get -u ./... && go mod tidy [\#2195](https://github.com/go-swagger/go-swagger/pull/2195) ([fredbi](https://github.com/fredbi))
- Throttle memory in codegen CI [\#2193](https://github.com/go-swagger/go-swagger/pull/2193) ([fredbi](https://github.com/fredbi))
- Fix client generation's mapvalidator with additionalProperties [\#2190](https://github.com/go-swagger/go-swagger/pull/2190) ([hmalphettes](https://github.com/hmalphettes))
- Review of codegen imports and package name mangling  [\#2181](https://github.com/go-swagger/go-swagger/pull/2181) ([fredbi](https://github.com/fredbi))
- fix some typo I find in custom-server.md   [\#2179](https://github.com/go-swagger/go-swagger/pull/2179) ([yuzp1996](https://github.com/yuzp1996))
- Fixed release Dockerfiles [\#2178](https://github.com/go-swagger/go-swagger/pull/2178) ([fredbi](https://github.com/fredbi))
- refactored code generator [\#2177](https://github.com/go-swagger/go-swagger/pull/2177) ([fredbi](https://github.com/fredbi))
- Feature/morlays enum [\#2176](https://github.com/go-swagger/go-swagger/pull/2176) ([sam016](https://github.com/sam016))
- CLI: refactored CLI commands to introduce command groups [\#2173](https://github.com/go-swagger/go-swagger/pull/2173) ([fredbi](https://github.com/fredbi))
- changes for \#2054 - extension fields in info.contact do not propagate… [\#2171](https://github.com/go-swagger/go-swagger/pull/2171) ([kul-amr](https://github.com/kul-amr))
- Fix processing type declarations [\#2169](https://github.com/go-swagger/go-swagger/pull/2169) ([novasharper](https://github.com/novasharper))
- feat\(parameters\): query & path parameters now accept x-go-name [\#2168](https://github.com/go-swagger/go-swagger/pull/2168) ([maxatome](https://github.com/maxatome))
- ignore not exported params fields [\#2165](https://github.com/go-swagger/go-swagger/pull/2165) ([mfranczy](https://github.com/mfranczy))
- fix typo [\#2162](https://github.com/go-swagger/go-swagger/pull/2162) ([derekperkins](https://github.com/derekperkins))
- fix: missing adding postDecls in response map field [\#2159](https://github.com/go-swagger/go-swagger/pull/2159) ([autumn31](https://github.com/autumn31))
- CI codegen [\#2158](https://github.com/go-swagger/go-swagger/pull/2158) ([fredbi](https://github.com/fredbi))
- add x-go-json-string [\#2157](https://github.com/go-swagger/go-swagger/pull/2157) ([mail2fish](https://github.com/mail2fish))
- fixed some edge cases when deconflicting client timeout parameters [\#2155](https://github.com/go-swagger/go-swagger/pull/2155) ([fredbi](https://github.com/fredbi))
- Speedup 'swagger generate' by not re-parsing schemas many times [\#2152](https://github.com/go-swagger/go-swagger/pull/2152) ([misha-ridge](https://github.com/misha-ridge))
- Client template interfaces [\#2151](https://github.com/go-swagger/go-swagger/pull/2151) ([fredbi](https://github.com/fredbi))
- Bugfix/data race serve shutdown [\#2150](https://github.com/go-swagger/go-swagger/pull/2150) ([fredbi](https://github.com/fredbi))
- fix\(doc\): fixed broken link in models FAQ [\#2149](https://github.com/go-swagger/go-swagger/pull/2149) ([fredbi](https://github.com/fredbi))
- Fixed x-omitempty in the case of $ref'ed schemas [\#2148](https://github.com/go-swagger/go-swagger/pull/2148) ([fredbi](https://github.com/fredbi))
- fix\(doc\): updated contributing guidelines [\#2147](https://github.com/go-swagger/go-swagger/pull/2147) ([fredbi](https://github.com/fredbi))
- fix\(model\): fixes validations for format="byte" \(no format validation\) [\#2146](https://github.com/go-swagger/go-swagger/pull/2146) ([fredbi](https://github.com/fredbi))
- Add support for empty enum values [\#2143](https://github.com/go-swagger/go-swagger/pull/2143) ([fredbi](https://github.com/fredbi))
- Fix overwriting security definitions on call Server.SetAPI\(\) [\#2140](https://github.com/go-swagger/go-swagger/pull/2140) ([h0mjam](https://github.com/h0mjam))
- fix endless loop issue for pkg import analysis [\#2138](https://github.com/go-swagger/go-swagger/pull/2138) ([mfranczy](https://github.com/mfranczy))
- Support multiple mime type specifications, with parameters [\#2120](https://github.com/go-swagger/go-swagger/pull/2120) ([fredbi](https://github.com/fredbi))
- Add .Context to location template context [\#2118](https://github.com/go-swagger/go-swagger/pull/2118) ([aeneasr](https://github.com/aeneasr))
- Support AllowTemplateOverride in `generate client` [\#2117](https://github.com/go-swagger/go-swagger/pull/2117) ([aeneasr](https://github.com/aeneasr))
- CI refactoring [\#2114](https://github.com/go-swagger/go-swagger/pull/2114) ([fredbi](https://github.com/fredbi))
- Issue:2108 - Adding files/tests to support PreServerShutdown - Take2 [\#2110](https://github.com/go-swagger/go-swagger/pull/2110) ([keperry](https://github.com/keperry))
- codescan: Natively support json.RawMessage [\#2107](https://github.com/go-swagger/go-swagger/pull/2107) ([aeneasr](https://github.com/aeneasr))
- support json tag with no name [\#2095](https://github.com/go-swagger/go-swagger/pull/2095) ([okhowang](https://github.com/okhowang))
- Update go-openapi/analysis [\#2093](https://github.com/go-swagger/go-swagger/pull/2093) ([fredbi](https://github.com/fredbi))
- fix: generated code can not pass gofmt \#2089 [\#2090](https://github.com/go-swagger/go-swagger/pull/2090) ([elonzh](https://github.com/elonzh))
- updates docs for deb install with apt-secure [\#2087](https://github.com/go-swagger/go-swagger/pull/2087) ([casualjim](https://github.com/casualjim))
- regenerated examples with v0.21.0 [\#2086](https://github.com/go-swagger/go-swagger/pull/2086) ([fredbi](https://github.com/fredbi))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
