// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Dblm API
//
// A description of the Dblm API
//

package dblm

import (
	"strings"
)

// VulnerabilityRiskLevelEnum Enum with underlying type: string
type VulnerabilityRiskLevelEnum string

// Set of constants representing the allowable values for VulnerabilityRiskLevelEnum
const (
	VulnerabilityRiskLevelCritical VulnerabilityRiskLevelEnum = "CRITICAL"
	VulnerabilityRiskLevelHigh     VulnerabilityRiskLevelEnum = "HIGH"
	VulnerabilityRiskLevelMedium   VulnerabilityRiskLevelEnum = "MEDIUM"
	VulnerabilityRiskLevelLow      VulnerabilityRiskLevelEnum = "LOW"
	VulnerabilityRiskLevelInfo     VulnerabilityRiskLevelEnum = "INFO"
)

var mappingVulnerabilityRiskLevelEnum = map[string]VulnerabilityRiskLevelEnum{
	"CRITICAL": VulnerabilityRiskLevelCritical,
	"HIGH":     VulnerabilityRiskLevelHigh,
	"MEDIUM":   VulnerabilityRiskLevelMedium,
	"LOW":      VulnerabilityRiskLevelLow,
	"INFO":     VulnerabilityRiskLevelInfo,
}

var mappingVulnerabilityRiskLevelEnumLowerCase = map[string]VulnerabilityRiskLevelEnum{
	"critical": VulnerabilityRiskLevelCritical,
	"high":     VulnerabilityRiskLevelHigh,
	"medium":   VulnerabilityRiskLevelMedium,
	"low":      VulnerabilityRiskLevelLow,
	"info":     VulnerabilityRiskLevelInfo,
}

// GetVulnerabilityRiskLevelEnumValues Enumerates the set of values for VulnerabilityRiskLevelEnum
func GetVulnerabilityRiskLevelEnumValues() []VulnerabilityRiskLevelEnum {
	values := make([]VulnerabilityRiskLevelEnum, 0)
	for _, v := range mappingVulnerabilityRiskLevelEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityRiskLevelEnumStringValues Enumerates the set of values in String for VulnerabilityRiskLevelEnum
func GetVulnerabilityRiskLevelEnumStringValues() []string {
	return []string{
		"CRITICAL",
		"HIGH",
		"MEDIUM",
		"LOW",
		"INFO",
	}
}

// GetMappingVulnerabilityRiskLevelEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityRiskLevelEnum(val string) (VulnerabilityRiskLevelEnum, bool) {
	enum, ok := mappingVulnerabilityRiskLevelEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
