// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package adm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListVulnerabilityAuditsRequest wrapper for the ListVulnerabilityAudits operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/adm/ListVulnerabilityAudits.go.html to see an example of how to use ListVulnerabilityAuditsRequest.
type ListVulnerabilityAuditsRequest struct {

	// A filter to return only resources that match the specified identifier.
	// Required only if the compartmentId query parameter is not specified.
	Id *string `mandatory:"false" contributesTo:"query" name:"id"`

	// A filter to return only resources that belong to the specified compartment identifier.
	// Required only if the id query param is not specified.
	CompartmentId *string `mandatory:"false" contributesTo:"query" name:"compartmentId"`

	// A filter to return only Vulnerability Audits that were created against the specified knowledge base.
	KnowledgeBaseId *string `mandatory:"false" contributesTo:"query" name:"knowledgeBaseId"`

	// A filter to return only successful or failed Vulnerability Audits.
	IsSuccess *bool `mandatory:"false" contributesTo:"query" name:"isSuccess"`

	// A filter to return only Vulnerability Audits that match the specified lifecycleState.
	LifecycleState VulnerabilityAuditLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListVulnerabilityAuditsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// The field used to sort Vulnerability Audits. Only one sort order is allowed.
	// Default order for _maxObservedCvssV2Score_ is **ascending**.
	// Default order for _maxObservedCvssV3Score_ is **ascending**.
	// Default order for _maxObservedCvssV2ScoreWithIgnored_ is **ascending**.
	// Default order for _maxObservedCvssV3ScoreWithIgnored_ is **ascending**.
	// Default order for _timeCreated_ is **descending**.
	// Default order for _vulnerableArtifactsCount_ is **ascending**.
	// Default order for _vulnerableArtifactsCountWithIgnored_ is **ascending**.
	// Default order for _maxObservedSeverity_ is **ascending**.
	// Default order for _maxObservedSeverityWithIgnored_ is **ascending**.
	// Default order for _displayName_ is **ascending**.
	SortBy ListVulnerabilityAuditsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// A filter to return only Vulnerability Audits with timeCreated greater or equal to the specified value.
	TimeCreatedGreaterThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeCreatedGreaterThanOrEqualTo"`

	// A filter to return only Vulnerability Audits with timeCreated less or equal to the specified value.
	TimeCreatedLessThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeCreatedLessThanOrEqualTo"`

	// A filter that returns only Vulnerability Audits that have a maximum observed Severity greater than or equal to the specified value.
	MaxObservedSeverityGreaterThanOrEqualTo ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum `mandatory:"false" contributesTo:"query" name:"maxObservedSeverityGreaterThanOrEqualTo" omitEmpty:"true"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListVulnerabilityAuditsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListVulnerabilityAuditsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListVulnerabilityAuditsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListVulnerabilityAuditsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListVulnerabilityAuditsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingVulnerabilityAuditLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetVulnerabilityAuditLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilityAuditsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListVulnerabilityAuditsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilityAuditsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListVulnerabilityAuditsSortByEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum(string(request.MaxObservedSeverityGreaterThanOrEqualTo)); !ok && request.MaxObservedSeverityGreaterThanOrEqualTo != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for MaxObservedSeverityGreaterThanOrEqualTo: %s. Supported values are: %s.", request.MaxObservedSeverityGreaterThanOrEqualTo, strings.Join(GetListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListVulnerabilityAuditsResponse wrapper for the ListVulnerabilityAudits operation
type ListVulnerabilityAuditsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of VulnerabilityAuditCollection instances
	VulnerabilityAuditCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListVulnerabilityAuditsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListVulnerabilityAuditsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListVulnerabilityAuditsSortOrderEnum Enum with underlying type: string
type ListVulnerabilityAuditsSortOrderEnum string

// Set of constants representing the allowable values for ListVulnerabilityAuditsSortOrderEnum
const (
	ListVulnerabilityAuditsSortOrderAsc  ListVulnerabilityAuditsSortOrderEnum = "ASC"
	ListVulnerabilityAuditsSortOrderDesc ListVulnerabilityAuditsSortOrderEnum = "DESC"
)

var mappingListVulnerabilityAuditsSortOrderEnum = map[string]ListVulnerabilityAuditsSortOrderEnum{
	"ASC":  ListVulnerabilityAuditsSortOrderAsc,
	"DESC": ListVulnerabilityAuditsSortOrderDesc,
}

var mappingListVulnerabilityAuditsSortOrderEnumLowerCase = map[string]ListVulnerabilityAuditsSortOrderEnum{
	"asc":  ListVulnerabilityAuditsSortOrderAsc,
	"desc": ListVulnerabilityAuditsSortOrderDesc,
}

// GetListVulnerabilityAuditsSortOrderEnumValues Enumerates the set of values for ListVulnerabilityAuditsSortOrderEnum
func GetListVulnerabilityAuditsSortOrderEnumValues() []ListVulnerabilityAuditsSortOrderEnum {
	values := make([]ListVulnerabilityAuditsSortOrderEnum, 0)
	for _, v := range mappingListVulnerabilityAuditsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityAuditsSortOrderEnumStringValues Enumerates the set of values in String for ListVulnerabilityAuditsSortOrderEnum
func GetListVulnerabilityAuditsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListVulnerabilityAuditsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityAuditsSortOrderEnum(val string) (ListVulnerabilityAuditsSortOrderEnum, bool) {
	enum, ok := mappingListVulnerabilityAuditsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilityAuditsSortByEnum Enum with underlying type: string
type ListVulnerabilityAuditsSortByEnum string

// Set of constants representing the allowable values for ListVulnerabilityAuditsSortByEnum
const (
	ListVulnerabilityAuditsSortByMaxobservedcvssv2score              ListVulnerabilityAuditsSortByEnum = "maxObservedCvssV2Score"
	ListVulnerabilityAuditsSortByMaxobservedcvssv3score              ListVulnerabilityAuditsSortByEnum = "maxObservedCvssV3Score"
	ListVulnerabilityAuditsSortByMaxobservedseverity                 ListVulnerabilityAuditsSortByEnum = "maxObservedSeverity"
	ListVulnerabilityAuditsSortByTimecreated                         ListVulnerabilityAuditsSortByEnum = "timeCreated"
	ListVulnerabilityAuditsSortByVulnerableartifactscount            ListVulnerabilityAuditsSortByEnum = "vulnerableArtifactsCount"
	ListVulnerabilityAuditsSortByMaxobservedcvssv2scorewithignored   ListVulnerabilityAuditsSortByEnum = "maxObservedCvssV2ScoreWithIgnored"
	ListVulnerabilityAuditsSortByMaxobservedcvssv3scorewithignored   ListVulnerabilityAuditsSortByEnum = "maxObservedCvssV3ScoreWithIgnored"
	ListVulnerabilityAuditsSortByMaxobservedseveritywithignored      ListVulnerabilityAuditsSortByEnum = "maxObservedSeverityWithIgnored"
	ListVulnerabilityAuditsSortByVulnerableartifactscountwithignored ListVulnerabilityAuditsSortByEnum = "vulnerableArtifactsCountWithIgnored"
	ListVulnerabilityAuditsSortByDisplayname                         ListVulnerabilityAuditsSortByEnum = "displayName"
)

var mappingListVulnerabilityAuditsSortByEnum = map[string]ListVulnerabilityAuditsSortByEnum{
	"maxObservedCvssV2Score":              ListVulnerabilityAuditsSortByMaxobservedcvssv2score,
	"maxObservedCvssV3Score":              ListVulnerabilityAuditsSortByMaxobservedcvssv3score,
	"maxObservedSeverity":                 ListVulnerabilityAuditsSortByMaxobservedseverity,
	"timeCreated":                         ListVulnerabilityAuditsSortByTimecreated,
	"vulnerableArtifactsCount":            ListVulnerabilityAuditsSortByVulnerableartifactscount,
	"maxObservedCvssV2ScoreWithIgnored":   ListVulnerabilityAuditsSortByMaxobservedcvssv2scorewithignored,
	"maxObservedCvssV3ScoreWithIgnored":   ListVulnerabilityAuditsSortByMaxobservedcvssv3scorewithignored,
	"maxObservedSeverityWithIgnored":      ListVulnerabilityAuditsSortByMaxobservedseveritywithignored,
	"vulnerableArtifactsCountWithIgnored": ListVulnerabilityAuditsSortByVulnerableartifactscountwithignored,
	"displayName":                         ListVulnerabilityAuditsSortByDisplayname,
}

var mappingListVulnerabilityAuditsSortByEnumLowerCase = map[string]ListVulnerabilityAuditsSortByEnum{
	"maxobservedcvssv2score":              ListVulnerabilityAuditsSortByMaxobservedcvssv2score,
	"maxobservedcvssv3score":              ListVulnerabilityAuditsSortByMaxobservedcvssv3score,
	"maxobservedseverity":                 ListVulnerabilityAuditsSortByMaxobservedseverity,
	"timecreated":                         ListVulnerabilityAuditsSortByTimecreated,
	"vulnerableartifactscount":            ListVulnerabilityAuditsSortByVulnerableartifactscount,
	"maxobservedcvssv2scorewithignored":   ListVulnerabilityAuditsSortByMaxobservedcvssv2scorewithignored,
	"maxobservedcvssv3scorewithignored":   ListVulnerabilityAuditsSortByMaxobservedcvssv3scorewithignored,
	"maxobservedseveritywithignored":      ListVulnerabilityAuditsSortByMaxobservedseveritywithignored,
	"vulnerableartifactscountwithignored": ListVulnerabilityAuditsSortByVulnerableartifactscountwithignored,
	"displayname":                         ListVulnerabilityAuditsSortByDisplayname,
}

// GetListVulnerabilityAuditsSortByEnumValues Enumerates the set of values for ListVulnerabilityAuditsSortByEnum
func GetListVulnerabilityAuditsSortByEnumValues() []ListVulnerabilityAuditsSortByEnum {
	values := make([]ListVulnerabilityAuditsSortByEnum, 0)
	for _, v := range mappingListVulnerabilityAuditsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityAuditsSortByEnumStringValues Enumerates the set of values in String for ListVulnerabilityAuditsSortByEnum
func GetListVulnerabilityAuditsSortByEnumStringValues() []string {
	return []string{
		"maxObservedCvssV2Score",
		"maxObservedCvssV3Score",
		"maxObservedSeverity",
		"timeCreated",
		"vulnerableArtifactsCount",
		"maxObservedCvssV2ScoreWithIgnored",
		"maxObservedCvssV3ScoreWithIgnored",
		"maxObservedSeverityWithIgnored",
		"vulnerableArtifactsCountWithIgnored",
		"displayName",
	}
}

// GetMappingListVulnerabilityAuditsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityAuditsSortByEnum(val string) (ListVulnerabilityAuditsSortByEnum, bool) {
	enum, ok := mappingListVulnerabilityAuditsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum Enum with underlying type: string
type ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum string

// Set of constants representing the allowable values for ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum
const (
	ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToNone     ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum = "NONE"
	ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToLow      ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum = "LOW"
	ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToMedium   ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum = "MEDIUM"
	ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToHigh     ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum = "HIGH"
	ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToCritical ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum = "CRITICAL"
)

var mappingListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum = map[string]ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum{
	"NONE":     ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToNone,
	"LOW":      ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToLow,
	"MEDIUM":   ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToMedium,
	"HIGH":     ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToHigh,
	"CRITICAL": ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToCritical,
}

var mappingListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnumLowerCase = map[string]ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum{
	"none":     ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToNone,
	"low":      ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToLow,
	"medium":   ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToMedium,
	"high":     ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToHigh,
	"critical": ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToCritical,
}

// GetListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnumValues Enumerates the set of values for ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum
func GetListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnumValues() []ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum {
	values := make([]ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum, 0)
	for _, v := range mappingListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnumStringValues Enumerates the set of values in String for ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum
func GetListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum(val string) (ListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnum, bool) {
	enum, ok := mappingListVulnerabilityAuditsMaxObservedSeverityGreaterThanOrEqualToEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
