// Copyright 2024 the u-root Authors. All rights reserved
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package main

// This file is an allow-list of go packages that have to be passed for the CI
// to be green. Until all u-root packages are passing, this list will be
// updated manually.
// For completeness, the currently not working packages are listed, but
// commented out.

var (
	tinygoCore = []string{
		"backoff",
		"base64",
		"basename",
		"bb",
		// "bind",
		"blkid",
		"brctl",
		"build_errors",
		"builds",
		"cat",
		"chmod",
		"chroot",
		"cmp",
		"comm",
		"cp",
		"cpio",
		"date",
		"dd",
		"df",
		// "dhclient",
		"dirname",
		"dmesg",
		"du",
		"echo",
		"false",
		"find",
		"free",
		"fusermount",
		"gosh",
		"gpgv",
		"gpt",
		"grep",
		"gzip",
		"head",
		"hexdump",
		"hostname",
		"hwclock",
		"id",
		"init",
		"insmod",
		"io",
		"ip",
		"kexec",
		"kill",
		"lddfiles",
		"ln",
		"lockmsrs",
		"losetup",
		"ls",
		"lsdrivers",
		"lsmod",
		"makebb-archie2x",
		"man",
		"md5sum",
		"mkdir",
		"mkfifo",
		"mknod",
		"mktemp",
		"more",
		"mount",
		"msr",
		"mv",
		// "netcat",
		// "netstat",
		"nohup",
		"ntpdate",
		"pci",
		// "ping",
		"poweroff",
		"printenv",
		"ps",
		"pwd",
		"rdmsr",
		"readlink",
		"realpath",
		"rm",
		"rmmod",
		"rsdp",
		"scp",
		"seq",
		"service",
		"shasum",
		"shutdown",
		"sleep",
		// "sluinit",
		"sort",
		// "sshd",
		"strace",
		"strings",
		"stty",
		"switch_root",
		"sync",
		"tail",
		"tar",
		"tee",
		"time",
		"timeout",
		"touch",
		"tr",
		"true",
		"truncate",
		"ts",
		"tty",
		"umount",
		"uname",
		"uniq",
		"unmount",
		"unshare",
		"update-rc.d",
		"uptime",
		"watchdog",
		"watchdogd",
		"wc",
		// "wget",
		"which",
		"xargs",
		"yes",
	}

	tinygoExp = []string{
		"acpicat",
		"acpigrep",
		"ansi",
		"bootvars",
		"bzimage",
		"cbmem",
		"console",
		"crc",
		"disk_unlock",
		"dmidecode",
		"dumpebda",
		"dumpmemmap",
		"ectool",
		"ed",
		"efivarfs",
		"esxiboot",
		// "fbnetboot",
		"fbsplash",
		"fdtdump",
		"field",
		"fixrsdp",
		"forth",
		"freq",
		"getty",
		"hdparm",
		"ipmidump",
		"kconf",
		"localboot",
		"lsfabric",
		"lsfd",
		"madeye",
		"modprobe",
		// "netbootxyz",
		// "newsshd",
		"nvme_unlock",
		"page",
		"partprobe",
		"pflask",
		"pidof",
		"pox",
		// "pxeserver",
		"readelf",
		"readpe",
		// "run",
		"rush",
		"serial",
		"smbios_transfer",
		"smn",
		"srvfiles",
		"ssh",
		"syscallfilter",
		"systemboot",
		"tac",
		"tc",
		// "tcpdump",
		"tcz",
		// "tftp",
		// "traceroute",
		"uefiboot",
		"vboot",
		"vmboot",
		"watch",
		"zbi",
		"zimage",
	}
	StatusQuo = append(tinygoCore, tinygoExp...)

	// There are good reasons to ignore some packages, e.g. they are guaranteed
	// not to build for a certain OS, e.g. bind only works for p9 builds.
	Ignore = map[string][]string{
		"bind": {"linux", "freebsd", "darwin", "windows"},
	}
)
