// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package bigqueryreservation provides access to the BigQuery Reservation API.
//
// For product documentation, see: https://cloud.google.com/bigquery/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/bigqueryreservation/v1"
//	...
//	ctx := context.Background()
//	bigqueryreservationService, err := bigqueryreservation.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	bigqueryreservationService, err := bigqueryreservation.NewService(ctx, option.WithScopes(bigqueryreservation.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	bigqueryreservationService, err := bigqueryreservation.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	bigqueryreservationService, err := bigqueryreservation.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package bigqueryreservation // import "google.golang.org/api/bigqueryreservation/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "bigqueryreservation:v1"
const apiName = "bigqueryreservation"
const apiVersion = "v1"
const basePath = "https://bigqueryreservation.googleapis.com/"
const basePathTemplate = "https://bigqueryreservation.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://bigqueryreservation.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your data in Google BigQuery and see the email address for
	// your Google Account
	BigqueryScope = "https://www.googleapis.com/auth/bigquery"

	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/bigquery",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.CapacityCommitments = NewProjectsLocationsCapacityCommitmentsService(s)
	rs.ReservationGroups = NewProjectsLocationsReservationGroupsService(s)
	rs.Reservations = NewProjectsLocationsReservationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	CapacityCommitments *ProjectsLocationsCapacityCommitmentsService

	ReservationGroups *ProjectsLocationsReservationGroupsService

	Reservations *ProjectsLocationsReservationsService
}

func NewProjectsLocationsCapacityCommitmentsService(s *Service) *ProjectsLocationsCapacityCommitmentsService {
	rs := &ProjectsLocationsCapacityCommitmentsService{s: s}
	return rs
}

type ProjectsLocationsCapacityCommitmentsService struct {
	s *Service
}

func NewProjectsLocationsReservationGroupsService(s *Service) *ProjectsLocationsReservationGroupsService {
	rs := &ProjectsLocationsReservationGroupsService{s: s}
	return rs
}

type ProjectsLocationsReservationGroupsService struct {
	s *Service
}

func NewProjectsLocationsReservationsService(s *Service) *ProjectsLocationsReservationsService {
	rs := &ProjectsLocationsReservationsService{s: s}
	rs.Assignments = NewProjectsLocationsReservationsAssignmentsService(s)
	return rs
}

type ProjectsLocationsReservationsService struct {
	s *Service

	Assignments *ProjectsLocationsReservationsAssignmentsService
}

func NewProjectsLocationsReservationsAssignmentsService(s *Service) *ProjectsLocationsReservationsAssignmentsService {
	rs := &ProjectsLocationsReservationsAssignmentsService{s: s}
	return rs
}

type ProjectsLocationsReservationsAssignmentsService struct {
	s *Service
}

// Assignment: An assignment allows a project to submit jobs of a certain type
// using slots from the specified reservation.
type Assignment struct {
	// Assignee: Optional. The resource which will use the reservation. E.g.
	// `projects/myproject`, `folders/123`, or `organizations/456`.
	Assignee string `json:"assignee,omitempty"`
	// EnableGeminiInBigquery: Optional. This field controls if "Gemini in
	// BigQuery" (https://cloud.google.com/gemini/docs/bigquery/overview) features
	// should be enabled for this reservation assignment, which is not on by
	// default. "Gemini in BigQuery" has a distinct compliance posture from
	// BigQuery. If this field is set to true, the assignment job type is QUERY,
	// and the parent reservation edition is ENTERPRISE_PLUS, then the assignment
	// will give the grantee project/organization access to "Gemini in BigQuery"
	// features.
	EnableGeminiInBigquery bool `json:"enableGeminiInBigquery,omitempty"`
	// JobType: Optional. Which type of jobs will use the reservation.
	//
	// Possible values:
	//   "JOB_TYPE_UNSPECIFIED" - Invalid type. Requests with this value will be
	// rejected with error code `google.rpc.Code.INVALID_ARGUMENT`.
	//   "PIPELINE" - Pipeline (load/export) jobs from the project will use the
	// reservation.
	//   "QUERY" - Query jobs from the project will use the reservation.
	//   "ML_EXTERNAL" - BigQuery ML jobs that use services external to BigQuery
	// for model training. These jobs will not utilize idle slots from other
	// reservations.
	//   "BACKGROUND" - Background jobs that BigQuery runs for the customers in the
	// background.
	//   "CONTINUOUS" - Continuous SQL jobs will use this reservation. Reservations
	// with continuous assignments cannot be mixed with non-continuous assignments.
	//   "BACKGROUND_CHANGE_DATA_CAPTURE" - Finer granularity background jobs for
	// capturing changes in a source database and streaming them into BigQuery.
	// Reservations with this job type take priority over a default BACKGROUND
	// reservation assignment (if it exists).
	//   "BACKGROUND_COLUMN_METADATA_INDEX" - Finer granularity background jobs for
	// refreshing cached metadata for BigQuery tables. Reservations with this job
	// type take priority over a default BACKGROUND reservation assignment (if it
	// exists).
	//   "BACKGROUND_SEARCH_INDEX_REFRESH" - Finer granularity background jobs for
	// refreshing search indexes upon BigQuery table columns. Reservations with
	// this job type take priority over a default BACKGROUND reservation assignment
	// (if it exists).
	JobType string `json:"jobType,omitempty"`
	// Name: Output only. Name of the resource. E.g.:
	// `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
	// The assignment_id must only contain lower case alphanumeric characters or
	// dashes and the max length is 64 characters.
	Name string `json:"name,omitempty"`
	// State: Output only. State of the assignment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Invalid state value.
	//   "PENDING" - Queries from assignee will be executed as on-demand, if
	// related assignment is pending.
	//   "ACTIVE" - Assignment is ready.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Assignee") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assignee") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Assignment) MarshalJSON() ([]byte, error) {
	type NoMethod Assignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Autoscale: Auto scaling settings.
type Autoscale struct {
	// CurrentSlots: Output only. The slot capacity added to this reservation when
	// autoscale happens. Will be between [0, max_slots]. Note: after users reduce
	// max_slots, it may take a while before it can be propagated, so current_slots
	// may stay in the original value and could be larger than max_slots for that
	// brief period (less than one minute)
	CurrentSlots int64 `json:"currentSlots,omitempty,string"`
	// MaxSlots: Optional. Number of slots to be scaled when needed.
	MaxSlots int64 `json:"maxSlots,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrentSlots") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentSlots") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Autoscale) MarshalJSON() ([]byte, error) {
	type NoMethod Autoscale
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BiReservation: Represents a BI Reservation.
type BiReservation struct {
	// Name: Identifier. The resource name of the singleton BI reservation.
	// Reservation names have the form
	// `projects/{project_id}/locations/{location_id}/biReservation`.
	Name string `json:"name,omitempty"`
	// PreferredTables: Optional. Preferred tables to use BI capacity for.
	PreferredTables []*TableReference `json:"preferredTables,omitempty"`
	// Size: Optional. Size of a reservation, in bytes.
	Size int64 `json:"size,omitempty,string"`
	// UpdateTime: Output only. The last update timestamp of a reservation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BiReservation) MarshalJSON() ([]byte, error) {
	type NoMethod BiReservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CapacityCommitment: Capacity commitment is a way to purchase compute
// capacity for BigQuery jobs (in the form of slots) with some committed period
// of usage. Annual commitments renew by default. Commitments can be removed
// after their commitment end time passes. In order to remove annual
// commitment, its plan needs to be changed to monthly or flex first. A
// capacity commitment resource exists as a child resource of the admin
// project.
type CapacityCommitment struct {
	// CommitmentEndTime: Output only. The end of the current commitment period. It
	// is applicable only for ACTIVE capacity commitments. Note after renewal,
	// commitment_end_time is the time the renewed commitment expires. So itwould
	// be at a time after commitment_start_time + committed period, because we
	// don't change commitment_start_time ,
	CommitmentEndTime string `json:"commitmentEndTime,omitempty"`
	// CommitmentStartTime: Output only. The start of the current commitment
	// period. It is applicable only for ACTIVE capacity commitments. Note after
	// the commitment is renewed, commitment_start_time won't be changed. It refers
	// to the start time of the original commitment.
	CommitmentStartTime string `json:"commitmentStartTime,omitempty"`
	// Edition: Optional. Edition of the capacity commitment.
	//
	// Possible values:
	//   "EDITION_UNSPECIFIED" - Default value, which will be treated as
	// ENTERPRISE.
	//   "STANDARD" - Standard edition.
	//   "ENTERPRISE" - Enterprise edition.
	//   "ENTERPRISE_PLUS" - Enterprise Plus edition.
	Edition string `json:"edition,omitempty"`
	// FailureStatus: Output only. For FAILED commitment plan, provides the reason
	// of failure.
	FailureStatus *Status `json:"failureStatus,omitempty"`
	// IsFlatRate: Output only. If true, the commitment is a flat-rate commitment,
	// otherwise, it's an edition commitment.
	IsFlatRate bool `json:"isFlatRate,omitempty"`
	// MultiRegionAuxiliary: Applicable only for commitments located within one of
	// the BigQuery multi-regions (US or EU). If set to true, this commitment is
	// placed in the organization's secondary region which is designated for
	// disaster recovery purposes. If false, this commitment is placed in the
	// organization's default region. NOTE: this is a preview feature. Project must
	// be allow-listed in order to set this field.
	MultiRegionAuxiliary bool `json:"multiRegionAuxiliary,omitempty"`
	// Name: Output only. The resource name of the capacity commitment, e.g.,
	// `projects/myproject/locations/US/capacityCommitments/123` The commitment_id
	// must only contain lower case alphanumeric characters or dashes. It must
	// start with a letter and must not end with a dash. Its maximum length is 64
	// characters.
	Name string `json:"name,omitempty"`
	// Plan: Optional. Capacity commitment commitment plan.
	//
	// Possible values:
	//   "COMMITMENT_PLAN_UNSPECIFIED" - Invalid plan value. Requests with this
	// value will be rejected with error code `google.rpc.Code.INVALID_ARGUMENT`.
	//   "FLEX" - Flex commitments have committed period of 1 minute after becoming
	// ACTIVE. After that, they are not in a committed period anymore and can be
	// removed any time.
	//   "FLEX_FLAT_RATE" - Same as FLEX, should only be used if flat-rate
	// commitments are still available.
	//   "TRIAL" - Trial commitments have a committed period of 182 days after
	// becoming ACTIVE. After that, they are converted to a new commitment based on
	// the `renewal_plan`. Default `renewal_plan` for Trial commitment is Flex so
	// that it can be deleted right after committed period ends.
	//   "MONTHLY" - Monthly commitments have a committed period of 30 days after
	// becoming ACTIVE. After that, they are not in a committed period anymore and
	// can be removed any time.
	//   "MONTHLY_FLAT_RATE" - Same as MONTHLY, should only be used if flat-rate
	// commitments are still available.
	//   "ANNUAL" - Annual commitments have a committed period of 365 days after
	// becoming ACTIVE. After that they are converted to a new commitment based on
	// the renewal_plan.
	//   "ANNUAL_FLAT_RATE" - Same as ANNUAL, should only be used if flat-rate
	// commitments are still available.
	//   "THREE_YEAR" - 3-year commitments have a committed period of 1095(3 * 365)
	// days after becoming ACTIVE. After that they are converted to a new
	// commitment based on the renewal_plan.
	//   "NONE" - Should only be used for `renewal_plan` and is only meaningful if
	// edition is specified to values other than EDITION_UNSPECIFIED. Otherwise
	// CreateCapacityCommitmentRequest or UpdateCapacityCommitmentRequest will be
	// rejected with error code `google.rpc.Code.INVALID_ARGUMENT`. If the
	// renewal_plan is NONE, capacity commitment will be removed at the end of its
	// commitment period.
	Plan string `json:"plan,omitempty"`
	// RenewalPlan: Optional. The plan this capacity commitment is converted to
	// after commitment_end_time passes. Once the plan is changed, committed period
	// is extended according to commitment plan. Only applicable for ANNUAL and
	// TRIAL commitments.
	//
	// Possible values:
	//   "COMMITMENT_PLAN_UNSPECIFIED" - Invalid plan value. Requests with this
	// value will be rejected with error code `google.rpc.Code.INVALID_ARGUMENT`.
	//   "FLEX" - Flex commitments have committed period of 1 minute after becoming
	// ACTIVE. After that, they are not in a committed period anymore and can be
	// removed any time.
	//   "FLEX_FLAT_RATE" - Same as FLEX, should only be used if flat-rate
	// commitments are still available.
	//   "TRIAL" - Trial commitments have a committed period of 182 days after
	// becoming ACTIVE. After that, they are converted to a new commitment based on
	// the `renewal_plan`. Default `renewal_plan` for Trial commitment is Flex so
	// that it can be deleted right after committed period ends.
	//   "MONTHLY" - Monthly commitments have a committed period of 30 days after
	// becoming ACTIVE. After that, they are not in a committed period anymore and
	// can be removed any time.
	//   "MONTHLY_FLAT_RATE" - Same as MONTHLY, should only be used if flat-rate
	// commitments are still available.
	//   "ANNUAL" - Annual commitments have a committed period of 365 days after
	// becoming ACTIVE. After that they are converted to a new commitment based on
	// the renewal_plan.
	//   "ANNUAL_FLAT_RATE" - Same as ANNUAL, should only be used if flat-rate
	// commitments are still available.
	//   "THREE_YEAR" - 3-year commitments have a committed period of 1095(3 * 365)
	// days after becoming ACTIVE. After that they are converted to a new
	// commitment based on the renewal_plan.
	//   "NONE" - Should only be used for `renewal_plan` and is only meaningful if
	// edition is specified to values other than EDITION_UNSPECIFIED. Otherwise
	// CreateCapacityCommitmentRequest or UpdateCapacityCommitmentRequest will be
	// rejected with error code `google.rpc.Code.INVALID_ARGUMENT`. If the
	// renewal_plan is NONE, capacity commitment will be removed at the end of its
	// commitment period.
	RenewalPlan string `json:"renewalPlan,omitempty"`
	// SlotCount: Optional. Number of slots in this commitment.
	SlotCount int64 `json:"slotCount,omitempty,string"`
	// State: Output only. State of the commitment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Invalid state value.
	//   "PENDING" - Capacity commitment is pending provisioning. Pending capacity
	// commitment does not contribute to the project's slot_capacity.
	//   "ACTIVE" - Once slots are provisioned, capacity commitment becomes active.
	// slot_count is added to the project's slot_capacity.
	//   "FAILED" - Capacity commitment is failed to be activated by the backend.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CommitmentEndTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommitmentEndTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CapacityCommitment) MarshalJSON() ([]byte, error) {
	type NoMethod CapacityCommitment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FailoverReservationRequest: The request for
// ReservationService.FailoverReservation.
type FailoverReservationRequest struct {
	// FailoverMode: Optional. A parameter that determines how writes that are
	// pending replication are handled after a failover is initiated. If not
	// specified, HARD failover mode is used by default.
	//
	// Possible values:
	//   "FAILOVER_MODE_UNSPECIFIED" - Invalid value.
	//   "SOFT" - When customers initiate a soft failover, BigQuery will wait until
	// all committed writes are replicated to the secondary. This mode requires
	// both regions to be available for the failover to succeed and prevents data
	// loss.
	//   "HARD" - When customers initiate a hard failover, BigQuery will not wait
	// until all committed writes are replicated to the secondary. There can be
	// data loss for hard failover.
	FailoverMode string `json:"failoverMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailoverMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailoverMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FailoverReservationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod FailoverReservationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAssignmentsResponse: The response for
// ReservationService.ListAssignments.
type ListAssignmentsResponse struct {
	// Assignments: List of assignments visible to the user.
	Assignments []*Assignment `json:"assignments,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Assignments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assignments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAssignmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAssignmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCapacityCommitmentsResponse: The response for
// ReservationService.ListCapacityCommitments.
type ListCapacityCommitmentsResponse struct {
	// CapacityCommitments: List of capacity commitments visible to the user.
	CapacityCommitments []*CapacityCommitment `json:"capacityCommitments,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CapacityCommitments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CapacityCommitments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCapacityCommitmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCapacityCommitmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReservationGroupsResponse: The response for
// ReservationService.ListReservationGroups.
type ListReservationGroupsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ReservationGroups: List of reservations visible to the user.
	ReservationGroups []*ReservationGroup `json:"reservationGroups,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReservationGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReservationGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReservationsResponse: The response for
// ReservationService.ListReservations.
type ListReservationsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Reservations: List of reservations visible to the user.
	Reservations []*Reservation `json:"reservations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReservationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReservationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MergeCapacityCommitmentsRequest: The request for
// ReservationService.MergeCapacityCommitments.
type MergeCapacityCommitmentsRequest struct {
	// CapacityCommitmentId: Optional. The optional resulting capacity commitment
	// ID. Capacity commitment name will be generated automatically if this field
	// is empty. This field must only contain lower case alphanumeric characters or
	// dashes. The first and last character cannot be a dash. Max length is 64
	// characters.
	CapacityCommitmentId string `json:"capacityCommitmentId,omitempty"`
	// CapacityCommitmentIds: Ids of capacity commitments to merge. These capacity
	// commitments must exist under admin project and location specified in the
	// parent. ID is the last portion of capacity commitment name e.g., 'abc' for
	// projects/myproject/locations/US/capacityCommitments/abc
	CapacityCommitmentIds []string `json:"capacityCommitmentIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CapacityCommitmentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CapacityCommitmentId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MergeCapacityCommitmentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod MergeCapacityCommitmentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MoveAssignmentRequest: The request for ReservationService.MoveAssignment.
// **Note**: "bigquery.reservationAssignments.create" permission is required on
// the destination_id. **Note**: "bigquery.reservationAssignments.create" and
// "bigquery.reservationAssignments.delete" permission are required on the
// related assignee.
type MoveAssignmentRequest struct {
	// AssignmentId: The optional assignment ID. A new assignment name is generated
	// if this field is empty. This field can contain only lowercase alphanumeric
	// characters or dashes. Max length is 64 characters.
	AssignmentId string `json:"assignmentId,omitempty"`
	// DestinationId: The new reservation ID, e.g.:
	// `projects/myotherproject/locations/US/reservations/team2-prod`
	DestinationId string `json:"destinationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssignmentId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssignmentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MoveAssignmentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod MoveAssignmentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReplicationStatus: Disaster Recovery(DR) replication status of the
// reservation.
type ReplicationStatus struct {
	// Error: Output only. The last error encountered while trying to replicate
	// changes from the primary to the secondary. This field is only available if
	// the replication has not succeeded since.
	Error *Status `json:"error,omitempty"`
	// LastErrorTime: Output only. The time at which the last error was encountered
	// while trying to replicate changes from the primary to the secondary. This
	// field is only available if the replication has not succeeded since.
	LastErrorTime string `json:"lastErrorTime,omitempty"`
	// LastReplicationTime: Output only. A timestamp corresponding to the last
	// change on the primary that was successfully replicated to the secondary.
	LastReplicationTime string `json:"lastReplicationTime,omitempty"`
	// SoftFailoverStartTime: Output only. The time at which a soft failover for
	// the reservation and its associated datasets was initiated. After this field
	// is set, all subsequent changes to the reservation will be rejected unless a
	// hard failover overrides this operation. This field will be cleared once the
	// failover is complete.
	SoftFailoverStartTime string `json:"softFailoverStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReplicationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ReplicationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Reservation: A reservation is a mechanism used to guarantee slots to users.
type Reservation struct {
	// Autoscale: Optional. The configuration parameters for the auto scaling
	// feature.
	Autoscale *Autoscale `json:"autoscale,omitempty"`
	// Concurrency: Optional. Job concurrency target which sets a soft upper bound
	// on the number of jobs that can run concurrently in this reservation. This is
	// a soft target due to asynchronous nature of the system and various
	// optimizations for small queries. Default value is 0 which means that
	// concurrency target will be automatically computed by the system. NOTE: this
	// field is exposed as target job concurrency in the Information Schema, DDL
	// and BigQuery CLI.
	Concurrency int64 `json:"concurrency,omitempty,string"`
	// CreationTime: Output only. Creation time of the reservation.
	CreationTime string `json:"creationTime,omitempty"`
	// Edition: Optional. Edition of the reservation.
	//
	// Possible values:
	//   "EDITION_UNSPECIFIED" - Default value, which will be treated as
	// ENTERPRISE.
	//   "STANDARD" - Standard edition.
	//   "ENTERPRISE" - Enterprise edition.
	//   "ENTERPRISE_PLUS" - Enterprise Plus edition.
	Edition string `json:"edition,omitempty"`
	// IgnoreIdleSlots: Optional. If false, any query or pipeline job using this
	// reservation will use idle slots from other reservations within the same
	// admin project. If true, a query or pipeline job using this reservation will
	// execute with the slot capacity specified in the slot_capacity field at most.
	IgnoreIdleSlots bool `json:"ignoreIdleSlots,omitempty"`
	// Labels: Optional. The labels associated with this reservation. You can use
	// these to organize and group your reservations. You can set this property
	// when you create or update a reservation.
	Labels map[string]string `json:"labels,omitempty"`
	// MaxSlots: Optional. The overall max slots for the reservation, covering
	// slot_capacity (baseline), idle slots (if ignore_idle_slots is false) and
	// scaled slots. If present, the reservation won't use more than the specified
	// number of slots, even if there is demand and supply (from idle slots). NOTE:
	// capping a reservation's idle slot usage is best effort and its usage may
	// exceed the max_slots value. However, in terms of autoscale.current_slots
	// (which accounts for the additional added slots), it will never exceed the
	// max_slots - baseline. This field must be set together with the scaling_mode
	// enum value, otherwise the request will be rejected with error code
	// `google.rpc.Code.INVALID_ARGUMENT`. If the max_slots and scaling_mode are
	// set, the autoscale or autoscale.max_slots field must be unset. Otherwise the
	// request will be rejected with error code `google.rpc.Code.INVALID_ARGUMENT`.
	// However, the autoscale field may still be in the output. The
	// autopscale.max_slots will always show as 0 and the autoscaler.current_slots
	// will represent the current slots from autoscaler excluding idle slots. For
	// example, if the max_slots is 1000 and scaling_mode is AUTOSCALE_ONLY, then
	// in the output, the autoscaler.max_slots will be 0 and the
	// autoscaler.current_slots may be any value between 0 and 1000. If the
	// max_slots is 1000, scaling_mode is ALL_SLOTS, the baseline is 100 and idle
	// slots usage is 200, then in the output, the autoscaler.max_slots will be 0
	// and the autoscaler.current_slots will not be higher than 700. If the
	// max_slots is 1000, scaling_mode is IDLE_SLOTS_ONLY, then in the output, the
	// autoscaler field will be null. If the max_slots and scaling_mode are set,
	// then the ignore_idle_slots field must be aligned with the scaling_mode enum
	// value.(See details in ScalingMode comments). Otherwise the request will be
	// rejected with error code `google.rpc.Code.INVALID_ARGUMENT`. Please note,
	// the max_slots is for user to manage the part of slots greater than the
	// baseline. Therefore, we don't allow users to set max_slots smaller or equal
	// to the baseline as it will not be meaningful. If the field is present and
	// slot_capacity>=max_slots, requests will be rejected with error code
	// `google.rpc.Code.INVALID_ARGUMENT`. Please note that if max_slots is set to
	// 0, we will treat it as unset. Customers can set max_slots to 0 and set
	// scaling_mode to SCALING_MODE_UNSPECIFIED to disable the max_slots feature.
	MaxSlots int64 `json:"maxSlots,omitempty,string"`
	// MultiRegionAuxiliary: Applicable only for reservations located within one of
	// the BigQuery multi-regions (US or EU). If set to true, this reservation is
	// placed in the organization's secondary region which is designated for
	// disaster recovery purposes. If false, this reservation is placed in the
	// organization's default region. NOTE: this is a preview feature. Project must
	// be allow-listed in order to set this field.
	MultiRegionAuxiliary bool `json:"multiRegionAuxiliary,omitempty"`
	// Name: Identifier. The resource name of the reservation, e.g.,
	// `projects/*/locations/*/reservations/team1-prod`. The reservation_id must
	// only contain lower case alphanumeric characters or dashes. It must start
	// with a letter and must not end with a dash. Its maximum length is 64
	// characters.
	Name string `json:"name,omitempty"`
	// OriginalPrimaryLocation: Output only. The location where the reservation was
	// originally created. This is set only during the failover reservation's
	// creation. All billing charges for the failover reservation will be applied
	// to this location.
	OriginalPrimaryLocation string `json:"originalPrimaryLocation,omitempty"`
	// PrimaryLocation: Output only. The current location of the reservation's
	// primary replica. This field is only set for reservations using the managed
	// disaster recovery feature.
	PrimaryLocation string `json:"primaryLocation,omitempty"`
	// ReplicationStatus: Output only. The Disaster Recovery(DR) replication status
	// of the reservation. This is only available for the primary replicas of
	// DR/failover reservations and provides information about the both the
	// staleness of the secondary and the last error encountered while trying to
	// replicate changes from the primary to the secondary. If this field is blank,
	// it means that the reservation is either not a DR reservation or the
	// reservation is a DR secondary or that any replication operations on the
	// reservation have succeeded.
	ReplicationStatus *ReplicationStatus `json:"replicationStatus,omitempty"`
	// ReservationGroup: Optional. The reservation group that this reservation
	// belongs to. You can set this property when you create or update a
	// reservation. Reservations do not need to belong to a reservation group.
	// Format:
	// projects/{project}/locations/{location}/reservationGroups/{reservation_group}
	//  or just {reservation_group}
	ReservationGroup string `json:"reservationGroup,omitempty"`
	// ScalingMode: Optional. The scaling mode for the reservation. If the field is
	// present but max_slots is not present, requests will be rejected with error
	// code `google.rpc.Code.INVALID_ARGUMENT`.
	//
	// Possible values:
	//   "SCALING_MODE_UNSPECIFIED" - Default value of ScalingMode.
	//   "AUTOSCALE_ONLY" - The reservation will scale up only using slots from
	// autoscaling. It will not use any idle slots even if there may be some
	// available. The upper limit that autoscaling can scale up to will be
	// max_slots - baseline. For example, if max_slots is 1000, baseline is 200 and
	// customer sets ScalingMode to AUTOSCALE_ONLY, then autoscalerg will scale up
	// to 800 slots and no idle slots will be used. Please note, in this mode, the
	// ignore_idle_slots field must be set to true. Otherwise the request will be
	// rejected with error code `google.rpc.Code.INVALID_ARGUMENT`.
	//   "IDLE_SLOTS_ONLY" - The reservation will scale up using only idle slots
	// contributed by other reservations or from unassigned commitments. If no idle
	// slots are available it will not scale up further. If the idle slots which it
	// is using are reclaimed by the contributing reservation(s) it may be forced
	// to scale down. The max idle slots the reservation can be max_slots -
	// baseline capacity. For example, if max_slots is 1000, baseline is 200 and
	// customer sets ScalingMode to IDLE_SLOTS_ONLY, 1. if there are 1000 idle
	// slots available in other reservations, the reservation will scale up to 1000
	// slots with 200 baseline and 800 idle slots. 2. if there are 500 idle slots
	// available in other reservations, the reservation will scale up to 700 slots
	// with 200 baseline and 300 idle slots. Please note, in this mode, the
	// reservation might not be able to scale up to max_slots. Please note, in this
	// mode, the ignore_idle_slots field must be set to false. Otherwise the
	// request will be rejected with error code `google.rpc.Code.INVALID_ARGUMENT`.
	//   "ALL_SLOTS" - The reservation will scale up using all slots available to
	// it. It will use idle slots contributed by other reservations or from
	// unassigned commitments first. If no idle slots are available it will scale
	// up using autoscaling. For example, if max_slots is 1000, baseline is 200 and
	// customer sets ScalingMode to ALL_SLOTS, 1. if there are 800 idle slots
	// available in other reservations, the reservation will scale up to 1000 slots
	// with 200 baseline and 800 idle slots. 2. if there are 500 idle slots
	// available in other reservations, the reservation will scale up to 1000 slots
	// with 200 baseline, 500 idle slots and 300 autoscaling slots. 3. if there are
	// no idle slots available in other reservations, it will scale up to 1000
	// slots with 200 baseline and 800 autoscaling slots. Please note, in this
	// mode, the ignore_idle_slots field must be set to false. Otherwise the
	// request will be rejected with error code `google.rpc.Code.INVALID_ARGUMENT`.
	ScalingMode string `json:"scalingMode,omitempty"`
	// SecondaryLocation: Optional. The current location of the reservation's
	// secondary replica. This field is only set for reservations using the managed
	// disaster recovery feature. Users can set this in create reservation calls to
	// create a failover reservation or in update reservation calls to convert a
	// non-failover reservation to a failover reservation(or vice versa).
	SecondaryLocation string `json:"secondaryLocation,omitempty"`
	// SlotCapacity: Optional. Baseline slots available to this reservation. A slot
	// is a unit of computational power in BigQuery, and serves as the unit of
	// parallelism. Queries using this reservation might use more slots during
	// runtime if ignore_idle_slots is set to false, or autoscaling is enabled. The
	// total slot_capacity of the reservation and its siblings may exceed the total
	// slot_count of capacity commitments. In that case, the exceeding slots will
	// be charged with the autoscale SKU. You can increase the number of baseline
	// slots in a reservation every few minutes. If you want to decrease your
	// baseline slots, you are limited to once an hour if you have recently changed
	// your baseline slot capacity and your baseline slots exceed your committed
	// slots. Otherwise, you can decrease your baseline slots every few minutes.
	SlotCapacity int64 `json:"slotCapacity,omitempty,string"`
	// UpdateTime: Output only. Last update time of the reservation.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Autoscale") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Autoscale") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Reservation) MarshalJSON() ([]byte, error) {
	type NoMethod Reservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReservationGroup: A reservation group is a container for reservations.
type ReservationGroup struct {
	// Name: Identifier. The resource name of the reservation group, e.g.,
	// `projects/*/locations/*/reservationGroups/team1-prod`. The
	// reservation_group_id must only contain lower case alphanumeric characters or
	// dashes. It must start with a letter and must not end with a dash. Its
	// maximum length is 64 characters.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReservationGroup) MarshalJSON() ([]byte, error) {
	type NoMethod ReservationGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchAllAssignmentsResponse: The response for
// ReservationService.SearchAllAssignments.
type SearchAllAssignmentsResponse struct {
	// Assignments: List of assignments visible to the user.
	Assignments []*Assignment `json:"assignments,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Assignments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assignments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchAllAssignmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchAllAssignmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchAssignmentsResponse: The response for
// ReservationService.SearchAssignments.
type SearchAssignmentsResponse struct {
	// Assignments: List of assignments visible to the user.
	Assignments []*Assignment `json:"assignments,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Assignments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assignments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchAssignmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchAssignmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SplitCapacityCommitmentRequest: The request for
// ReservationService.SplitCapacityCommitment.
type SplitCapacityCommitmentRequest struct {
	// SlotCount: Number of slots in the capacity commitment after the split.
	SlotCount int64 `json:"slotCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "SlotCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SlotCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SplitCapacityCommitmentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SplitCapacityCommitmentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SplitCapacityCommitmentResponse: The response for
// ReservationService.SplitCapacityCommitment.
type SplitCapacityCommitmentResponse struct {
	// First: First capacity commitment, result of a split.
	First *CapacityCommitment `json:"first,omitempty"`
	// Second: Second capacity commitment, result of a split.
	Second *CapacityCommitment `json:"second,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "First") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "First") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SplitCapacityCommitmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SplitCapacityCommitmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableReference: Fully qualified reference to BigQuery table. Internally
// stored as google.cloud.bi.v1.BqTableReference.
type TableReference struct {
	// DatasetId: Optional. The ID of the dataset in the above project.
	DatasetId string `json:"datasetId,omitempty"`
	// ProjectId: Optional. The assigned project ID of the project.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Optional. The ID of the table in the above dataset.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableReference) MarshalJSON() ([]byte, error) {
	type NoMethod TableReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetBiReservationCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetBiReservation: Retrieves a BI reservation.
//
//   - name: Name of the requested reservation, for example:
//     `projects/{project_id}/locations/{location_id}/biReservation`.
func (r *ProjectsLocationsService) GetBiReservation(name string) *ProjectsLocationsGetBiReservationCall {
	c := &ProjectsLocationsGetBiReservationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetBiReservationCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetBiReservationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetBiReservationCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetBiReservationCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetBiReservationCall) Context(ctx context.Context) *ProjectsLocationsGetBiReservationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetBiReservationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetBiReservationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.getBiReservation", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.getBiReservation" call.
// Any non-2xx status code is an error. Response headers are in either
// *BiReservation.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetBiReservationCall) Do(opts ...googleapi.CallOption) (*BiReservation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BiReservation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.getBiReservation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSearchAllAssignmentsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchAllAssignments: Looks up assignments for a specified resource for a
// particular region. If the request is about a project: 1. Assignments created
// on the project will be returned if they exist. 2. Otherwise assignments
// created on the closest ancestor will be returned. 3. Assignments for
// different JobTypes will all be returned. The same logic applies if the
// request is about a folder. If the request is about an organization, then
// assignments created on the organization will be returned (organization
// doesn't have ancestors). Comparing to ListAssignments, there are some
// behavior differences: 1. permission on the assignee will be verified in this
// API. 2. Hierarchy lookup (project->folder->organization) happens in this
// API. 3. Parent here is `projects/*/locations/*`, instead of
// `projects/*/locations/*reservations/*`.
//
//   - parent: The resource name with location (project name could be the
//     wildcard '-'), e.g.: `projects/-/locations/US`.
func (r *ProjectsLocationsService) SearchAllAssignments(parent string) *ProjectsLocationsSearchAllAssignmentsCall {
	c := &ProjectsLocationsSearchAllAssignmentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return per page.
func (c *ProjectsLocationsSearchAllAssignmentsCall) PageSize(pageSize int64) *ProjectsLocationsSearchAllAssignmentsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *ProjectsLocationsSearchAllAssignmentsCall) PageToken(pageToken string) *ProjectsLocationsSearchAllAssignmentsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Please specify resource name as
// assignee in the query. Examples: * `assignee=projects/myproject` *
// `assignee=folders/123` * `assignee=organizations/456`
func (c *ProjectsLocationsSearchAllAssignmentsCall) Query(query string) *ProjectsLocationsSearchAllAssignmentsCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSearchAllAssignmentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsSearchAllAssignmentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSearchAllAssignmentsCall) IfNoneMatch(entityTag string) *ProjectsLocationsSearchAllAssignmentsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSearchAllAssignmentsCall) Context(ctx context.Context) *ProjectsLocationsSearchAllAssignmentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSearchAllAssignmentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSearchAllAssignmentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:searchAllAssignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.searchAllAssignments", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.searchAllAssignments" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchAllAssignmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSearchAllAssignmentsCall) Do(opts ...googleapi.CallOption) (*SearchAllAssignmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchAllAssignmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.searchAllAssignments", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSearchAllAssignmentsCall) Pages(ctx context.Context, f func(*SearchAllAssignmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSearchAssignmentsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchAssignments: Deprecated: Looks up assignments for a specified resource
// for a particular region. If the request is about a project: 1. Assignments
// created on the project will be returned if they exist. 2. Otherwise
// assignments created on the closest ancestor will be returned. 3. Assignments
// for different JobTypes will all be returned. The same logic applies if the
// request is about a folder. If the request is about an organization, then
// assignments created on the organization will be returned (organization
// doesn't have ancestors). Comparing to ListAssignments, there are some
// behavior differences: 1. permission on the assignee will be verified in this
// API. 2. Hierarchy lookup (project->folder->organization) happens in this
// API. 3. Parent here is `projects/*/locations/*`, instead of
// `projects/*/locations/*reservations/*`. **Note** "-" cannot be used for
// projects nor locations.
//
//   - parent: The resource name of the admin project(containing project and
//     location), e.g.: `projects/myproject/locations/US`.
func (r *ProjectsLocationsService) SearchAssignments(parent string) *ProjectsLocationsSearchAssignmentsCall {
	c := &ProjectsLocationsSearchAssignmentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return per page.
func (c *ProjectsLocationsSearchAssignmentsCall) PageSize(pageSize int64) *ProjectsLocationsSearchAssignmentsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *ProjectsLocationsSearchAssignmentsCall) PageToken(pageToken string) *ProjectsLocationsSearchAssignmentsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Please specify resource name as
// assignee in the query. Examples: * `assignee=projects/myproject` *
// `assignee=folders/123` * `assignee=organizations/456`
func (c *ProjectsLocationsSearchAssignmentsCall) Query(query string) *ProjectsLocationsSearchAssignmentsCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSearchAssignmentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsSearchAssignmentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSearchAssignmentsCall) IfNoneMatch(entityTag string) *ProjectsLocationsSearchAssignmentsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSearchAssignmentsCall) Context(ctx context.Context) *ProjectsLocationsSearchAssignmentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSearchAssignmentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSearchAssignmentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:searchAssignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.searchAssignments", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.searchAssignments" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchAssignmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSearchAssignmentsCall) Do(opts ...googleapi.CallOption) (*SearchAssignmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchAssignmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.searchAssignments", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSearchAssignmentsCall) Pages(ctx context.Context, f func(*SearchAssignmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsUpdateBiReservationCall struct {
	s             *Service
	name          string
	bireservation *BiReservation
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// UpdateBiReservation: Updates a BI reservation. Only fields specified in the
// `field_mask` are updated. A singleton BI reservation always exists with
// default size 0. In order to reserve BI capacity it needs to be updated to an
// amount greater than 0. In order to release BI capacity reservation size must
// be set to 0.
//
//   - name: Identifier. The resource name of the singleton BI reservation.
//     Reservation names have the form
//     `projects/{project_id}/locations/{location_id}/biReservation`.
func (r *ProjectsLocationsService) UpdateBiReservation(name string, bireservation *BiReservation) *ProjectsLocationsUpdateBiReservationCall {
	c := &ProjectsLocationsUpdateBiReservationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.bireservation = bireservation
	return c
}

// UpdateMask sets the optional parameter "updateMask": A list of fields to be
// updated in this request.
func (c *ProjectsLocationsUpdateBiReservationCall) UpdateMask(updateMask string) *ProjectsLocationsUpdateBiReservationCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUpdateBiReservationCall) Fields(s ...googleapi.Field) *ProjectsLocationsUpdateBiReservationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUpdateBiReservationCall) Context(ctx context.Context) *ProjectsLocationsUpdateBiReservationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUpdateBiReservationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUpdateBiReservationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.bireservation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.updateBiReservation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.updateBiReservation" call.
// Any non-2xx status code is an error. Response headers are in either
// *BiReservation.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsUpdateBiReservationCall) Do(opts ...googleapi.CallOption) (*BiReservation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BiReservation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.updateBiReservation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCapacityCommitmentsCreateCall struct {
	s                  *Service
	parent             string
	capacitycommitment *CapacityCommitment
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Creates a new capacity commitment resource.
//
//   - parent: Resource name of the parent reservation. E.g.,
//     `projects/myproject/locations/US`.
func (r *ProjectsLocationsCapacityCommitmentsService) Create(parent string, capacitycommitment *CapacityCommitment) *ProjectsLocationsCapacityCommitmentsCreateCall {
	c := &ProjectsLocationsCapacityCommitmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.capacitycommitment = capacitycommitment
	return c
}

// CapacityCommitmentId sets the optional parameter "capacityCommitmentId": The
// optional capacity commitment ID. Capacity commitment name will be generated
// automatically if this field is empty. This field must only contain lower
// case alphanumeric characters or dashes. The first and last character cannot
// be a dash. Max length is 64 characters. NOTE: this ID won't be kept if the
// capacity commitment is split or merged.
func (c *ProjectsLocationsCapacityCommitmentsCreateCall) CapacityCommitmentId(capacityCommitmentId string) *ProjectsLocationsCapacityCommitmentsCreateCall {
	c.urlParams_.Set("capacityCommitmentId", capacityCommitmentId)
	return c
}

// EnforceSingleAdminProjectPerOrg sets the optional parameter
// "enforceSingleAdminProjectPerOrg": If true, fail the request if another
// project in the organization has a capacity commitment.
func (c *ProjectsLocationsCapacityCommitmentsCreateCall) EnforceSingleAdminProjectPerOrg(enforceSingleAdminProjectPerOrg bool) *ProjectsLocationsCapacityCommitmentsCreateCall {
	c.urlParams_.Set("enforceSingleAdminProjectPerOrg", fmt.Sprint(enforceSingleAdminProjectPerOrg))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCapacityCommitmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCapacityCommitmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCapacityCommitmentsCreateCall) Context(ctx context.Context) *ProjectsLocationsCapacityCommitmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCapacityCommitmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCapacityCommitmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.capacitycommitment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/capacityCommitments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.capacityCommitments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *CapacityCommitment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCapacityCommitmentsCreateCall) Do(opts ...googleapi.CallOption) (*CapacityCommitment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CapacityCommitment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCapacityCommitmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a capacity commitment. Attempting to delete capacity
// commitment before its commitment_end_time will fail with the error code
// `google.rpc.Code.FAILED_PRECONDITION`.
//
//   - name: Resource name of the capacity commitment to delete. E.g.,
//     `projects/myproject/locations/US/capacityCommitments/123`.
func (r *ProjectsLocationsCapacityCommitmentsService) Delete(name string) *ProjectsLocationsCapacityCommitmentsDeleteCall {
	c := &ProjectsLocationsCapacityCommitmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": Can be used to force delete
// commitments even if assignments exist. Deleting commitments with assignments
// may cause queries to fail if they no longer have access to slots.
func (c *ProjectsLocationsCapacityCommitmentsDeleteCall) Force(force bool) *ProjectsLocationsCapacityCommitmentsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCapacityCommitmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCapacityCommitmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCapacityCommitmentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCapacityCommitmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCapacityCommitmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCapacityCommitmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.capacityCommitments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCapacityCommitmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCapacityCommitmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns information about the capacity commitment.
//
//   - name: Resource name of the capacity commitment to retrieve. E.g.,
//     `projects/myproject/locations/US/capacityCommitments/123`.
func (r *ProjectsLocationsCapacityCommitmentsService) Get(name string) *ProjectsLocationsCapacityCommitmentsGetCall {
	c := &ProjectsLocationsCapacityCommitmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCapacityCommitmentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCapacityCommitmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCapacityCommitmentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCapacityCommitmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCapacityCommitmentsGetCall) Context(ctx context.Context) *ProjectsLocationsCapacityCommitmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCapacityCommitmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCapacityCommitmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.capacityCommitments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CapacityCommitment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCapacityCommitmentsGetCall) Do(opts ...googleapi.CallOption) (*CapacityCommitment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CapacityCommitment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCapacityCommitmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the capacity commitments for the admin project.
//
//   - parent: Resource name of the parent reservation. E.g.,
//     `projects/myproject/locations/US`.
func (r *ProjectsLocationsCapacityCommitmentsService) List(parent string) *ProjectsLocationsCapacityCommitmentsListCall {
	c := &ProjectsLocationsCapacityCommitmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return.
func (c *ProjectsLocationsCapacityCommitmentsListCall) PageSize(pageSize int64) *ProjectsLocationsCapacityCommitmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *ProjectsLocationsCapacityCommitmentsListCall) PageToken(pageToken string) *ProjectsLocationsCapacityCommitmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCapacityCommitmentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCapacityCommitmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCapacityCommitmentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCapacityCommitmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCapacityCommitmentsListCall) Context(ctx context.Context) *ProjectsLocationsCapacityCommitmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCapacityCommitmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCapacityCommitmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/capacityCommitments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.capacityCommitments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCapacityCommitmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCapacityCommitmentsListCall) Do(opts ...googleapi.CallOption) (*ListCapacityCommitmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCapacityCommitmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCapacityCommitmentsListCall) Pages(ctx context.Context, f func(*ListCapacityCommitmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCapacityCommitmentsMergeCall struct {
	s                               *Service
	parent                          string
	mergecapacitycommitmentsrequest *MergeCapacityCommitmentsRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Merge: Merges capacity commitments of the same plan into a single
// commitment. The resulting capacity commitment has the greater
// commitment_end_time out of the to-be-merged capacity commitments. Attempting
// to merge capacity commitments of different plan will fail with the error
// code `google.rpc.Code.FAILED_PRECONDITION`.
//
//   - parent: Parent resource that identifies admin project and location e.g.,
//     `projects/myproject/locations/us`.
func (r *ProjectsLocationsCapacityCommitmentsService) Merge(parent string, mergecapacitycommitmentsrequest *MergeCapacityCommitmentsRequest) *ProjectsLocationsCapacityCommitmentsMergeCall {
	c := &ProjectsLocationsCapacityCommitmentsMergeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.mergecapacitycommitmentsrequest = mergecapacitycommitmentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCapacityCommitmentsMergeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCapacityCommitmentsMergeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCapacityCommitmentsMergeCall) Context(ctx context.Context) *ProjectsLocationsCapacityCommitmentsMergeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCapacityCommitmentsMergeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCapacityCommitmentsMergeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mergecapacitycommitmentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/capacityCommitments:merge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.merge", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.capacityCommitments.merge" call.
// Any non-2xx status code is an error. Response headers are in either
// *CapacityCommitment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCapacityCommitmentsMergeCall) Do(opts ...googleapi.CallOption) (*CapacityCommitment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CapacityCommitment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.merge", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCapacityCommitmentsPatchCall struct {
	s                  *Service
	name               string
	capacitycommitment *CapacityCommitment
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Updates an existing capacity commitment. Only `plan` and
// `renewal_plan` fields can be updated. Plan can only be changed to a plan of
// a longer commitment period. Attempting to change to a plan with shorter
// commitment period will fail with the error code
// `google.rpc.Code.FAILED_PRECONDITION`.
//
//   - name: Output only. The resource name of the capacity commitment, e.g.,
//     `projects/myproject/locations/US/capacityCommitments/123` The
//     commitment_id must only contain lower case alphanumeric characters or
//     dashes. It must start with a letter and must not end with a dash. Its
//     maximum length is 64 characters.
func (r *ProjectsLocationsCapacityCommitmentsService) Patch(name string, capacitycommitment *CapacityCommitment) *ProjectsLocationsCapacityCommitmentsPatchCall {
	c := &ProjectsLocationsCapacityCommitmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.capacitycommitment = capacitycommitment
	return c
}

// UpdateMask sets the optional parameter "updateMask": Standard field mask for
// the set of fields to be updated.
func (c *ProjectsLocationsCapacityCommitmentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCapacityCommitmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCapacityCommitmentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCapacityCommitmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCapacityCommitmentsPatchCall) Context(ctx context.Context) *ProjectsLocationsCapacityCommitmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCapacityCommitmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCapacityCommitmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.capacitycommitment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.capacityCommitments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *CapacityCommitment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCapacityCommitmentsPatchCall) Do(opts ...googleapi.CallOption) (*CapacityCommitment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CapacityCommitment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCapacityCommitmentsSplitCall struct {
	s                              *Service
	name                           string
	splitcapacitycommitmentrequest *SplitCapacityCommitmentRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Split: Splits capacity commitment to two commitments of the same plan and
// `commitment_end_time`. A common use case is to enable downgrading
// commitments. For example, in order to downgrade from 10000 slots to 8000,
// you might split a 10000 capacity commitment into commitments of 2000 and
// 8000. Then, you delete the first one after the commitment end time passes.
//
//   - name: The resource name e.g.,:
//     `projects/myproject/locations/US/capacityCommitments/123`.
func (r *ProjectsLocationsCapacityCommitmentsService) Split(name string, splitcapacitycommitmentrequest *SplitCapacityCommitmentRequest) *ProjectsLocationsCapacityCommitmentsSplitCall {
	c := &ProjectsLocationsCapacityCommitmentsSplitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.splitcapacitycommitmentrequest = splitcapacitycommitmentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCapacityCommitmentsSplitCall) Fields(s ...googleapi.Field) *ProjectsLocationsCapacityCommitmentsSplitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCapacityCommitmentsSplitCall) Context(ctx context.Context) *ProjectsLocationsCapacityCommitmentsSplitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCapacityCommitmentsSplitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCapacityCommitmentsSplitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.splitcapacitycommitmentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:split")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.split", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.capacityCommitments.split" call.
// Any non-2xx status code is an error. Response headers are in either
// *SplitCapacityCommitmentResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCapacityCommitmentsSplitCall) Do(opts ...googleapi.CallOption) (*SplitCapacityCommitmentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SplitCapacityCommitmentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.capacityCommitments.split", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationGroupsCreateCall struct {
	s                *Service
	parent           string
	reservationgroup *ReservationGroup
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Create: Creates a new reservation group.
//
// - parent: Project, location. E.g., `projects/myproject/locations/US`.
func (r *ProjectsLocationsReservationGroupsService) Create(parent string, reservationgroup *ReservationGroup) *ProjectsLocationsReservationGroupsCreateCall {
	c := &ProjectsLocationsReservationGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.reservationgroup = reservationgroup
	return c
}

// ReservationGroupId sets the optional parameter "reservationGroupId":
// Required. The reservation group ID. It must only contain lower case
// alphanumeric characters or dashes. It must start with a letter and must not
// end with a dash. Its maximum length is 64 characters.
func (c *ProjectsLocationsReservationGroupsCreateCall) ReservationGroupId(reservationGroupId string) *ProjectsLocationsReservationGroupsCreateCall {
	c.urlParams_.Set("reservationGroupId", reservationGroupId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationGroupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationGroupsCreateCall) Context(ctx context.Context) *ProjectsLocationsReservationGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reservationgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reservationGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservationGroups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservationGroups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *ReservationGroup.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsReservationGroupsCreateCall) Do(opts ...googleapi.CallOption) (*ReservationGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ReservationGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservationGroups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a reservation. Returns `google.rpc.Code.FAILED_PRECONDITION`
// when reservation has assignments.
//
//   - name: Resource name of the reservation group to retrieve. E.g.,
//     `projects/myproject/locations/US/reservationGroups/team1-prod`.
func (r *ProjectsLocationsReservationGroupsService) Delete(name string) *ProjectsLocationsReservationGroupsDeleteCall {
	c := &ProjectsLocationsReservationGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationGroupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationGroupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsReservationGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservationGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservationGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservationGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns information about the reservation group.
//
//   - name: Resource name of the reservation group to retrieve. E.g.,
//     `projects/myproject/locations/US/reservationGroups/team1-prod`.
func (r *ProjectsLocationsReservationGroupsService) Get(name string) *ProjectsLocationsReservationGroupsGetCall {
	c := &ProjectsLocationsReservationGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationGroupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReservationGroupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsReservationGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationGroupsGetCall) Context(ctx context.Context) *ProjectsLocationsReservationGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservationGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservationGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ReservationGroup.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsReservationGroupsGetCall) Do(opts ...googleapi.CallOption) (*ReservationGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ReservationGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservationGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the reservation groups for the project in the specified
// location.
//
//   - parent: The parent resource name containing project and location, e.g.:
//     `projects/myproject/locations/US`.
func (r *ProjectsLocationsReservationGroupsService) List(parent string) *ProjectsLocationsReservationGroupsListCall {
	c := &ProjectsLocationsReservationGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return per page.
func (c *ProjectsLocationsReservationGroupsListCall) PageSize(pageSize int64) *ProjectsLocationsReservationGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *ProjectsLocationsReservationGroupsListCall) PageToken(pageToken string) *ProjectsLocationsReservationGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationGroupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReservationGroupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsReservationGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationGroupsListCall) Context(ctx context.Context) *ProjectsLocationsReservationGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reservationGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservationGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservationGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListReservationGroupsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationGroupsListCall) Do(opts ...googleapi.CallOption) (*ListReservationGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReservationGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservationGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsReservationGroupsListCall) Pages(ctx context.Context, f func(*ListReservationGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsReservationsCreateCall struct {
	s           *Service
	parent      string
	reservation *Reservation
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a new reservation resource.
//
// - parent: Project, location. E.g., `projects/myproject/locations/US`.
func (r *ProjectsLocationsReservationsService) Create(parent string, reservation *Reservation) *ProjectsLocationsReservationsCreateCall {
	c := &ProjectsLocationsReservationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.reservation = reservation
	return c
}

// ReservationId sets the optional parameter "reservationId": The reservation
// ID. It must only contain lower case alphanumeric characters or dashes. It
// must start with a letter and must not end with a dash. Its maximum length is
// 64 characters.
func (c *ProjectsLocationsReservationsCreateCall) ReservationId(reservationId string) *ProjectsLocationsReservationsCreateCall {
	c.urlParams_.Set("reservationId", reservationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsCreateCall) Context(ctx context.Context) *ProjectsLocationsReservationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reservation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reservations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Reservation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsCreateCall) Do(opts ...googleapi.CallOption) (*Reservation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Reservation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a reservation. Returns `google.rpc.Code.FAILED_PRECONDITION`
// when reservation has assignments.
//
//   - name: Resource name of the reservation to retrieve. E.g.,
//     `projects/myproject/locations/US/reservations/team1-prod`.
func (r *ProjectsLocationsReservationsService) Delete(name string) *ProjectsLocationsReservationsDeleteCall {
	c := &ProjectsLocationsReservationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsReservationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsFailoverReservationCall struct {
	s                          *Service
	name                       string
	failoverreservationrequest *FailoverReservationRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// FailoverReservation: Fail over a reservation to the secondary location. The
// operation should be done in the current secondary location, which will be
// promoted to the new primary location for the reservation. Attempting to
// failover a reservation in the current primary location will fail with the
// error code `google.rpc.Code.FAILED_PRECONDITION`.
//
//   - name: Resource name of the reservation to failover. E.g.,
//     `projects/myproject/locations/US/reservations/team1-prod`.
func (r *ProjectsLocationsReservationsService) FailoverReservation(name string, failoverreservationrequest *FailoverReservationRequest) *ProjectsLocationsReservationsFailoverReservationCall {
	c := &ProjectsLocationsReservationsFailoverReservationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.failoverreservationrequest = failoverreservationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsFailoverReservationCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsFailoverReservationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsFailoverReservationCall) Context(ctx context.Context) *ProjectsLocationsReservationsFailoverReservationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsFailoverReservationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsFailoverReservationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.failoverreservationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:failoverReservation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.failoverReservation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.failoverReservation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Reservation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsFailoverReservationCall) Do(opts ...googleapi.CallOption) (*Reservation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Reservation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.failoverReservation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns information about the reservation.
//
//   - name: Resource name of the reservation to retrieve. E.g.,
//     `projects/myproject/locations/US/reservations/team1-prod`.
func (r *ProjectsLocationsReservationsService) Get(name string) *ProjectsLocationsReservationsGetCall {
	c := &ProjectsLocationsReservationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReservationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsReservationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsGetCall) Context(ctx context.Context) *ProjectsLocationsReservationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Reservation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsGetCall) Do(opts ...googleapi.CallOption) (*Reservation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Reservation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. May return: *
// A`NOT_FOUND` error if the resource doesn't exist or you don't have the
// permission to view it. * An empty policy if the resource exists but doesn't
// have a set policy. Supported resources are: - Reservations -
// ReservationAssignments To call this method, you must have the following
// Google IAM permissions: - `bigqueryreservation.reservations.getIamPolicy` to
// get policies on reservations.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsReservationsService) GetIamPolicy(resource string) *ProjectsLocationsReservationsGetIamPolicyCall {
	c := &ProjectsLocationsReservationsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsReservationsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsReservationsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReservationsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsReservationsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsReservationsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the reservations for the project in the specified location.
//
//   - parent: The parent resource name containing project and location, e.g.:
//     `projects/myproject/locations/US`.
func (r *ProjectsLocationsReservationsService) List(parent string) *ProjectsLocationsReservationsListCall {
	c := &ProjectsLocationsReservationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return per page.
func (c *ProjectsLocationsReservationsListCall) PageSize(pageSize int64) *ProjectsLocationsReservationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *ProjectsLocationsReservationsListCall) PageToken(pageToken string) *ProjectsLocationsReservationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReservationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsReservationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsListCall) Context(ctx context.Context) *ProjectsLocationsReservationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reservations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListReservationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsListCall) Do(opts ...googleapi.CallOption) (*ListReservationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReservationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsReservationsListCall) Pages(ctx context.Context, f func(*ListReservationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsReservationsPatchCall struct {
	s           *Service
	name        string
	reservation *Reservation
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates an existing reservation resource.
//
//   - name: Identifier. The resource name of the reservation, e.g.,
//     `projects/*/locations/*/reservations/team1-prod`. The reservation_id must
//     only contain lower case alphanumeric characters or dashes. It must start
//     with a letter and must not end with a dash. Its maximum length is 64
//     characters.
func (r *ProjectsLocationsReservationsService) Patch(name string, reservation *Reservation) *ProjectsLocationsReservationsPatchCall {
	c := &ProjectsLocationsReservationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.reservation = reservation
	return c
}

// UpdateMask sets the optional parameter "updateMask": Standard field mask for
// the set of fields to be updated.
func (c *ProjectsLocationsReservationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsReservationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsPatchCall) Context(ctx context.Context) *ProjectsLocationsReservationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.reservation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Reservation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsPatchCall) Do(opts ...googleapi.CallOption) (*Reservation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Reservation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets an access control policy for a resource. Replaces any
// existing policy. Supported resources are: - Reservations To call this
// method, you must have the following Google IAM permissions: -
// `bigqueryreservation.reservations.setIamPolicy` to set policies on
// reservations.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsReservationsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsReservationsSetIamPolicyCall {
	c := &ProjectsLocationsReservationsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsReservationsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Gets your permissions on a resource. Returns an empty
// set of permissions if the resource doesn't exist. Supported resources are: -
// Reservations No Google IAM permissions are required to call this method.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsReservationsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsReservationsTestIamPermissionsCall {
	c := &ProjectsLocationsReservationsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsReservationsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsAssignmentsCreateCall struct {
	s          *Service
	parent     string
	assignment *Assignment
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates an assignment object which allows the given project to
// submit jobs of a certain type using slots from the specified reservation.
// Currently a resource (project, folder, organization) can only have one
// assignment per each (job_type, location) combination, and that reservation
// will be used for all jobs of the matching type. Different assignments can be
// created on different levels of the projects, folders or organization
// hierarchy. During query execution, the assignment is looked up at the
// project, folder and organization levels in that order. The first assignment
// found is applied to the query. When creating assignments, it does not matter
// if other assignments exist at higher levels. Example: * The organization
// `organizationA` contains two projects, `project1` and `project2`. *
// Assignments for all three entities (`organizationA`, `project1`, and
// `project2`) could all be created and mapped to the same or different
// reservations. "None" assignments represent an absence of the assignment.
// Projects assigned to None use on-demand pricing. To create a "None"
// assignment, use "none" as a reservation_id in the parent. Example parent:
// `projects/myproject/locations/US/reservations/none`. Returns
// `google.rpc.Code.PERMISSION_DENIED` if user does not have 'bigquery.admin'
// permissions on the project using the reservation and the project that owns
// this reservation. Returns `google.rpc.Code.INVALID_ARGUMENT` when location
// of the assignment does not match location of the reservation.
//
//   - parent: The parent resource name of the assignment E.g.
//     `projects/myproject/locations/US/reservations/team1-prod`.
func (r *ProjectsLocationsReservationsAssignmentsService) Create(parent string, assignment *Assignment) *ProjectsLocationsReservationsAssignmentsCreateCall {
	c := &ProjectsLocationsReservationsAssignmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.assignment = assignment
	return c
}

// AssignmentId sets the optional parameter "assignmentId": The optional
// assignment ID. Assignment name will be generated automatically if this field
// is empty. This field must only contain lower case alphanumeric characters or
// dashes. Max length is 64 characters.
func (c *ProjectsLocationsReservationsAssignmentsCreateCall) AssignmentId(assignmentId string) *ProjectsLocationsReservationsAssignmentsCreateCall {
	c.urlParams_.Set("assignmentId", assignmentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsAssignmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsAssignmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsAssignmentsCreateCall) Context(ctx context.Context) *ProjectsLocationsReservationsAssignmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsAssignmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsAssignmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.assignment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.assignments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Assignment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsAssignmentsCreateCall) Do(opts ...googleapi.CallOption) (*Assignment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Assignment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsAssignmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a assignment. No expansion will happen. Example: *
// Organization `organizationA` contains two projects, `project1` and
// `project2`. * Reservation `res1` exists and was created previously. *
// CreateAssignment was used previously to define the following associations
// between entities and reservations: “ and “ In this example, deletion of
// the “ assignment won't affect the other assignment “. After said deletion,
// queries from `project1` will still use `res1` while queries from `project2`
// will switch to use on-demand mode.
//
//   - name: Name of the resource, e.g.
//     `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
func (r *ProjectsLocationsReservationsAssignmentsService) Delete(name string) *ProjectsLocationsReservationsAssignmentsDeleteCall {
	c := &ProjectsLocationsReservationsAssignmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsAssignmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsAssignmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsAssignmentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsReservationsAssignmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsAssignmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsAssignmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.assignments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsAssignmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsAssignmentsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. May return: *
// A`NOT_FOUND` error if the resource doesn't exist or you don't have the
// permission to view it. * An empty policy if the resource exists but doesn't
// have a set policy. Supported resources are: - Reservations -
// ReservationAssignments To call this method, you must have the following
// Google IAM permissions: - `bigqueryreservation.reservations.getIamPolicy` to
// get policies on reservations.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsReservationsAssignmentsService) GetIamPolicy(resource string) *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall {
	c := &ProjectsLocationsReservationsAssignmentsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.assignments.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsAssignmentsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsAssignmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists assignments. Only explicitly created assignments will be
// returned. Example: * Organization `organizationA` contains two projects,
// `project1` and `project2`. * Reservation `res1` exists and was created
// previously. * CreateAssignment was used previously to define the following
// associations between entities and reservations: “ and “ In this example,
// ListAssignments will just return the above two assignments for reservation
// `res1`, and no expansion/merge will happen. The wildcard "-" can be used for
// reservations in the request. In that case all assignments belongs to the
// specified project and location will be listed. **Note** "-" cannot be used
// for projects nor locations.
//
//   - parent: The parent resource name e.g.:
//     `projects/myproject/locations/US/reservations/team1-prod` Or:
//     `projects/myproject/locations/US/reservations/-`.
func (r *ProjectsLocationsReservationsAssignmentsService) List(parent string) *ProjectsLocationsReservationsAssignmentsListCall {
	c := &ProjectsLocationsReservationsAssignmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return per page.
func (c *ProjectsLocationsReservationsAssignmentsListCall) PageSize(pageSize int64) *ProjectsLocationsReservationsAssignmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *ProjectsLocationsReservationsAssignmentsListCall) PageToken(pageToken string) *ProjectsLocationsReservationsAssignmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsAssignmentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsAssignmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReservationsAssignmentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsReservationsAssignmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsAssignmentsListCall) Context(ctx context.Context) *ProjectsLocationsReservationsAssignmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsAssignmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsAssignmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.assignments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAssignmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsAssignmentsListCall) Do(opts ...googleapi.CallOption) (*ListAssignmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAssignmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsReservationsAssignmentsListCall) Pages(ctx context.Context, f func(*ListAssignmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsReservationsAssignmentsMoveCall struct {
	s                     *Service
	name                  string
	moveassignmentrequest *MoveAssignmentRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Move: Moves an assignment under a new reservation. This differs from
// removing an existing assignment and recreating a new one by providing a
// transactional change that ensures an assignee always has an associated
// reservation.
//
//   - name: The resource name of the assignment, e.g.
//     `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
func (r *ProjectsLocationsReservationsAssignmentsService) Move(name string, moveassignmentrequest *MoveAssignmentRequest) *ProjectsLocationsReservationsAssignmentsMoveCall {
	c := &ProjectsLocationsReservationsAssignmentsMoveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.moveassignmentrequest = moveassignmentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsAssignmentsMoveCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsAssignmentsMoveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsAssignmentsMoveCall) Context(ctx context.Context) *ProjectsLocationsReservationsAssignmentsMoveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsAssignmentsMoveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsAssignmentsMoveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.moveassignmentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:move")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.move", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.assignments.move" call.
// Any non-2xx status code is an error. Response headers are in either
// *Assignment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsAssignmentsMoveCall) Do(opts ...googleapi.CallOption) (*Assignment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Assignment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.move", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsAssignmentsPatchCall struct {
	s          *Service
	name       string
	assignment *Assignment
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an existing assignment. Only the `priority` field can be
// updated.
//
//   - name: Output only. Name of the resource. E.g.:
//     `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
//     The assignment_id must only contain lower case alphanumeric characters or
//     dashes and the max length is 64 characters.
func (r *ProjectsLocationsReservationsAssignmentsService) Patch(name string, assignment *Assignment) *ProjectsLocationsReservationsAssignmentsPatchCall {
	c := &ProjectsLocationsReservationsAssignmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.assignment = assignment
	return c
}

// UpdateMask sets the optional parameter "updateMask": Standard field mask for
// the set of fields to be updated.
func (c *ProjectsLocationsReservationsAssignmentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsReservationsAssignmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsAssignmentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsAssignmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsAssignmentsPatchCall) Context(ctx context.Context) *ProjectsLocationsReservationsAssignmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsAssignmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsAssignmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.assignment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.assignments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Assignment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsAssignmentsPatchCall) Do(opts ...googleapi.CallOption) (*Assignment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Assignment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsAssignmentsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets an access control policy for a resource. Replaces any
// existing policy. Supported resources are: - Reservations To call this
// method, you must have the following Google IAM permissions: -
// `bigqueryreservation.reservations.setIamPolicy` to set policies on
// reservations.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsReservationsAssignmentsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsReservationsAssignmentsSetIamPolicyCall {
	c := &ProjectsLocationsReservationsAssignmentsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsAssignmentsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsAssignmentsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsAssignmentsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsReservationsAssignmentsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsAssignmentsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsAssignmentsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.assignments.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsAssignmentsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Gets your permissions on a resource. Returns an empty
// set of permissions if the resource doesn't exist. Supported resources are: -
// Reservations No Google IAM permissions are required to call this method.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsReservationsAssignmentsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall {
	c := &ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigqueryreservation.projects.locations.reservations.assignments.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReservationsAssignmentsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigqueryreservation.projects.locations.reservations.assignments.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
