/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.initialization.SharedModelDefaults;
import org.gradle.api.internal.initialization.ActionBasedDefault;
import org.gradle.internal.Cast;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.plugin.software.internal.SoftwareTypeImplementation;
import org.gradle.plugin.software.internal.SoftwareTypeRegistry;
import org.gradle.util.internal.ClosureBackedAction;

public class DefaultSharedModelDefaults
implements SharedModelDefaults,
MethodMixIn {
    private final SoftwareTypeRegistry softwareTypeRegistry;
    private final DynamicMethods dynamicMethods = new DynamicMethods();

    @Inject
    public DefaultSharedModelDefaults(SoftwareTypeRegistry softwareTypeRegistry) {
        this.softwareTypeRegistry = softwareTypeRegistry;
    }

    public <T> void add(String name, Class<T> publicType, Action<? super T> configureAction) {
        SoftwareTypeImplementation<? super T> softwareType;
        if (this.softwareTypeRegistry.getSoftwareTypeImplementations().containsKey(name)) {
            softwareType = this.softwareTypeRegistry.getSoftwareTypeImplementations().get(name);
            if (!softwareType.getModelPublicType().isAssignableFrom(publicType)) {
                throw new IllegalArgumentException(String.format("Cannot add convention for software type '%s' with public type '%s'. Expected public type to be assignable from '%s'.", name, publicType, softwareType.getModelPublicType()));
            }
        } else {
            throw new IllegalArgumentException(String.format("Cannot add convention for unknown software type '%s'.", name));
        }
        softwareType.addModelDefault(new ActionBasedDefault<T>(configureAction));
    }

    public MethodAccess getAdditionalMethods() {
        return this.dynamicMethods;
    }

    class DynamicMethods
    implements MethodAccess {
        DynamicMethods() {
        }

        public boolean hasMethod(String name, Object ... arguments) {
            return arguments.length == 1 && (arguments[0] instanceof Action || arguments[0] instanceof Closure) && DefaultSharedModelDefaults.this.softwareTypeRegistry.getSoftwareTypeImplementations().containsKey(name);
        }

        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            if (this.hasMethod(name, arguments)) {
                SoftwareTypeImplementation<?> softwareType = DefaultSharedModelDefaults.this.softwareTypeRegistry.getSoftwareTypeImplementations().get(name);
                DefaultSharedModelDefaults.this.add(name, softwareType.getModelPublicType(), (Action)Cast.uncheckedNonnullCast(this.toAction(arguments[0])));
                return DynamicInvokeResult.found();
            }
            return DynamicInvokeResult.notFound();
        }

        private Action<?> toAction(Object argument) {
            if (argument instanceof Action) {
                return (Action)Cast.uncheckedNonnullCast((Object)argument);
            }
            if (argument instanceof Closure) {
                return ClosureBackedAction.of((Closure)((Closure)argument));
            }
            throw new IllegalArgumentException("Expected an Action or Closure, but received: " + argument);
        }
    }
}

