/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeParser;
import org.javacc.jjtree.JJTreeParserTreeConstants;
import org.javacc.jjtree.Node;
import org.javacc.jjtree.NodeScope;
import org.javacc.jjtree.Token;

public class SimpleNode
implements Node {
    private Node parent;
    private Node[] children;
    private int id;
    private int myOrdinal;
    private Token first;
    private Token last;
    private boolean whitingOut = false;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(JJTreeParser p, int i) {
        this(i);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
        ((SimpleNode)n).setOrdinal(i);
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return JJTreeParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(prefix + " ");
                }
                ++i;
            }
        }
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    public void setOrdinal(int o) {
        this.myOrdinal = o;
    }

    public Token getFirstToken() {
        return this.first;
    }

    public void setFirstToken(Token t) {
        this.first = t;
    }

    public Token getLastToken() {
        return this.last;
    }

    public void setLastToken(Token t) {
        this.last = t;
    }

    public void print(IO io) {
        if (this.getLastToken().next == this.getFirstToken()) {
            return;
        }
        Token t1 = this.getFirstToken();
        Token t = new Token();
        t.next = t1;
        int ord = 0;
        while (ord < this.jjtGetNumChildren()) {
            SimpleNode n = (SimpleNode)this.jjtGetChild(ord);
            while ((t = t.next) != n.getFirstToken()) {
                this.print(t, io);
            }
            n.print(io);
            t = n.getLastToken();
            ++ord;
        }
        while (t != this.getLastToken()) {
            t = t.next;
            this.print(t, io);
        }
    }

    String translateImage(Token t) {
        return t.image;
    }

    String whiteOut(Token t) {
        String s = "";
        int i = 0;
        while (i < t.image.length()) {
            s = s + " ";
            ++i;
        }
        return s;
    }

    protected void print(Token t, IO io) {
        NodeScope s;
        Token tt = t.specialToken;
        if (tt != null) {
            while (tt.specialToken != null) {
                tt = tt.specialToken;
            }
            while (tt != null) {
                io.print(this.addUnicodeEscapes(this.translateImage(tt)));
                tt = tt.next;
            }
        }
        if ((s = NodeScope.getEnclosingNodeScope(this)) == null) {
            io.print(this.addUnicodeEscapes(this.translateImage(t)));
            return;
        }
        if (t.image.equals("jjtThis")) {
            io.print(s.getNodeVariable());
            return;
        }
        if (t.image.equals("jjtree") && t.next.image.equals(".") && t.next.next.image.equals("currentNode") && t.next.next.next.image.equals("(") && t.next.next.next.next.image.equals(")")) {
            this.whitingOut = true;
        }
        if (this.whitingOut) {
            if (t.image.equals("jjtree")) {
                io.print(s.getNodeVariable());
                io.print(" ");
            } else if (t.image.equals(")")) {
                io.print(" ");
                this.whitingOut = false;
            } else {
                int i = 0;
                while (i < t.image.length()) {
                    io.print(" ");
                    ++i;
                }
            }
            return;
        }
        io.print(this.addUnicodeEscapes(this.translateImage(t)));
    }

    protected String addUnicodeEscapes(String str) {
        String retval = "";
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if ((ch < ' ' || ch > '~') && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') {
                String s = "0000" + Integer.toString(ch, 16);
                retval = retval + "\\u" + s.substring(s.length() - 4, s.length());
            } else {
                retval = retval + ch;
            }
            ++i;
        }
        return retval;
    }

    static void openJJTreeComment(IO io, String arg) {
        if (arg != null) {
            io.print("/*@bgen(jjtree) " + arg + " */");
        } else {
            io.print("/*@bgen(jjtree)*/");
        }
    }

    static void closeJJTreeComment(IO io) {
        io.print("/*@egen*/");
    }

    String getIndentation(SimpleNode n) {
        return this.getIndentation(n, 0);
    }

    String getIndentation(SimpleNode n, int offset) {
        String s = "";
        int i = offset + 1;
        while (i < n.getFirstToken().beginColumn) {
            s = s + " ";
            ++i;
        }
        return s;
    }
}

