// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/run/v2/k8s.min.proto

package runpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A single application container.
// This specifies both the container to run, the command to run in the container
// and the arguments to supply to it.
// Note that additional arguments may be supplied by the system to the container
// at runtime.
type Container struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the container specified as a DNS_LABEL.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. URL of the Container image in Google Container Registry or Google Artifact
	// Registry. More info: https://kubernetes.io/docs/concepts/containers/images
	Image string `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	// Entrypoint array. Not executed within a shell.
	// The docker image's ENTRYPOINT is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's
	// environment. If a variable cannot be resolved, the reference in the input
	// string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
	// double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// More info:
	// https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	Command []string `protobuf:"bytes,3,rep,name=command,proto3" json:"command,omitempty"`
	// Arguments to the entrypoint.
	// The docker image's CMD is used if this is not provided.
	// Variable references $(VAR_NAME) are expanded using the container's
	// environment. If a variable cannot be resolved, the reference in the input
	// string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
	// double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
	// regardless of whether the variable exists or not.
	// More info:
	// https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	Args []string `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty"`
	// List of environment variables to set in the container.
	Env []*EnvVar `protobuf:"bytes,5,rep,name=env,proto3" json:"env,omitempty"`
	// Compute Resource requirements by this container.
	// More info:
	// https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
	Resources *ResourceRequirements `protobuf:"bytes,6,opt,name=resources,proto3" json:"resources,omitempty"`
	// List of ports to expose from the container. Only a single port can be
	// specified. The specified ports must be listening on all interfaces
	// (0.0.0.0) within the container to be accessible.
	//
	// If omitted, a port number will be chosen and passed to the container
	// through the PORT environment variable for the container to listen on.
	Ports []*ContainerPort `protobuf:"bytes,7,rep,name=ports,proto3" json:"ports,omitempty"`
	// Volume to mount into the container's filesystem.
	VolumeMounts []*VolumeMount `protobuf:"bytes,8,rep,name=volume_mounts,json=volumeMounts,proto3" json:"volume_mounts,omitempty"`
	// Container's working directory.
	// If not specified, the container runtime's default will be used, which
	// might be configured in the container image.
	WorkingDir string `protobuf:"bytes,9,opt,name=working_dir,json=workingDir,proto3" json:"working_dir,omitempty"`
	// Periodic probe of container liveness.
	// Container will be restarted if the probe fails.
	// More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	LivenessProbe *Probe `protobuf:"bytes,10,opt,name=liveness_probe,json=livenessProbe,proto3" json:"liveness_probe,omitempty"`
	// Startup probe of application within the container.
	// All other probes are disabled if a startup probe is provided, until it
	// succeeds. Container will not be added to service endpoints if the probe
	// fails.
	// More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	StartupProbe *Probe `protobuf:"bytes,11,opt,name=startup_probe,json=startupProbe,proto3" json:"startup_probe,omitempty"`
}

func (x *Container) Reset() {
	*x = Container{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Container) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Container) ProtoMessage() {}

func (x *Container) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Container.ProtoReflect.Descriptor instead.
func (*Container) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{0}
}

func (x *Container) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Container) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *Container) GetCommand() []string {
	if x != nil {
		return x.Command
	}
	return nil
}

func (x *Container) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *Container) GetEnv() []*EnvVar {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *Container) GetResources() *ResourceRequirements {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Container) GetPorts() []*ContainerPort {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *Container) GetVolumeMounts() []*VolumeMount {
	if x != nil {
		return x.VolumeMounts
	}
	return nil
}

func (x *Container) GetWorkingDir() string {
	if x != nil {
		return x.WorkingDir
	}
	return ""
}

func (x *Container) GetLivenessProbe() *Probe {
	if x != nil {
		return x.LivenessProbe
	}
	return nil
}

func (x *Container) GetStartupProbe() *Probe {
	if x != nil {
		return x.StartupProbe
	}
	return nil
}

// ResourceRequirements describes the compute resource requirements.
type ResourceRequirements struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only memory and CPU are supported. Note: The only
	// supported values for CPU are '1', '2', and '4'. Setting 4 CPU requires at
	// least 2Gi of memory.
	// The values of the map is string form of the 'quantity' k8s type:
	// https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
	Limits map[string]string `protobuf:"bytes,1,rep,name=limits,proto3" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Determines whether CPU should be throttled or not outside of requests.
	CpuIdle bool `protobuf:"varint,2,opt,name=cpu_idle,json=cpuIdle,proto3" json:"cpu_idle,omitempty"`
}

func (x *ResourceRequirements) Reset() {
	*x = ResourceRequirements{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceRequirements) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceRequirements) ProtoMessage() {}

func (x *ResourceRequirements) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceRequirements.ProtoReflect.Descriptor instead.
func (*ResourceRequirements) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{1}
}

func (x *ResourceRequirements) GetLimits() map[string]string {
	if x != nil {
		return x.Limits
	}
	return nil
}

func (x *ResourceRequirements) GetCpuIdle() bool {
	if x != nil {
		return x.CpuIdle
	}
	return false
}

// EnvVar represents an environment variable present in a Container.
type EnvVar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the environment variable. Must be a C_IDENTIFIER, and mnay not
	// exceed 32768 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to Values:
	//
	//	*EnvVar_Value
	//	*EnvVar_ValueSource
	Values isEnvVar_Values `protobuf_oneof:"values"`
}

func (x *EnvVar) Reset() {
	*x = EnvVar{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvVar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvVar) ProtoMessage() {}

func (x *EnvVar) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvVar.ProtoReflect.Descriptor instead.
func (*EnvVar) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{2}
}

func (x *EnvVar) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *EnvVar) GetValues() isEnvVar_Values {
	if m != nil {
		return m.Values
	}
	return nil
}

func (x *EnvVar) GetValue() string {
	if x, ok := x.GetValues().(*EnvVar_Value); ok {
		return x.Value
	}
	return ""
}

func (x *EnvVar) GetValueSource() *EnvVarSource {
	if x, ok := x.GetValues().(*EnvVar_ValueSource); ok {
		return x.ValueSource
	}
	return nil
}

type isEnvVar_Values interface {
	isEnvVar_Values()
}

type EnvVar_Value struct {
	// Variable references $(VAR_NAME) are expanded
	// using the previous defined environment variables in the container and
	// any route environment variables. If a variable cannot be resolved,
	// the reference in the input string will be unchanged. The $(VAR_NAME)
	// syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
	// references will never be expanded, regardless of whether the variable
	// exists or not.
	// Defaults to "", and the maximum length is 32768 bytes.
	Value string `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}

type EnvVar_ValueSource struct {
	// Source for the environment variable's value.
	ValueSource *EnvVarSource `protobuf:"bytes,3,opt,name=value_source,json=valueSource,proto3,oneof"`
}

func (*EnvVar_Value) isEnvVar_Values() {}

func (*EnvVar_ValueSource) isEnvVar_Values() {}

// EnvVarSource represents a source for the value of an EnvVar.
type EnvVarSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selects a secret and a specific version from Cloud Secret Manager.
	SecretKeyRef *SecretKeySelector `protobuf:"bytes,1,opt,name=secret_key_ref,json=secretKeyRef,proto3" json:"secret_key_ref,omitempty"`
}

func (x *EnvVarSource) Reset() {
	*x = EnvVarSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvVarSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvVarSource) ProtoMessage() {}

func (x *EnvVarSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvVarSource.ProtoReflect.Descriptor instead.
func (*EnvVarSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{3}
}

func (x *EnvVarSource) GetSecretKeyRef() *SecretKeySelector {
	if x != nil {
		return x.SecretKeyRef
	}
	return nil
}

// SecretEnvVarSource represents a source for the value of an EnvVar.
type SecretKeySelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the secret in Cloud Secret Manager.
	// Format: {secret_name} if the secret is in the same project.
	// projects/{project}/secrets/{secret_name} if the secret is
	// in a different project.
	Secret string `protobuf:"bytes,1,opt,name=secret,proto3" json:"secret,omitempty"`
	// The Cloud Secret Manager secret version.
	// Can be 'latest' for the latest value or an integer for a specific version.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SecretKeySelector) Reset() {
	*x = SecretKeySelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretKeySelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretKeySelector) ProtoMessage() {}

func (x *SecretKeySelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretKeySelector.ProtoReflect.Descriptor instead.
func (*SecretKeySelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{4}
}

func (x *SecretKeySelector) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *SecretKeySelector) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// ContainerPort represents a network port in a single container.
type ContainerPort struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If specified, used to specify which protocol to use.
	// Allowed values are "http1" and "h2c".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Port number the container listens on.
	// This must be a valid TCP port number, 0 < container_port < 65536.
	ContainerPort int32 `protobuf:"varint,3,opt,name=container_port,json=containerPort,proto3" json:"container_port,omitempty"`
}

func (x *ContainerPort) Reset() {
	*x = ContainerPort{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerPort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerPort) ProtoMessage() {}

func (x *ContainerPort) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerPort.ProtoReflect.Descriptor instead.
func (*ContainerPort) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{5}
}

func (x *ContainerPort) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ContainerPort) GetContainerPort() int32 {
	if x != nil {
		return x.ContainerPort
	}
	return 0
}

// VolumeMount describes a mounting of a Volume within a container.
type VolumeMount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. This must match the Name of a Volume.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Path within the container at which the volume should be mounted.  Must
	// not contain ':'. For Cloud SQL volumes, it can be left empty, or must
	// otherwise be `/cloudsql`. All instances defined in the Volume will be
	// available as `/cloudsql/[instance]`. For more information on Cloud SQL
	// volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
	MountPath string `protobuf:"bytes,3,opt,name=mount_path,json=mountPath,proto3" json:"mount_path,omitempty"`
}

func (x *VolumeMount) Reset() {
	*x = VolumeMount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VolumeMount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VolumeMount) ProtoMessage() {}

func (x *VolumeMount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VolumeMount.ProtoReflect.Descriptor instead.
func (*VolumeMount) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{6}
}

func (x *VolumeMount) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VolumeMount) GetMountPath() string {
	if x != nil {
		return x.MountPath
	}
	return ""
}

// Volume represents a named volume in a container.
type Volume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Volume's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to VolumeType:
	//
	//	*Volume_Secret
	//	*Volume_CloudSqlInstance
	VolumeType isVolume_VolumeType `protobuf_oneof:"volume_type"`
}

func (x *Volume) Reset() {
	*x = Volume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Volume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Volume) ProtoMessage() {}

func (x *Volume) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Volume.ProtoReflect.Descriptor instead.
func (*Volume) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{7}
}

func (x *Volume) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Volume) GetVolumeType() isVolume_VolumeType {
	if m != nil {
		return m.VolumeType
	}
	return nil
}

func (x *Volume) GetSecret() *SecretVolumeSource {
	if x, ok := x.GetVolumeType().(*Volume_Secret); ok {
		return x.Secret
	}
	return nil
}

func (x *Volume) GetCloudSqlInstance() *CloudSqlInstance {
	if x, ok := x.GetVolumeType().(*Volume_CloudSqlInstance); ok {
		return x.CloudSqlInstance
	}
	return nil
}

type isVolume_VolumeType interface {
	isVolume_VolumeType()
}

type Volume_Secret struct {
	// Secret represents a secret that should populate this volume.
	// More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
	Secret *SecretVolumeSource `protobuf:"bytes,2,opt,name=secret,proto3,oneof"`
}

type Volume_CloudSqlInstance struct {
	// For Cloud SQL volumes, contains the specific instances that should be
	// mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
	// more information on how to connect Cloud SQL and Cloud Run.
	CloudSqlInstance *CloudSqlInstance `protobuf:"bytes,3,opt,name=cloud_sql_instance,json=cloudSqlInstance,proto3,oneof"`
}

func (*Volume_Secret) isVolume_VolumeType() {}

func (*Volume_CloudSqlInstance) isVolume_VolumeType() {}

// The secret's value will be presented as the content of a file whose
// name is defined in the item path. If no items are defined, the name of
// the file is the secret.
type SecretVolumeSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the secret in Cloud Secret Manager.
	// Format: {secret} if the secret is in the same project.
	// projects/{project}/secrets/{secret} if the secret is
	// in a different project.
	Secret string `protobuf:"bytes,1,opt,name=secret,proto3" json:"secret,omitempty"`
	// If unspecified, the volume will expose a file whose name is the
	// secret, relative to VolumeMount.mount_path.
	// If specified, the key will be used as the version to fetch from Cloud
	// Secret Manager and the path will be the name of the file exposed in the
	// volume. When items are defined, they must specify a path and a version.
	Items []*VersionToPath `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	// Integer representation of mode bits to use on created files by default.
	// Must be a value between 0000 and 0777 (octal), defaulting to 0444.
	// Directories within the path are not affected by  this setting.
	//
	// # Notes
	//
	// * Internally, a umask of 0222 will be applied to any non-zero value.
	// * This is an integer representation of the mode bits. So, the octal
	// integer value should look exactly as the chmod numeric notation with a
	// leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or
	// 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or
	// 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493
	// (base-10).
	// * This might be in conflict with other options that affect the
	// file mode, like fsGroup, and the result can be other mode bits set.
	//
	// This might be in conflict with other options that affect the
	// file mode, like fsGroup, and as a result, other mode bits could be set.
	DefaultMode int32 `protobuf:"varint,3,opt,name=default_mode,json=defaultMode,proto3" json:"default_mode,omitempty"`
}

func (x *SecretVolumeSource) Reset() {
	*x = SecretVolumeSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretVolumeSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretVolumeSource) ProtoMessage() {}

func (x *SecretVolumeSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretVolumeSource.ProtoReflect.Descriptor instead.
func (*SecretVolumeSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{8}
}

func (x *SecretVolumeSource) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *SecretVolumeSource) GetItems() []*VersionToPath {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *SecretVolumeSource) GetDefaultMode() int32 {
	if x != nil {
		return x.DefaultMode
	}
	return 0
}

// VersionToPath maps a specific version of a secret to a relative file to mount
// to, relative to VolumeMount's mount_path.
type VersionToPath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative path of the secret in the container.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The Cloud Secret Manager secret version.
	// Can be 'latest' for the latest value or an integer for a specific version.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Integer octal mode bits to use on this file, must be a value between
	// 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be
	// used.
	//
	// # Notes
	//
	// * Internally, a umask of 0222 will be applied to any non-zero value.
	// * This is an integer representation of the mode bits. So, the octal
	// integer value should look exactly as the chmod numeric notation with a
	// leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or
	// 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or
	// 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493
	// (base-10).
	// * This might be in conflict with other options that affect the
	// file mode, like fsGroup, and the result can be other mode bits set.
	Mode int32 `protobuf:"varint,3,opt,name=mode,proto3" json:"mode,omitempty"`
}

func (x *VersionToPath) Reset() {
	*x = VersionToPath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionToPath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionToPath) ProtoMessage() {}

func (x *VersionToPath) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionToPath.ProtoReflect.Descriptor instead.
func (*VersionToPath) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{9}
}

func (x *VersionToPath) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *VersionToPath) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *VersionToPath) GetMode() int32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

// Represents a specific Cloud SQL instance.
type CloudSqlInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud SQL instance connection names, as can be found in
	// https://console.cloud.google.com/sql/instances. Visit
	// https://cloud.google.com/sql/docs/mysql/connect-run for more information on
	// how to connect Cloud SQL and Cloud Run. Format:
	// {project}:{location}:{instance}
	Instances []string `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *CloudSqlInstance) Reset() {
	*x = CloudSqlInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudSqlInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSqlInstance) ProtoMessage() {}

func (x *CloudSqlInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSqlInstance.ProtoReflect.Descriptor instead.
func (*CloudSqlInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{10}
}

func (x *CloudSqlInstance) GetInstances() []string {
	if x != nil {
		return x.Instances
	}
	return nil
}

// Probe describes a health check to be performed against a container to
// determine whether it is alive or ready to receive traffic.
type Probe struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of seconds after the container has started before the probe is
	// initiated.
	// Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe
	// is 3600. Maximum value for startup probe is 240.
	// More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	InitialDelaySeconds int32 `protobuf:"varint,1,opt,name=initial_delay_seconds,json=initialDelaySeconds,proto3" json:"initial_delay_seconds,omitempty"`
	// Number of seconds after which the probe times out.
	// Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
	// Must be smaller than period_seconds.
	// More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	TimeoutSeconds int32 `protobuf:"varint,2,opt,name=timeout_seconds,json=timeoutSeconds,proto3" json:"timeout_seconds,omitempty"`
	// How often (in seconds) to perform the probe.
	// Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe
	// is 3600. Maximum value for startup probe is 240.
	// Must be greater or equal than timeout_seconds.
	PeriodSeconds int32 `protobuf:"varint,3,opt,name=period_seconds,json=periodSeconds,proto3" json:"period_seconds,omitempty"`
	// Minimum consecutive failures for the probe to be considered failed after
	// having succeeded. Defaults to 3. Minimum value is 1.
	FailureThreshold int32 `protobuf:"varint,4,opt,name=failure_threshold,json=failureThreshold,proto3" json:"failure_threshold,omitempty"`
	// Types that are assignable to ProbeType:
	//
	//	*Probe_HttpGet
	//	*Probe_TcpSocket
	ProbeType isProbe_ProbeType `protobuf_oneof:"probe_type"`
}

func (x *Probe) Reset() {
	*x = Probe{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Probe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Probe) ProtoMessage() {}

func (x *Probe) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Probe.ProtoReflect.Descriptor instead.
func (*Probe) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{11}
}

func (x *Probe) GetInitialDelaySeconds() int32 {
	if x != nil {
		return x.InitialDelaySeconds
	}
	return 0
}

func (x *Probe) GetTimeoutSeconds() int32 {
	if x != nil {
		return x.TimeoutSeconds
	}
	return 0
}

func (x *Probe) GetPeriodSeconds() int32 {
	if x != nil {
		return x.PeriodSeconds
	}
	return 0
}

func (x *Probe) GetFailureThreshold() int32 {
	if x != nil {
		return x.FailureThreshold
	}
	return 0
}

func (m *Probe) GetProbeType() isProbe_ProbeType {
	if m != nil {
		return m.ProbeType
	}
	return nil
}

func (x *Probe) GetHttpGet() *HTTPGetAction {
	if x, ok := x.GetProbeType().(*Probe_HttpGet); ok {
		return x.HttpGet
	}
	return nil
}

func (x *Probe) GetTcpSocket() *TCPSocketAction {
	if x, ok := x.GetProbeType().(*Probe_TcpSocket); ok {
		return x.TcpSocket
	}
	return nil
}

type isProbe_ProbeType interface {
	isProbe_ProbeType()
}

type Probe_HttpGet struct {
	// HTTPGet specifies the http request to perform.
	// Exactly one of HTTPGet or TCPSocket must be specified.
	HttpGet *HTTPGetAction `protobuf:"bytes,5,opt,name=http_get,json=httpGet,proto3,oneof"`
}

type Probe_TcpSocket struct {
	// TCPSocket specifies an action involving a TCP port.
	// Exactly one of HTTPGet or TCPSocket must be specified.
	TcpSocket *TCPSocketAction `protobuf:"bytes,6,opt,name=tcp_socket,json=tcpSocket,proto3,oneof"`
}

func (*Probe_HttpGet) isProbe_ProbeType() {}

func (*Probe_TcpSocket) isProbe_ProbeType() {}

// HTTPGetAction describes an action based on HTTP Get requests.
type HTTPGetAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to access on the HTTP server. Defaults to '/'.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Custom headers to set in the request. HTTP allows repeated headers.
	HttpHeaders []*HTTPHeader `protobuf:"bytes,4,rep,name=http_headers,json=httpHeaders,proto3" json:"http_headers,omitempty"`
}

func (x *HTTPGetAction) Reset() {
	*x = HTTPGetAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPGetAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPGetAction) ProtoMessage() {}

func (x *HTTPGetAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPGetAction.ProtoReflect.Descriptor instead.
func (*HTTPGetAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{12}
}

func (x *HTTPGetAction) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *HTTPGetAction) GetHttpHeaders() []*HTTPHeader {
	if x != nil {
		return x.HttpHeaders
	}
	return nil
}

// HTTPHeader describes a custom header to be used in HTTP probes
type HTTPHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The header field name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The header field value
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *HTTPHeader) Reset() {
	*x = HTTPHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHeader) ProtoMessage() {}

func (x *HTTPHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHeader.ProtoReflect.Descriptor instead.
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{13}
}

func (x *HTTPHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPHeader) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// TCPSocketAction describes an action based on opening a socket
type TCPSocketAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Port number to access on the container. Must be in the range 1 to 65535.
	Port int32 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *TCPSocketAction) Reset() {
	*x = TCPSocketAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TCPSocketAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TCPSocketAction) ProtoMessage() {}

func (x *TCPSocketAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_k8s_min_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TCPSocketAction.ProtoReflect.Descriptor instead.
func (*TCPSocketAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP(), []int{14}
}

func (x *TCPSocketAction) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

var File_google_cloud_run_v2_k8s_min_proto protoreflect.FileDescriptor

var file_google_cloud_run_v2_k8s_min_proto_rawDesc = []byte{
	0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x75, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x6b, 0x38, 0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x86, 0x04, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x61,
	0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12,
	0x2d, 0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x52, 0x03, 0x65, 0x6e, 0x76, 0x12, 0x47,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x05, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x12, 0x45, 0x0a, 0x0d, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0c, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x77,
	0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x72, 0x12, 0x41, 0x0a, 0x0e, 0x6c, 0x69, 0x76,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x52, 0x0d, 0x6c,
	0x69, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x12, 0x3f, 0x0a, 0x0d,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x52,
	0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x22, 0xbb, 0x01,
	0x0a, 0x14, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x70, 0x75, 0x5f, 0x69, 0x64, 0x6c,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x70, 0x75, 0x49, 0x64, 0x6c, 0x65,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x8b, 0x01, 0x0a, 0x06,
	0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x46, 0x0a, 0x0c, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x08, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x5c, 0x0a, 0x0c, 0x45, 0x6e, 0x76,
	0x56, 0x61, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4c, 0x0a, 0x0e, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65,
	0x79, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x0c, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x66, 0x22, 0xa3, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x43, 0x0a,
	0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x12, 0x49, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x4a, 0x0a,
	0x0d, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f,
	0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x22, 0x4a, 0x0a, 0x0b, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x50, 0x61, 0x74, 0x68, 0x22, 0xca, 0x01, 0x0a, 0x06, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x48, 0x00, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x55, 0x0a, 0x12,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x22, 0x8e, 0x01, 0x0a, 0x12, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x38, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x50, 0x61, 0x74, 0x68, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4d,
	0x6f, 0x64, 0x65, 0x22, 0x56, 0x0a, 0x0d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x50, 0x61, 0x74, 0x68, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x30, 0x0a, 0x10, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22, 0xce, 0x02,
	0x0a, 0x05, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x44,
	0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x53, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x70, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x66,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x3f, 0x0a, 0x08, 0x68, 0x74, 0x74, 0x70,
	0x5f, 0x67, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x48, 0x54, 0x54, 0x50, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x07, 0x68, 0x74, 0x74, 0x70, 0x47, 0x65, 0x74, 0x12, 0x45, 0x0a, 0x0a, 0x74, 0x63, 0x70,
	0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x43, 0x50, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x74, 0x63, 0x70, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x67,
	0x0a, 0x0d, 0x48, 0x54, 0x54, 0x50, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x42, 0x0a, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x0b, 0x68, 0x74, 0x74, 0x70,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x22, 0x3b, 0x0a, 0x0a, 0x48, 0x54, 0x54, 0x50, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x25, 0x0a, 0x0f, 0x54, 0x43, 0x50, 0x53, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x42, 0xf6, 0x03, 0x0a, 0x17,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x42, 0x0b, 0x4b, 0x38, 0x73, 0x4d, 0x69, 0x6e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x72, 0x75, 0x6e, 0x2f, 0x76, 0x32, 0x3b, 0x72, 0x75, 0x6e, 0xea, 0x41,
	0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65,
	0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67,
	0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0xea, 0x41, 0x4a, 0x0a, 0x23, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x12, 0x23, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x7d, 0xea, 0x41, 0x64, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x64,
	0x0a, 0x22, 0x76, 0x70, 0x63, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x12, 0x3e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_run_v2_k8s_min_proto_rawDescOnce sync.Once
	file_google_cloud_run_v2_k8s_min_proto_rawDescData = file_google_cloud_run_v2_k8s_min_proto_rawDesc
)

func file_google_cloud_run_v2_k8s_min_proto_rawDescGZIP() []byte {
	file_google_cloud_run_v2_k8s_min_proto_rawDescOnce.Do(func() {
		file_google_cloud_run_v2_k8s_min_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_run_v2_k8s_min_proto_rawDescData)
	})
	return file_google_cloud_run_v2_k8s_min_proto_rawDescData
}

var file_google_cloud_run_v2_k8s_min_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_run_v2_k8s_min_proto_goTypes = []interface{}{
	(*Container)(nil),            // 0: google.cloud.run.v2.Container
	(*ResourceRequirements)(nil), // 1: google.cloud.run.v2.ResourceRequirements
	(*EnvVar)(nil),               // 2: google.cloud.run.v2.EnvVar
	(*EnvVarSource)(nil),         // 3: google.cloud.run.v2.EnvVarSource
	(*SecretKeySelector)(nil),    // 4: google.cloud.run.v2.SecretKeySelector
	(*ContainerPort)(nil),        // 5: google.cloud.run.v2.ContainerPort
	(*VolumeMount)(nil),          // 6: google.cloud.run.v2.VolumeMount
	(*Volume)(nil),               // 7: google.cloud.run.v2.Volume
	(*SecretVolumeSource)(nil),   // 8: google.cloud.run.v2.SecretVolumeSource
	(*VersionToPath)(nil),        // 9: google.cloud.run.v2.VersionToPath
	(*CloudSqlInstance)(nil),     // 10: google.cloud.run.v2.CloudSqlInstance
	(*Probe)(nil),                // 11: google.cloud.run.v2.Probe
	(*HTTPGetAction)(nil),        // 12: google.cloud.run.v2.HTTPGetAction
	(*HTTPHeader)(nil),           // 13: google.cloud.run.v2.HTTPHeader
	(*TCPSocketAction)(nil),      // 14: google.cloud.run.v2.TCPSocketAction
	nil,                          // 15: google.cloud.run.v2.ResourceRequirements.LimitsEntry
}
var file_google_cloud_run_v2_k8s_min_proto_depIdxs = []int32{
	2,  // 0: google.cloud.run.v2.Container.env:type_name -> google.cloud.run.v2.EnvVar
	1,  // 1: google.cloud.run.v2.Container.resources:type_name -> google.cloud.run.v2.ResourceRequirements
	5,  // 2: google.cloud.run.v2.Container.ports:type_name -> google.cloud.run.v2.ContainerPort
	6,  // 3: google.cloud.run.v2.Container.volume_mounts:type_name -> google.cloud.run.v2.VolumeMount
	11, // 4: google.cloud.run.v2.Container.liveness_probe:type_name -> google.cloud.run.v2.Probe
	11, // 5: google.cloud.run.v2.Container.startup_probe:type_name -> google.cloud.run.v2.Probe
	15, // 6: google.cloud.run.v2.ResourceRequirements.limits:type_name -> google.cloud.run.v2.ResourceRequirements.LimitsEntry
	3,  // 7: google.cloud.run.v2.EnvVar.value_source:type_name -> google.cloud.run.v2.EnvVarSource
	4,  // 8: google.cloud.run.v2.EnvVarSource.secret_key_ref:type_name -> google.cloud.run.v2.SecretKeySelector
	8,  // 9: google.cloud.run.v2.Volume.secret:type_name -> google.cloud.run.v2.SecretVolumeSource
	10, // 10: google.cloud.run.v2.Volume.cloud_sql_instance:type_name -> google.cloud.run.v2.CloudSqlInstance
	9,  // 11: google.cloud.run.v2.SecretVolumeSource.items:type_name -> google.cloud.run.v2.VersionToPath
	12, // 12: google.cloud.run.v2.Probe.http_get:type_name -> google.cloud.run.v2.HTTPGetAction
	14, // 13: google.cloud.run.v2.Probe.tcp_socket:type_name -> google.cloud.run.v2.TCPSocketAction
	13, // 14: google.cloud.run.v2.HTTPGetAction.http_headers:type_name -> google.cloud.run.v2.HTTPHeader
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_run_v2_k8s_min_proto_init() }
func file_google_cloud_run_v2_k8s_min_proto_init() {
	if File_google_cloud_run_v2_k8s_min_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Container); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceRequirements); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvVar); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvVarSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretKeySelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerPort); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VolumeMount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Volume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretVolumeSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionToPath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudSqlInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Probe); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPGetAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_run_v2_k8s_min_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TCPSocketAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_run_v2_k8s_min_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*EnvVar_Value)(nil),
		(*EnvVar_ValueSource)(nil),
	}
	file_google_cloud_run_v2_k8s_min_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Volume_Secret)(nil),
		(*Volume_CloudSqlInstance)(nil),
	}
	file_google_cloud_run_v2_k8s_min_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*Probe_HttpGet)(nil),
		(*Probe_TcpSocket)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_run_v2_k8s_min_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_run_v2_k8s_min_proto_goTypes,
		DependencyIndexes: file_google_cloud_run_v2_k8s_min_proto_depIdxs,
		MessageInfos:      file_google_cloud_run_v2_k8s_min_proto_msgTypes,
	}.Build()
	File_google_cloud_run_v2_k8s_min_proto = out.File
	file_google_cloud_run_v2_k8s_min_proto_rawDesc = nil
	file_google_cloud_run_v2_k8s_min_proto_goTypes = nil
	file_google_cloud_run_v2_k8s_min_proto_depIdxs = nil
}
