package datacollection

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// KnownColumnDefinitionType enumerates the values for known column definition type.
type KnownColumnDefinitionType string

const (
	// KnownColumnDefinitionTypeBoolean ...
	KnownColumnDefinitionTypeBoolean KnownColumnDefinitionType = "boolean"
	// KnownColumnDefinitionTypeDatetime ...
	KnownColumnDefinitionTypeDatetime KnownColumnDefinitionType = "datetime"
	// KnownColumnDefinitionTypeDynamic ...
	KnownColumnDefinitionTypeDynamic KnownColumnDefinitionType = "dynamic"
	// KnownColumnDefinitionTypeInt ...
	KnownColumnDefinitionTypeInt KnownColumnDefinitionType = "int"
	// KnownColumnDefinitionTypeLong ...
	KnownColumnDefinitionTypeLong KnownColumnDefinitionType = "long"
	// KnownColumnDefinitionTypeReal ...
	KnownColumnDefinitionTypeReal KnownColumnDefinitionType = "real"
	// KnownColumnDefinitionTypeString ...
	KnownColumnDefinitionTypeString KnownColumnDefinitionType = "string"
)

// PossibleKnownColumnDefinitionTypeValues returns an array of possible values for the KnownColumnDefinitionType const type.
func PossibleKnownColumnDefinitionTypeValues() []KnownColumnDefinitionType {
	return []KnownColumnDefinitionType{KnownColumnDefinitionTypeBoolean, KnownColumnDefinitionTypeDatetime, KnownColumnDefinitionTypeDynamic, KnownColumnDefinitionTypeInt, KnownColumnDefinitionTypeLong, KnownColumnDefinitionTypeReal, KnownColumnDefinitionTypeString}
}

// KnownDataCollectionEndpointProvisioningState enumerates the values for known data collection endpoint
// provisioning state.
type KnownDataCollectionEndpointProvisioningState string

const (
	// KnownDataCollectionEndpointProvisioningStateCreating ...
	KnownDataCollectionEndpointProvisioningStateCreating KnownDataCollectionEndpointProvisioningState = "Creating"
	// KnownDataCollectionEndpointProvisioningStateDeleting ...
	KnownDataCollectionEndpointProvisioningStateDeleting KnownDataCollectionEndpointProvisioningState = "Deleting"
	// KnownDataCollectionEndpointProvisioningStateFailed ...
	KnownDataCollectionEndpointProvisioningStateFailed KnownDataCollectionEndpointProvisioningState = "Failed"
	// KnownDataCollectionEndpointProvisioningStateSucceeded ...
	KnownDataCollectionEndpointProvisioningStateSucceeded KnownDataCollectionEndpointProvisioningState = "Succeeded"
	// KnownDataCollectionEndpointProvisioningStateUpdating ...
	KnownDataCollectionEndpointProvisioningStateUpdating KnownDataCollectionEndpointProvisioningState = "Updating"
)

// PossibleKnownDataCollectionEndpointProvisioningStateValues returns an array of possible values for the KnownDataCollectionEndpointProvisioningState const type.
func PossibleKnownDataCollectionEndpointProvisioningStateValues() []KnownDataCollectionEndpointProvisioningState {
	return []KnownDataCollectionEndpointProvisioningState{KnownDataCollectionEndpointProvisioningStateCreating, KnownDataCollectionEndpointProvisioningStateDeleting, KnownDataCollectionEndpointProvisioningStateFailed, KnownDataCollectionEndpointProvisioningStateSucceeded, KnownDataCollectionEndpointProvisioningStateUpdating}
}

// KnownDataCollectionEndpointResourceKind enumerates the values for known data collection endpoint resource
// kind.
type KnownDataCollectionEndpointResourceKind string

const (
	// KnownDataCollectionEndpointResourceKindLinux ...
	KnownDataCollectionEndpointResourceKindLinux KnownDataCollectionEndpointResourceKind = "Linux"
	// KnownDataCollectionEndpointResourceKindWindows ...
	KnownDataCollectionEndpointResourceKindWindows KnownDataCollectionEndpointResourceKind = "Windows"
)

// PossibleKnownDataCollectionEndpointResourceKindValues returns an array of possible values for the KnownDataCollectionEndpointResourceKind const type.
func PossibleKnownDataCollectionEndpointResourceKindValues() []KnownDataCollectionEndpointResourceKind {
	return []KnownDataCollectionEndpointResourceKind{KnownDataCollectionEndpointResourceKindLinux, KnownDataCollectionEndpointResourceKindWindows}
}

// KnownDataCollectionRuleAssociationProvisioningState enumerates the values for known data collection rule
// association provisioning state.
type KnownDataCollectionRuleAssociationProvisioningState string

const (
	// KnownDataCollectionRuleAssociationProvisioningStateCreating ...
	KnownDataCollectionRuleAssociationProvisioningStateCreating KnownDataCollectionRuleAssociationProvisioningState = "Creating"
	// KnownDataCollectionRuleAssociationProvisioningStateDeleting ...
	KnownDataCollectionRuleAssociationProvisioningStateDeleting KnownDataCollectionRuleAssociationProvisioningState = "Deleting"
	// KnownDataCollectionRuleAssociationProvisioningStateFailed ...
	KnownDataCollectionRuleAssociationProvisioningStateFailed KnownDataCollectionRuleAssociationProvisioningState = "Failed"
	// KnownDataCollectionRuleAssociationProvisioningStateSucceeded ...
	KnownDataCollectionRuleAssociationProvisioningStateSucceeded KnownDataCollectionRuleAssociationProvisioningState = "Succeeded"
	// KnownDataCollectionRuleAssociationProvisioningStateUpdating ...
	KnownDataCollectionRuleAssociationProvisioningStateUpdating KnownDataCollectionRuleAssociationProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleAssociationProvisioningStateValues returns an array of possible values for the KnownDataCollectionRuleAssociationProvisioningState const type.
func PossibleKnownDataCollectionRuleAssociationProvisioningStateValues() []KnownDataCollectionRuleAssociationProvisioningState {
	return []KnownDataCollectionRuleAssociationProvisioningState{KnownDataCollectionRuleAssociationProvisioningStateCreating, KnownDataCollectionRuleAssociationProvisioningStateDeleting, KnownDataCollectionRuleAssociationProvisioningStateFailed, KnownDataCollectionRuleAssociationProvisioningStateSucceeded, KnownDataCollectionRuleAssociationProvisioningStateUpdating}
}

// KnownDataCollectionRuleProvisioningState enumerates the values for known data collection rule provisioning
// state.
type KnownDataCollectionRuleProvisioningState string

const (
	// KnownDataCollectionRuleProvisioningStateCreating ...
	KnownDataCollectionRuleProvisioningStateCreating KnownDataCollectionRuleProvisioningState = "Creating"
	// KnownDataCollectionRuleProvisioningStateDeleting ...
	KnownDataCollectionRuleProvisioningStateDeleting KnownDataCollectionRuleProvisioningState = "Deleting"
	// KnownDataCollectionRuleProvisioningStateFailed ...
	KnownDataCollectionRuleProvisioningStateFailed KnownDataCollectionRuleProvisioningState = "Failed"
	// KnownDataCollectionRuleProvisioningStateSucceeded ...
	KnownDataCollectionRuleProvisioningStateSucceeded KnownDataCollectionRuleProvisioningState = "Succeeded"
	// KnownDataCollectionRuleProvisioningStateUpdating ...
	KnownDataCollectionRuleProvisioningStateUpdating KnownDataCollectionRuleProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleProvisioningStateValues returns an array of possible values for the KnownDataCollectionRuleProvisioningState const type.
func PossibleKnownDataCollectionRuleProvisioningStateValues() []KnownDataCollectionRuleProvisioningState {
	return []KnownDataCollectionRuleProvisioningState{KnownDataCollectionRuleProvisioningStateCreating, KnownDataCollectionRuleProvisioningStateDeleting, KnownDataCollectionRuleProvisioningStateFailed, KnownDataCollectionRuleProvisioningStateSucceeded, KnownDataCollectionRuleProvisioningStateUpdating}
}

// KnownDataCollectionRuleResourceKind enumerates the values for known data collection rule resource kind.
type KnownDataCollectionRuleResourceKind string

const (
	// KnownDataCollectionRuleResourceKindLinux ...
	KnownDataCollectionRuleResourceKindLinux KnownDataCollectionRuleResourceKind = "Linux"
	// KnownDataCollectionRuleResourceKindWindows ...
	KnownDataCollectionRuleResourceKindWindows KnownDataCollectionRuleResourceKind = "Windows"
)

// PossibleKnownDataCollectionRuleResourceKindValues returns an array of possible values for the KnownDataCollectionRuleResourceKind const type.
func PossibleKnownDataCollectionRuleResourceKindValues() []KnownDataCollectionRuleResourceKind {
	return []KnownDataCollectionRuleResourceKind{KnownDataCollectionRuleResourceKindLinux, KnownDataCollectionRuleResourceKindWindows}
}

// KnownDataFlowStreams enumerates the values for known data flow streams.
type KnownDataFlowStreams string

const (
	// KnownDataFlowStreamsMicrosoftEvent ...
	KnownDataFlowStreamsMicrosoftEvent KnownDataFlowStreams = "Microsoft-Event"
	// KnownDataFlowStreamsMicrosoftInsightsMetrics ...
	KnownDataFlowStreamsMicrosoftInsightsMetrics KnownDataFlowStreams = "Microsoft-InsightsMetrics"
	// KnownDataFlowStreamsMicrosoftPerf ...
	KnownDataFlowStreamsMicrosoftPerf KnownDataFlowStreams = "Microsoft-Perf"
	// KnownDataFlowStreamsMicrosoftSyslog ...
	KnownDataFlowStreamsMicrosoftSyslog KnownDataFlowStreams = "Microsoft-Syslog"
	// KnownDataFlowStreamsMicrosoftWindowsEvent ...
	KnownDataFlowStreamsMicrosoftWindowsEvent KnownDataFlowStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownDataFlowStreamsValues returns an array of possible values for the KnownDataFlowStreams const type.
func PossibleKnownDataFlowStreamsValues() []KnownDataFlowStreams {
	return []KnownDataFlowStreams{KnownDataFlowStreamsMicrosoftEvent, KnownDataFlowStreamsMicrosoftInsightsMetrics, KnownDataFlowStreamsMicrosoftPerf, KnownDataFlowStreamsMicrosoftSyslog, KnownDataFlowStreamsMicrosoftWindowsEvent}
}

// KnownExtensionDataSourceStreams enumerates the values for known extension data source streams.
type KnownExtensionDataSourceStreams string

const (
	// KnownExtensionDataSourceStreamsMicrosoftEvent ...
	KnownExtensionDataSourceStreamsMicrosoftEvent KnownExtensionDataSourceStreams = "Microsoft-Event"
	// KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics ...
	KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics KnownExtensionDataSourceStreams = "Microsoft-InsightsMetrics"
	// KnownExtensionDataSourceStreamsMicrosoftPerf ...
	KnownExtensionDataSourceStreamsMicrosoftPerf KnownExtensionDataSourceStreams = "Microsoft-Perf"
	// KnownExtensionDataSourceStreamsMicrosoftSyslog ...
	KnownExtensionDataSourceStreamsMicrosoftSyslog KnownExtensionDataSourceStreams = "Microsoft-Syslog"
	// KnownExtensionDataSourceStreamsMicrosoftWindowsEvent ...
	KnownExtensionDataSourceStreamsMicrosoftWindowsEvent KnownExtensionDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownExtensionDataSourceStreamsValues returns an array of possible values for the KnownExtensionDataSourceStreams const type.
func PossibleKnownExtensionDataSourceStreamsValues() []KnownExtensionDataSourceStreams {
	return []KnownExtensionDataSourceStreams{KnownExtensionDataSourceStreamsMicrosoftEvent, KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics, KnownExtensionDataSourceStreamsMicrosoftPerf, KnownExtensionDataSourceStreamsMicrosoftSyslog, KnownExtensionDataSourceStreamsMicrosoftWindowsEvent}
}

// KnownLogFileTextSettingsRecordStartTimestampFormat enumerates the values for known log file text settings
// record start timestamp format.
type KnownLogFileTextSettingsRecordStartTimestampFormat string

const (
	// KnownLogFileTextSettingsRecordStartTimestampFormatDdMMMyyyyHHmmsszzz ...
	KnownLogFileTextSettingsRecordStartTimestampFormatDdMMMyyyyHHmmsszzz KnownLogFileTextSettingsRecordStartTimestampFormat = "dd/MMM/yyyy:HH:mm:ss zzz"
	// KnownLogFileTextSettingsRecordStartTimestampFormatDdMMyyHHmmss ...
	KnownLogFileTextSettingsRecordStartTimestampFormatDdMMyyHHmmss KnownLogFileTextSettingsRecordStartTimestampFormat = "ddMMyy HH:mm:ss"
	// KnownLogFileTextSettingsRecordStartTimestampFormatISO8601 ...
	KnownLogFileTextSettingsRecordStartTimestampFormatISO8601 KnownLogFileTextSettingsRecordStartTimestampFormat = "ISO 8601"
	// KnownLogFileTextSettingsRecordStartTimestampFormatMDYYYYHHMMSSAMPM ...
	KnownLogFileTextSettingsRecordStartTimestampFormatMDYYYYHHMMSSAMPM KnownLogFileTextSettingsRecordStartTimestampFormat = "M/D/YYYY HH:MM:SS AM/PM"
	// KnownLogFileTextSettingsRecordStartTimestampFormatMMMdhhmmss ...
	KnownLogFileTextSettingsRecordStartTimestampFormatMMMdhhmmss KnownLogFileTextSettingsRecordStartTimestampFormat = "MMM d hh:mm:ss"
	// KnownLogFileTextSettingsRecordStartTimestampFormatMonDDYYYYHHMMSS ...
	KnownLogFileTextSettingsRecordStartTimestampFormatMonDDYYYYHHMMSS KnownLogFileTextSettingsRecordStartTimestampFormat = "Mon DD, YYYY HH:MM:SS"
	// KnownLogFileTextSettingsRecordStartTimestampFormatYyMMddHHmmss ...
	KnownLogFileTextSettingsRecordStartTimestampFormatYyMMddHHmmss KnownLogFileTextSettingsRecordStartTimestampFormat = "yyMMdd HH:mm:ss"
	// KnownLogFileTextSettingsRecordStartTimestampFormatYYYYMMDDHHMMSS ...
	KnownLogFileTextSettingsRecordStartTimestampFormatYYYYMMDDHHMMSS KnownLogFileTextSettingsRecordStartTimestampFormat = "YYYY-MM-DD HH:MM:SS"
	// KnownLogFileTextSettingsRecordStartTimestampFormatYyyyMMDdTHHmmssK ...
	KnownLogFileTextSettingsRecordStartTimestampFormatYyyyMMDdTHHmmssK KnownLogFileTextSettingsRecordStartTimestampFormat = "yyyy-MM-ddTHH:mm:ssK"
)

// PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues returns an array of possible values for the KnownLogFileTextSettingsRecordStartTimestampFormat const type.
func PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues() []KnownLogFileTextSettingsRecordStartTimestampFormat {
	return []KnownLogFileTextSettingsRecordStartTimestampFormat{KnownLogFileTextSettingsRecordStartTimestampFormatDdMMMyyyyHHmmsszzz, KnownLogFileTextSettingsRecordStartTimestampFormatDdMMyyHHmmss, KnownLogFileTextSettingsRecordStartTimestampFormatISO8601, KnownLogFileTextSettingsRecordStartTimestampFormatMDYYYYHHMMSSAMPM, KnownLogFileTextSettingsRecordStartTimestampFormatMMMdhhmmss, KnownLogFileTextSettingsRecordStartTimestampFormatMonDDYYYYHHMMSS, KnownLogFileTextSettingsRecordStartTimestampFormatYyMMddHHmmss, KnownLogFileTextSettingsRecordStartTimestampFormatYYYYMMDDHHMMSS, KnownLogFileTextSettingsRecordStartTimestampFormatYyyyMMDdTHHmmssK}
}

// KnownPerfCounterDataSourceStreams enumerates the values for known perf counter data source streams.
type KnownPerfCounterDataSourceStreams string

const (
	// KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics ...
	KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics KnownPerfCounterDataSourceStreams = "Microsoft-InsightsMetrics"
	// KnownPerfCounterDataSourceStreamsMicrosoftPerf ...
	KnownPerfCounterDataSourceStreamsMicrosoftPerf KnownPerfCounterDataSourceStreams = "Microsoft-Perf"
)

// PossibleKnownPerfCounterDataSourceStreamsValues returns an array of possible values for the KnownPerfCounterDataSourceStreams const type.
func PossibleKnownPerfCounterDataSourceStreamsValues() []KnownPerfCounterDataSourceStreams {
	return []KnownPerfCounterDataSourceStreams{KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics, KnownPerfCounterDataSourceStreamsMicrosoftPerf}
}

// KnownPublicNetworkAccessOptions enumerates the values for known public network access options.
type KnownPublicNetworkAccessOptions string

const (
	// KnownPublicNetworkAccessOptionsDisabled ...
	KnownPublicNetworkAccessOptionsDisabled KnownPublicNetworkAccessOptions = "Disabled"
	// KnownPublicNetworkAccessOptionsEnabled ...
	KnownPublicNetworkAccessOptionsEnabled KnownPublicNetworkAccessOptions = "Enabled"
)

// PossibleKnownPublicNetworkAccessOptionsValues returns an array of possible values for the KnownPublicNetworkAccessOptions const type.
func PossibleKnownPublicNetworkAccessOptionsValues() []KnownPublicNetworkAccessOptions {
	return []KnownPublicNetworkAccessOptions{KnownPublicNetworkAccessOptionsDisabled, KnownPublicNetworkAccessOptionsEnabled}
}

// KnownSyslogDataSourceFacilityNames enumerates the values for known syslog data source facility names.
type KnownSyslogDataSourceFacilityNames string

const (
	// KnownSyslogDataSourceFacilityNamesAsterisk ...
	KnownSyslogDataSourceFacilityNamesAsterisk KnownSyslogDataSourceFacilityNames = "*"
	// KnownSyslogDataSourceFacilityNamesAuth ...
	KnownSyslogDataSourceFacilityNamesAuth KnownSyslogDataSourceFacilityNames = "auth"
	// KnownSyslogDataSourceFacilityNamesAuthpriv ...
	KnownSyslogDataSourceFacilityNamesAuthpriv KnownSyslogDataSourceFacilityNames = "authpriv"
	// KnownSyslogDataSourceFacilityNamesCron ...
	KnownSyslogDataSourceFacilityNamesCron KnownSyslogDataSourceFacilityNames = "cron"
	// KnownSyslogDataSourceFacilityNamesDaemon ...
	KnownSyslogDataSourceFacilityNamesDaemon KnownSyslogDataSourceFacilityNames = "daemon"
	// KnownSyslogDataSourceFacilityNamesKern ...
	KnownSyslogDataSourceFacilityNamesKern KnownSyslogDataSourceFacilityNames = "kern"
	// KnownSyslogDataSourceFacilityNamesLocal0 ...
	KnownSyslogDataSourceFacilityNamesLocal0 KnownSyslogDataSourceFacilityNames = "local0"
	// KnownSyslogDataSourceFacilityNamesLocal1 ...
	KnownSyslogDataSourceFacilityNamesLocal1 KnownSyslogDataSourceFacilityNames = "local1"
	// KnownSyslogDataSourceFacilityNamesLocal2 ...
	KnownSyslogDataSourceFacilityNamesLocal2 KnownSyslogDataSourceFacilityNames = "local2"
	// KnownSyslogDataSourceFacilityNamesLocal3 ...
	KnownSyslogDataSourceFacilityNamesLocal3 KnownSyslogDataSourceFacilityNames = "local3"
	// KnownSyslogDataSourceFacilityNamesLocal4 ...
	KnownSyslogDataSourceFacilityNamesLocal4 KnownSyslogDataSourceFacilityNames = "local4"
	// KnownSyslogDataSourceFacilityNamesLocal5 ...
	KnownSyslogDataSourceFacilityNamesLocal5 KnownSyslogDataSourceFacilityNames = "local5"
	// KnownSyslogDataSourceFacilityNamesLocal6 ...
	KnownSyslogDataSourceFacilityNamesLocal6 KnownSyslogDataSourceFacilityNames = "local6"
	// KnownSyslogDataSourceFacilityNamesLocal7 ...
	KnownSyslogDataSourceFacilityNamesLocal7 KnownSyslogDataSourceFacilityNames = "local7"
	// KnownSyslogDataSourceFacilityNamesLpr ...
	KnownSyslogDataSourceFacilityNamesLpr KnownSyslogDataSourceFacilityNames = "lpr"
	// KnownSyslogDataSourceFacilityNamesMail ...
	KnownSyslogDataSourceFacilityNamesMail KnownSyslogDataSourceFacilityNames = "mail"
	// KnownSyslogDataSourceFacilityNamesMark ...
	KnownSyslogDataSourceFacilityNamesMark KnownSyslogDataSourceFacilityNames = "mark"
	// KnownSyslogDataSourceFacilityNamesNews ...
	KnownSyslogDataSourceFacilityNamesNews KnownSyslogDataSourceFacilityNames = "news"
	// KnownSyslogDataSourceFacilityNamesSyslog ...
	KnownSyslogDataSourceFacilityNamesSyslog KnownSyslogDataSourceFacilityNames = "syslog"
	// KnownSyslogDataSourceFacilityNamesUser ...
	KnownSyslogDataSourceFacilityNamesUser KnownSyslogDataSourceFacilityNames = "user"
	// KnownSyslogDataSourceFacilityNamesUucp ...
	KnownSyslogDataSourceFacilityNamesUucp KnownSyslogDataSourceFacilityNames = "uucp"
)

// PossibleKnownSyslogDataSourceFacilityNamesValues returns an array of possible values for the KnownSyslogDataSourceFacilityNames const type.
func PossibleKnownSyslogDataSourceFacilityNamesValues() []KnownSyslogDataSourceFacilityNames {
	return []KnownSyslogDataSourceFacilityNames{KnownSyslogDataSourceFacilityNamesAsterisk, KnownSyslogDataSourceFacilityNamesAuth, KnownSyslogDataSourceFacilityNamesAuthpriv, KnownSyslogDataSourceFacilityNamesCron, KnownSyslogDataSourceFacilityNamesDaemon, KnownSyslogDataSourceFacilityNamesKern, KnownSyslogDataSourceFacilityNamesLocal0, KnownSyslogDataSourceFacilityNamesLocal1, KnownSyslogDataSourceFacilityNamesLocal2, KnownSyslogDataSourceFacilityNamesLocal3, KnownSyslogDataSourceFacilityNamesLocal4, KnownSyslogDataSourceFacilityNamesLocal5, KnownSyslogDataSourceFacilityNamesLocal6, KnownSyslogDataSourceFacilityNamesLocal7, KnownSyslogDataSourceFacilityNamesLpr, KnownSyslogDataSourceFacilityNamesMail, KnownSyslogDataSourceFacilityNamesMark, KnownSyslogDataSourceFacilityNamesNews, KnownSyslogDataSourceFacilityNamesSyslog, KnownSyslogDataSourceFacilityNamesUser, KnownSyslogDataSourceFacilityNamesUucp}
}

// KnownSyslogDataSourceLogLevels enumerates the values for known syslog data source log levels.
type KnownSyslogDataSourceLogLevels string

const (
	// KnownSyslogDataSourceLogLevelsAlert ...
	KnownSyslogDataSourceLogLevelsAlert KnownSyslogDataSourceLogLevels = "Alert"
	// KnownSyslogDataSourceLogLevelsAsterisk ...
	KnownSyslogDataSourceLogLevelsAsterisk KnownSyslogDataSourceLogLevels = "*"
	// KnownSyslogDataSourceLogLevelsCritical ...
	KnownSyslogDataSourceLogLevelsCritical KnownSyslogDataSourceLogLevels = "Critical"
	// KnownSyslogDataSourceLogLevelsDebug ...
	KnownSyslogDataSourceLogLevelsDebug KnownSyslogDataSourceLogLevels = "Debug"
	// KnownSyslogDataSourceLogLevelsEmergency ...
	KnownSyslogDataSourceLogLevelsEmergency KnownSyslogDataSourceLogLevels = "Emergency"
	// KnownSyslogDataSourceLogLevelsError ...
	KnownSyslogDataSourceLogLevelsError KnownSyslogDataSourceLogLevels = "Error"
	// KnownSyslogDataSourceLogLevelsInfo ...
	KnownSyslogDataSourceLogLevelsInfo KnownSyslogDataSourceLogLevels = "Info"
	// KnownSyslogDataSourceLogLevelsNotice ...
	KnownSyslogDataSourceLogLevelsNotice KnownSyslogDataSourceLogLevels = "Notice"
	// KnownSyslogDataSourceLogLevelsWarning ...
	KnownSyslogDataSourceLogLevelsWarning KnownSyslogDataSourceLogLevels = "Warning"
)

// PossibleKnownSyslogDataSourceLogLevelsValues returns an array of possible values for the KnownSyslogDataSourceLogLevels const type.
func PossibleKnownSyslogDataSourceLogLevelsValues() []KnownSyslogDataSourceLogLevels {
	return []KnownSyslogDataSourceLogLevels{KnownSyslogDataSourceLogLevelsAlert, KnownSyslogDataSourceLogLevelsAsterisk, KnownSyslogDataSourceLogLevelsCritical, KnownSyslogDataSourceLogLevelsDebug, KnownSyslogDataSourceLogLevelsEmergency, KnownSyslogDataSourceLogLevelsError, KnownSyslogDataSourceLogLevelsInfo, KnownSyslogDataSourceLogLevelsNotice, KnownSyslogDataSourceLogLevelsWarning}
}

// KnownSyslogDataSourceStreams enumerates the values for known syslog data source streams.
type KnownSyslogDataSourceStreams string

const (
	// KnownSyslogDataSourceStreamsMicrosoftSyslog ...
	KnownSyslogDataSourceStreamsMicrosoftSyslog KnownSyslogDataSourceStreams = "Microsoft-Syslog"
)

// PossibleKnownSyslogDataSourceStreamsValues returns an array of possible values for the KnownSyslogDataSourceStreams const type.
func PossibleKnownSyslogDataSourceStreamsValues() []KnownSyslogDataSourceStreams {
	return []KnownSyslogDataSourceStreams{KnownSyslogDataSourceStreamsMicrosoftSyslog}
}

// KnownWindowsEventLogDataSourceStreams enumerates the values for known windows event log data source streams.
type KnownWindowsEventLogDataSourceStreams string

const (
	// KnownWindowsEventLogDataSourceStreamsMicrosoftEvent ...
	KnownWindowsEventLogDataSourceStreamsMicrosoftEvent KnownWindowsEventLogDataSourceStreams = "Microsoft-Event"
	// KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent ...
	KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent KnownWindowsEventLogDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownWindowsEventLogDataSourceStreamsValues returns an array of possible values for the KnownWindowsEventLogDataSourceStreams const type.
func PossibleKnownWindowsEventLogDataSourceStreamsValues() []KnownWindowsEventLogDataSourceStreams {
	return []KnownWindowsEventLogDataSourceStreams{KnownWindowsEventLogDataSourceStreamsMicrosoftEvent, KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent}
}
