// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: quads.proto

package pquads

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Quad is in internal representation of quad used by Cayley.
type Quad struct {
	Subject              string   `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	Predicate            string   `protobuf:"bytes,2,opt,name=predicate,proto3" json:"predicate,omitempty"`
	Object               string   `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	Label                string   `protobuf:"bytes,4,opt,name=label,proto3" json:"label,omitempty"`
	SubjectValue         *Value   `protobuf:"bytes,5,opt,name=subject_value,json=subjectValue,proto3" json:"subject_value,omitempty"`
	PredicateValue       *Value   `protobuf:"bytes,6,opt,name=predicate_value,json=predicateValue,proto3" json:"predicate_value,omitempty"`
	ObjectValue          *Value   `protobuf:"bytes,7,opt,name=object_value,json=objectValue,proto3" json:"object_value,omitempty"`
	LabelValue           *Value   `protobuf:"bytes,8,opt,name=label_value,json=labelValue,proto3" json:"label_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Quad) Reset()         { *m = Quad{} }
func (m *Quad) String() string { return proto.CompactTextString(m) }
func (*Quad) ProtoMessage()    {}
func (*Quad) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{0}
}
func (m *Quad) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Quad) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Quad.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Quad) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Quad.Merge(m, src)
}
func (m *Quad) XXX_Size() int {
	return m.ProtoSize()
}
func (m *Quad) XXX_DiscardUnknown() {
	xxx_messageInfo_Quad.DiscardUnknown(m)
}

var xxx_messageInfo_Quad proto.InternalMessageInfo

func (m *Quad) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *Quad) GetPredicate() string {
	if m != nil {
		return m.Predicate
	}
	return ""
}

func (m *Quad) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *Quad) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Quad) GetSubjectValue() *Value {
	if m != nil {
		return m.SubjectValue
	}
	return nil
}

func (m *Quad) GetPredicateValue() *Value {
	if m != nil {
		return m.PredicateValue
	}
	return nil
}

func (m *Quad) GetObjectValue() *Value {
	if m != nil {
		return m.ObjectValue
	}
	return nil
}

func (m *Quad) GetLabelValue() *Value {
	if m != nil {
		return m.LabelValue
	}
	return nil
}

// WireQuad is a quad that allows any value for it's directions.
type WireQuad struct {
	Subject              *Value   `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	Predicate            *Value   `protobuf:"bytes,2,opt,name=predicate,proto3" json:"predicate,omitempty"`
	Object               *Value   `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	Label                *Value   `protobuf:"bytes,4,opt,name=label,proto3" json:"label,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WireQuad) Reset()         { *m = WireQuad{} }
func (m *WireQuad) String() string { return proto.CompactTextString(m) }
func (*WireQuad) ProtoMessage()    {}
func (*WireQuad) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{1}
}
func (m *WireQuad) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WireQuad) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WireQuad.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WireQuad) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WireQuad.Merge(m, src)
}
func (m *WireQuad) XXX_Size() int {
	return m.ProtoSize()
}
func (m *WireQuad) XXX_DiscardUnknown() {
	xxx_messageInfo_WireQuad.DiscardUnknown(m)
}

var xxx_messageInfo_WireQuad proto.InternalMessageInfo

func (m *WireQuad) GetSubject() *Value {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *WireQuad) GetPredicate() *Value {
	if m != nil {
		return m.Predicate
	}
	return nil
}

func (m *WireQuad) GetObject() *Value {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *WireQuad) GetLabel() *Value {
	if m != nil {
		return m.Label
	}
	return nil
}

// WireQuadRaw is the same as WireQuad, but doesn't decode underlying values.
type WireQuadRaw struct {
	Subject              []byte   `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	Predicate            []byte   `protobuf:"bytes,2,opt,name=predicate,proto3" json:"predicate,omitempty"`
	Object               []byte   `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	Label                []byte   `protobuf:"bytes,4,opt,name=label,proto3" json:"label,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WireQuadRaw) Reset()         { *m = WireQuadRaw{} }
func (m *WireQuadRaw) String() string { return proto.CompactTextString(m) }
func (*WireQuadRaw) ProtoMessage()    {}
func (*WireQuadRaw) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{2}
}
func (m *WireQuadRaw) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WireQuadRaw) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WireQuadRaw.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WireQuadRaw) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WireQuadRaw.Merge(m, src)
}
func (m *WireQuadRaw) XXX_Size() int {
	return m.ProtoSize()
}
func (m *WireQuadRaw) XXX_DiscardUnknown() {
	xxx_messageInfo_WireQuadRaw.DiscardUnknown(m)
}

var xxx_messageInfo_WireQuadRaw proto.InternalMessageInfo

func (m *WireQuadRaw) GetSubject() []byte {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *WireQuadRaw) GetPredicate() []byte {
	if m != nil {
		return m.Predicate
	}
	return nil
}

func (m *WireQuadRaw) GetObject() []byte {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *WireQuadRaw) GetLabel() []byte {
	if m != nil {
		return m.Label
	}
	return nil
}

// StrictQuad is a quad as described by RDF spec.
type StrictQuad struct {
	Subject              *StrictQuad_Ref `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	Predicate            *StrictQuad_Ref `protobuf:"bytes,2,opt,name=predicate,proto3" json:"predicate,omitempty"`
	Object               *Value          `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	Label                *StrictQuad_Ref `protobuf:"bytes,4,opt,name=label,proto3" json:"label,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StrictQuad) Reset()         { *m = StrictQuad{} }
func (m *StrictQuad) String() string { return proto.CompactTextString(m) }
func (*StrictQuad) ProtoMessage()    {}
func (*StrictQuad) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{3}
}
func (m *StrictQuad) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StrictQuad) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StrictQuad.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StrictQuad) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StrictQuad.Merge(m, src)
}
func (m *StrictQuad) XXX_Size() int {
	return m.ProtoSize()
}
func (m *StrictQuad) XXX_DiscardUnknown() {
	xxx_messageInfo_StrictQuad.DiscardUnknown(m)
}

var xxx_messageInfo_StrictQuad proto.InternalMessageInfo

func (m *StrictQuad) GetSubject() *StrictQuad_Ref {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *StrictQuad) GetPredicate() *StrictQuad_Ref {
	if m != nil {
		return m.Predicate
	}
	return nil
}

func (m *StrictQuad) GetObject() *Value {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *StrictQuad) GetLabel() *StrictQuad_Ref {
	if m != nil {
		return m.Label
	}
	return nil
}

type StrictQuad_Ref struct {
	// Types that are valid to be assigned to Value:
	//	*StrictQuad_Ref_BnodeLabel
	//	*StrictQuad_Ref_Iri
	Value                isStrictQuad_Ref_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *StrictQuad_Ref) Reset()         { *m = StrictQuad_Ref{} }
func (m *StrictQuad_Ref) String() string { return proto.CompactTextString(m) }
func (*StrictQuad_Ref) ProtoMessage()    {}
func (*StrictQuad_Ref) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{3, 0}
}
func (m *StrictQuad_Ref) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StrictQuad_Ref) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StrictQuad_Ref.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StrictQuad_Ref) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StrictQuad_Ref.Merge(m, src)
}
func (m *StrictQuad_Ref) XXX_Size() int {
	return m.ProtoSize()
}
func (m *StrictQuad_Ref) XXX_DiscardUnknown() {
	xxx_messageInfo_StrictQuad_Ref.DiscardUnknown(m)
}

var xxx_messageInfo_StrictQuad_Ref proto.InternalMessageInfo

type isStrictQuad_Ref_Value interface {
	isStrictQuad_Ref_Value()
	MarshalTo([]byte) (int, error)
	ProtoSize() int
}

type StrictQuad_Ref_BnodeLabel struct {
	BnodeLabel string `protobuf:"bytes,2,opt,name=bnode_label,json=bnodeLabel,proto3,oneof"`
}
type StrictQuad_Ref_Iri struct {
	Iri string `protobuf:"bytes,3,opt,name=iri,proto3,oneof"`
}

func (*StrictQuad_Ref_BnodeLabel) isStrictQuad_Ref_Value() {}
func (*StrictQuad_Ref_Iri) isStrictQuad_Ref_Value()        {}

func (m *StrictQuad_Ref) GetValue() isStrictQuad_Ref_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *StrictQuad_Ref) GetBnodeLabel() string {
	if x, ok := m.GetValue().(*StrictQuad_Ref_BnodeLabel); ok {
		return x.BnodeLabel
	}
	return ""
}

func (m *StrictQuad_Ref) GetIri() string {
	if x, ok := m.GetValue().(*StrictQuad_Ref_Iri); ok {
		return x.Iri
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StrictQuad_Ref) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StrictQuad_Ref_OneofMarshaler, _StrictQuad_Ref_OneofUnmarshaler, _StrictQuad_Ref_OneofSizer, []interface{}{
		(*StrictQuad_Ref_BnodeLabel)(nil),
		(*StrictQuad_Ref_Iri)(nil),
	}
}

func _StrictQuad_Ref_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StrictQuad_Ref)
	// value
	switch x := m.Value.(type) {
	case *StrictQuad_Ref_BnodeLabel:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.BnodeLabel)
	case *StrictQuad_Ref_Iri:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Iri)
	case nil:
	default:
		return fmt.Errorf("StrictQuad_Ref.Value has unexpected type %T", x)
	}
	return nil
}

func _StrictQuad_Ref_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StrictQuad_Ref)
	switch tag {
	case 2: // value.bnode_label
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &StrictQuad_Ref_BnodeLabel{x}
		return true, err
	case 3: // value.iri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &StrictQuad_Ref_Iri{x}
		return true, err
	default:
		return false, nil
	}
}

func _StrictQuad_Ref_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StrictQuad_Ref)
	// value
	switch x := m.Value.(type) {
	case *StrictQuad_Ref_BnodeLabel:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.BnodeLabel)))
		n += len(x.BnodeLabel)
	case *StrictQuad_Ref_Iri:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Iri)))
		n += len(x.Iri)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// StrictQuadRaw is the same as StrictQuad, but doesn't decode underlying values.
type StrictQuadRaw struct {
	Subject              []byte   `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	Predicate            []byte   `protobuf:"bytes,2,opt,name=predicate,proto3" json:"predicate,omitempty"`
	Object               []byte   `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	Label                []byte   `protobuf:"bytes,4,opt,name=label,proto3" json:"label,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StrictQuadRaw) Reset()         { *m = StrictQuadRaw{} }
func (m *StrictQuadRaw) String() string { return proto.CompactTextString(m) }
func (*StrictQuadRaw) ProtoMessage()    {}
func (*StrictQuadRaw) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{4}
}
func (m *StrictQuadRaw) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StrictQuadRaw) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StrictQuadRaw.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StrictQuadRaw) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StrictQuadRaw.Merge(m, src)
}
func (m *StrictQuadRaw) XXX_Size() int {
	return m.ProtoSize()
}
func (m *StrictQuadRaw) XXX_DiscardUnknown() {
	xxx_messageInfo_StrictQuadRaw.DiscardUnknown(m)
}

var xxx_messageInfo_StrictQuadRaw proto.InternalMessageInfo

func (m *StrictQuadRaw) GetSubject() []byte {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *StrictQuadRaw) GetPredicate() []byte {
	if m != nil {
		return m.Predicate
	}
	return nil
}

func (m *StrictQuadRaw) GetObject() []byte {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *StrictQuadRaw) GetLabel() []byte {
	if m != nil {
		return m.Label
	}
	return nil
}

type Value struct {
	// Types that are valid to be assigned to Value:
	//	*Value_Raw
	//	*Value_Str
	//	*Value_Iri
	//	*Value_Bnode
	//	*Value_TypedStr
	//	*Value_LangStr
	//	*Value_Int
	//	*Value_Float
	//	*Value_Boolean
	//	*Value_Time
	Value                isValue_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Value) Reset()         { *m = Value{} }
func (m *Value) String() string { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()    {}
func (*Value) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{5}
}
func (m *Value) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Value) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Value.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Value) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Value.Merge(m, src)
}
func (m *Value) XXX_Size() int {
	return m.ProtoSize()
}
func (m *Value) XXX_DiscardUnknown() {
	xxx_messageInfo_Value.DiscardUnknown(m)
}

var xxx_messageInfo_Value proto.InternalMessageInfo

type isValue_Value interface {
	isValue_Value()
	MarshalTo([]byte) (int, error)
	ProtoSize() int
}

type Value_Raw struct {
	Raw []byte `protobuf:"bytes,1,opt,name=raw,proto3,oneof"`
}
type Value_Str struct {
	Str string `protobuf:"bytes,2,opt,name=str,proto3,oneof"`
}
type Value_Iri struct {
	Iri string `protobuf:"bytes,3,opt,name=iri,proto3,oneof"`
}
type Value_Bnode struct {
	Bnode string `protobuf:"bytes,4,opt,name=bnode,proto3,oneof"`
}
type Value_TypedStr struct {
	TypedStr *Value_TypedString `protobuf:"bytes,5,opt,name=typed_str,json=typedStr,proto3,oneof"`
}
type Value_LangStr struct {
	LangStr *Value_LangString `protobuf:"bytes,6,opt,name=lang_str,json=langStr,proto3,oneof"`
}
type Value_Int struct {
	Int int64 `protobuf:"varint,7,opt,name=int,proto3,oneof"`
}
type Value_Float struct {
	Float float64 `protobuf:"fixed64,8,opt,name=float,proto3,oneof"`
}
type Value_Boolean struct {
	Boolean bool `protobuf:"varint,9,opt,name=boolean,proto3,oneof"`
}
type Value_Time struct {
	Time *Value_Timestamp `protobuf:"bytes,10,opt,name=time,proto3,oneof"`
}

func (*Value_Raw) isValue_Value()      {}
func (*Value_Str) isValue_Value()      {}
func (*Value_Iri) isValue_Value()      {}
func (*Value_Bnode) isValue_Value()    {}
func (*Value_TypedStr) isValue_Value() {}
func (*Value_LangStr) isValue_Value()  {}
func (*Value_Int) isValue_Value()      {}
func (*Value_Float) isValue_Value()    {}
func (*Value_Boolean) isValue_Value()  {}
func (*Value_Time) isValue_Value()     {}

func (m *Value) GetValue() isValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Value) GetRaw() []byte {
	if x, ok := m.GetValue().(*Value_Raw); ok {
		return x.Raw
	}
	return nil
}

func (m *Value) GetStr() string {
	if x, ok := m.GetValue().(*Value_Str); ok {
		return x.Str
	}
	return ""
}

func (m *Value) GetIri() string {
	if x, ok := m.GetValue().(*Value_Iri); ok {
		return x.Iri
	}
	return ""
}

func (m *Value) GetBnode() string {
	if x, ok := m.GetValue().(*Value_Bnode); ok {
		return x.Bnode
	}
	return ""
}

func (m *Value) GetTypedStr() *Value_TypedString {
	if x, ok := m.GetValue().(*Value_TypedStr); ok {
		return x.TypedStr
	}
	return nil
}

func (m *Value) GetLangStr() *Value_LangString {
	if x, ok := m.GetValue().(*Value_LangStr); ok {
		return x.LangStr
	}
	return nil
}

func (m *Value) GetInt() int64 {
	if x, ok := m.GetValue().(*Value_Int); ok {
		return x.Int
	}
	return 0
}

func (m *Value) GetFloat() float64 {
	if x, ok := m.GetValue().(*Value_Float); ok {
		return x.Float
	}
	return 0
}

func (m *Value) GetBoolean() bool {
	if x, ok := m.GetValue().(*Value_Boolean); ok {
		return x.Boolean
	}
	return false
}

func (m *Value) GetTime() *Value_Timestamp {
	if x, ok := m.GetValue().(*Value_Time); ok {
		return x.Time
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Value) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Value_OneofMarshaler, _Value_OneofUnmarshaler, _Value_OneofSizer, []interface{}{
		(*Value_Raw)(nil),
		(*Value_Str)(nil),
		(*Value_Iri)(nil),
		(*Value_Bnode)(nil),
		(*Value_TypedStr)(nil),
		(*Value_LangStr)(nil),
		(*Value_Int)(nil),
		(*Value_Float)(nil),
		(*Value_Boolean)(nil),
		(*Value_Time)(nil),
	}
}

func _Value_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Value)
	// value
	switch x := m.Value.(type) {
	case *Value_Raw:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.Raw)
	case *Value_Str:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Str)
	case *Value_Iri:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Iri)
	case *Value_Bnode:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Bnode)
	case *Value_TypedStr:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TypedStr); err != nil {
			return err
		}
	case *Value_LangStr:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LangStr); err != nil {
			return err
		}
	case *Value_Int:
		_ = b.EncodeVarint(7<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Int))
	case *Value_Float:
		_ = b.EncodeVarint(8<<3 | proto.WireFixed64)
		_ = b.EncodeFixed64(math.Float64bits(x.Float))
	case *Value_Boolean:
		t := uint64(0)
		if x.Boolean {
			t = 1
		}
		_ = b.EncodeVarint(9<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *Value_Time:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Time); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Value.Value has unexpected type %T", x)
	}
	return nil
}

func _Value_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Value)
	switch tag {
	case 1: // value.raw
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &Value_Raw{x}
		return true, err
	case 2: // value.str
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &Value_Str{x}
		return true, err
	case 3: // value.iri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &Value_Iri{x}
		return true, err
	case 4: // value.bnode
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &Value_Bnode{x}
		return true, err
	case 5: // value.typed_str
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Value_TypedString)
		err := b.DecodeMessage(msg)
		m.Value = &Value_TypedStr{msg}
		return true, err
	case 6: // value.lang_str
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Value_LangString)
		err := b.DecodeMessage(msg)
		m.Value = &Value_LangStr{msg}
		return true, err
	case 7: // value.int
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Value_Int{int64(x)}
		return true, err
	case 8: // value.float
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &Value_Float{math.Float64frombits(x)}
		return true, err
	case 9: // value.boolean
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Value_Boolean{x != 0}
		return true, err
	case 10: // value.time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Value_Timestamp)
		err := b.DecodeMessage(msg)
		m.Value = &Value_Time{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Value_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Value)
	// value
	switch x := m.Value.(type) {
	case *Value_Raw:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Raw)))
		n += len(x.Raw)
	case *Value_Str:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Str)))
		n += len(x.Str)
	case *Value_Iri:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Iri)))
		n += len(x.Iri)
	case *Value_Bnode:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Bnode)))
		n += len(x.Bnode)
	case *Value_TypedStr:
		s := proto.Size(x.TypedStr)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_LangStr:
		s := proto.Size(x.LangStr)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_Int:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Int))
	case *Value_Float:
		n += 1 // tag and wire
		n += 8
	case *Value_Boolean:
		n += 1 // tag and wire
		n += 1
	case *Value_Time:
		s := proto.Size(x.Time)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Value_TypedString struct {
	Value                string   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Type                 string   `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Value_TypedString) Reset()         { *m = Value_TypedString{} }
func (m *Value_TypedString) String() string { return proto.CompactTextString(m) }
func (*Value_TypedString) ProtoMessage()    {}
func (*Value_TypedString) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{5, 0}
}
func (m *Value_TypedString) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Value_TypedString) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Value_TypedString.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Value_TypedString) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Value_TypedString.Merge(m, src)
}
func (m *Value_TypedString) XXX_Size() int {
	return m.ProtoSize()
}
func (m *Value_TypedString) XXX_DiscardUnknown() {
	xxx_messageInfo_Value_TypedString.DiscardUnknown(m)
}

var xxx_messageInfo_Value_TypedString proto.InternalMessageInfo

func (m *Value_TypedString) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Value_TypedString) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

type Value_LangString struct {
	Value                string   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Lang                 string   `protobuf:"bytes,2,opt,name=lang,proto3" json:"lang,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Value_LangString) Reset()         { *m = Value_LangString{} }
func (m *Value_LangString) String() string { return proto.CompactTextString(m) }
func (*Value_LangString) ProtoMessage()    {}
func (*Value_LangString) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{5, 1}
}
func (m *Value_LangString) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Value_LangString) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Value_LangString.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Value_LangString) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Value_LangString.Merge(m, src)
}
func (m *Value_LangString) XXX_Size() int {
	return m.ProtoSize()
}
func (m *Value_LangString) XXX_DiscardUnknown() {
	xxx_messageInfo_Value_LangString.DiscardUnknown(m)
}

var xxx_messageInfo_Value_LangString proto.InternalMessageInfo

func (m *Value_LangString) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Value_LangString) GetLang() string {
	if m != nil {
		return m.Lang
	}
	return ""
}

// From https://github.com/golang/protobuf/blob/master/ptypes/timestamp/timestamp.proto
type Value_Timestamp struct {
	Seconds              int64    `protobuf:"varint,1,opt,name=seconds,proto3" json:"seconds,omitempty"`
	Nanos                int32    `protobuf:"varint,2,opt,name=nanos,proto3" json:"nanos,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Value_Timestamp) Reset()         { *m = Value_Timestamp{} }
func (m *Value_Timestamp) String() string { return proto.CompactTextString(m) }
func (*Value_Timestamp) ProtoMessage()    {}
func (*Value_Timestamp) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{5, 2}
}
func (m *Value_Timestamp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Value_Timestamp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Value_Timestamp.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Value_Timestamp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Value_Timestamp.Merge(m, src)
}
func (m *Value_Timestamp) XXX_Size() int {
	return m.ProtoSize()
}
func (m *Value_Timestamp) XXX_DiscardUnknown() {
	xxx_messageInfo_Value_Timestamp.DiscardUnknown(m)
}

var xxx_messageInfo_Value_Timestamp proto.InternalMessageInfo

func (m *Value_Timestamp) GetSeconds() int64 {
	if m != nil {
		return m.Seconds
	}
	return 0
}

func (m *Value_Timestamp) GetNanos() int32 {
	if m != nil {
		return m.Nanos
	}
	return 0
}

type Header struct {
	// Full is set if encoder always writes every quad directions instead of
	// skipping duplicated values on each direction (except label) for subsequent quads.
	Full bool `protobuf:"varint,1,opt,name=full,proto3" json:"full,omitempty"`
	// NotStrict is set if encoder emits WireQuad instead of StrictQuad messages.
	NotStrict            bool     `protobuf:"varint,2,opt,name=not_strict,json=notStrict,proto3" json:"not_strict,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Header) Reset()         { *m = Header{} }
func (m *Header) String() string { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()    {}
func (*Header) Descriptor() ([]byte, []int) {
	return fileDescriptor_e699ef8faa75dcf5, []int{6}
}
func (m *Header) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Header) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Header.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Header) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Header.Merge(m, src)
}
func (m *Header) XXX_Size() int {
	return m.ProtoSize()
}
func (m *Header) XXX_DiscardUnknown() {
	xxx_messageInfo_Header.DiscardUnknown(m)
}

var xxx_messageInfo_Header proto.InternalMessageInfo

func (m *Header) GetFull() bool {
	if m != nil {
		return m.Full
	}
	return false
}

func (m *Header) GetNotStrict() bool {
	if m != nil {
		return m.NotStrict
	}
	return false
}

func init() {
	proto.RegisterType((*Quad)(nil), "pquads.Quad")
	proto.RegisterType((*WireQuad)(nil), "pquads.WireQuad")
	proto.RegisterType((*WireQuadRaw)(nil), "pquads.WireQuadRaw")
	proto.RegisterType((*StrictQuad)(nil), "pquads.StrictQuad")
	proto.RegisterType((*StrictQuad_Ref)(nil), "pquads.StrictQuad.Ref")
	proto.RegisterType((*StrictQuadRaw)(nil), "pquads.StrictQuadRaw")
	proto.RegisterType((*Value)(nil), "pquads.Value")
	proto.RegisterType((*Value_TypedString)(nil), "pquads.Value.TypedString")
	proto.RegisterType((*Value_LangString)(nil), "pquads.Value.LangString")
	proto.RegisterType((*Value_Timestamp)(nil), "pquads.Value.Timestamp")
	proto.RegisterType((*Header)(nil), "pquads.Header")
}

func init() { proto.RegisterFile("quads.proto", fileDescriptor_e699ef8faa75dcf5) }

var fileDescriptor_e699ef8faa75dcf5 = []byte{
	// 663 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0xcd, 0x6e, 0xd4, 0x3c,
	0x14, 0x9d, 0x4c, 0xe6, 0x27, 0x73, 0x93, 0x7e, 0x1f, 0xb2, 0x50, 0x09, 0x23, 0xa8, 0xca, 0x20,
	0x44, 0x25, 0x68, 0x5a, 0x15, 0x28, 0x48, 0xdd, 0x75, 0x35, 0x82, 0x6e, 0x30, 0x08, 0x96, 0x95,
	0x33, 0xf1, 0x84, 0xa0, 0x8c, 0x3d, 0x24, 0x0e, 0x23, 0x5e, 0x84, 0x35, 0x0f, 0xc0, 0x13, 0xf0,
	0x04, 0x2c, 0x79, 0x86, 0xf2, 0x16, 0xac, 0x90, 0xaf, 0x93, 0xcc, 0x3f, 0x12, 0x1b, 0x76, 0x3e,
	0xf6, 0x3d, 0xbe, 0xe7, 0x1e, 0xdf, 0x9b, 0x80, 0xfb, 0xa1, 0x60, 0x51, 0x1e, 0x4c, 0x33, 0xa9,
	0x24, 0xe9, 0x4c, 0x11, 0xf5, 0x0f, 0xe3, 0x44, 0xbd, 0x2b, 0xc2, 0x60, 0x24, 0x27, 0x47, 0xb1,
	0x8c, 0xe5, 0x11, 0x1e, 0x87, 0xc5, 0x18, 0x11, 0x02, 0x5c, 0x19, 0xda, 0xe0, 0x5b, 0x13, 0x5a,
	0x2f, 0x0b, 0x16, 0x11, 0x1f, 0xba, 0x79, 0x11, 0xbe, 0xe7, 0x23, 0xe5, 0x5b, 0xfb, 0xd6, 0x41,
	0x8f, 0x56, 0x90, 0xdc, 0x82, 0xde, 0x34, 0xe3, 0x51, 0x32, 0x62, 0x8a, 0xfb, 0x4d, 0x3c, 0x9b,
	0x6f, 0x90, 0x5d, 0xe8, 0x48, 0x43, 0xb3, 0xf1, 0xa8, 0x44, 0xe4, 0x3a, 0xb4, 0x53, 0x16, 0xf2,
	0xd4, 0x6f, 0xe1, 0xb6, 0x01, 0xe4, 0x04, 0x76, 0xca, 0x6b, 0x2f, 0x3f, 0xb2, 0xb4, 0xe0, 0x7e,
	0x7b, 0xdf, 0x3a, 0x70, 0x4f, 0x76, 0x02, 0xa3, 0x3e, 0x78, 0xa3, 0x37, 0xa9, 0x57, 0xc6, 0x20,
	0x22, 0xa7, 0xf0, 0x7f, 0x9d, 0xae, 0x64, 0x75, 0x36, 0xb1, 0xfe, 0xab, 0xa3, 0x0c, 0xef, 0x18,
	0x3c, 0xb9, 0x98, 0xaa, 0xbb, 0x89, 0xe4, 0xca, 0x85, 0x4c, 0x01, 0xb8, 0x28, 0xb3, 0x24, 0x38,
	0x9b, 0x08, 0x80, 0x11, 0xb8, 0x1e, 0x7c, 0xb5, 0xc0, 0x79, 0x9b, 0x64, 0x1c, 0x0d, 0xbc, 0xbf,
	0x6c, 0xe0, 0x1a, 0xb1, 0xf6, 0xf3, 0xc1, 0xaa, 0x9f, 0x6b, 0xa1, 0x0b, 0xf6, 0xde, 0x5b, 0xb2,
	0x77, 0x2d, 0xb2, 0x72, 0xfb, 0xee, 0xa2, 0xdb, 0x6b, 0x51, 0xe6, 0x6c, 0x90, 0x83, 0x5b, 0xa9,
	0xa5, 0x6c, 0xb6, 0xfa, 0xe2, 0xde, 0x1f, 0x5e, 0xdc, 0xdb, 0xfe, 0xe2, 0xde, 0xe6, 0x17, 0xf7,
	0xaa, 0xa4, 0x9f, 0x9b, 0x00, 0xaf, 0x54, 0x96, 0x8c, 0x14, 0xba, 0x74, 0xbc, 0xea, 0xd2, 0x6e,
	0x25, 0x75, 0x1e, 0x14, 0x50, 0x3e, 0x9e, 0x8b, 0x79, 0xbc, 0x6e, 0xd7, 0x36, 0xce, 0xdf, 0xfb,
	0xf6, 0x70, 0xd9, 0xb7, 0x6d, 0x17, 0x9b, 0xa0, 0xfe, 0x0b, 0xb0, 0x29, 0x1f, 0x93, 0x3b, 0xe0,
	0x86, 0x42, 0x46, 0xfc, 0xd2, 0x50, 0x71, 0x24, 0x86, 0x0d, 0x0a, 0xb8, 0x79, 0x81, 0x7d, 0x4e,
	0xc0, 0x4e, 0xb2, 0xc4, 0x8c, 0xc4, 0xb0, 0x41, 0x35, 0x38, 0xef, 0x42, 0x1b, 0xfb, 0xea, 0x79,
	0xcb, 0xb1, 0xae, 0x35, 0x07, 0x05, 0xec, 0xcc, 0xb3, 0xfc, 0xbb, 0xf7, 0xf8, 0x65, 0x43, 0xdb,
	0x74, 0x3b, 0x01, 0x3b, 0x63, 0x33, 0x93, 0x4b, 0x6b, 0xcc, 0xd8, 0x4c, 0xef, 0xe5, 0x2a, 0xab,
	0x4b, 0xd2, 0x60, 0x53, 0x2d, 0x64, 0x17, 0xda, 0x58, 0xad, 0x99, 0xee, 0x61, 0x83, 0x1a, 0x48,
	0x9e, 0x41, 0x4f, 0x7d, 0x9a, 0xf2, 0xe8, 0x52, 0xdf, 0x62, 0x66, 0xfb, 0xe6, 0x92, 0xf3, 0xc1,
	0x6b, 0x7d, 0xac, 0x0b, 0x17, 0xf1, 0xb0, 0x41, 0x1d, 0x55, 0x42, 0xf2, 0x04, 0x9c, 0x94, 0x89,
	0x18, 0x89, 0x66, 0xbc, 0xfd, 0x65, 0xe2, 0x05, 0x13, 0x71, 0xcd, 0xeb, 0xa6, 0x06, 0xa1, 0x38,
	0xa1, 0x70, 0xb6, 0x6d, 0x14, 0x27, 0x94, 0x16, 0x37, 0x4e, 0x25, 0x53, 0x38, 0xc0, 0x96, 0x16,
	0x87, 0x90, 0xf4, 0xa1, 0x1b, 0x4a, 0x99, 0x72, 0x26, 0xfc, 0xde, 0xbe, 0x75, 0xe0, 0xe8, 0x7b,
	0xca, 0x0d, 0x72, 0x08, 0x2d, 0x95, 0x4c, 0xb8, 0x0f, 0x98, 0xfa, 0xc6, 0x8a, 0xe6, 0x64, 0xc2,
	0x73, 0xc5, 0x26, 0xd3, 0x61, 0x83, 0x62, 0x58, 0xff, 0x29, 0xb8, 0x0b, 0x85, 0x68, 0xab, 0xcd,
	0x27, 0xc3, 0x7c, 0x3a, 0x0d, 0x20, 0x04, 0x5a, 0xba, 0xbc, 0xf2, 0x9b, 0x89, 0xeb, 0xfe, 0x29,
	0xc0, 0xbc, 0x90, 0xed, 0x3c, 0x5d, 0x5e, 0xc5, 0xd3, 0xeb, 0xfe, 0x19, 0xf4, 0x6a, 0x15, 0xd8,
	0x29, 0x7c, 0x24, 0x45, 0x94, 0x23, 0xd1, 0xa6, 0x15, 0xd4, 0x17, 0x0a, 0x26, 0x64, 0x8e, 0xdc,
	0x36, 0x35, 0xa0, 0xee, 0xbc, 0xc1, 0x19, 0x74, 0x86, 0x9c, 0x45, 0x5c, 0xfb, 0xd6, 0x1a, 0x17,
	0x69, 0x8a, 0x7c, 0x87, 0xe2, 0x9a, 0xdc, 0x06, 0x10, 0x52, 0xe9, 0x17, 0x48, 0x46, 0x0a, 0x6f,
	0x70, 0x68, 0x4f, 0x48, 0x65, 0xda, 0xf4, 0xdc, 0xfb, 0x7e, 0xb5, 0x67, 0xfd, 0xb8, 0xda, 0xb3,
	0xbe, 0xfc, 0xdc, 0xb3, 0xc2, 0x0e, 0xfe, 0x3f, 0x1e, 0xfd, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x0a,
	0x85, 0x07, 0x6d, 0x85, 0x06, 0x00, 0x00,
}

func (m *Quad) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Quad) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Quad) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LabelValue != nil {
		{
			size, err := m.LabelValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.ObjectValue != nil {
		{
			size, err := m.ObjectValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.PredicateValue != nil {
		{
			size, err := m.PredicateValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.SubjectValue != nil {
		{
			size, err := m.SubjectValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Label) > 0 {
		i -= len(m.Label)
		copy(dAtA[i:], m.Label)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Label)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Object) > 0 {
		i -= len(m.Object)
		copy(dAtA[i:], m.Object)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Object)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Predicate) > 0 {
		i -= len(m.Predicate)
		copy(dAtA[i:], m.Predicate)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Predicate)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Subject) > 0 {
		i -= len(m.Subject)
		copy(dAtA[i:], m.Subject)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Subject)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WireQuad) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WireQuad) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WireQuad) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Label != nil {
		{
			size, err := m.Label.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Object != nil {
		{
			size, err := m.Object.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Predicate != nil {
		{
			size, err := m.Predicate.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Subject != nil {
		{
			size, err := m.Subject.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WireQuadRaw) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WireQuadRaw) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WireQuadRaw) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Label) > 0 {
		i -= len(m.Label)
		copy(dAtA[i:], m.Label)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Label)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Object) > 0 {
		i -= len(m.Object)
		copy(dAtA[i:], m.Object)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Object)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Predicate) > 0 {
		i -= len(m.Predicate)
		copy(dAtA[i:], m.Predicate)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Predicate)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Subject) > 0 {
		i -= len(m.Subject)
		copy(dAtA[i:], m.Subject)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Subject)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StrictQuad) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StrictQuad) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StrictQuad) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Label != nil {
		{
			size, err := m.Label.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Object != nil {
		{
			size, err := m.Object.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Predicate != nil {
		{
			size, err := m.Predicate.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Subject != nil {
		{
			size, err := m.Subject.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StrictQuad_Ref) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StrictQuad_Ref) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StrictQuad_Ref) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != nil {
		{
			size := m.Value.ProtoSize()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *StrictQuad_Ref_BnodeLabel) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *StrictQuad_Ref_BnodeLabel) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.BnodeLabel)
	copy(dAtA[i:], m.BnodeLabel)
	i = encodeVarintQuads(dAtA, i, uint64(len(m.BnodeLabel)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *StrictQuad_Ref_Iri) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *StrictQuad_Ref_Iri) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Iri)
	copy(dAtA[i:], m.Iri)
	i = encodeVarintQuads(dAtA, i, uint64(len(m.Iri)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *StrictQuadRaw) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StrictQuadRaw) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StrictQuadRaw) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Label) > 0 {
		i -= len(m.Label)
		copy(dAtA[i:], m.Label)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Label)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Object) > 0 {
		i -= len(m.Object)
		copy(dAtA[i:], m.Object)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Object)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Predicate) > 0 {
		i -= len(m.Predicate)
		copy(dAtA[i:], m.Predicate)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Predicate)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Subject) > 0 {
		i -= len(m.Subject)
		copy(dAtA[i:], m.Subject)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Subject)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Value) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != nil {
		{
			size := m.Value.ProtoSize()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Value_Raw) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_Raw) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Raw != nil {
		i -= len(m.Raw)
		copy(dAtA[i:], m.Raw)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Raw)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Value_Str) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_Str) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Str)
	copy(dAtA[i:], m.Str)
	i = encodeVarintQuads(dAtA, i, uint64(len(m.Str)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *Value_Iri) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_Iri) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Iri)
	copy(dAtA[i:], m.Iri)
	i = encodeVarintQuads(dAtA, i, uint64(len(m.Iri)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *Value_Bnode) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_Bnode) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Bnode)
	copy(dAtA[i:], m.Bnode)
	i = encodeVarintQuads(dAtA, i, uint64(len(m.Bnode)))
	i--
	dAtA[i] = 0x22
	return len(dAtA) - i, nil
}
func (m *Value_TypedStr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_TypedStr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.TypedStr != nil {
		{
			size, err := m.TypedStr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *Value_LangStr) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_LangStr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.LangStr != nil {
		{
			size, err := m.LangStr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *Value_Int) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_Int) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintQuads(dAtA, i, uint64(m.Int))
	i--
	dAtA[i] = 0x38
	return len(dAtA) - i, nil
}
func (m *Value_Float) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_Float) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Float))))
	i--
	dAtA[i] = 0x41
	return len(dAtA) - i, nil
}
func (m *Value_Boolean) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_Boolean) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.Boolean {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x48
	return len(dAtA) - i, nil
}
func (m *Value_Time) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.ProtoSize()])
}

func (m *Value_Time) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Time != nil {
		{
			size, err := m.Time.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintQuads(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	return len(dAtA) - i, nil
}
func (m *Value_TypedString) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value_TypedString) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_TypedString) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Value_LangString) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value_LangString) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_LangString) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Lang) > 0 {
		i -= len(m.Lang)
		copy(dAtA[i:], m.Lang)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Lang)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintQuads(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Value_Timestamp) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value_Timestamp) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_Timestamp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Nanos != 0 {
		i = encodeVarintQuads(dAtA, i, uint64(m.Nanos))
		i--
		dAtA[i] = 0x10
	}
	if m.Seconds != 0 {
		i = encodeVarintQuads(dAtA, i, uint64(m.Seconds))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Header) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Header) MarshalTo(dAtA []byte) (int, error) {
	size := m.ProtoSize()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Header) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NotStrict {
		i--
		if m.NotStrict {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Full {
		i--
		if m.Full {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintQuads(dAtA []byte, offset int, v uint64) int {
	offset -= sovQuads(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Quad) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Subject)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Predicate)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Object)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.SubjectValue != nil {
		l = m.SubjectValue.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.PredicateValue != nil {
		l = m.PredicateValue.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.ObjectValue != nil {
		l = m.ObjectValue.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.LabelValue != nil {
		l = m.LabelValue.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WireQuad) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Predicate != nil {
		l = m.Predicate.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Object != nil {
		l = m.Object.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Label != nil {
		l = m.Label.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WireQuadRaw) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Subject)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Predicate)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Object)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StrictQuad) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Predicate != nil {
		l = m.Predicate.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Object != nil {
		l = m.Object.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.Label != nil {
		l = m.Label.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StrictQuad_Ref) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.ProtoSize()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StrictQuad_Ref_BnodeLabel) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.BnodeLabel)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *StrictQuad_Ref_Iri) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Iri)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *StrictQuadRaw) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Subject)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Predicate)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Object)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.ProtoSize()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Raw) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Raw != nil {
		l = len(m.Raw)
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}
func (m *Value_Str) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Str)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *Value_Iri) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Iri)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *Value_Bnode) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Bnode)
	n += 1 + l + sovQuads(uint64(l))
	return n
}
func (m *Value_TypedStr) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TypedStr != nil {
		l = m.TypedStr.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}
func (m *Value_LangStr) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LangStr != nil {
		l = m.LangStr.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}
func (m *Value_Int) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovQuads(uint64(m.Int))
	return n
}
func (m *Value_Float) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *Value_Boolean) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *Value_Time) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Time != nil {
		l = m.Time.ProtoSize()
		n += 1 + l + sovQuads(uint64(l))
	}
	return n
}
func (m *Value_TypedString) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_LangString) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	l = len(m.Lang)
	if l > 0 {
		n += 1 + l + sovQuads(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Timestamp) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Seconds != 0 {
		n += 1 + sovQuads(uint64(m.Seconds))
	}
	if m.Nanos != 0 {
		n += 1 + sovQuads(uint64(m.Nanos))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Header) ProtoSize() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Full {
		n += 2
	}
	if m.NotStrict {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovQuads(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozQuads(x uint64) (n int) {
	return sovQuads(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Quad) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Quad: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Quad: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subject = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Predicate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Object = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SubjectValue == nil {
				m.SubjectValue = &Value{}
			}
			if err := m.SubjectValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PredicateValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PredicateValue == nil {
				m.PredicateValue = &Value{}
			}
			if err := m.PredicateValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ObjectValue == nil {
				m.ObjectValue = &Value{}
			}
			if err := m.ObjectValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LabelValue == nil {
				m.LabelValue = &Value{}
			}
			if err := m.LabelValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WireQuad) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WireQuad: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WireQuad: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &Value{}
			}
			if err := m.Subject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Predicate == nil {
				m.Predicate = &Value{}
			}
			if err := m.Predicate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Object == nil {
				m.Object = &Value{}
			}
			if err := m.Object.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Label == nil {
				m.Label = &Value{}
			}
			if err := m.Label.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WireQuadRaw) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WireQuadRaw: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WireQuadRaw: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subject = append(m.Subject[:0], dAtA[iNdEx:postIndex]...)
			if m.Subject == nil {
				m.Subject = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Predicate = append(m.Predicate[:0], dAtA[iNdEx:postIndex]...)
			if m.Predicate == nil {
				m.Predicate = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Object = append(m.Object[:0], dAtA[iNdEx:postIndex]...)
			if m.Object == nil {
				m.Object = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = append(m.Label[:0], dAtA[iNdEx:postIndex]...)
			if m.Label == nil {
				m.Label = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StrictQuad) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StrictQuad: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StrictQuad: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &StrictQuad_Ref{}
			}
			if err := m.Subject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Predicate == nil {
				m.Predicate = &StrictQuad_Ref{}
			}
			if err := m.Predicate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Object == nil {
				m.Object = &Value{}
			}
			if err := m.Object.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Label == nil {
				m.Label = &StrictQuad_Ref{}
			}
			if err := m.Label.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StrictQuad_Ref) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ref: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ref: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BnodeLabel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &StrictQuad_Ref_BnodeLabel{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &StrictQuad_Ref_Iri{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StrictQuadRaw) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StrictQuadRaw: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StrictQuadRaw: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subject = append(m.Subject[:0], dAtA[iNdEx:postIndex]...)
			if m.Subject == nil {
				m.Subject = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Predicate = append(m.Predicate[:0], dAtA[iNdEx:postIndex]...)
			if m.Predicate == nil {
				m.Predicate = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Object = append(m.Object[:0], dAtA[iNdEx:postIndex]...)
			if m.Object == nil {
				m.Object = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = append(m.Label[:0], dAtA[iNdEx:postIndex]...)
			if m.Label == nil {
				m.Label = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Raw", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Value = &Value_Raw{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Str", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &Value_Str{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &Value_Iri{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bnode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &Value_Bnode{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedStr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Value_TypedString{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Value_TypedStr{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LangStr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Value_LangString{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Value_LangStr{v}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &Value_Int{v}
		case 8:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Float", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &Value_Float{float64(math.Float64frombits(v))}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Boolean", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Value = &Value_Boolean{b}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Value_Timestamp{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Value_Time{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_TypedString) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TypedString: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TypedString: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_LangString) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LangString: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LangString: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lang", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuads
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuads
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Lang = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_Timestamp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Timestamp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Timestamp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seconds", wireType)
			}
			m.Seconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nanos", wireType)
			}
			m.Nanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Nanos |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Full", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Full = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotStrict", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NotStrict = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipQuads(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQuads
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuads(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuads
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuads
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthQuads
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthQuads
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowQuads
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipQuads(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthQuads
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthQuads = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuads   = fmt.Errorf("proto: integer overflow")
)
