package dockercontainer

import (
	"net/url"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestSpecFromURL(t *testing.T) {
	cases := map[string]*Spec{
		"docker-container://containername": {
			Container: "containername",
		},
		"docker-container://containername?context=ctxname": {
			Context: "ctxname", Container: "containername",
		},
		"docker-container://": nil,
	}
	for s, expected := range cases {
		u, err := url.Parse(s)
		if err != nil {
			t.Fatal(err)
		}
		got, err := SpecFromURL(u)
		if expected != nil {
			require.NoError(t, err)
			require.Equal(t, expected, got, s)
		} else {
			require.Error(t, err, s)
		}
	}
}
