// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// OperationTypeEnum Enum with underlying type: string
type OperationTypeEnum string

// Set of constants representing the allowable values for OperationTypeEnum
const (
	OperationTypeCreateHostScanRecipe             OperationTypeEnum = "CREATE_HOST_SCAN_RECIPE"
	OperationTypeUpdateHostScanRecipe             OperationTypeEnum = "UPDATE_HOST_SCAN_RECIPE"
	OperationTypeDeleteHostScanRecipe             OperationTypeEnum = "DELETE_HOST_SCAN_RECIPE"
	OperationTypeCreateHostScanTarget             OperationTypeEnum = "CREATE_HOST_SCAN_TARGET"
	OperationTypeUpdateHostScanTarget             OperationTypeEnum = "UPDATE_HOST_SCAN_TARGET"
	OperationTypeDeleteHostScanTarget             OperationTypeEnum = "DELETE_HOST_SCAN_TARGET"
	OperationTypeCreateContainerScanRecipe        OperationTypeEnum = "CREATE_CONTAINER_SCAN_RECIPE"
	OperationTypeUpdateContainerScanRecipe        OperationTypeEnum = "UPDATE_CONTAINER_SCAN_RECIPE"
	OperationTypeDeleteContainerScanRecipe        OperationTypeEnum = "DELETE_CONTAINER_SCAN_RECIPE"
	OperationTypeCreateContainerScanTarget        OperationTypeEnum = "CREATE_CONTAINER_SCAN_TARGET"
	OperationTypeUpdateContainerScanTarget        OperationTypeEnum = "UPDATE_CONTAINER_SCAN_TARGET"
	OperationTypeDeleteContainerScanTarget        OperationTypeEnum = "DELETE_CONTAINER_SCAN_TARGET"
	OperationTypeDeleteHostAgentScanResult        OperationTypeEnum = "DELETE_HOST_AGENT_SCAN_RESULT"
	OperationTypeDeleteHostPortScanResult         OperationTypeEnum = "DELETE_HOST_PORT_SCAN_RESULT"
	OperationTypeDeleteHostCisBenchmarkScanResult OperationTypeEnum = "DELETE_HOST_CIS_BENCHMARK_SCAN_RESULT"
	OperationTypeDeleteContainerScanResult        OperationTypeEnum = "DELETE_CONTAINER_SCAN_RESULT"
)

var mappingOperationTypeEnum = map[string]OperationTypeEnum{
	"CREATE_HOST_SCAN_RECIPE":               OperationTypeCreateHostScanRecipe,
	"UPDATE_HOST_SCAN_RECIPE":               OperationTypeUpdateHostScanRecipe,
	"DELETE_HOST_SCAN_RECIPE":               OperationTypeDeleteHostScanRecipe,
	"CREATE_HOST_SCAN_TARGET":               OperationTypeCreateHostScanTarget,
	"UPDATE_HOST_SCAN_TARGET":               OperationTypeUpdateHostScanTarget,
	"DELETE_HOST_SCAN_TARGET":               OperationTypeDeleteHostScanTarget,
	"CREATE_CONTAINER_SCAN_RECIPE":          OperationTypeCreateContainerScanRecipe,
	"UPDATE_CONTAINER_SCAN_RECIPE":          OperationTypeUpdateContainerScanRecipe,
	"DELETE_CONTAINER_SCAN_RECIPE":          OperationTypeDeleteContainerScanRecipe,
	"CREATE_CONTAINER_SCAN_TARGET":          OperationTypeCreateContainerScanTarget,
	"UPDATE_CONTAINER_SCAN_TARGET":          OperationTypeUpdateContainerScanTarget,
	"DELETE_CONTAINER_SCAN_TARGET":          OperationTypeDeleteContainerScanTarget,
	"DELETE_HOST_AGENT_SCAN_RESULT":         OperationTypeDeleteHostAgentScanResult,
	"DELETE_HOST_PORT_SCAN_RESULT":          OperationTypeDeleteHostPortScanResult,
	"DELETE_HOST_CIS_BENCHMARK_SCAN_RESULT": OperationTypeDeleteHostCisBenchmarkScanResult,
	"DELETE_CONTAINER_SCAN_RESULT":          OperationTypeDeleteContainerScanResult,
}

var mappingOperationTypeEnumLowerCase = map[string]OperationTypeEnum{
	"create_host_scan_recipe":               OperationTypeCreateHostScanRecipe,
	"update_host_scan_recipe":               OperationTypeUpdateHostScanRecipe,
	"delete_host_scan_recipe":               OperationTypeDeleteHostScanRecipe,
	"create_host_scan_target":               OperationTypeCreateHostScanTarget,
	"update_host_scan_target":               OperationTypeUpdateHostScanTarget,
	"delete_host_scan_target":               OperationTypeDeleteHostScanTarget,
	"create_container_scan_recipe":          OperationTypeCreateContainerScanRecipe,
	"update_container_scan_recipe":          OperationTypeUpdateContainerScanRecipe,
	"delete_container_scan_recipe":          OperationTypeDeleteContainerScanRecipe,
	"create_container_scan_target":          OperationTypeCreateContainerScanTarget,
	"update_container_scan_target":          OperationTypeUpdateContainerScanTarget,
	"delete_container_scan_target":          OperationTypeDeleteContainerScanTarget,
	"delete_host_agent_scan_result":         OperationTypeDeleteHostAgentScanResult,
	"delete_host_port_scan_result":          OperationTypeDeleteHostPortScanResult,
	"delete_host_cis_benchmark_scan_result": OperationTypeDeleteHostCisBenchmarkScanResult,
	"delete_container_scan_result":          OperationTypeDeleteContainerScanResult,
}

// GetOperationTypeEnumValues Enumerates the set of values for OperationTypeEnum
func GetOperationTypeEnumValues() []OperationTypeEnum {
	values := make([]OperationTypeEnum, 0)
	for _, v := range mappingOperationTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetOperationTypeEnumStringValues Enumerates the set of values in String for OperationTypeEnum
func GetOperationTypeEnumStringValues() []string {
	return []string{
		"CREATE_HOST_SCAN_RECIPE",
		"UPDATE_HOST_SCAN_RECIPE",
		"DELETE_HOST_SCAN_RECIPE",
		"CREATE_HOST_SCAN_TARGET",
		"UPDATE_HOST_SCAN_TARGET",
		"DELETE_HOST_SCAN_TARGET",
		"CREATE_CONTAINER_SCAN_RECIPE",
		"UPDATE_CONTAINER_SCAN_RECIPE",
		"DELETE_CONTAINER_SCAN_RECIPE",
		"CREATE_CONTAINER_SCAN_TARGET",
		"UPDATE_CONTAINER_SCAN_TARGET",
		"DELETE_CONTAINER_SCAN_TARGET",
		"DELETE_HOST_AGENT_SCAN_RESULT",
		"DELETE_HOST_PORT_SCAN_RESULT",
		"DELETE_HOST_CIS_BENCHMARK_SCAN_RESULT",
		"DELETE_CONTAINER_SCAN_RESULT",
	}
}

// GetMappingOperationTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingOperationTypeEnum(val string) (OperationTypeEnum, bool) {
	enum, ok := mappingOperationTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
