// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Java Management Service API
//
// API for the Java Management Service. Use this API to view, create, and manage Fleets.
//

package jms

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// UpdateDrsFileDetails Details of the request to update DRS file in a Fleet.
type UpdateDrsFileDetails struct {

	// The Object Storage bucket name where the DRS file is located.
	BucketName *string `mandatory:"true" json:"bucketName"`

	// The namespace for Object Storage.
	Namespace *string `mandatory:"true" json:"namespace"`

	// The name of the DRS file in Object Store.
	DrsFileName *string `mandatory:"true" json:"drsFileName"`
}

func (m UpdateDrsFileDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m UpdateDrsFileDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
