// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// HostEndpointProtectionScanLevelEnum Enum with underlying type: string
type HostEndpointProtectionScanLevelEnum string

// Set of constants representing the allowable values for HostEndpointProtectionScanLevelEnum
const (
	HostEndpointProtectionScanLevelNone     HostEndpointProtectionScanLevelEnum = "NONE"
	HostEndpointProtectionScanLevelStandard HostEndpointProtectionScanLevelEnum = "STANDARD"
)

var mappingHostEndpointProtectionScanLevelEnum = map[string]HostEndpointProtectionScanLevelEnum{
	"NONE":     HostEndpointProtectionScanLevelNone,
	"STANDARD": HostEndpointProtectionScanLevelStandard,
}

var mappingHostEndpointProtectionScanLevelEnumLowerCase = map[string]HostEndpointProtectionScanLevelEnum{
	"none":     HostEndpointProtectionScanLevelNone,
	"standard": HostEndpointProtectionScanLevelStandard,
}

// GetHostEndpointProtectionScanLevelEnumValues Enumerates the set of values for HostEndpointProtectionScanLevelEnum
func GetHostEndpointProtectionScanLevelEnumValues() []HostEndpointProtectionScanLevelEnum {
	values := make([]HostEndpointProtectionScanLevelEnum, 0)
	for _, v := range mappingHostEndpointProtectionScanLevelEnum {
		values = append(values, v)
	}
	return values
}

// GetHostEndpointProtectionScanLevelEnumStringValues Enumerates the set of values in String for HostEndpointProtectionScanLevelEnum
func GetHostEndpointProtectionScanLevelEnumStringValues() []string {
	return []string{
		"NONE",
		"STANDARD",
	}
}

// GetMappingHostEndpointProtectionScanLevelEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingHostEndpointProtectionScanLevelEnum(val string) (HostEndpointProtectionScanLevelEnum, bool) {
	enum, ok := mappingHostEndpointProtectionScanLevelEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
