// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Core Services API
//
// Use the Core Services API to manage resources such as virtual cloud networks (VCNs),
// compute instances, and block storage volumes. For more information, see the console
// documentation for the Networking (https://docs.oracle.com/iaas/Content/Network/Concepts/overview.htm),
// Compute (https://docs.oracle.com/iaas/Content/Compute/Concepts/computeoverview.htm), and
// Block Volume (https://docs.oracle.com/iaas/Content/Block/Concepts/overview.htm) services.
// The required permissions are documented in the
// Details for the Core Services (https://docs.oracle.com/iaas/Content/Identity/Reference/corepolicyreference.htm) article.
//

package core

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// IpInventoryCollection The results returned by a `ListIpInventory` operation.
type IpInventoryCollection struct {

	// Species the count for the number of results for the response.
	Count *int `mandatory:"false" json:"count"`

	// The timestamp of the latest update from the database in the format defined by RFC3339 (https://tools.ietf.org/html/rfc3339).
	// Example: `2016-08-25T21:10:29.600Z`
	LastUpdatedTimestamp *common.SDKTime `mandatory:"false" json:"lastUpdatedTimestamp"`

	// The number of compartments per compartments per tenant.
	CompartmentsPerTenant *int64 `mandatory:"false" json:"compartmentsPerTenant"`

	// Lists `IpInventoryVcnSummary` objects.
	InventoryVcnCollection []InventoryVcnSummary `mandatory:"false" json:"inventoryVcnCollection"`

	// Indicates the status of the data.
	Message *string `mandatory:"false" json:"message"`
}

func (m IpInventoryCollection) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m IpInventoryCollection) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
