// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package onesubscription

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListInvoicelineComputedUsagesRequest wrapper for the ListInvoicelineComputedUsages operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/onesubscription/ListInvoicelineComputedUsages.go.html to see an example of how to use ListInvoicelineComputedUsagesRequest.
type ListInvoicelineComputedUsagesRequest struct {

	// The OCID of the root compartment.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// Invoice Line Identifier - Primary Key SPM
	InvoiceLineId *string `mandatory:"true" contributesTo:"query" name:"invoiceLineId"`

	// The sort order to use, either ascending ('ASC') or descending ('DESC').
	SortOrder ListInvoicelineComputedUsagesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by Invoiced Computed Usages. You can provide one sort order (`sortOrder`).
	SortBy ListInvoicelineComputedUsagesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The maximum number of items to return in a paginated "List" call. Default: (`50`)
	// Example: '500'
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The value of the 'opc-next-page' response header from the previous "List" call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// Partial response refers to an optimization technique offered
	// by the RESTful web APIs to return only the information
	// (fields) required by the client. This parameter is used to control what fields to
	// return.
	Fields []string `contributesTo:"query" name:"fields" collectionFormat:"multi"`

	// Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListInvoicelineComputedUsagesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListInvoicelineComputedUsagesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListInvoicelineComputedUsagesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListInvoicelineComputedUsagesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListInvoicelineComputedUsagesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListInvoicelineComputedUsagesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListInvoicelineComputedUsagesSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListInvoicelineComputedUsagesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListInvoicelineComputedUsagesSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListInvoicelineComputedUsagesResponse wrapper for the ListInvoicelineComputedUsages operation
type ListInvoicelineComputedUsagesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of []InvoicelineComputedUsageSummary instances
	Items []InvoicelineComputedUsageSummary `presentIn:"body"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`

	// Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
	// particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`
}

func (response ListInvoicelineComputedUsagesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListInvoicelineComputedUsagesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListInvoicelineComputedUsagesSortOrderEnum Enum with underlying type: string
type ListInvoicelineComputedUsagesSortOrderEnum string

// Set of constants representing the allowable values for ListInvoicelineComputedUsagesSortOrderEnum
const (
	ListInvoicelineComputedUsagesSortOrderAsc  ListInvoicelineComputedUsagesSortOrderEnum = "ASC"
	ListInvoicelineComputedUsagesSortOrderDesc ListInvoicelineComputedUsagesSortOrderEnum = "DESC"
)

var mappingListInvoicelineComputedUsagesSortOrderEnum = map[string]ListInvoicelineComputedUsagesSortOrderEnum{
	"ASC":  ListInvoicelineComputedUsagesSortOrderAsc,
	"DESC": ListInvoicelineComputedUsagesSortOrderDesc,
}

var mappingListInvoicelineComputedUsagesSortOrderEnumLowerCase = map[string]ListInvoicelineComputedUsagesSortOrderEnum{
	"asc":  ListInvoicelineComputedUsagesSortOrderAsc,
	"desc": ListInvoicelineComputedUsagesSortOrderDesc,
}

// GetListInvoicelineComputedUsagesSortOrderEnumValues Enumerates the set of values for ListInvoicelineComputedUsagesSortOrderEnum
func GetListInvoicelineComputedUsagesSortOrderEnumValues() []ListInvoicelineComputedUsagesSortOrderEnum {
	values := make([]ListInvoicelineComputedUsagesSortOrderEnum, 0)
	for _, v := range mappingListInvoicelineComputedUsagesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListInvoicelineComputedUsagesSortOrderEnumStringValues Enumerates the set of values in String for ListInvoicelineComputedUsagesSortOrderEnum
func GetListInvoicelineComputedUsagesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListInvoicelineComputedUsagesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListInvoicelineComputedUsagesSortOrderEnum(val string) (ListInvoicelineComputedUsagesSortOrderEnum, bool) {
	enum, ok := mappingListInvoicelineComputedUsagesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListInvoicelineComputedUsagesSortByEnum Enum with underlying type: string
type ListInvoicelineComputedUsagesSortByEnum string

// Set of constants representing the allowable values for ListInvoicelineComputedUsagesSortByEnum
const (
	ListInvoicelineComputedUsagesSortByTimecreated   ListInvoicelineComputedUsagesSortByEnum = "timeCreated"
	ListInvoicelineComputedUsagesSortByMeteredondate ListInvoicelineComputedUsagesSortByEnum = "meteredOnDate"
)

var mappingListInvoicelineComputedUsagesSortByEnum = map[string]ListInvoicelineComputedUsagesSortByEnum{
	"timeCreated":   ListInvoicelineComputedUsagesSortByTimecreated,
	"meteredOnDate": ListInvoicelineComputedUsagesSortByMeteredondate,
}

var mappingListInvoicelineComputedUsagesSortByEnumLowerCase = map[string]ListInvoicelineComputedUsagesSortByEnum{
	"timecreated":   ListInvoicelineComputedUsagesSortByTimecreated,
	"meteredondate": ListInvoicelineComputedUsagesSortByMeteredondate,
}

// GetListInvoicelineComputedUsagesSortByEnumValues Enumerates the set of values for ListInvoicelineComputedUsagesSortByEnum
func GetListInvoicelineComputedUsagesSortByEnumValues() []ListInvoicelineComputedUsagesSortByEnum {
	values := make([]ListInvoicelineComputedUsagesSortByEnum, 0)
	for _, v := range mappingListInvoicelineComputedUsagesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListInvoicelineComputedUsagesSortByEnumStringValues Enumerates the set of values in String for ListInvoicelineComputedUsagesSortByEnum
func GetListInvoicelineComputedUsagesSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"meteredOnDate",
	}
}

// GetMappingListInvoicelineComputedUsagesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListInvoicelineComputedUsagesSortByEnum(val string) (ListInvoicelineComputedUsagesSortByEnum, bool) {
	enum, ok := mappingListInvoicelineComputedUsagesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
