package uniseg

// Code generated via go generate from gen_breaktest.go. DO NOT EDIT.

// graphemeBreakTestCases are Grapheme testcases taken from
// https://www.unicode.org/Public/14.0.0/ucd/auxiliary/GraphemeBreakTest.txt
// on July 25, 2022. See
// https://www.unicode.org/license.html for the Unicode license agreement.
var graphemeBreakTestCases = []testCase{
	{original: "\u0020\u0020", expected: [][]rune{{0x0020}, {0x0020}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0020\u0308\u0020", expected: [][]rune{{0x0020, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0020\u000D", expected: [][]rune{{0x0020}, {0x000D}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0020\u0308\u000D", expected: [][]rune{{0x0020, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0020\u000A", expected: [][]rune{{0x0020}, {0x000A}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0020\u0308\u000A", expected: [][]rune{{0x0020, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0020\u0001", expected: [][]rune{{0x0020}, {0x0001}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0020\u0308\u0001", expected: [][]rune{{0x0020, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0020\u034F", expected: [][]rune{{0x0020, 0x034F}}},                                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0020\u0308\u034F", expected: [][]rune{{0x0020, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0020\U0001F1E6", expected: [][]rune{{0x0020}, {0x1F1E6}}},                                                                            // ÷ [0.2] SPACE (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0020\u0308\U0001F1E6", expected: [][]rune{{0x0020, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0020\u0600", expected: [][]rune{{0x0020}, {0x0600}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0020\u0308\u0600", expected: [][]rune{{0x0020, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0020\u0903", expected: [][]rune{{0x0020, 0x0903}}},                                                                                   // ÷ [0.2] SPACE (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0020\u0308\u0903", expected: [][]rune{{0x0020, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0020\u1100", expected: [][]rune{{0x0020}, {0x1100}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0020\u0308\u1100", expected: [][]rune{{0x0020, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0020\u1160", expected: [][]rune{{0x0020}, {0x1160}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0020\u0308\u1160", expected: [][]rune{{0x0020, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0020\u11A8", expected: [][]rune{{0x0020}, {0x11A8}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0020\u0308\u11A8", expected: [][]rune{{0x0020, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0020\uAC00", expected: [][]rune{{0x0020}, {0xAC00}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0020\u0308\uAC00", expected: [][]rune{{0x0020, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0020\uAC01", expected: [][]rune{{0x0020}, {0xAC01}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0020\u0308\uAC01", expected: [][]rune{{0x0020, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0020\u231A", expected: [][]rune{{0x0020}, {0x231A}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0020\u0308\u231A", expected: [][]rune{{0x0020, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0020\u0300", expected: [][]rune{{0x0020, 0x0300}}},                                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0020\u0308\u0300", expected: [][]rune{{0x0020, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0020\u200D", expected: [][]rune{{0x0020, 0x200D}}},                                                                                   // ÷ [0.2] SPACE (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0020\u0308\u200D", expected: [][]rune{{0x0020, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0020\u0378", expected: [][]rune{{0x0020}, {0x0378}}},                                                                                 // ÷ [0.2] SPACE (Other) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0020\u0308\u0378", expected: [][]rune{{0x0020, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u000D\u0020", expected: [][]rune{{0x000D}, {0x0020}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] SPACE (Other) ÷ [0.3]
	{original: "\u000D\u0308\u0020", expected: [][]rune{{0x000D}, {0x0308}, {0x0020}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u000D\u000D", expected: [][]rune{{0x000D}, {0x000D}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u0308\u000D", expected: [][]rune{{0x000D}, {0x0308}, {0x000D}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u000A", expected: [][]rune{{0x000D, 0x000A}}},                                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u0308\u000A", expected: [][]rune{{0x000D}, {0x0308}, {0x000A}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u0001", expected: [][]rune{{0x000D}, {0x0001}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u000D\u0308\u0001", expected: [][]rune{{0x000D}, {0x0308}, {0x0001}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u000D\u034F", expected: [][]rune{{0x000D}, {0x034F}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u000D\u0308\u034F", expected: [][]rune{{0x000D}, {0x0308, 0x034F}}},                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u000D\U0001F1E6", expected: [][]rune{{0x000D}, {0x1F1E6}}},                                                                            // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000D\u0308\U0001F1E6", expected: [][]rune{{0x000D}, {0x0308}, {0x1F1E6}}},                                                            // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000D\u0600", expected: [][]rune{{0x000D}, {0x0600}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u000D\u0308\u0600", expected: [][]rune{{0x000D}, {0x0308}, {0x0600}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u000D\u0903", expected: [][]rune{{0x000D}, {0x0903}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u000D\u0308\u0903", expected: [][]rune{{0x000D}, {0x0308, 0x0903}}},                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u000D\u1100", expected: [][]rune{{0x000D}, {0x1100}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u000D\u0308\u1100", expected: [][]rune{{0x000D}, {0x0308}, {0x1100}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u000D\u1160", expected: [][]rune{{0x000D}, {0x1160}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u000D\u0308\u1160", expected: [][]rune{{0x000D}, {0x0308}, {0x1160}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u000D\u11A8", expected: [][]rune{{0x000D}, {0x11A8}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u000D\u0308\u11A8", expected: [][]rune{{0x000D}, {0x0308}, {0x11A8}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u000D\uAC00", expected: [][]rune{{0x000D}, {0xAC00}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u000D\u0308\uAC00", expected: [][]rune{{0x000D}, {0x0308}, {0xAC00}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u000D\uAC01", expected: [][]rune{{0x000D}, {0xAC01}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u000D\u0308\uAC01", expected: [][]rune{{0x000D}, {0x0308}, {0xAC01}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u000D\u231A", expected: [][]rune{{0x000D}, {0x231A}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000D\u0308\u231A", expected: [][]rune{{0x000D}, {0x0308}, {0x231A}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000D\u0300", expected: [][]rune{{0x000D}, {0x0300}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u000D\u0308\u0300", expected: [][]rune{{0x000D}, {0x0308, 0x0300}}},                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u000D\u200D", expected: [][]rune{{0x000D}, {0x200D}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u000D\u0308\u200D", expected: [][]rune{{0x000D}, {0x0308, 0x200D}}},                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u000D\u0378", expected: [][]rune{{0x000D}, {0x0378}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u000D\u0308\u0378", expected: [][]rune{{0x000D}, {0x0308}, {0x0378}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u000A\u0020", expected: [][]rune{{0x000A}, {0x0020}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] SPACE (Other) ÷ [0.3]
	{original: "\u000A\u0308\u0020", expected: [][]rune{{0x000A}, {0x0308}, {0x0020}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u000A\u000D", expected: [][]rune{{0x000A}, {0x000D}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000A\u0308\u000D", expected: [][]rune{{0x000A}, {0x0308}, {0x000D}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000A\u000A", expected: [][]rune{{0x000A}, {0x000A}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000A\u0308\u000A", expected: [][]rune{{0x000A}, {0x0308}, {0x000A}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000A\u0001", expected: [][]rune{{0x000A}, {0x0001}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u000A\u0308\u0001", expected: [][]rune{{0x000A}, {0x0308}, {0x0001}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u000A\u034F", expected: [][]rune{{0x000A}, {0x034F}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u000A\u0308\u034F", expected: [][]rune{{0x000A}, {0x0308, 0x034F}}},                                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u000A\U0001F1E6", expected: [][]rune{{0x000A}, {0x1F1E6}}},                                                                            // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000A\u0308\U0001F1E6", expected: [][]rune{{0x000A}, {0x0308}, {0x1F1E6}}},                                                            // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000A\u0600", expected: [][]rune{{0x000A}, {0x0600}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u000A\u0308\u0600", expected: [][]rune{{0x000A}, {0x0308}, {0x0600}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u000A\u0903", expected: [][]rune{{0x000A}, {0x0903}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u000A\u0308\u0903", expected: [][]rune{{0x000A}, {0x0308, 0x0903}}},                                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u000A\u1100", expected: [][]rune{{0x000A}, {0x1100}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u000A\u0308\u1100", expected: [][]rune{{0x000A}, {0x0308}, {0x1100}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u000A\u1160", expected: [][]rune{{0x000A}, {0x1160}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u000A\u0308\u1160", expected: [][]rune{{0x000A}, {0x0308}, {0x1160}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u000A\u11A8", expected: [][]rune{{0x000A}, {0x11A8}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u000A\u0308\u11A8", expected: [][]rune{{0x000A}, {0x0308}, {0x11A8}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u000A\uAC00", expected: [][]rune{{0x000A}, {0xAC00}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u000A\u0308\uAC00", expected: [][]rune{{0x000A}, {0x0308}, {0xAC00}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u000A\uAC01", expected: [][]rune{{0x000A}, {0xAC01}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u000A\u0308\uAC01", expected: [][]rune{{0x000A}, {0x0308}, {0xAC01}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u000A\u231A", expected: [][]rune{{0x000A}, {0x231A}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000A\u0308\u231A", expected: [][]rune{{0x000A}, {0x0308}, {0x231A}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000A\u0300", expected: [][]rune{{0x000A}, {0x0300}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u000A\u0308\u0300", expected: [][]rune{{0x000A}, {0x0308, 0x0300}}},                                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u000A\u200D", expected: [][]rune{{0x000A}, {0x200D}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u000A\u0308\u200D", expected: [][]rune{{0x000A}, {0x0308, 0x200D}}},                                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u000A\u0378", expected: [][]rune{{0x000A}, {0x0378}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u000A\u0308\u0378", expected: [][]rune{{0x000A}, {0x0308}, {0x0378}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0001\u0020", expected: [][]rune{{0x0001}, {0x0020}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] SPACE (Other) ÷ [0.3]
	{original: "\u0001\u0308\u0020", expected: [][]rune{{0x0001}, {0x0308}, {0x0020}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0001\u000D", expected: [][]rune{{0x0001}, {0x000D}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0001\u0308\u000D", expected: [][]rune{{0x0001}, {0x0308}, {0x000D}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0001\u000A", expected: [][]rune{{0x0001}, {0x000A}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0001\u0308\u000A", expected: [][]rune{{0x0001}, {0x0308}, {0x000A}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0001\u0001", expected: [][]rune{{0x0001}, {0x0001}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0001\u0308\u0001", expected: [][]rune{{0x0001}, {0x0308}, {0x0001}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0001\u034F", expected: [][]rune{{0x0001}, {0x034F}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0001\u0308\u034F", expected: [][]rune{{0x0001}, {0x0308, 0x034F}}},                                                                   // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0001\U0001F1E6", expected: [][]rune{{0x0001}, {0x1F1E6}}},                                                                            // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0001\u0308\U0001F1E6", expected: [][]rune{{0x0001}, {0x0308}, {0x1F1E6}}},                                                            // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0001\u0600", expected: [][]rune{{0x0001}, {0x0600}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0001\u0308\u0600", expected: [][]rune{{0x0001}, {0x0308}, {0x0600}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0001\u0903", expected: [][]rune{{0x0001}, {0x0903}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0001\u0308\u0903", expected: [][]rune{{0x0001}, {0x0308, 0x0903}}},                                                                   // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0001\u1100", expected: [][]rune{{0x0001}, {0x1100}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0001\u0308\u1100", expected: [][]rune{{0x0001}, {0x0308}, {0x1100}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0001\u1160", expected: [][]rune{{0x0001}, {0x1160}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0001\u0308\u1160", expected: [][]rune{{0x0001}, {0x0308}, {0x1160}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0001\u11A8", expected: [][]rune{{0x0001}, {0x11A8}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0001\u0308\u11A8", expected: [][]rune{{0x0001}, {0x0308}, {0x11A8}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0001\uAC00", expected: [][]rune{{0x0001}, {0xAC00}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0001\u0308\uAC00", expected: [][]rune{{0x0001}, {0x0308}, {0xAC00}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0001\uAC01", expected: [][]rune{{0x0001}, {0xAC01}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0001\u0308\uAC01", expected: [][]rune{{0x0001}, {0x0308}, {0xAC01}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0001\u231A", expected: [][]rune{{0x0001}, {0x231A}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0001\u0308\u231A", expected: [][]rune{{0x0001}, {0x0308}, {0x231A}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0001\u0300", expected: [][]rune{{0x0001}, {0x0300}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0001\u0308\u0300", expected: [][]rune{{0x0001}, {0x0308, 0x0300}}},                                                                   // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0001\u200D", expected: [][]rune{{0x0001}, {0x200D}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0001\u0308\u200D", expected: [][]rune{{0x0001}, {0x0308, 0x200D}}},                                                                   // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0001\u0378", expected: [][]rune{{0x0001}, {0x0378}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0001\u0308\u0378", expected: [][]rune{{0x0001}, {0x0308}, {0x0378}}},                                                                 // ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u034F\u0020", expected: [][]rune{{0x034F}, {0x0020}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u034F\u0308\u0020", expected: [][]rune{{0x034F, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u034F\u000D", expected: [][]rune{{0x034F}, {0x000D}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u034F\u0308\u000D", expected: [][]rune{{0x034F, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u034F\u000A", expected: [][]rune{{0x034F}, {0x000A}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u034F\u0308\u000A", expected: [][]rune{{0x034F, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u034F\u0001", expected: [][]rune{{0x034F}, {0x0001}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u034F\u0308\u0001", expected: [][]rune{{0x034F, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u034F\u034F", expected: [][]rune{{0x034F, 0x034F}}},                                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u034F\u0308\u034F", expected: [][]rune{{0x034F, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u034F\U0001F1E6", expected: [][]rune{{0x034F}, {0x1F1E6}}},                                                                            // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u034F\u0308\U0001F1E6", expected: [][]rune{{0x034F, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u034F\u0600", expected: [][]rune{{0x034F}, {0x0600}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u034F\u0308\u0600", expected: [][]rune{{0x034F, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u034F\u0903", expected: [][]rune{{0x034F, 0x0903}}},                                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u034F\u0308\u0903", expected: [][]rune{{0x034F, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u034F\u1100", expected: [][]rune{{0x034F}, {0x1100}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u034F\u0308\u1100", expected: [][]rune{{0x034F, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u034F\u1160", expected: [][]rune{{0x034F}, {0x1160}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u034F\u0308\u1160", expected: [][]rune{{0x034F, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u034F\u11A8", expected: [][]rune{{0x034F}, {0x11A8}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u034F\u0308\u11A8", expected: [][]rune{{0x034F, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u034F\uAC00", expected: [][]rune{{0x034F}, {0xAC00}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u034F\u0308\uAC00", expected: [][]rune{{0x034F, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u034F\uAC01", expected: [][]rune{{0x034F}, {0xAC01}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u034F\u0308\uAC01", expected: [][]rune{{0x034F, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u034F\u231A", expected: [][]rune{{0x034F}, {0x231A}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u034F\u0308\u231A", expected: [][]rune{{0x034F, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u034F\u0300", expected: [][]rune{{0x034F, 0x0300}}},                                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u034F\u0308\u0300", expected: [][]rune{{0x034F, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u034F\u200D", expected: [][]rune{{0x034F, 0x200D}}},                                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u034F\u0308\u200D", expected: [][]rune{{0x034F, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u034F\u0378", expected: [][]rune{{0x034F}, {0x0378}}},                                                                                 // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u034F\u0308\u0378", expected: [][]rune{{0x034F, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\U0001F1E6\u0020", expected: [][]rune{{0x1F1E6}, {0x0020}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0020", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0020}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\U0001F1E6\u000D", expected: [][]rune{{0x1F1E6}, {0x000D}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u000D", expected: [][]rune{{0x1F1E6, 0x0308}, {0x000D}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\U0001F1E6\u000A", expected: [][]rune{{0x1F1E6}, {0x000A}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u000A", expected: [][]rune{{0x1F1E6, 0x0308}, {0x000A}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\U0001F1E6\u0001", expected: [][]rune{{0x1F1E6}, {0x0001}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0001", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0001}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\U0001F1E6\u034F", expected: [][]rune{{0x1F1E6, 0x034F}}},                                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u034F", expected: [][]rune{{0x1F1E6, 0x0308, 0x034F}}},                                                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\U0001F1E6\U0001F1E6", expected: [][]rune{{0x1F1E6, 0x1F1E6}}},                                                                         // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\U0001F1E6\u0308\U0001F1E6", expected: [][]rune{{0x1F1E6, 0x0308}, {0x1F1E6}}},                                                         // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\U0001F1E6\u0600", expected: [][]rune{{0x1F1E6}, {0x0600}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0600", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0600}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\U0001F1E6\u0903", expected: [][]rune{{0x1F1E6, 0x0903}}},                                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0903", expected: [][]rune{{0x1F1E6, 0x0308, 0x0903}}},                                                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\U0001F1E6\u1100", expected: [][]rune{{0x1F1E6}, {0x1100}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u1100", expected: [][]rune{{0x1F1E6, 0x0308}, {0x1100}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\U0001F1E6\u1160", expected: [][]rune{{0x1F1E6}, {0x1160}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u1160", expected: [][]rune{{0x1F1E6, 0x0308}, {0x1160}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\U0001F1E6\u11A8", expected: [][]rune{{0x1F1E6}, {0x11A8}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u11A8", expected: [][]rune{{0x1F1E6, 0x0308}, {0x11A8}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\U0001F1E6\uAC00", expected: [][]rune{{0x1F1E6}, {0xAC00}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\U0001F1E6\u0308\uAC00", expected: [][]rune{{0x1F1E6, 0x0308}, {0xAC00}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\U0001F1E6\uAC01", expected: [][]rune{{0x1F1E6}, {0xAC01}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\U0001F1E6\u0308\uAC01", expected: [][]rune{{0x1F1E6, 0x0308}, {0xAC01}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\U0001F1E6\u231A", expected: [][]rune{{0x1F1E6}, {0x231A}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u231A", expected: [][]rune{{0x1F1E6, 0x0308}, {0x231A}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\U0001F1E6\u0300", expected: [][]rune{{0x1F1E6, 0x0300}}},                                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0300", expected: [][]rune{{0x1F1E6, 0x0308, 0x0300}}},                                                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\U0001F1E6\u200D", expected: [][]rune{{0x1F1E6, 0x200D}}},                                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u200D", expected: [][]rune{{0x1F1E6, 0x0308, 0x200D}}},                                                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\U0001F1E6\u0378", expected: [][]rune{{0x1F1E6}, {0x0378}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0378", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0378}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0600\u0020", expected: [][]rune{{0x0600, 0x0020}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] SPACE (Other) ÷ [0.3]
	{original: "\u0600\u0308\u0020", expected: [][]rune{{0x0600, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0600\u000D", expected: [][]rune{{0x0600}, {0x000D}}},                                                                                 // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0600\u0308\u000D", expected: [][]rune{{0x0600, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0600\u000A", expected: [][]rune{{0x0600}, {0x000A}}},                                                                                 // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0600\u0308\u000A", expected: [][]rune{{0x0600, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0600\u0001", expected: [][]rune{{0x0600}, {0x0001}}},                                                                                 // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0600\u0308\u0001", expected: [][]rune{{0x0600, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0600\u034F", expected: [][]rune{{0x0600, 0x034F}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0600\u0308\u034F", expected: [][]rune{{0x0600, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0600\U0001F1E6", expected: [][]rune{{0x0600, 0x1F1E6}}},                                                                              // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0600\u0308\U0001F1E6", expected: [][]rune{{0x0600, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0600\u0600", expected: [][]rune{{0x0600, 0x0600}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0600\u0308\u0600", expected: [][]rune{{0x0600, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0600\u0903", expected: [][]rune{{0x0600, 0x0903}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0600\u0308\u0903", expected: [][]rune{{0x0600, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0600\u1100", expected: [][]rune{{0x0600, 0x1100}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0600\u0308\u1100", expected: [][]rune{{0x0600, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0600\u1160", expected: [][]rune{{0x0600, 0x1160}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0600\u0308\u1160", expected: [][]rune{{0x0600, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0600\u11A8", expected: [][]rune{{0x0600, 0x11A8}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0600\u0308\u11A8", expected: [][]rune{{0x0600, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0600\uAC00", expected: [][]rune{{0x0600, 0xAC00}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0600\u0308\uAC00", expected: [][]rune{{0x0600, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0600\uAC01", expected: [][]rune{{0x0600, 0xAC01}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0600\u0308\uAC01", expected: [][]rune{{0x0600, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0600\u231A", expected: [][]rune{{0x0600, 0x231A}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0600\u0308\u231A", expected: [][]rune{{0x0600, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0600\u0300", expected: [][]rune{{0x0600, 0x0300}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0600\u0308\u0300", expected: [][]rune{{0x0600, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0600\u200D", expected: [][]rune{{0x0600, 0x200D}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0600\u0308\u200D", expected: [][]rune{{0x0600, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0600\u0378", expected: [][]rune{{0x0600, 0x0378}}},                                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0600\u0308\u0378", expected: [][]rune{{0x0600, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0903\u0020", expected: [][]rune{{0x0903}, {0x0020}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0903\u0308\u0020", expected: [][]rune{{0x0903, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0903\u000D", expected: [][]rune{{0x0903}, {0x000D}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0903\u0308\u000D", expected: [][]rune{{0x0903, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0903\u000A", expected: [][]rune{{0x0903}, {0x000A}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0903\u0308\u000A", expected: [][]rune{{0x0903, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0903\u0001", expected: [][]rune{{0x0903}, {0x0001}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0903\u0308\u0001", expected: [][]rune{{0x0903, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0903\u034F", expected: [][]rune{{0x0903, 0x034F}}},                                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0903\u0308\u034F", expected: [][]rune{{0x0903, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0903\U0001F1E6", expected: [][]rune{{0x0903}, {0x1F1E6}}},                                                                            // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0903\u0308\U0001F1E6", expected: [][]rune{{0x0903, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0903\u0600", expected: [][]rune{{0x0903}, {0x0600}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0903\u0308\u0600", expected: [][]rune{{0x0903, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0903\u0903", expected: [][]rune{{0x0903, 0x0903}}},                                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0903\u0308\u0903", expected: [][]rune{{0x0903, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0903\u1100", expected: [][]rune{{0x0903}, {0x1100}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0903\u0308\u1100", expected: [][]rune{{0x0903, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0903\u1160", expected: [][]rune{{0x0903}, {0x1160}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0903\u0308\u1160", expected: [][]rune{{0x0903, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0903\u11A8", expected: [][]rune{{0x0903}, {0x11A8}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0903\u0308\u11A8", expected: [][]rune{{0x0903, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0903\uAC00", expected: [][]rune{{0x0903}, {0xAC00}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0903\u0308\uAC00", expected: [][]rune{{0x0903, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0903\uAC01", expected: [][]rune{{0x0903}, {0xAC01}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0903\u0308\uAC01", expected: [][]rune{{0x0903, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0903\u231A", expected: [][]rune{{0x0903}, {0x231A}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0903\u0308\u231A", expected: [][]rune{{0x0903, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0903\u0300", expected: [][]rune{{0x0903, 0x0300}}},                                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0903\u0308\u0300", expected: [][]rune{{0x0903, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0903\u200D", expected: [][]rune{{0x0903, 0x200D}}},                                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0903\u0308\u200D", expected: [][]rune{{0x0903, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0903\u0378", expected: [][]rune{{0x0903}, {0x0378}}},                                                                                 // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0903\u0308\u0378", expected: [][]rune{{0x0903, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u1100\u0020", expected: [][]rune{{0x1100}, {0x0020}}},                                                                                 // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u1100\u0308\u0020", expected: [][]rune{{0x1100, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u1100\u000D", expected: [][]rune{{0x1100}, {0x000D}}},                                                                                 // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1100\u0308\u000D", expected: [][]rune{{0x1100, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1100\u000A", expected: [][]rune{{0x1100}, {0x000A}}},                                                                                 // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1100\u0308\u000A", expected: [][]rune{{0x1100, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1100\u0001", expected: [][]rune{{0x1100}, {0x0001}}},                                                                                 // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u1100\u0308\u0001", expected: [][]rune{{0x1100, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u1100\u034F", expected: [][]rune{{0x1100, 0x034F}}},                                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u1100\u0308\u034F", expected: [][]rune{{0x1100, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u1100\U0001F1E6", expected: [][]rune{{0x1100}, {0x1F1E6}}},                                                                            // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u1100\u0308\U0001F1E6", expected: [][]rune{{0x1100, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u1100\u0600", expected: [][]rune{{0x1100}, {0x0600}}},                                                                                 // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u1100\u0308\u0600", expected: [][]rune{{0x1100, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u1100\u0903", expected: [][]rune{{0x1100, 0x0903}}},                                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u1100\u0308\u0903", expected: [][]rune{{0x1100, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u1100\u1100", expected: [][]rune{{0x1100, 0x1100}}},                                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u1100\u0308\u1100", expected: [][]rune{{0x1100, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u1100\u1160", expected: [][]rune{{0x1100, 0x1160}}},                                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u1100\u0308\u1160", expected: [][]rune{{0x1100, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u1100\u11A8", expected: [][]rune{{0x1100}, {0x11A8}}},                                                                                 // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u1100\u0308\u11A8", expected: [][]rune{{0x1100, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u1100\uAC00", expected: [][]rune{{0x1100, 0xAC00}}},                                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u1100\u0308\uAC00", expected: [][]rune{{0x1100, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u1100\uAC01", expected: [][]rune{{0x1100, 0xAC01}}},                                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u1100\u0308\uAC01", expected: [][]rune{{0x1100, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u1100\u231A", expected: [][]rune{{0x1100}, {0x231A}}},                                                                                 // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u1100\u0308\u231A", expected: [][]rune{{0x1100, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u1100\u0300", expected: [][]rune{{0x1100, 0x0300}}},                                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u1100\u0308\u0300", expected: [][]rune{{0x1100, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u1100\u200D", expected: [][]rune{{0x1100, 0x200D}}},                                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u1100\u0308\u200D", expected: [][]rune{{0x1100, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u1100\u0378", expected: [][]rune{{0x1100}, {0x0378}}},                                                                                 // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u1100\u0308\u0378", expected: [][]rune{{0x1100, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u1160\u0020", expected: [][]rune{{0x1160}, {0x0020}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u1160\u0308\u0020", expected: [][]rune{{0x1160, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u1160\u000D", expected: [][]rune{{0x1160}, {0x000D}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1160\u0308\u000D", expected: [][]rune{{0x1160, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u1160\u000A", expected: [][]rune{{0x1160}, {0x000A}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1160\u0308\u000A", expected: [][]rune{{0x1160, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u1160\u0001", expected: [][]rune{{0x1160}, {0x0001}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u1160\u0308\u0001", expected: [][]rune{{0x1160, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u1160\u034F", expected: [][]rune{{0x1160, 0x034F}}},                                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u1160\u0308\u034F", expected: [][]rune{{0x1160, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u1160\U0001F1E6", expected: [][]rune{{0x1160}, {0x1F1E6}}},                                                                            // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u1160\u0308\U0001F1E6", expected: [][]rune{{0x1160, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u1160\u0600", expected: [][]rune{{0x1160}, {0x0600}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u1160\u0308\u0600", expected: [][]rune{{0x1160, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u1160\u0903", expected: [][]rune{{0x1160, 0x0903}}},                                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u1160\u0308\u0903", expected: [][]rune{{0x1160, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u1160\u1100", expected: [][]rune{{0x1160}, {0x1100}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u1160\u0308\u1100", expected: [][]rune{{0x1160, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u1160\u1160", expected: [][]rune{{0x1160, 0x1160}}},                                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u1160\u0308\u1160", expected: [][]rune{{0x1160, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u1160\u11A8", expected: [][]rune{{0x1160, 0x11A8}}},                                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u1160\u0308\u11A8", expected: [][]rune{{0x1160, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u1160\uAC00", expected: [][]rune{{0x1160}, {0xAC00}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u1160\u0308\uAC00", expected: [][]rune{{0x1160, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u1160\uAC01", expected: [][]rune{{0x1160}, {0xAC01}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u1160\u0308\uAC01", expected: [][]rune{{0x1160, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u1160\u231A", expected: [][]rune{{0x1160}, {0x231A}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u1160\u0308\u231A", expected: [][]rune{{0x1160, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u1160\u0300", expected: [][]rune{{0x1160, 0x0300}}},                                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u1160\u0308\u0300", expected: [][]rune{{0x1160, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u1160\u200D", expected: [][]rune{{0x1160, 0x200D}}},                                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u1160\u0308\u200D", expected: [][]rune{{0x1160, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u1160\u0378", expected: [][]rune{{0x1160}, {0x0378}}},                                                                                 // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u1160\u0308\u0378", expected: [][]rune{{0x1160, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u11A8\u0020", expected: [][]rune{{0x11A8}, {0x0020}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u11A8\u0308\u0020", expected: [][]rune{{0x11A8, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u11A8\u000D", expected: [][]rune{{0x11A8}, {0x000D}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u11A8\u0308\u000D", expected: [][]rune{{0x11A8, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u11A8\u000A", expected: [][]rune{{0x11A8}, {0x000A}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u11A8\u0308\u000A", expected: [][]rune{{0x11A8, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u11A8\u0001", expected: [][]rune{{0x11A8}, {0x0001}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u11A8\u0308\u0001", expected: [][]rune{{0x11A8, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u11A8\u034F", expected: [][]rune{{0x11A8, 0x034F}}},                                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u11A8\u0308\u034F", expected: [][]rune{{0x11A8, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u11A8\U0001F1E6", expected: [][]rune{{0x11A8}, {0x1F1E6}}},                                                                            // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u11A8\u0308\U0001F1E6", expected: [][]rune{{0x11A8, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u11A8\u0600", expected: [][]rune{{0x11A8}, {0x0600}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u11A8\u0308\u0600", expected: [][]rune{{0x11A8, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u11A8\u0903", expected: [][]rune{{0x11A8, 0x0903}}},                                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u11A8\u0308\u0903", expected: [][]rune{{0x11A8, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u11A8\u1100", expected: [][]rune{{0x11A8}, {0x1100}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u11A8\u0308\u1100", expected: [][]rune{{0x11A8, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u11A8\u1160", expected: [][]rune{{0x11A8}, {0x1160}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u11A8\u0308\u1160", expected: [][]rune{{0x11A8, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u11A8\u11A8", expected: [][]rune{{0x11A8, 0x11A8}}},                                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u11A8\u0308\u11A8", expected: [][]rune{{0x11A8, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u11A8\uAC00", expected: [][]rune{{0x11A8}, {0xAC00}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u11A8\u0308\uAC00", expected: [][]rune{{0x11A8, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u11A8\uAC01", expected: [][]rune{{0x11A8}, {0xAC01}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u11A8\u0308\uAC01", expected: [][]rune{{0x11A8, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u11A8\u231A", expected: [][]rune{{0x11A8}, {0x231A}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u11A8\u0308\u231A", expected: [][]rune{{0x11A8, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u11A8\u0300", expected: [][]rune{{0x11A8, 0x0300}}},                                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u11A8\u0308\u0300", expected: [][]rune{{0x11A8, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u11A8\u200D", expected: [][]rune{{0x11A8, 0x200D}}},                                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u11A8\u0308\u200D", expected: [][]rune{{0x11A8, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u11A8\u0378", expected: [][]rune{{0x11A8}, {0x0378}}},                                                                                 // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u11A8\u0308\u0378", expected: [][]rune{{0x11A8, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\uAC00\u0020", expected: [][]rune{{0xAC00}, {0x0020}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\uAC00\u0308\u0020", expected: [][]rune{{0xAC00, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\uAC00\u000D", expected: [][]rune{{0xAC00}, {0x000D}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC00\u0308\u000D", expected: [][]rune{{0xAC00, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC00\u000A", expected: [][]rune{{0xAC00}, {0x000A}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC00\u0308\u000A", expected: [][]rune{{0xAC00, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC00\u0001", expected: [][]rune{{0xAC00}, {0x0001}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\uAC00\u0308\u0001", expected: [][]rune{{0xAC00, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\uAC00\u034F", expected: [][]rune{{0xAC00, 0x034F}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\uAC00\u0308\u034F", expected: [][]rune{{0xAC00, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\uAC00\U0001F1E6", expected: [][]rune{{0xAC00}, {0x1F1E6}}},                                                                            // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC00\u0308\U0001F1E6", expected: [][]rune{{0xAC00, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC00\u0600", expected: [][]rune{{0xAC00}, {0x0600}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\uAC00\u0308\u0600", expected: [][]rune{{0xAC00, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\uAC00\u0903", expected: [][]rune{{0xAC00, 0x0903}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\uAC00\u0308\u0903", expected: [][]rune{{0xAC00, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\uAC00\u1100", expected: [][]rune{{0xAC00}, {0x1100}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\uAC00\u0308\u1100", expected: [][]rune{{0xAC00, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\uAC00\u1160", expected: [][]rune{{0xAC00, 0x1160}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\uAC00\u0308\u1160", expected: [][]rune{{0xAC00, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\uAC00\u11A8", expected: [][]rune{{0xAC00, 0x11A8}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\uAC00\u0308\u11A8", expected: [][]rune{{0xAC00, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\uAC00\uAC00", expected: [][]rune{{0xAC00}, {0xAC00}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\uAC00\u0308\uAC00", expected: [][]rune{{0xAC00, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\uAC00\uAC01", expected: [][]rune{{0xAC00}, {0xAC01}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\uAC00\u0308\uAC01", expected: [][]rune{{0xAC00, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\uAC00\u231A", expected: [][]rune{{0xAC00}, {0x231A}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\uAC00\u0308\u231A", expected: [][]rune{{0xAC00, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\uAC00\u0300", expected: [][]rune{{0xAC00, 0x0300}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\uAC00\u0308\u0300", expected: [][]rune{{0xAC00, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\uAC00\u200D", expected: [][]rune{{0xAC00, 0x200D}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\uAC00\u0308\u200D", expected: [][]rune{{0xAC00, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\uAC00\u0378", expected: [][]rune{{0xAC00}, {0x0378}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\uAC00\u0308\u0378", expected: [][]rune{{0xAC00, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\uAC01\u0020", expected: [][]rune{{0xAC01}, {0x0020}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\uAC01\u0308\u0020", expected: [][]rune{{0xAC01, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\uAC01\u000D", expected: [][]rune{{0xAC01}, {0x000D}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC01\u0308\u000D", expected: [][]rune{{0xAC01, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\uAC01\u000A", expected: [][]rune{{0xAC01}, {0x000A}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC01\u0308\u000A", expected: [][]rune{{0xAC01, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\uAC01\u0001", expected: [][]rune{{0xAC01}, {0x0001}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\uAC01\u0308\u0001", expected: [][]rune{{0xAC01, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\uAC01\u034F", expected: [][]rune{{0xAC01, 0x034F}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\uAC01\u0308\u034F", expected: [][]rune{{0xAC01, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\uAC01\U0001F1E6", expected: [][]rune{{0xAC01}, {0x1F1E6}}},                                                                            // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC01\u0308\U0001F1E6", expected: [][]rune{{0xAC01, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\uAC01\u0600", expected: [][]rune{{0xAC01}, {0x0600}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\uAC01\u0308\u0600", expected: [][]rune{{0xAC01, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\uAC01\u0903", expected: [][]rune{{0xAC01, 0x0903}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\uAC01\u0308\u0903", expected: [][]rune{{0xAC01, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\uAC01\u1100", expected: [][]rune{{0xAC01}, {0x1100}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\uAC01\u0308\u1100", expected: [][]rune{{0xAC01, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\uAC01\u1160", expected: [][]rune{{0xAC01}, {0x1160}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\uAC01\u0308\u1160", expected: [][]rune{{0xAC01, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\uAC01\u11A8", expected: [][]rune{{0xAC01, 0x11A8}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\uAC01\u0308\u11A8", expected: [][]rune{{0xAC01, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\uAC01\uAC00", expected: [][]rune{{0xAC01}, {0xAC00}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\uAC01\u0308\uAC00", expected: [][]rune{{0xAC01, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\uAC01\uAC01", expected: [][]rune{{0xAC01}, {0xAC01}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\uAC01\u0308\uAC01", expected: [][]rune{{0xAC01, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\uAC01\u231A", expected: [][]rune{{0xAC01}, {0x231A}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\uAC01\u0308\u231A", expected: [][]rune{{0xAC01, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\uAC01\u0300", expected: [][]rune{{0xAC01, 0x0300}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\uAC01\u0308\u0300", expected: [][]rune{{0xAC01, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\uAC01\u200D", expected: [][]rune{{0xAC01, 0x200D}}},                                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\uAC01\u0308\u200D", expected: [][]rune{{0xAC01, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\uAC01\u0378", expected: [][]rune{{0xAC01}, {0x0378}}},                                                                                 // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\uAC01\u0308\u0378", expected: [][]rune{{0xAC01, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u231A\u0020", expected: [][]rune{{0x231A}, {0x0020}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u231A\u0308\u0020", expected: [][]rune{{0x231A, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u231A\u000D", expected: [][]rune{{0x231A}, {0x000D}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u231A\u0308\u000D", expected: [][]rune{{0x231A, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u231A\u000A", expected: [][]rune{{0x231A}, {0x000A}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u231A\u0308\u000A", expected: [][]rune{{0x231A, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u231A\u0001", expected: [][]rune{{0x231A}, {0x0001}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u231A\u0308\u0001", expected: [][]rune{{0x231A, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u231A\u034F", expected: [][]rune{{0x231A, 0x034F}}},                                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u231A\u0308\u034F", expected: [][]rune{{0x231A, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u231A\U0001F1E6", expected: [][]rune{{0x231A}, {0x1F1E6}}},                                                                            // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u231A\u0308\U0001F1E6", expected: [][]rune{{0x231A, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u231A\u0600", expected: [][]rune{{0x231A}, {0x0600}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u231A\u0308\u0600", expected: [][]rune{{0x231A, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u231A\u0903", expected: [][]rune{{0x231A, 0x0903}}},                                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u231A\u0308\u0903", expected: [][]rune{{0x231A, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u231A\u1100", expected: [][]rune{{0x231A}, {0x1100}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u231A\u0308\u1100", expected: [][]rune{{0x231A, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u231A\u1160", expected: [][]rune{{0x231A}, {0x1160}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u231A\u0308\u1160", expected: [][]rune{{0x231A, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u231A\u11A8", expected: [][]rune{{0x231A}, {0x11A8}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u231A\u0308\u11A8", expected: [][]rune{{0x231A, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u231A\uAC00", expected: [][]rune{{0x231A}, {0xAC00}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u231A\u0308\uAC00", expected: [][]rune{{0x231A, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u231A\uAC01", expected: [][]rune{{0x231A}, {0xAC01}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u231A\u0308\uAC01", expected: [][]rune{{0x231A, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u231A\u231A", expected: [][]rune{{0x231A}, {0x231A}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u231A\u0308\u231A", expected: [][]rune{{0x231A, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u231A\u0300", expected: [][]rune{{0x231A, 0x0300}}},                                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u231A\u0308\u0300", expected: [][]rune{{0x231A, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u231A\u200D", expected: [][]rune{{0x231A, 0x200D}}},                                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u231A\u0308\u200D", expected: [][]rune{{0x231A, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u231A\u0378", expected: [][]rune{{0x231A}, {0x0378}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u231A\u0308\u0378", expected: [][]rune{{0x231A, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0300\u0020", expected: [][]rune{{0x0300}, {0x0020}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0300\u0308\u0020", expected: [][]rune{{0x0300, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0300\u000D", expected: [][]rune{{0x0300}, {0x000D}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0300\u0308\u000D", expected: [][]rune{{0x0300, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0300\u000A", expected: [][]rune{{0x0300}, {0x000A}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0300\u0308\u000A", expected: [][]rune{{0x0300, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0300\u0001", expected: [][]rune{{0x0300}, {0x0001}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0300\u0308\u0001", expected: [][]rune{{0x0300, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0300\u034F", expected: [][]rune{{0x0300, 0x034F}}},                                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0300\u0308\u034F", expected: [][]rune{{0x0300, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0300\U0001F1E6", expected: [][]rune{{0x0300}, {0x1F1E6}}},                                                                            // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0300\u0308\U0001F1E6", expected: [][]rune{{0x0300, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0300\u0600", expected: [][]rune{{0x0300}, {0x0600}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0300\u0308\u0600", expected: [][]rune{{0x0300, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0300\u0903", expected: [][]rune{{0x0300, 0x0903}}},                                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0300\u0308\u0903", expected: [][]rune{{0x0300, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0300\u1100", expected: [][]rune{{0x0300}, {0x1100}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0300\u0308\u1100", expected: [][]rune{{0x0300, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0300\u1160", expected: [][]rune{{0x0300}, {0x1160}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0300\u0308\u1160", expected: [][]rune{{0x0300, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0300\u11A8", expected: [][]rune{{0x0300}, {0x11A8}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0300\u0308\u11A8", expected: [][]rune{{0x0300, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0300\uAC00", expected: [][]rune{{0x0300}, {0xAC00}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0300\u0308\uAC00", expected: [][]rune{{0x0300, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0300\uAC01", expected: [][]rune{{0x0300}, {0xAC01}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0300\u0308\uAC01", expected: [][]rune{{0x0300, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0300\u231A", expected: [][]rune{{0x0300}, {0x231A}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0300\u0308\u231A", expected: [][]rune{{0x0300, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0300\u0300", expected: [][]rune{{0x0300, 0x0300}}},                                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0300\u0308\u0300", expected: [][]rune{{0x0300, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0300\u200D", expected: [][]rune{{0x0300, 0x200D}}},                                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0300\u0308\u200D", expected: [][]rune{{0x0300, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0300\u0378", expected: [][]rune{{0x0300}, {0x0378}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0300\u0308\u0378", expected: [][]rune{{0x0300, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u200D\u0020", expected: [][]rune{{0x200D}, {0x0020}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u200D\u0308\u0020", expected: [][]rune{{0x200D, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u200D\u000D", expected: [][]rune{{0x200D}, {0x000D}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u200D\u0308\u000D", expected: [][]rune{{0x200D, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u200D\u000A", expected: [][]rune{{0x200D}, {0x000A}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u200D\u0308\u000A", expected: [][]rune{{0x200D, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u200D\u0001", expected: [][]rune{{0x200D}, {0x0001}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u200D\u0308\u0001", expected: [][]rune{{0x200D, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u200D\u034F", expected: [][]rune{{0x200D, 0x034F}}},                                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u200D\u0308\u034F", expected: [][]rune{{0x200D, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u200D\U0001F1E6", expected: [][]rune{{0x200D}, {0x1F1E6}}},                                                                            // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u200D\u0308\U0001F1E6", expected: [][]rune{{0x200D, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u200D\u0600", expected: [][]rune{{0x200D}, {0x0600}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u200D\u0308\u0600", expected: [][]rune{{0x200D, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u200D\u0903", expected: [][]rune{{0x200D, 0x0903}}},                                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u200D\u0308\u0903", expected: [][]rune{{0x200D, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u200D\u1100", expected: [][]rune{{0x200D}, {0x1100}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u200D\u0308\u1100", expected: [][]rune{{0x200D, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u200D\u1160", expected: [][]rune{{0x200D}, {0x1160}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u200D\u0308\u1160", expected: [][]rune{{0x200D, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u200D\u11A8", expected: [][]rune{{0x200D}, {0x11A8}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u200D\u0308\u11A8", expected: [][]rune{{0x200D, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u200D\uAC00", expected: [][]rune{{0x200D}, {0xAC00}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u200D\u0308\uAC00", expected: [][]rune{{0x200D, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u200D\uAC01", expected: [][]rune{{0x200D}, {0xAC01}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u200D\u0308\uAC01", expected: [][]rune{{0x200D, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u200D\u231A", expected: [][]rune{{0x200D}, {0x231A}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u200D\u0308\u231A", expected: [][]rune{{0x200D, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u200D\u0300", expected: [][]rune{{0x200D, 0x0300}}},                                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u200D\u0308\u0300", expected: [][]rune{{0x200D, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u200D\u200D", expected: [][]rune{{0x200D, 0x200D}}},                                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u200D\u0308\u200D", expected: [][]rune{{0x200D, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u200D\u0378", expected: [][]rune{{0x200D}, {0x0378}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u200D\u0308\u0378", expected: [][]rune{{0x200D, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0378\u0020", expected: [][]rune{{0x0378}, {0x0020}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0378\u0308\u0020", expected: [][]rune{{0x0378, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u0378\u000D", expected: [][]rune{{0x0378}, {0x000D}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0378\u0308\u000D", expected: [][]rune{{0x0378, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0378\u000A", expected: [][]rune{{0x0378}, {0x000A}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0378\u0308\u000A", expected: [][]rune{{0x0378, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0378\u0001", expected: [][]rune{{0x0378}, {0x0001}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0378\u0308\u0001", expected: [][]rune{{0x0378, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
	{original: "\u0378\u034F", expected: [][]rune{{0x0378, 0x034F}}},                                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0378\u0308\u034F", expected: [][]rune{{0x0378, 0x0308, 0x034F}}},                                                                     // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
	{original: "\u0378\U0001F1E6", expected: [][]rune{{0x0378}, {0x1F1E6}}},                                                                            // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0378\u0308\U0001F1E6", expected: [][]rune{{0x0378, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0378\u0600", expected: [][]rune{{0x0378}, {0x0600}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0378\u0308\u0600", expected: [][]rune{{0x0378, 0x0308}, {0x0600}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
	{original: "\u0378\u0903", expected: [][]rune{{0x0378, 0x0903}}},                                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0378\u0308\u0903", expected: [][]rune{{0x0378, 0x0308, 0x0903}}},                                                                     // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
	{original: "\u0378\u1100", expected: [][]rune{{0x0378}, {0x1100}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0378\u0308\u1100", expected: [][]rune{{0x0378, 0x0308}, {0x1100}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\u0378\u1160", expected: [][]rune{{0x0378}, {0x1160}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0378\u0308\u1160", expected: [][]rune{{0x0378, 0x0308}, {0x1160}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
	{original: "\u0378\u11A8", expected: [][]rune{{0x0378}, {0x11A8}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0378\u0308\u11A8", expected: [][]rune{{0x0378, 0x0308}, {0x11A8}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
	{original: "\u0378\uAC00", expected: [][]rune{{0x0378}, {0xAC00}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0378\u0308\uAC00", expected: [][]rune{{0x0378, 0x0308}, {0xAC00}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
	{original: "\u0378\uAC01", expected: [][]rune{{0x0378}, {0xAC01}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0378\u0308\uAC01", expected: [][]rune{{0x0378, 0x0308}, {0xAC01}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
	{original: "\u0378\u231A", expected: [][]rune{{0x0378}, {0x231A}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0378\u0308\u231A", expected: [][]rune{{0x0378, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0378\u0300", expected: [][]rune{{0x0378, 0x0300}}},                                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0378\u0308\u0300", expected: [][]rune{{0x0378, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0378\u200D", expected: [][]rune{{0x0378, 0x200D}}},                                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0378\u0308\u200D", expected: [][]rune{{0x0378, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0378\u0378", expected: [][]rune{{0x0378}, {0x0378}}},                                                                                 // ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u0378\u0308\u0378", expected: [][]rune{{0x0378, 0x0308}, {0x0378}}},                                                                   // ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
	{original: "\u000D\u000A\u0061\u000A\u0308", expected: [][]rune{{0x000D, 0x000A}, {0x0061}, {0x000A}, {0x0308}}},                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0061\u0308", expected: [][]rune{{0x0061, 0x0308}}},                                                                                   // ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [0.3]
	{original: "\u0020\u200D\u0646", expected: [][]rune{{0x0020, 0x200D}, {0x0646}}},                                                                   // ÷ [0.2] SPACE (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] ARABIC LETTER NOON (Other) ÷ [0.3]
	{original: "\u0646\u200D\u0020", expected: [][]rune{{0x0646, 0x200D}, {0x0020}}},                                                                   // ÷ [0.2] ARABIC LETTER NOON (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
	{original: "\u1100\u1100", expected: [][]rune{{0x1100, 0x1100}}},                                                                                   // ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\uAC00\u11A8\u1100", expected: [][]rune{{0xAC00, 0x11A8}, {0x1100}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\uAC01\u11A8\u1100", expected: [][]rune{{0xAC01, 0x11A8}, {0x1100}}},                                                                   // ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
	{original: "\U0001F1E6\U0001F1E7\U0001F1E8\u0062", expected: [][]rune{{0x1F1E6, 0x1F1E7}, {0x1F1E8}, {0x0062}}},                                    // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
	{original: "\u0061\U0001F1E6\U0001F1E7\U0001F1E8\u0062", expected: [][]rune{{0x0061}, {0x1F1E6, 0x1F1E7}, {0x1F1E8}, {0x0062}}},                    // ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
	{original: "\u0061\U0001F1E6\U0001F1E7\u200D\U0001F1E8\u0062", expected: [][]rune{{0x0061}, {0x1F1E6, 0x1F1E7, 0x200D}, {0x1F1E8}, {0x0062}}},      // ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
	{original: "\u0061\U0001F1E6\u200D\U0001F1E7\U0001F1E8\u0062", expected: [][]rune{{0x0061}, {0x1F1E6, 0x200D}, {0x1F1E7, 0x1F1E8}, {0x0062}}},      // ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
	{original: "\u0061\U0001F1E6\U0001F1E7\U0001F1E8\U0001F1E9\u0062", expected: [][]rune{{0x0061}, {0x1F1E6, 0x1F1E7}, {0x1F1E8, 0x1F1E9}, {0x0062}}}, // ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER D (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
	{original: "\u0061\u200D", expected: [][]rune{{0x0061, 0x200D}}},                                                                                   // ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
	{original: "\u0061\u0308\u0062", expected: [][]rune{{0x0061, 0x0308}, {0x0062}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
	{original: "\u0061\u0903\u0062", expected: [][]rune{{0x0061, 0x0903}, {0x0062}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
	{original: "\u0061\u0600\u0062", expected: [][]rune{{0x0061}, {0x0600, 0x0062}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) × [9.2] LATIN SMALL LETTER B (Other) ÷ [0.3]
	{original: "\U0001F476\U0001F3FF\U0001F476", expected: [][]rune{{0x1F476, 0x1F3FF}, {0x1F476}}},                                                    // ÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPict) ÷ [0.3]
	{original: "\u0061\U0001F3FF\U0001F476", expected: [][]rune{{0x0061, 0x1F3FF}, {0x1F476}}},                                                         // ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPict) ÷ [0.3]
	{original: "\u0061\U0001F3FF\U0001F476\u200D\U0001F6D1", expected: [][]rune{{0x0061, 0x1F3FF}, {0x1F476, 0x200D, 0x1F6D1}}},                        // ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
	{original: "\U0001F476\U0001F3FF\u0308\u200D\U0001F476\U0001F3FF", expected: [][]rune{{0x1F476, 0x1F3FF, 0x0308, 0x200D, 0x1F476, 0x1F3FF}}},       // ÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [0.3]
	{original: "\U0001F6D1\u200D\U0001F6D1", expected: [][]rune{{0x1F6D1, 0x200D, 0x1F6D1}}},                                                           // ÷ [0.2] OCTAGONAL SIGN (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
	{original: "\u0061\u200D\U0001F6D1", expected: [][]rune{{0x0061, 0x200D}, {0x1F6D1}}},                                                              // ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
	{original: "\u2701\u200D\u2701", expected: [][]rune{{0x2701, 0x200D, 0x2701}}},                                                                     // ÷ [0.2] UPPER BLADE SCISSORS (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] UPPER BLADE SCISSORS (Other) ÷ [0.3]
	{original: "\u0061\u200D\u2701", expected: [][]rune{{0x0061, 0x200D}, {0x2701}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] UPPER BLADE SCISSORS (Other) ÷ [0.3]
}
