// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package authorizedbuyersmarketplace provides access to the Authorized Buyers Marketplace API.
//
// For product documentation, see: https://developers.google.com/authorized-buyers/apis/marketplace/reference/rest/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/authorizedbuyersmarketplace/v1"
//	...
//	ctx := context.Background()
//	authorizedbuyersmarketplaceService, err := authorizedbuyersmarketplace.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	authorizedbuyersmarketplaceService, err := authorizedbuyersmarketplace.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	authorizedbuyersmarketplaceService, err := authorizedbuyersmarketplace.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package authorizedbuyersmarketplace // import "google.golang.org/api/authorizedbuyersmarketplace/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "authorizedbuyersmarketplace:v1"
const apiName = "authorizedbuyersmarketplace"
const apiVersion = "v1"
const basePath = "https://authorizedbuyersmarketplace.googleapis.com/"
const basePathTemplate = "https://authorizedbuyersmarketplace.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://authorizedbuyersmarketplace.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, create, edit, and delete your Authorized Buyers Marketplace entities.
	AuthorizedBuyersMarketplaceScope = "https://www.googleapis.com/auth/authorized-buyers-marketplace"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/authorized-buyers-marketplace",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Bidders = NewBiddersService(s)
	s.Buyers = NewBuyersService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Bidders *BiddersService

	Buyers *BuyersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewBiddersService(s *Service) *BiddersService {
	rs := &BiddersService{s: s}
	rs.AuctionPackages = NewBiddersAuctionPackagesService(s)
	rs.FinalizedDeals = NewBiddersFinalizedDealsService(s)
	return rs
}

type BiddersService struct {
	s *Service

	AuctionPackages *BiddersAuctionPackagesService

	FinalizedDeals *BiddersFinalizedDealsService
}

func NewBiddersAuctionPackagesService(s *Service) *BiddersAuctionPackagesService {
	rs := &BiddersAuctionPackagesService{s: s}
	return rs
}

type BiddersAuctionPackagesService struct {
	s *Service
}

func NewBiddersFinalizedDealsService(s *Service) *BiddersFinalizedDealsService {
	rs := &BiddersFinalizedDealsService{s: s}
	return rs
}

type BiddersFinalizedDealsService struct {
	s *Service
}

func NewBuyersService(s *Service) *BuyersService {
	rs := &BuyersService{s: s}
	rs.AuctionPackages = NewBuyersAuctionPackagesService(s)
	rs.Clients = NewBuyersClientsService(s)
	rs.FinalizedDeals = NewBuyersFinalizedDealsService(s)
	rs.Proposals = NewBuyersProposalsService(s)
	rs.PublisherProfiles = NewBuyersPublisherProfilesService(s)
	return rs
}

type BuyersService struct {
	s *Service

	AuctionPackages *BuyersAuctionPackagesService

	Clients *BuyersClientsService

	FinalizedDeals *BuyersFinalizedDealsService

	Proposals *BuyersProposalsService

	PublisherProfiles *BuyersPublisherProfilesService
}

func NewBuyersAuctionPackagesService(s *Service) *BuyersAuctionPackagesService {
	rs := &BuyersAuctionPackagesService{s: s}
	return rs
}

type BuyersAuctionPackagesService struct {
	s *Service
}

func NewBuyersClientsService(s *Service) *BuyersClientsService {
	rs := &BuyersClientsService{s: s}
	rs.Users = NewBuyersClientsUsersService(s)
	return rs
}

type BuyersClientsService struct {
	s *Service

	Users *BuyersClientsUsersService
}

func NewBuyersClientsUsersService(s *Service) *BuyersClientsUsersService {
	rs := &BuyersClientsUsersService{s: s}
	return rs
}

type BuyersClientsUsersService struct {
	s *Service
}

func NewBuyersFinalizedDealsService(s *Service) *BuyersFinalizedDealsService {
	rs := &BuyersFinalizedDealsService{s: s}
	return rs
}

type BuyersFinalizedDealsService struct {
	s *Service
}

func NewBuyersProposalsService(s *Service) *BuyersProposalsService {
	rs := &BuyersProposalsService{s: s}
	rs.Deals = NewBuyersProposalsDealsService(s)
	return rs
}

type BuyersProposalsService struct {
	s *Service

	Deals *BuyersProposalsDealsService
}

func NewBuyersProposalsDealsService(s *Service) *BuyersProposalsDealsService {
	rs := &BuyersProposalsDealsService{s: s}
	return rs
}

type BuyersProposalsDealsService struct {
	s *Service
}

func NewBuyersPublisherProfilesService(s *Service) *BuyersPublisherProfilesService {
	rs := &BuyersPublisherProfilesService{s: s}
	return rs
}

type BuyersPublisherProfilesService struct {
	s *Service
}

// AcceptProposalRequest: Request to accept a proposal. Accepting a proposal
// implies acceptance of the publisher terms_and_conditions, if any.
type AcceptProposalRequest struct {
	// ProposalRevision: The last known client revision number of the proposal.
	ProposalRevision int64 `json:"proposalRevision,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ProposalRevision") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProposalRevision") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *AcceptProposalRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AcceptProposalRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ActivateClientRequest: Request message for activating a client.
type ActivateClientRequest struct {
}

// ActivateClientUserRequest: Request message for activating a client user.
type ActivateClientUserRequest struct {
}

// AdSize: Represents size of a single ad slot, or a creative.
type AdSize struct {
	// Height: The height of the ad slot in pixels. This field will be present only
	// when size type is `PIXEL`.
	Height int64 `json:"height,omitempty,string"`
	// Type: The type of the ad slot size.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - A placeholder for an undefined size type.
	//   "PIXEL" - Ad slot with size specified by height and width in pixels.
	//   "INTERSTITIAL" - Special size to describe an interstitial ad slot.
	//   "NATIVE" - Native (mobile) ads rendered by the publisher.
	//   "FLUID" - Fluid size (responsive size) can be resized automatically with
	// the change of outside environment.
	Type string `json:"type,omitempty"`
	// Width: The width of the ad slot in pixels. This field will be present only
	// when size type is `PIXEL`.
	Width int64 `json:"width,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *AdSize) MarshalJSON() ([]byte, error) {
	type NoMethod AdSize
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// AddCreativeRequest: Request message for adding creative to be used in the
// bidding process for the finalized deal.
type AddCreativeRequest struct {
	// Creative: Name of the creative to add to the finalized deal, in the format
	// `buyers/{buyerAccountId}/creatives/{creativeId}`. See creative.name.
	Creative string `json:"creative,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Creative") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Creative") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *AddCreativeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddCreativeRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// AddNoteRequest: Request to add a note.
type AddNoteRequest struct {
	// Note: The note to add.
	Note *Note `json:"note,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Note") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Note") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *AddNoteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddNoteRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// AuctionPackage: Defines a segment of inventory that buyer wants to buy. It's
// created by buyer and could be shared with multiple buyers.
type AuctionPackage struct {
	// CreateTime: Output only. Time the auction package was created.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. The buyer that created this auction package. Format:
	// `buyers/{buyerAccountId}`
	Creator string `json:"creator,omitempty"`
	// Description: Output only. A description of the auction package.
	Description string `json:"description,omitempty"`
	// DisplayName: The display_name assigned to the auction package.
	DisplayName string `json:"displayName,omitempty"`
	// EligibleSeatIds: Output only. If set, this field contains the list of DSP
	// specific seat ids set by media planners that are eligible to transact on
	// this deal. The seat ID is in the calling DSP's namespace.
	EligibleSeatIds []string `json:"eligibleSeatIds,omitempty"`
	// Name: Immutable. The unique identifier for the auction package. Format:
	// `buyers/{accountId}/auctionPackages/{auctionPackageId}` The
	// auction_package_id part of name is sent in the BidRequest to all RTB bidders
	// and is returned as deal_id by the bidder in the BidResponse.
	Name string `json:"name,omitempty"`
	// SubscribedBuyers: Output only. The list of buyers that are subscribed to the
	// AuctionPackage. This field is only populated when calling as a bidder.
	// Format: `buyers/{buyerAccountId}`
	SubscribedBuyers []string `json:"subscribedBuyers,omitempty"`
	// SubscribedClients: Output only. When calling as a buyer, the list of clients
	// of the current buyer that are subscribed to the AuctionPackage. When calling
	// as a bidder, the list of clients that are subscribed to the AuctionPackage
	// owned by the bidder or its buyers. Format:
	// `buyers/{buyerAccountId}/clients/{clientAccountId}`
	SubscribedClients []string `json:"subscribedClients,omitempty"`
	// SubscribedMediaPlanners: Output only. The list of media planners that are
	// subscribed to the AuctionPackage. This field is only populated when calling
	// as a bidder.
	SubscribedMediaPlanners []*MediaPlanner `json:"subscribedMediaPlanners,omitempty"`
	// UpdateTime: Output only. Time the auction package was last updated. This
	// value is only increased when this auction package is updated but never when
	// a buyer subscribed.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *AuctionPackage) MarshalJSON() ([]byte, error) {
	type NoMethod AuctionPackage
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// BatchUpdateDealsRequest: Request message for batch updating deals.
type BatchUpdateDealsRequest struct {
	// Requests: Required. List of request messages to update deals.
	Requests []*UpdateDealRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateDealsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateDealsRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// BatchUpdateDealsResponse: Response message for batch updating deals.
type BatchUpdateDealsResponse struct {
	// Deals: Deals updated.
	Deals []*Deal `json:"deals,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Deals") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *BatchUpdateDealsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateDealsResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// CancelNegotiationRequest: Request to cancel an ongoing negotiation.
type CancelNegotiationRequest struct {
}

// Client: A client represents an agency, a brand, or an advertiser customer of
// the buyer. Based on the client's role, its client users will have varying
// levels of restricted access to the Marketplace and certain other sections of
// the Authorized Buyers UI.
type Client struct {
	// DisplayName: Required. Display name shown to publishers. Must be unique for
	// clients without partnerClientId specified. Maximum length of 255 characters
	// is allowed.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. The resource name of the client. Format:
	// `buyers/{accountId}/clients/{clientAccountId}`
	Name string `json:"name,omitempty"`
	// PartnerClientId: Arbitrary unique identifier provided by the buyer. This
	// field can be used to associate a client with an identifier in the namespace
	// of the buyer, lookup clients by that identifier and verify whether an
	// Authorized Buyers account of the client already exists. If present, must be
	// unique across all the clients.
	PartnerClientId string `json:"partnerClientId,omitempty"`
	// Role: Required. The role assigned to the client. Each role implies a set of
	// permissions granted to the client.
	//
	// Possible values:
	//   "CLIENT_ROLE_UNSPECIFIED" - A placeholder for an undefined client role.
	// This value should never be specified in user input for create or update
	// method, otherwise an error will be returned.
	//   "CLIENT_DEAL_VIEWER" - Users associated with this client role can only
	// view proposals and deals in the Marketplace UI. They cannot negotiate or
	// approve proposals and deals sent from publishers or send RFP to publishers.
	//   "CLIENT_DEAL_NEGOTIATOR" - Users associated with this client role can view
	// and negotiate on the proposals and deals in the Marketplace UI sent from
	// publishers and send RFP to publishers, but cannot approve the proposals and
	// deals by themselves. The buyer can approve the proposals and deals on behalf
	// of the client.
	//   "CLIENT_DEAL_APPROVER" - Users associated with this client role can view,
	// negotiate and approve proposals and deals in the Marketplace UI and send RFP
	// to publishers.
	Role string `json:"role,omitempty"`
	// SellerVisible: Whether the client will be visible to sellers.
	SellerVisible bool `json:"sellerVisible,omitempty"`
	// State: Output only. The state of the client.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - A placeholder for an undefined client state. Should
	// not be used.
	//   "ACTIVE" - A client that is currently active and allowed to access the
	// Authorized Buyers UI.
	//   "INACTIVE" - A client that is currently inactive and not allowed to access
	// the Authorized Buyers UI.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *Client) MarshalJSON() ([]byte, error) {
	type NoMethod Client
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ClientUser: A user of a client who has restricted access to the Marketplace
// and certain other sections of the Authorized Buyers UI based on the role
// granted to the associated client.
type ClientUser struct {
	// Email: Required. The client user's email address that has to be unique
	// across all users for the same client.
	Email string `json:"email,omitempty"`
	// Name: Output only. The resource name of the client user. Format:
	// `buyers/{accountId}/clients/{clientAccountId}/users/{userId}`
	Name string `json:"name,omitempty"`
	// State: Output only. The state of the client user.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - A placeholder for an undefined user state.
	//   "INVITED" - A user who was created but hasn't accepted the invitation yet,
	// not allowed to access the Authorized Buyers UI.
	//   "ACTIVE" - A user that is currently active and allowed to access the
	// Authorized Buyers UI.
	//   "INACTIVE" - A user that is currently inactive and not allowed to access
	// the Authorized Buyers UI.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *ClientUser) MarshalJSON() ([]byte, error) {
	type NoMethod ClientUser
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// Contact: Contains information on how a buyer or seller can be reached.
type Contact struct {
	// DisplayName: The display_name of the contact.
	DisplayName string `json:"displayName,omitempty"`
	// Email: Email address for the contact.
	Email string `json:"email,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *Contact) MarshalJSON() ([]byte, error) {
	type NoMethod Contact
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// CreativeRequirements: Message captures data about the creatives in the deal.
type CreativeRequirements struct {
	// CreativeFormat: Output only. The format of the creative, only applicable for
	// programmatic guaranteed and preferred deals.
	//
	// Possible values:
	//   "CREATIVE_FORMAT_UNSPECIFIED" - A placeholder for an unspecified creative
	// format.
	//   "DISPLAY" - Banner creatives such as image or HTML5 assets.
	//   "VIDEO" - Video creatives that can be played in a video player.
	//   "AUDIO" - Audio creatives that can play during audio content or point to a
	// third party ad server.
	CreativeFormat string `json:"creativeFormat,omitempty"`
	// CreativePreApprovalPolicy: Output only. Specifies the creative pre-approval
	// policy.
	//
	// Possible values:
	//   "CREATIVE_PRE_APPROVAL_POLICY_UNSPECIFIED" - A placeholder for an
	// undefined creative pre-approval policy.
	//   "SELLER_PRE_APPROVAL_REQUIRED" - The seller needs to approve each creative
	// before it can serve.
	//   "SELLER_PRE_APPROVAL_NOT_REQUIRED" - The seller does not need to approve
	// each creative before it can serve.
	CreativePreApprovalPolicy string `json:"creativePreApprovalPolicy,omitempty"`
	// CreativeSafeFrameCompatibility: Output only. Specifies whether the creative
	// is safeFrame compatible.
	//
	// Possible values:
	//   "CREATIVE_SAFE_FRAME_COMPATIBILITY_UNSPECIFIED" - A placeholder for an
	// undefined creative safe-frame compatibility.
	//   "COMPATIBLE" - The creatives need to be compatible with the safe frame
	// option.
	//   "INCOMPATIBLE" - The creatives can be incompatible with the safe frame
	// option.
	CreativeSafeFrameCompatibility string `json:"creativeSafeFrameCompatibility,omitempty"`
	// MaxAdDurationMs: Output only. The max duration of the video creative in
	// milliseconds. only applicable for deals with video creatives.
	MaxAdDurationMs int64 `json:"maxAdDurationMs,omitempty,string"`
	// ProgrammaticCreativeSource: Output only. Specifies the creative source for
	// programmatic deals. PUBLISHER means creative is provided by seller and
	// ADVERTISER means creative is provided by the buyer.
	//
	// Possible values:
	//   "PROGRAMMATIC_CREATIVE_SOURCE_UNSPECIFIED" - A placeholder for an
	// undefined programmatic creative source.
	//   "ADVERTISER" - The advertiser provides the creatives.
	//   "PUBLISHER" - The publisher provides the creatives to be served.
	ProgrammaticCreativeSource string `json:"programmaticCreativeSource,omitempty"`
	// SkippableAdType: Output only. Skippable video ads allow viewers to skip ads
	// after 5 seconds. Only applicable for deals with video creatives.
	//
	// Possible values:
	//   "SKIPPABLE_AD_TYPE_UNSPECIFIED" - A placeholder for an unspecified
	// skippable ad type.
	//   "SKIPPABLE" - Video ad that can be skipped after 5 seconds. This value
	// will appear in RTB bid requests as
	// SkippableBidRequestType::REQUIRE_SKIPPABLE.
	//   "INSTREAM_SELECT" - Video ad that can be skipped after 5 seconds, and is
	// counted as engaged view after 30 seconds. The creative is hosted on YouTube
	// only, and viewcount of the YouTube video increments after the engaged view.
	// This value will appear in RTB bid requests as
	// SkippableBidRequestType::REQUIRE_SKIPPABLE.
	//   "NOT_SKIPPABLE" - This video ad is not skippable. This value will appear
	// in RTB bid requests as SkippableBidRequestType::BLOCK_SKIPPABLE.
	//   "ANY" - This video ad can be skipped after 5 seconds or not-skippable.
	// This value will appear in RTB bid requests as
	// SkippableBidRequestType::ALLOW_SKIPPABLE.
	SkippableAdType string `json:"skippableAdType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreativeFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreativeFormat") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *CreativeRequirements) MarshalJSON() ([]byte, error) {
	type NoMethod CreativeRequirements
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// CriteriaTargeting: Generic targeting used for targeting dimensions that
// contains a list of included and excluded numeric IDs. This cannot be
// filtered using list filter syntax.
type CriteriaTargeting struct {
	// ExcludedCriteriaIds: A list of numeric IDs to be excluded.
	ExcludedCriteriaIds googleapi.Int64s `json:"excludedCriteriaIds,omitempty"`
	// TargetedCriteriaIds: A list of numeric IDs to be included.
	TargetedCriteriaIds googleapi.Int64s `json:"targetedCriteriaIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedCriteriaIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedCriteriaIds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *CriteriaTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod CriteriaTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// DayPart: Defines targeting for a period of time on a specific week day.
type DayPart struct {
	// DayOfWeek: Day of week for the period.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	DayOfWeek string `json:"dayOfWeek,omitempty"`
	// EndTime: Hours in 24 hour time between 0 and 24, inclusive. Note: 24 is
	// logically equivalent to 0, but is supported since in some cases there may
	// need to be differentiation made between midnight on one day and midnight on
	// the next day. Accepted values for minutes are [0, 15, 30, 45]. 0 is the only
	// acceptable minute value for hour 24. Seconds and nanos are ignored.
	EndTime *TimeOfDay `json:"endTime,omitempty"`
	// StartTime: Hours in 24 hour time between 0 and 24, inclusive. Note: 24 is
	// logically equivalent to 0, but is supported since in some cases there may
	// need to be differentiation made between midnight on one day and midnight on
	// the next day. Accepted values for minutes are [0, 15, 30, 45]. 0 is the only
	// acceptable minute value for hour 24. Seconds and nanos are ignored.
	StartTime *TimeOfDay `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DayOfWeek") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DayOfWeek") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *DayPart) MarshalJSON() ([]byte, error) {
	type NoMethod DayPart
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// DayPartTargeting: Represents Daypart targeting.
type DayPartTargeting struct {
	// DayParts: The targeted weekdays and times
	DayParts []*DayPart `json:"dayParts,omitempty"`
	// TimeZoneType: The time zone type of the day parts
	//
	// Possible values:
	//   "TIME_ZONE_TYPE_UNSPECIFIED" - Default value. This field is unused.
	//   "SELLER" - The publisher's time zone
	//   "USER" - The user's time zone
	TimeZoneType string `json:"timeZoneType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DayParts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DayParts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *DayPartTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod DayPartTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// DeactivateClientRequest: Request message for disabling a client.
type DeactivateClientRequest struct {
}

// DeactivateClientUserRequest: Request message for deactivating a client user.
type DeactivateClientUserRequest struct {
}

// Deal: A deal represents a segment of inventory for displaying ads that
// contains the terms and targeting information that is used for serving as
// well as the deal stats and status. Note: A proposal may contain multiple
// deals.
type Deal struct {
	// BilledBuyer: Output only. When the client field is populated, this field
	// refers to the buyer who creates and manages the client buyer and gets billed
	// on behalf of the client buyer; when the buyer field is populated, this field
	// is the same value as buyer; when the deal belongs to a media planner
	// account, this field will be empty. Format : `buyers/{buyerAccountId}`
	BilledBuyer string `json:"billedBuyer,omitempty"`
	// Buyer: Output only. Refers to a buyer in Real-time Bidding API's Buyer
	// resource. Format: `buyers/{buyerAccountId}`
	Buyer string `json:"buyer,omitempty"`
	// Client: Output only. Refers to a Client. Format:
	// `buyers/{buyerAccountId}/clients/{clientAccountid}`
	Client string `json:"client,omitempty"`
	// CreateTime: Output only. The time of the deal creation.
	CreateTime string `json:"createTime,omitempty"`
	// CreativeRequirements: Output only. Metadata about the creatives of this
	// deal.
	CreativeRequirements *CreativeRequirements `json:"creativeRequirements,omitempty"`
	// DealType: Output only. Type of deal.
	//
	// Possible values:
	//   "DEAL_TYPE_UNSPECIFIED" - Default, unspecified deal type.
	//   "PREFERRED_DEAL" - Preferred deals.
	//   "PRIVATE_AUCTION" - Private auction deals.
	//   "PROGRAMMATIC_GUARANTEED" - Programmatic guaranteed deals.
	DealType string `json:"dealType,omitempty"`
	// DeliveryControl: Output only. Specifies the pacing set by the publisher.
	DeliveryControl *DeliveryControl `json:"deliveryControl,omitempty"`
	// Description: Output only. Free text description for the deal terms.
	Description string `json:"description,omitempty"`
	// DisplayName: Output only. The name of the deal. Maximum length of 255
	// unicode characters is allowed. Control characters are not allowed. Buyers
	// cannot update this field. Note: Not to be confused with name, which is a
	// unique identifier of the deal.
	DisplayName string `json:"displayName,omitempty"`
	// EligibleSeatIds: Output only. If set, this field contains the list of DSP
	// specific seat ids set by media planners that are eligible to transact on
	// this deal. The seat ID is in the calling DSP's namespace.
	EligibleSeatIds []string `json:"eligibleSeatIds,omitempty"`
	// EstimatedGrossSpend: Specified by buyers in request for proposal (RFP) to
	// notify publisher the total estimated spend for the proposal. Publishers will
	// receive this information and send back proposed deals accordingly.
	EstimatedGrossSpend *Money `json:"estimatedGrossSpend,omitempty"`
	// FlightEndTime: Proposed flight end time of the deal. This will generally be
	// stored in a granularity of a second. A value is not necessary for Private
	// Auction deals.
	FlightEndTime string `json:"flightEndTime,omitempty"`
	// FlightStartTime: Proposed flight start time of the deal. This will generally
	// be stored in the granularity of one second since deal serving starts at
	// seconds boundary. Any time specified with more granularity (for example, in
	// milliseconds) will be truncated towards the start of time in seconds.
	FlightStartTime string `json:"flightStartTime,omitempty"`
	// MediaPlanner: Output only. Refers to a buyer in Real-time Bidding API's
	// Buyer resource. This field represents a media planner (For example, agency
	// or big advertiser).
	MediaPlanner *MediaPlanner `json:"mediaPlanner,omitempty"`
	// Name: Immutable. The unique identifier of the deal. Auto-generated by the
	// server when a deal is created. Format:
	// buyers/{accountId}/proposals/{proposalId}/deals/{dealId}
	Name string `json:"name,omitempty"`
	// PreferredDealTerms: The terms for preferred deals.
	PreferredDealTerms *PreferredDealTerms `json:"preferredDealTerms,omitempty"`
	// PrivateAuctionTerms: The terms for private auction deals.
	PrivateAuctionTerms *PrivateAuctionTerms `json:"privateAuctionTerms,omitempty"`
	// ProgrammaticGuaranteedTerms: The terms for programmatic guaranteed deals.
	ProgrammaticGuaranteedTerms *ProgrammaticGuaranteedTerms `json:"programmaticGuaranteedTerms,omitempty"`
	// ProposalRevision: Output only. The revision number for the proposal and is
	// the same value as proposal.proposal_revision. Each update to deal causes the
	// proposal revision number to auto-increment. The buyer keeps track of the
	// last revision number they know of and pass it in when making an update. If
	// the head revision number on the server has since incremented, then an
	// ABORTED error is returned during the update operation to let the buyer know
	// that a subsequent update was made.
	ProposalRevision int64 `json:"proposalRevision,omitempty,string"`
	// PublisherProfile: Immutable. Reference to the seller on the deal. Format:
	// `buyers/{buyerAccountId}/publisherProfiles/{publisherProfileId}`
	PublisherProfile string `json:"publisherProfile,omitempty"`
	// SellerTimeZone: Output only. Time zone of the seller used to mark the
	// boundaries of a day for daypart targeting and CPD billing.
	SellerTimeZone *TimeZone `json:"sellerTimeZone,omitempty"`
	// Targeting: Specifies the subset of inventory targeted by the deal. Can be
	// updated by the buyer before the deal is finalized.
	Targeting *MarketplaceTargeting `json:"targeting,omitempty"`
	// UpdateTime: Output only. The time when the deal was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BilledBuyer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BilledBuyer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *Deal) MarshalJSON() ([]byte, error) {
	type NoMethod Deal
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// DealPausingInfo: Information related to deal pausing.
type DealPausingInfo struct {
	// PauseReason: The reason for the pausing of the deal; empty for active deals.
	PauseReason string `json:"pauseReason,omitempty"`
	// PauseRole: The party that first paused the deal; unspecified for active
	// deals.
	//
	// Possible values:
	//   "BUYER_SELLER_ROLE_UNSPECIFIED" - A placeholder for an undefined
	// buyer/seller role.
	//   "BUYER" - Specifies the role as buyer.
	//   "SELLER" - Specifies the role as seller.
	PauseRole string `json:"pauseRole,omitempty"`
	// PausingConsented: Whether pausing is consented between buyer and seller for
	// the deal.
	PausingConsented bool `json:"pausingConsented,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PauseReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PauseReason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *DealPausingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DealPausingInfo
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// DeliveryControl: Message contains details about how the deal will be paced.
type DeliveryControl struct {
	// CompanionDeliveryType: Output only. Specifies roadblocking in a main
	// companion lineitem.
	//
	// Possible values:
	//   "COMPANION_DELIVERY_TYPE_UNSPECIFIED" - A placeholder for an unspecified
	// companion delivery type.
	//   "DELIVERY_OPTIONAL" - Companions are not required to serve a creative set.
	// The creative set can serve an inventory that has zero or more matching
	// companions.
	//   "DELIVERY_AT_LEAST_ONE" - At least one companion must be served in order
	// for the creative set to be used.
	//   "DELIVERY_ALL" - All companions in the set must be served in order for the
	// creative set to be used. This can still serve to inventory that has more
	// companions than can be filled.
	CompanionDeliveryType string `json:"companionDeliveryType,omitempty"`
	// CreativeRotationType: Output only. Specifies strategy to use for selecting a
	// creative when multiple creatives of the same size are available.
	//
	// Possible values:
	//   "CREATIVE_ROTATION_TYPE_UNSPECIFIED" - Creatives are displayed roughly the
	// same number of times over the duration of the deal.
	//   "ROTATION_EVEN" - Creatives are displayed roughly the same number of times
	// over the duration of the deal.
	//   "ROTATION_OPTIMIZED" - Creatives are served roughly proportionally to
	// their performance.
	//   "ROTATION_MANUAL" - Creatives are served roughly proportionally to their
	// weights.
	//   "ROTATION_SEQUENTIAL" - Creatives are served exactly in sequential order,
	// also known as Storyboarding.
	CreativeRotationType string `json:"creativeRotationType,omitempty"`
	// DeliveryRateType: Output only. Specifies how the impression delivery will be
	// paced.
	//
	// Possible values:
	//   "DELIVERY_RATE_TYPE_UNSPECIFIED" - A placeholder for an undefined delivery
	// rate type.
	//   "EVENLY" - Impressions are served uniformly over the life of the deal.
	//   "FRONT_LOADED" - Impressions are served front-loaded.
	//   "AS_FAST_AS_POSSIBLE" - Impressions are served as fast as possible.
	DeliveryRateType string `json:"deliveryRateType,omitempty"`
	// FrequencyCap: Output only. Specifies any frequency caps. Cannot be filtered
	// within ListDealsRequest.
	FrequencyCap []*FrequencyCap `json:"frequencyCap,omitempty"`
	// RoadblockingType: Output only. Specifies the roadblocking type in display
	// creatives.
	//
	// Possible values:
	//   "ROADBLOCKING_TYPE_UNSPECIFIED" - A placeholder for an unspecified
	// roadblocking type.
	//   "ONLY_ONE" - Only one creative from a deal can serve per ad request.
	// https://support.google.com/admanager/answer/177277.
	//   "ONE_OR_MORE" - Any number of creatives from a deal can serve together per
	// ad request.
	//   "AS_MANY_AS_POSSIBLE" - As many creatives from a deal as can fit on a page
	// will serve. This could mean anywhere from one to all of a deal's creatives
	// given the size constraints of ad slots on a page.
	//   "ALL_ROADBLOCK" - All or none of the creatives from a deal will serve.
	//   "CREATIVE_SET" - A main/companion creative set roadblocking type.
	RoadblockingType string `json:"roadblockingType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompanionDeliveryType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompanionDeliveryType") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *DeliveryControl) MarshalJSON() ([]byte, error) {
	type NoMethod DeliveryControl
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// FinalizedDeal: A finalized deal is a snapshot of the deal when both buyer
// and seller accept the deal. The buyer or seller can update the deal after
// it's been finalized and renegotiate on the deal targeting, terms and other
// fields, while at the same time the finalized snapshot of the deal can still
// be retrieved using this API. The finalized deal contains a copy of the deal
// as it existed when most recently finalized, as well as fields related to
// deal serving such as pause/resume status, RTB metrics, and more.
type FinalizedDeal struct {
	// Deal: A copy of the Deal made upon finalization. During renegotiation, this
	// will reflect the last finalized deal before renegotiation was initiated.
	Deal *Deal `json:"deal,omitempty"`
	// DealPausingInfo: Information related to deal pausing for the deal.
	DealPausingInfo *DealPausingInfo `json:"dealPausingInfo,omitempty"`
	// DealServingStatus: Serving status of the deal.
	//
	// Possible values:
	//   "DEAL_SERVING_STATUS_UNSPECIFIED" - Unspecified.
	//   "ACTIVE" - The deal is actively serving or ready to serve when the start
	// date is reached.
	//   "ENDED" - The deal serving has ended.
	//   "PAUSED_BY_BUYER" - The deal serving is paused by buyer.
	//   "PAUSED_BY_SELLER" - The deal serving is paused by seller.
	DealServingStatus string `json:"dealServingStatus,omitempty"`
	// Name: The resource name of the finalized deal. Format:
	// `buyers/{accountId}/finalizedDeals/{finalizedDealId}`
	Name string `json:"name,omitempty"`
	// ReadyToServe: Whether the Programmatic Guaranteed deal is ready for serving.
	ReadyToServe bool `json:"readyToServe,omitempty"`
	// RtbMetrics: Real-time bidding metrics for this deal.
	RtbMetrics *RtbMetrics `json:"rtbMetrics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Deal") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deal") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *FinalizedDeal) MarshalJSON() ([]byte, error) {
	type NoMethod FinalizedDeal
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// FirstPartyMobileApplicationTargeting: Represents a list of targeted and
// excluded mobile application IDs that publishers own. Android App ID, for
// example, com.google.android.apps.maps, can be found in Google Play Store
// URL. iOS App ID (which is a number) can be found at the end of iTunes store
// URL. First party mobile applications is either included or excluded.
type FirstPartyMobileApplicationTargeting struct {
	// ExcludedAppIds: A list of application IDs to be excluded.
	ExcludedAppIds []string `json:"excludedAppIds,omitempty"`
	// TargetedAppIds: A list of application IDs to be included.
	TargetedAppIds []string `json:"targetedAppIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedAppIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedAppIds") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *FirstPartyMobileApplicationTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod FirstPartyMobileApplicationTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// FrequencyCap: Message contains details about publisher-set frequency caps of
// the delivery.
type FrequencyCap struct {
	// MaxImpressions: The maximum number of impressions that can be served to a
	// user within the specified time period.
	MaxImpressions int64 `json:"maxImpressions,omitempty"`
	// TimeUnitType: The time unit. Along with num_time_units defines the amount of
	// time over which impressions per user are counted and capped.
	//
	// Possible values:
	//   "TIME_UNIT_TYPE_UNSPECIFIED" - A placeholder for an undefined time unit
	// type. This just indicates the variable with this value hasn't been
	// initialized.
	//   "MINUTE" - Minute unit.
	//   "HOUR" - Hour unit.
	//   "DAY" - Day unit.
	//   "WEEK" - Week unit.
	//   "MONTH" - Month unit.
	//   "LIFETIME" - Lifecycle/Lifetime unit.
	//   "POD" - Pod unit.
	//   "STREAM" - Stream unit.
	TimeUnitType string `json:"timeUnitType,omitempty"`
	// TimeUnitsCount: The amount of time, in the units specified by
	// time_unit_type. Defines the amount of time over which impressions per user
	// are counted and capped.
	TimeUnitsCount int64 `json:"timeUnitsCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxImpressions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxImpressions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *FrequencyCap) MarshalJSON() ([]byte, error) {
	type NoMethod FrequencyCap
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// InventorySizeTargeting: Represents the size of an ad unit that can be
// targeted on a bid request.
type InventorySizeTargeting struct {
	// ExcludedInventorySizes: A list of inventory sizes to be excluded.
	ExcludedInventorySizes []*AdSize `json:"excludedInventorySizes,omitempty"`
	// TargetedInventorySizes: A list of inventory sizes to be included.
	TargetedInventorySizes []*AdSize `json:"targetedInventorySizes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedInventorySizes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedInventorySizes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *InventorySizeTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod InventorySizeTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// InventoryTypeTargeting: Targeting of the inventory types a bid request can
// originate from.
type InventoryTypeTargeting struct {
	// InventoryTypes: The list of targeted inventory types for the bid request.
	//
	// Possible values:
	//   "INVENTORY_TYPE_UNSPECIFIED" - Unspecified inventory type
	//   "BROWSER" - Desktop or mobile web browser excluding ads inside a video
	// player
	//   "MOBILE_APP" - Mobile apps other than video players and web browsers
	//   "VIDEO_PLAYER" - Instream video and audio
	InventoryTypes []string `json:"inventoryTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InventoryTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InventoryTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *InventoryTypeTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryTypeTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ListAuctionPackagesResponse: Response message for listing auction packages.
type ListAuctionPackagesResponse struct {
	// AuctionPackages: The list of auction packages.
	AuctionPackages []*AuctionPackage `json:"auctionPackages,omitempty"`
	// NextPageToken: Continuation token for fetching the next page of results.
	// Pass this value in the ListAuctionPackagesRequest.pageToken field in the
	// subsequent call to the `ListAuctionPackages` method to retrieve the next
	// page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuctionPackages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuctionPackages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *ListAuctionPackagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAuctionPackagesResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ListClientUsersResponse: Response message for the list method.
type ListClientUsersResponse struct {
	// ClientUsers: The returned list of client users.
	ClientUsers []*ClientUser `json:"clientUsers,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass this value
	// in the ListClientUsersRequest.pageToken field in the subsequent call to the
	// list method to retrieve the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClientUsers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientUsers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *ListClientUsersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListClientUsersResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ListClientsResponse: Response message for the list method.
type ListClientsResponse struct {
	// Clients: The returned list of clients.
	Clients []*Client `json:"clients,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass this value
	// in the ListClientsRequest.pageToken field in the subsequent call to the list
	// method to retrieve the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Clients") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clients") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *ListClientsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListClientsResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ListDealsResponse: Response message for listing deals in a proposal.
type ListDealsResponse struct {
	// Deals: The list of deals.
	Deals []*Deal `json:"deals,omitempty"`
	// NextPageToken: Token to fetch the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Deals") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *ListDealsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDealsResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ListFinalizedDealsResponse: Response message for listing finalized deals.
type ListFinalizedDealsResponse struct {
	// FinalizedDeals: The list of finalized deals.
	FinalizedDeals []*FinalizedDeal `json:"finalizedDeals,omitempty"`
	// NextPageToken: Token to fetch the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FinalizedDeals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FinalizedDeals") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *ListFinalizedDealsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFinalizedDealsResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ListProposalsResponse: Response message for listing proposals.
type ListProposalsResponse struct {
	// NextPageToken: Continuation token for fetching the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Proposals: The list of proposals.
	Proposals []*Proposal `json:"proposals,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *ListProposalsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListProposalsResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ListPublisherProfilesResponse: Response message for profiles visible to the
// buyer.
type ListPublisherProfilesResponse struct {
	// NextPageToken: Token to fetch the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PublisherProfiles: The list of matching publisher profiles.
	PublisherProfiles []*PublisherProfile `json:"publisherProfiles,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *ListPublisherProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPublisherProfilesResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// MarketplaceTargeting: Targeting represents different criteria that can be
// used to target deals or auction packages. For example, they can choose to
// target inventory only if the user is in the US. Multiple types of targeting
// are always applied as a logical AND, unless noted otherwise.
type MarketplaceTargeting struct {
	// DaypartTargeting: Daypart targeting information.
	DaypartTargeting *DayPartTargeting `json:"daypartTargeting,omitempty"`
	// ExcludedSensitiveCategoryIds: Output only. The sensitive content category
	// label IDs excluded. Refer to this file
	// https://storage.googleapis.com/adx-rtb-dictionaries/content-labels.txt for
	// category IDs.
	ExcludedSensitiveCategoryIds googleapi.Int64s `json:"excludedSensitiveCategoryIds,omitempty"`
	// GeoTargeting: Output only. Geo criteria IDs to be included/excluded.
	GeoTargeting *CriteriaTargeting `json:"geoTargeting,omitempty"`
	// InventorySizeTargeting: Output only. Inventory sizes to be
	// included/excluded.
	InventorySizeTargeting *InventorySizeTargeting `json:"inventorySizeTargeting,omitempty"`
	// InventoryTypeTargeting: Output only. Inventory type targeting information.
	InventoryTypeTargeting *InventoryTypeTargeting `json:"inventoryTypeTargeting,omitempty"`
	// PlacementTargeting: Output only. Placement targeting information, for
	// example, URL, mobile applications.
	PlacementTargeting *PlacementTargeting `json:"placementTargeting,omitempty"`
	// TechnologyTargeting: Output only. Technology targeting information, for
	// example, operating system, device category.
	TechnologyTargeting *TechnologyTargeting `json:"technologyTargeting,omitempty"`
	// UserListTargeting: Buyer user list targeting information. User lists can be
	// uploaded using
	// https://developers.google.com/authorized-buyers/rtb/bulk-uploader.
	UserListTargeting *CriteriaTargeting `json:"userListTargeting,omitempty"`
	// VerticalTargeting: Output only. The verticals included or excluded as
	// defined in
	// https://developers.google.com/authorized-buyers/rtb/downloads/publisher-verticals
	VerticalTargeting *CriteriaTargeting `json:"verticalTargeting,omitempty"`
	// VideoTargeting: Output only. Video targeting information.
	VideoTargeting *VideoTargeting `json:"videoTargeting,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DaypartTargeting") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DaypartTargeting") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *MarketplaceTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod MarketplaceTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// MediaPlanner: Describes a single Media Planner account.
type MediaPlanner struct {
	// AccountId: Output only. Account ID of the media planner.
	AccountId string `json:"accountId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *MediaPlanner) MarshalJSON() ([]byte, error) {
	type NoMethod MediaPlanner
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// MobileApplicationTargeting: Mobile application targeting settings.
type MobileApplicationTargeting struct {
	// FirstPartyTargeting: Publisher owned apps to be targeted or excluded by the
	// publisher to display the ads in.
	FirstPartyTargeting *FirstPartyMobileApplicationTargeting `json:"firstPartyTargeting,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FirstPartyTargeting") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirstPartyTargeting") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *MobileApplicationTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod MobileApplicationTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// Money: Represents an amount of money with its currency type.
type Money struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Nanos: Number of nano (10^-9) units of the amount. The value must be between
	// -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos`
	// must be positive or zero. If `units` is zero, `nanos` can be positive, zero,
	// or negative. If `units` is negative, `nanos` must be negative or zero. For
	// example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`
	// Units: The whole units of the amount. For example if `currencyCode` is
	// "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *Money) MarshalJSON() ([]byte, error) {
	type NoMethod Money
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// Note: A text note attached to the proposal to facilitate the communication
// between buyers and sellers.
type Note struct {
	// CreateTime: Output only. When this note was created.
	CreateTime string `json:"createTime,omitempty"`
	// CreatorRole: Output only. The role who created the note.
	//
	// Possible values:
	//   "BUYER_SELLER_ROLE_UNSPECIFIED" - A placeholder for an undefined
	// buyer/seller role.
	//   "BUYER" - Specifies the role as buyer.
	//   "SELLER" - Specifies the role as seller.
	CreatorRole string `json:"creatorRole,omitempty"`
	// Note: The text of the note. Maximum length is 1024 characters.
	Note string `json:"note,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *Note) MarshalJSON() ([]byte, error) {
	type NoMethod Note
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// OperatingSystemTargeting: Represents targeting information for operating
// systems.
type OperatingSystemTargeting struct {
	// OperatingSystemCriteria: IDs of operating systems to be included/excluded.
	OperatingSystemCriteria *CriteriaTargeting `json:"operatingSystemCriteria,omitempty"`
	// OperatingSystemVersionCriteria: IDs of operating system versions to be
	// included/excluded.
	OperatingSystemVersionCriteria *CriteriaTargeting `json:"operatingSystemVersionCriteria,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OperatingSystemCriteria") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperatingSystemCriteria") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *OperatingSystemTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod OperatingSystemTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// PauseFinalizedDealRequest: Request message for pausing a finalized deal.
type PauseFinalizedDealRequest struct {
	// Reason: The reason to pause the finalized deal, will be displayed to the
	// seller. Maximum length is 1000 characters.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Reason") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *PauseFinalizedDealRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PauseFinalizedDealRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// PlacementTargeting: Represents targeting about where the ads can appear, for
// example, certain sites or mobile applications. Different placement targeting
// types will be logically OR'ed.
type PlacementTargeting struct {
	// MobileApplicationTargeting: Mobile application targeting information in a
	// deal. This doesn't apply to Auction Packages.
	MobileApplicationTargeting *MobileApplicationTargeting `json:"mobileApplicationTargeting,omitempty"`
	// UriTargeting: URLs to be included/excluded.
	UriTargeting *UriTargeting `json:"uriTargeting,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MobileApplicationTargeting")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MobileApplicationTargeting") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *PlacementTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod PlacementTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// PreferredDealTerms: Pricing terms for Preferred Deals.
type PreferredDealTerms struct {
	// FixedPrice: Fixed price for the deal.
	FixedPrice *Price `json:"fixedPrice,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FixedPrice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FixedPrice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *PreferredDealTerms) MarshalJSON() ([]byte, error) {
	type NoMethod PreferredDealTerms
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// Price: Represents a price and a pricing type for a deal.
type Price struct {
	// Amount: The actual price with currency specified.
	Amount *Money `json:"amount,omitempty"`
	// Type: The pricing type for the deal.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - A placeholder for an undefined pricing type. If the
	// pricing type is unspecified, CPM will be used instead.
	//   "CPM" - Cost per thousand impressions.
	//   "CPD" - Cost per day.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Amount") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *Price) MarshalJSON() ([]byte, error) {
	type NoMethod Price
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// PrivateAuctionTerms: Pricing terms for Private Auctions.
type PrivateAuctionTerms struct {
	// FloorPrice: The minimum price buyer has to bid to compete in the private
	// auction.
	FloorPrice *Price `json:"floorPrice,omitempty"`
	// OpenAuctionAllowed: Output only. True if open auction buyers are allowed to
	// compete with invited buyers in this private auction.
	OpenAuctionAllowed bool `json:"openAuctionAllowed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FloorPrice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FloorPrice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *PrivateAuctionTerms) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateAuctionTerms
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// PrivateData: Buyers are allowed to store certain types of private data in a
// proposal or deal.
type PrivateData struct {
	// ReferenceId: A buyer specified reference ID. This can be queried in the list
	// operations (max-length: 1024 unicode code units).
	ReferenceId string `json:"referenceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferenceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *PrivateData) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateData
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ProgrammaticGuaranteedTerms: Pricing terms for Programmatic Guaranteed
// Deals.
type ProgrammaticGuaranteedTerms struct {
	// FixedPrice: Fixed price for the deal.
	FixedPrice *Price `json:"fixedPrice,omitempty"`
	// GuaranteedLooks: Count of guaranteed looks. For CPD deals, buyer changes to
	// guaranteed_looks will be ignored.
	GuaranteedLooks int64 `json:"guaranteedLooks,omitempty,string"`
	// ImpressionCap: The lifetime impression cap for CPM Sponsorship deals. Deal
	// will stop serving when cap is reached.
	ImpressionCap int64 `json:"impressionCap,omitempty,string"`
	// MinimumDailyLooks: Daily minimum looks for CPD deal types. For CPD deals,
	// buyer should negotiate on this field instead of guaranteed_looks.
	MinimumDailyLooks int64 `json:"minimumDailyLooks,omitempty,string"`
	// PercentShareOfVoice: For sponsorship deals, this is the percentage of the
	// seller's eligible impressions that the deal will serve until the cap is
	// reached. Valid value is within range 0~100.
	PercentShareOfVoice int64 `json:"percentShareOfVoice,omitempty,string"`
	// ReservationType: The reservation type for a Programmatic Guaranteed deal.
	// This indicates whether the number of impressions is fixed, or a percent of
	// available impressions. If not specified, the default reservation type is
	// STANDARD.
	//
	// Possible values:
	//   "RESERVATION_TYPE_UNSPECIFIED" - An unspecified reservation type.
	//   "STANDARD" - Non-sponsorship deal.
	//   "SPONSORSHIP" - Sponsorship deals don't have impression goal
	// (guaranteed_looks) and they are served based on the flight dates. For CPM
	// Sponsorship deals, impression_cap is the lifetime impression limit.
	ReservationType string `json:"reservationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FixedPrice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FixedPrice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *ProgrammaticGuaranteedTerms) MarshalJSON() ([]byte, error) {
	type NoMethod ProgrammaticGuaranteedTerms
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// Proposal: Represents a proposal in the Marketplace. A proposal is the unit
// of negotiation between a seller and a buyer.
type Proposal struct {
	// BilledBuyer: Output only. When the client field is populated, this field
	// refers to the buyer who creates and manages the client buyer and gets billed
	// on behalf of the client buyer; when the buyer field is populated, this field
	// is the same value as buyer. Format : `buyers/{buyerAccountId}`
	BilledBuyer string `json:"billedBuyer,omitempty"`
	// Buyer: Output only. Refers to a buyer in The Realtime-bidding API. Format:
	// `buyers/{buyerAccountId}`
	Buyer string `json:"buyer,omitempty"`
	// BuyerContacts: Contact information for the buyer.
	BuyerContacts []*Contact `json:"buyerContacts,omitempty"`
	// BuyerPrivateData: Buyer private data (hidden from seller).
	BuyerPrivateData *PrivateData `json:"buyerPrivateData,omitempty"`
	// Client: Output only. Refers to a Client. Format:
	// `buyers/{buyerAccountId}/clients/{clientAccountid}`
	Client string `json:"client,omitempty"`
	// DealType: Output only. Type of deal the proposal contains.
	//
	// Possible values:
	//   "DEAL_TYPE_UNSPECIFIED" - Default, unspecified deal type.
	//   "PREFERRED_DEAL" - Preferred deals.
	//   "PRIVATE_AUCTION" - Private auction deals.
	//   "PROGRAMMATIC_GUARANTEED" - Programmatic guaranteed deals.
	DealType string `json:"dealType,omitempty"`
	// DisplayName: Output only. The descriptive name for the proposal. Maximum
	// length of 255 unicode characters is allowed. Control characters are not
	// allowed. Buyers cannot update this field. Note: Not to be confused with
	// name, which is a unique identifier of the proposal.
	DisplayName string `json:"displayName,omitempty"`
	// IsRenegotiating: Output only. True if the proposal was previously finalized
	// and is now being renegotiated.
	IsRenegotiating bool `json:"isRenegotiating,omitempty"`
	// LastUpdaterOrCommentorRole: Output only. The role of the last user that
	// either updated the proposal or left a comment.
	//
	// Possible values:
	//   "BUYER_SELLER_ROLE_UNSPECIFIED" - A placeholder for an undefined
	// buyer/seller role.
	//   "BUYER" - Specifies the role as buyer.
	//   "SELLER" - Specifies the role as seller.
	LastUpdaterOrCommentorRole string `json:"lastUpdaterOrCommentorRole,omitempty"`
	// Name: Immutable. The name of the proposal serving as a unique identifier.
	// Format: buyers/{accountId}/proposals/{proposalId}
	Name string `json:"name,omitempty"`
	// Notes: A list of notes from the buyer and the seller attached to this
	// proposal.
	Notes []*Note `json:"notes,omitempty"`
	// OriginatorRole: Output only. Indicates whether the buyer/seller created the
	// proposal.
	//
	// Possible values:
	//   "BUYER_SELLER_ROLE_UNSPECIFIED" - A placeholder for an undefined
	// buyer/seller role.
	//   "BUYER" - Specifies the role as buyer.
	//   "SELLER" - Specifies the role as seller.
	OriginatorRole string `json:"originatorRole,omitempty"`
	// PausingConsented: Whether pausing is allowed for the proposal. This is a
	// negotiable term between buyers and publishers.
	PausingConsented bool `json:"pausingConsented,omitempty"`
	// ProposalRevision: Output only. The revision number for the proposal. Each
	// update to the proposal or deal causes the proposal revision number to
	// auto-increment. The buyer keeps track of the last revision number they know
	// of and pass it in when making an update. If the head revision number on the
	// server has since incremented, then an ABORTED error is returned during the
	// update operation to let the buyer know that a subsequent update was made.
	ProposalRevision int64 `json:"proposalRevision,omitempty,string"`
	// PublisherProfile: Immutable. Reference to the seller on the proposal.
	// Format: `buyers/{buyerAccountId}/publisherProfiles/{publisherProfileId}`
	// Note: This field may be set only when creating the resource. Modifying this
	// field while updating the resource will result in an error.
	PublisherProfile string `json:"publisherProfile,omitempty"`
	// SellerContacts: Output only. Contact information for the seller.
	SellerContacts []*Contact `json:"sellerContacts,omitempty"`
	// State: Output only. Indicates the state of the proposal.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified proposal state
	//   "BUYER_REVIEW_REQUESTED" - When a proposal is waiting for buyer to review.
	//   "SELLER_REVIEW_REQUESTED" - When the proposal is waiting for the seller to
	// review.
	//   "BUYER_ACCEPTANCE_REQUESTED" - When the seller accepted the proposal and
	// sent it to the buyer for review.
	//   "FINALIZED" - When both buyer and seller has accepted the proposal
	//   "TERMINATED" - When either buyer or seller has cancelled the proposal
	State string `json:"state,omitempty"`
	// TermsAndConditions: Output only. The terms and conditions associated with
	// this proposal. Accepting a proposal implies acceptance of this field. This
	// is created by the seller, the buyer can only view it.
	TermsAndConditions string `json:"termsAndConditions,omitempty"`
	// UpdateTime: Output only. The time when the proposal was last revised.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BilledBuyer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BilledBuyer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *Proposal) MarshalJSON() ([]byte, error) {
	type NoMethod Proposal
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// PublisherProfile: The values in the publisher profile are supplied by the
// publisher. All fields are not filterable unless stated otherwise.
type PublisherProfile struct {
	// AudienceDescription: Description on the publisher's audience.
	AudienceDescription string `json:"audienceDescription,omitempty"`
	// DirectDealsContact: Contact information for direct reservation deals. This
	// is free text entered by the publisher and may include information like
	// names, phone numbers and email addresses.
	DirectDealsContact string `json:"directDealsContact,omitempty"`
	// DisplayName: Display name of the publisher profile. Can be used to filter
	// the response of the publisherProfiles.list method.
	DisplayName string `json:"displayName,omitempty"`
	// Domains: The list of domains represented in this publisher profile. Empty if
	// this is a parent profile. These are top private domains, meaning that these
	// will not contain a string like "photos.google.co.uk/123", but will instead
	// contain "google.co.uk". Can be used to filter the response of the
	// publisherProfiles.list method.
	Domains []string `json:"domains,omitempty"`
	// IsParent: Indicates if this profile is the parent profile of the seller. A
	// parent profile represents all the inventory from the seller, as opposed to
	// child profile that is created to brand a portion of inventory. One seller
	// has only one parent publisher profile, and can have multiple child profiles.
	// See https://support.google.com/admanager/answer/6035806 for details. Can be
	// used to filter the response of the publisherProfiles.list method by setting
	// the filter to "is_parent: true".
	IsParent bool `json:"isParent,omitempty"`
	// LogoUrl: A Google public URL to the logo for this publisher profile. The
	// logo is stored as a PNG, JPG, or GIF image.
	LogoUrl string `json:"logoUrl,omitempty"`
	// MediaKitUrl: URL to additional marketing and sales materials.
	MediaKitUrl string `json:"mediaKitUrl,omitempty"`
	// MobileApps: The list of apps represented in this publisher profile. Empty if
	// this is a parent profile.
	MobileApps []*PublisherProfileMobileApplication `json:"mobileApps,omitempty"`
	// Name: Name of the publisher profile. Format:
	// `buyers/{buyer}/publisherProfiles/{publisher_profile}`
	Name string `json:"name,omitempty"`
	// Overview: Overview of the publisher.
	Overview string `json:"overview,omitempty"`
	// PitchStatement: Statement explaining what's unique about publisher's
	// business, and why buyers should partner with the publisher.
	PitchStatement string `json:"pitchStatement,omitempty"`
	// ProgrammaticDealsContact: Contact information for programmatic deals. This
	// is free text entered by the publisher and may include information like
	// names, phone numbers and email addresses.
	ProgrammaticDealsContact string `json:"programmaticDealsContact,omitempty"`
	// PublisherCode: A unique identifying code for the seller. This value is the
	// same for all of the seller's parent and child publisher profiles. Can be
	// used to filter the response of the publisherProfiles.list method.
	PublisherCode string `json:"publisherCode,omitempty"`
	// SamplePageUrl: URL to a sample content page.
	SamplePageUrl string `json:"samplePageUrl,omitempty"`
	// TopHeadlines: Up to three key metrics and rankings. For example, "#1 Mobile
	// News Site for 20 Straight Months".
	TopHeadlines []string `json:"topHeadlines,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AudienceDescription") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudienceDescription") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *PublisherProfile) MarshalJSON() ([]byte, error) {
	type NoMethod PublisherProfile
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// PublisherProfileMobileApplication: A mobile application that contains a
// external app ID, name, and app store.
type PublisherProfileMobileApplication struct {
	// AppStore: The app store the app belongs to. Can be used to filter the
	// response of the publisherProfiles.list method.
	//
	// Possible values:
	//   "APP_STORE_TYPE_UNSPECIFIED" - A placeholder for an unknown app store.
	//   "APPLE_ITUNES" - Apple iTunes
	//   "GOOGLE_PLAY" - Google Play
	//   "ROKU" - Roku
	//   "AMAZON_FIRE_TV" - Amazon Fire TV
	//   "PLAYSTATION" - PlayStation
	//   "XBOX" - Xbox
	//   "SAMSUNG_TV" - Samsung TV
	//   "AMAZON" - Amazon Appstore
	//   "OPPO" - OPPO App Market
	//   "SAMSUNG" - Samsung Galaxy Store
	//   "VIVO" - VIVO App Store
	//   "XIAOMI" - Xiaomi GetApps
	//   "LG_TV" - LG TV
	AppStore string `json:"appStore,omitempty"`
	// ExternalAppId: The external ID for the app from its app store. Can be used
	// to filter the response of the publisherProfiles.list method.
	ExternalAppId string `json:"externalAppId,omitempty"`
	// Name: The name of the app.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *PublisherProfileMobileApplication) MarshalJSON() ([]byte, error) {
	type NoMethod PublisherProfileMobileApplication
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// ResumeFinalizedDealRequest: Request message for resuming a finalized deal.
type ResumeFinalizedDealRequest struct {
}

// RtbMetrics: Real-time bidding metrics. For what each metric means refer to
// Report metrics
// (https://support.google.com/adxbuyer/answer/6115195#report-metrics)
type RtbMetrics struct {
	// AdImpressions7Days: Ad impressions in last 7 days.
	AdImpressions7Days int64 `json:"adImpressions7Days,omitempty,string"`
	// BidRate7Days: Bid rate in last 7 days, calculated by (bids / bid requests).
	BidRate7Days float64 `json:"bidRate7Days,omitempty"`
	// BidRequests7Days: Bid requests in last 7 days.
	BidRequests7Days int64 `json:"bidRequests7Days,omitempty,string"`
	// Bids7Days: Bids in last 7 days.
	Bids7Days int64 `json:"bids7Days,omitempty,string"`
	// FilteredBidRate7Days: Filtered bid rate in last 7 days, calculated by
	// (filtered bids / bids).
	FilteredBidRate7Days float64 `json:"filteredBidRate7Days,omitempty"`
	// MustBidRateCurrentMonth: Must bid rate for current month.
	MustBidRateCurrentMonth float64 `json:"mustBidRateCurrentMonth,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdImpressions7Days") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdImpressions7Days") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *RtbMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod RtbMetrics
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

func (s *RtbMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod RtbMetrics
	var s1 struct {
		BidRate7Days            gensupport.JSONFloat64 `json:"bidRate7Days"`
		FilteredBidRate7Days    gensupport.JSONFloat64 `json:"filteredBidRate7Days"`
		MustBidRateCurrentMonth gensupport.JSONFloat64 `json:"mustBidRateCurrentMonth"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BidRate7Days = float64(s1.BidRate7Days)
	s.FilteredBidRate7Days = float64(s1.FilteredBidRate7Days)
	s.MustBidRateCurrentMonth = float64(s1.MustBidRateCurrentMonth)
	return nil
}

// SendRfpRequest: Request to send an RFP. All fields in this request are
// proposed to publisher and subject to changes by publisher during later
// negotiation.
type SendRfpRequest struct {
	// BuyerContacts: Contact information for the buyer.
	BuyerContacts []*Contact `json:"buyerContacts,omitempty"`
	// Client: If the current buyer is sending the RFP on behalf of its client, use
	// this field to specify the name of the client in the format:
	// `buyers/{accountId}/clients/{clientAccountid}`.
	Client string `json:"client,omitempty"`
	// DisplayName: Required. The display name of the proposal being created by
	// this RFP.
	DisplayName string `json:"displayName,omitempty"`
	// EstimatedGrossSpend: Specified by buyers in request for proposal (RFP) to
	// notify publisher the total estimated spend for the proposal. Publishers will
	// receive this information and send back proposed deals accordingly.
	EstimatedGrossSpend *Money `json:"estimatedGrossSpend,omitempty"`
	// FlightEndTime: Required. Proposed flight end time of the RFP. A timestamp in
	// RFC3339 UTC "Zulu" format. Note that the specified value will be truncated
	// to a granularity of one second.
	FlightEndTime string `json:"flightEndTime,omitempty"`
	// FlightStartTime: Required. Proposed flight start time of the RFP. A
	// timestamp in RFC3339 UTC "Zulu" format. Note that the specified value will
	// be truncated to a granularity of one second.
	FlightStartTime string `json:"flightStartTime,omitempty"`
	// GeoTargeting: Geo criteria IDs to be targeted. Refer to Geo tables.
	GeoTargeting *CriteriaTargeting `json:"geoTargeting,omitempty"`
	// InventorySizeTargeting: Inventory sizes to be targeted.
	InventorySizeTargeting *InventorySizeTargeting `json:"inventorySizeTargeting,omitempty"`
	// Note: A message that is sent to the publisher. Maximum length is 1024
	// characters.
	Note string `json:"note,omitempty"`
	// PreferredDealTerms: The terms for preferred deals.
	PreferredDealTerms *PreferredDealTerms `json:"preferredDealTerms,omitempty"`
	// ProgrammaticGuaranteedTerms: The terms for programmatic guaranteed deals.
	ProgrammaticGuaranteedTerms *ProgrammaticGuaranteedTerms `json:"programmaticGuaranteedTerms,omitempty"`
	// PublisherProfile: Required. The profile of the publisher who will receive
	// this RFP in the format:
	// `buyers/{accountId}/publisherProfiles/{publisherProfileId}`.
	PublisherProfile string `json:"publisherProfile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuyerContacts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuyerContacts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *SendRfpRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SendRfpRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// SetReadyToServeRequest: Request message for setting ready to serve for a
// finalized deal.
type SetReadyToServeRequest struct {
}

// SubscribeAuctionPackageRequest: Request message for SubscribeAuctionPackage.
type SubscribeAuctionPackageRequest struct {
}

// SubscribeClientsRequest: Request message for SubscribeAuctionPackageClients.
type SubscribeClientsRequest struct {
	// Clients: Optional. A list of client buyers to subscribe to the auction
	// package, with client buyer in the format
	// `buyers/{accountId}/clients/{clientAccountId}`. The current buyer will be
	// subscribed to the auction package regardless of the list contents if not
	// already.
	Clients []string `json:"clients,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clients") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clients") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *SubscribeClientsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SubscribeClientsRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// TechnologyTargeting: Represents targeting about various types of technology.
type TechnologyTargeting struct {
	// DeviceCapabilityTargeting: IDs of device capabilities to be
	// included/excluded.
	DeviceCapabilityTargeting *CriteriaTargeting `json:"deviceCapabilityTargeting,omitempty"`
	// DeviceCategoryTargeting: IDs of device categories to be included/excluded.
	DeviceCategoryTargeting *CriteriaTargeting `json:"deviceCategoryTargeting,omitempty"`
	// OperatingSystemTargeting: Operating system related targeting information.
	OperatingSystemTargeting *OperatingSystemTargeting `json:"operatingSystemTargeting,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceCapabilityTargeting")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceCapabilityTargeting") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *TechnologyTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod TechnologyTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// TimeOfDay: Represents a time of day. The date and time zone are either not
// significant or are specified elsewhere. An API may choose to allow leap
// seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
type TimeOfDay struct {
	// Hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
	// choose to allow the value "24:00:00" for scenarios like business closing
	// time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Minutes of hour of day. Must be from 0 to 59.
	Minutes int64 `json:"minutes,omitempty"`
	// Nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
	// API may allow the value 60 if it allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hours") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *TimeOfDay) MarshalJSON() ([]byte, error) {
	type NoMethod TimeOfDay
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// TimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type TimeZone struct {
	// Id: IANA Time Zone Database time zone, e.g. "America/New_York".
	Id string `json:"id,omitempty"`
	// Version: Optional. IANA Time Zone Database version number, e.g. "2019a".
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *TimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod TimeZone
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// UnsubscribeAuctionPackageRequest: Request message for
// UnsubscribeAuctionPackage.
type UnsubscribeAuctionPackageRequest struct {
}

// UnsubscribeClientsRequest: Request message for UnsubscribeAuctionPackage.
type UnsubscribeClientsRequest struct {
	// Clients: Optional. A list of client buyers to unsubscribe from the auction
	// package, with client buyer in the format
	// `buyers/{accountId}/clients/{clientAccountId}`.
	Clients []string `json:"clients,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clients") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clients") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *UnsubscribeClientsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UnsubscribeClientsRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// UpdateDealRequest: Request message for updating the deal at the given
// revision number.
type UpdateDealRequest struct {
	// Deal: Required. The deal to update. The deal's `name` field is used to
	// identify the deal to be updated. Note: proposal_revision will have to be
	// provided within the resource or else an error will be thrown. Format:
	// buyers/{accountId}/proposals/{proposalId}/deals/{dealId}
	Deal *Deal `json:"deal,omitempty"`
	// UpdateMask: List of fields to be updated. If empty or unspecified, the
	// service will update all fields populated in the update request excluding the
	// output only fields and primitive fields with default value. Note that
	// explicit field mask is required in order to reset a primitive field back to
	// its default value, for example, false for boolean fields, 0 for integer
	// fields. A special field mask consisting of a single path "*" can be used to
	// indicate full replacement(the equivalent of PUT method), updatable fields
	// unset or unspecified in the input will be cleared or set to default value.
	// Output only fields will be ignored regardless of the value of updateMask.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deal") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deal") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *UpdateDealRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateDealRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// UriTargeting: Represents a list of targeted and excluded URLs (for example,
// google.com). For Private Auction Deals, URLs are either included or
// excluded. For Programmatic Guaranteed and Preferred Deals, this doesn't
// apply.
type UriTargeting struct {
	// ExcludedUris: A list of URLs to be excluded.
	ExcludedUris []string `json:"excludedUris,omitempty"`
	// TargetedUris: A list of URLs to be included.
	TargetedUris []string `json:"targetedUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *UriTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod UriTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// VideoTargeting: Represents targeting information about video.
type VideoTargeting struct {
	// ExcludedPositionTypes: A list of video positions to be excluded. When this
	// field is populated, the targeted_position_types field must be empty.
	//
	// Possible values:
	//   "POSITION_TYPE_UNSPECIFIED" - A placeholder for an undefined video
	// position.
	//   "PREROLL" - Ad is played before the video.
	//   "MIDROLL" - Ad is played during the video.
	//   "POSTROLL" - Ad is played after the video.
	ExcludedPositionTypes []string `json:"excludedPositionTypes,omitempty"`
	// TargetedPositionTypes: A list of video positions to be included. When this
	// field is populated, the excluded_position_types field must be empty.
	//
	// Possible values:
	//   "POSITION_TYPE_UNSPECIFIED" - A placeholder for an undefined video
	// position.
	//   "PREROLL" - Ad is played before the video.
	//   "MIDROLL" - Ad is played during the video.
	//   "POSTROLL" - Ad is played after the video.
	TargetedPositionTypes []string `json:"targetedPositionTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedPositionTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedPositionTypes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *VideoTargeting) MarshalJSON() ([]byte, error) {
	type NoMethod VideoTargeting
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type BiddersAuctionPackagesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List the auction packages. Buyers can use the URL path
// "/v1/buyers/{accountId}/auctionPackages" to list auction packages for the
// current buyer and its clients. Bidders can use the URL path
// "/v1/bidders/{accountId}/auctionPackages" to list auction packages for the
// bidder, its media planners, its buyers, and all their clients.
//
//   - parent: Name of the parent buyer that can access the auction package.
//     Format: `buyers/{accountId}`. When used with a bidder account, the auction
//     packages that the bidder, its media planners, its buyers and clients are
//     subscribed to will be listed, in the format `bidders/{accountId}`.
func (r *BiddersAuctionPackagesService) List(parent string) *BiddersAuctionPackagesListCall {
	c := &BiddersAuctionPackagesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Optional query string using the
// Cloud API list filtering syntax
// (/authorized-buyers/apis/guides/list-filters). Only supported when parent is
// bidder. Supported columns for filtering are: * displayName * createTime *
// updateTime * eligibleSeatIds
func (c *BiddersAuctionPackagesListCall) Filter(filter string) *BiddersAuctionPackagesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An optional query string to
// sort auction packages using the Cloud API sorting syntax
// (https://cloud.google.com/apis/design/design_patterns#sorting_order). If no
// sort order is specified, results will be returned in an arbitrary order.
// Only supported when parent is bidder. Supported columns for sorting are: *
// displayName * createTime * updateTime
func (c *BiddersAuctionPackagesListCall) OrderBy(orderBy string) *BiddersAuctionPackagesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. Max allowed page size is
// 500.
func (c *BiddersAuctionPackagesListCall) PageSize(pageSize int64) *BiddersAuctionPackagesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token as
// returned. ListAuctionPackagesResponse.nextPageToken
func (c *BiddersAuctionPackagesListCall) PageToken(pageToken string) *BiddersAuctionPackagesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersAuctionPackagesListCall) Fields(s ...googleapi.Field) *BiddersAuctionPackagesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersAuctionPackagesListCall) IfNoneMatch(entityTag string) *BiddersAuctionPackagesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersAuctionPackagesListCall) Context(ctx context.Context) *BiddersAuctionPackagesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersAuctionPackagesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersAuctionPackagesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/auctionPackages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.bidders.auctionPackages.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAuctionPackagesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BiddersAuctionPackagesListCall) Do(opts ...googleapi.CallOption) (*ListAuctionPackagesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAuctionPackagesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BiddersAuctionPackagesListCall) Pages(ctx context.Context, f func(*ListAuctionPackagesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BiddersFinalizedDealsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists finalized deals. Use the URL path
// "/v1/buyers/{accountId}/finalizedDeals" to list finalized deals for the
// current buyer and its clients. Bidders can use the URL path
// "/v1/bidders/{accountId}/finalizedDeals" to list finalized deals for the
// bidder, its buyers and all their clients.
//
//   - parent: The buyer to list the finalized deals for, in the format:
//     `buyers/{accountId}`. When used to list finalized deals for a bidder, its
//     buyers and clients, in the format `bidders/{accountId}`.
func (r *BiddersFinalizedDealsService) List(parent string) *BiddersFinalizedDealsListCall {
	c := &BiddersFinalizedDealsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Optional query string using the
// Cloud API list filtering syntax
// (https://developers.google.com/authorized-buyers/apis/guides/list-filters)
// Supported columns for filtering are: * deal.displayName * deal.dealType *
// deal.createTime * deal.updateTime * deal.flightStartTime *
// deal.flightEndTime * deal.eligibleSeatIds * dealServingStatus
func (c *BiddersFinalizedDealsListCall) Filter(filter string) *BiddersFinalizedDealsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An optional query string to
// sort finalized deals using the Cloud API sorting syntax
// (https://cloud.google.com/apis/design/design_patterns#sorting_order). If no
// sort order is specified, results will be returned in an arbitrary order.
// Supported columns for sorting are: * deal.displayName * deal.createTime *
// deal.updateTime * deal.flightStartTime * deal.flightEndTime *
// rtbMetrics.bidRequests7Days * rtbMetrics.bids7Days *
// rtbMetrics.adImpressions7Days * rtbMetrics.bidRate7Days *
// rtbMetrics.filteredBidRate7Days * rtbMetrics.mustBidRateCurrentMonth
func (c *BiddersFinalizedDealsListCall) OrderBy(orderBy string) *BiddersFinalizedDealsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. If requested more than 500,
// the server will return 500 results per page. If unspecified, the server will
// pick a default page size of 100.
func (c *BiddersFinalizedDealsListCall) PageSize(pageSize int64) *BiddersFinalizedDealsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token as
// returned from ListFinalizedDealsResponse.
func (c *BiddersFinalizedDealsListCall) PageToken(pageToken string) *BiddersFinalizedDealsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BiddersFinalizedDealsListCall) Fields(s ...googleapi.Field) *BiddersFinalizedDealsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BiddersFinalizedDealsListCall) IfNoneMatch(entityTag string) *BiddersFinalizedDealsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BiddersFinalizedDealsListCall) Context(ctx context.Context) *BiddersFinalizedDealsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BiddersFinalizedDealsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BiddersFinalizedDealsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/finalizedDeals")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.bidders.finalizedDeals.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFinalizedDealsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BiddersFinalizedDealsListCall) Do(opts ...googleapi.CallOption) (*ListFinalizedDealsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFinalizedDealsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BiddersFinalizedDealsListCall) Pages(ctx context.Context, f func(*ListFinalizedDealsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersAuctionPackagesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an auction package given its name.
//
//   - name: Name of auction package to get. Format:
//     `buyers/{accountId}/auctionPackages/{auctionPackageId}`.
func (r *BuyersAuctionPackagesService) Get(name string) *BuyersAuctionPackagesGetCall {
	c := &BuyersAuctionPackagesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersAuctionPackagesGetCall) Fields(s ...googleapi.Field) *BuyersAuctionPackagesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersAuctionPackagesGetCall) IfNoneMatch(entityTag string) *BuyersAuctionPackagesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersAuctionPackagesGetCall) Context(ctx context.Context) *BuyersAuctionPackagesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersAuctionPackagesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersAuctionPackagesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.auctionPackages.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AuctionPackage.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersAuctionPackagesGetCall) Do(opts ...googleapi.CallOption) (*AuctionPackage, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AuctionPackage{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersAuctionPackagesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List the auction packages. Buyers can use the URL path
// "/v1/buyers/{accountId}/auctionPackages" to list auction packages for the
// current buyer and its clients. Bidders can use the URL path
// "/v1/bidders/{accountId}/auctionPackages" to list auction packages for the
// bidder, its media planners, its buyers, and all their clients.
//
//   - parent: Name of the parent buyer that can access the auction package.
//     Format: `buyers/{accountId}`. When used with a bidder account, the auction
//     packages that the bidder, its media planners, its buyers and clients are
//     subscribed to will be listed, in the format `bidders/{accountId}`.
func (r *BuyersAuctionPackagesService) List(parent string) *BuyersAuctionPackagesListCall {
	c := &BuyersAuctionPackagesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Optional query string using the
// Cloud API list filtering syntax
// (/authorized-buyers/apis/guides/list-filters). Only supported when parent is
// bidder. Supported columns for filtering are: * displayName * createTime *
// updateTime * eligibleSeatIds
func (c *BuyersAuctionPackagesListCall) Filter(filter string) *BuyersAuctionPackagesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An optional query string to
// sort auction packages using the Cloud API sorting syntax
// (https://cloud.google.com/apis/design/design_patterns#sorting_order). If no
// sort order is specified, results will be returned in an arbitrary order.
// Only supported when parent is bidder. Supported columns for sorting are: *
// displayName * createTime * updateTime
func (c *BuyersAuctionPackagesListCall) OrderBy(orderBy string) *BuyersAuctionPackagesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. Max allowed page size is
// 500.
func (c *BuyersAuctionPackagesListCall) PageSize(pageSize int64) *BuyersAuctionPackagesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token as
// returned. ListAuctionPackagesResponse.nextPageToken
func (c *BuyersAuctionPackagesListCall) PageToken(pageToken string) *BuyersAuctionPackagesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersAuctionPackagesListCall) Fields(s ...googleapi.Field) *BuyersAuctionPackagesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersAuctionPackagesListCall) IfNoneMatch(entityTag string) *BuyersAuctionPackagesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersAuctionPackagesListCall) Context(ctx context.Context) *BuyersAuctionPackagesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersAuctionPackagesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersAuctionPackagesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/auctionPackages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.auctionPackages.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAuctionPackagesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BuyersAuctionPackagesListCall) Do(opts ...googleapi.CallOption) (*ListAuctionPackagesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAuctionPackagesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersAuctionPackagesListCall) Pages(ctx context.Context, f func(*ListAuctionPackagesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersAuctionPackagesSubscribeCall struct {
	s                              *Service
	name                           string
	subscribeauctionpackagerequest *SubscribeAuctionPackageRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Subscribe: Subscribe to the auction package for the specified buyer. Once
// subscribed, the bidder will receive a call out for inventory matching the
// auction package targeting criteria with the auction package deal ID and the
// specified buyer.
//
//   - name: Name of the auction package. Format:
//     `buyers/{accountId}/auctionPackages/{auctionPackageId}`.
func (r *BuyersAuctionPackagesService) Subscribe(name string, subscribeauctionpackagerequest *SubscribeAuctionPackageRequest) *BuyersAuctionPackagesSubscribeCall {
	c := &BuyersAuctionPackagesSubscribeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.subscribeauctionpackagerequest = subscribeauctionpackagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersAuctionPackagesSubscribeCall) Fields(s ...googleapi.Field) *BuyersAuctionPackagesSubscribeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersAuctionPackagesSubscribeCall) Context(ctx context.Context) *BuyersAuctionPackagesSubscribeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersAuctionPackagesSubscribeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersAuctionPackagesSubscribeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.subscribeauctionpackagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:subscribe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.auctionPackages.subscribe" call.
// Any non-2xx status code is an error. Response headers are in either
// *AuctionPackage.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersAuctionPackagesSubscribeCall) Do(opts ...googleapi.CallOption) (*AuctionPackage, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AuctionPackage{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersAuctionPackagesSubscribeClientsCall struct {
	s                       *Service
	auctionPackage          string
	subscribeclientsrequest *SubscribeClientsRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// SubscribeClients: Subscribe the specified clients of the buyer to the
// auction package. If a client in the list does not belong to the buyer, an
// error response will be returned, and all of the following clients in the
// list will not be subscribed. Subscribing an already subscribed client will
// have no effect.
//
//   - auctionPackage: Name of the auction package. Format:
//     `buyers/{accountId}/auctionPackages/{auctionPackageId}`.
func (r *BuyersAuctionPackagesService) SubscribeClients(auctionPackage string, subscribeclientsrequest *SubscribeClientsRequest) *BuyersAuctionPackagesSubscribeClientsCall {
	c := &BuyersAuctionPackagesSubscribeClientsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.auctionPackage = auctionPackage
	c.subscribeclientsrequest = subscribeclientsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersAuctionPackagesSubscribeClientsCall) Fields(s ...googleapi.Field) *BuyersAuctionPackagesSubscribeClientsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersAuctionPackagesSubscribeClientsCall) Context(ctx context.Context) *BuyersAuctionPackagesSubscribeClientsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersAuctionPackagesSubscribeClientsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersAuctionPackagesSubscribeClientsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.subscribeclientsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+auctionPackage}:subscribeClients")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"auctionPackage": c.auctionPackage,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.auctionPackages.subscribeClients" call.
// Any non-2xx status code is an error. Response headers are in either
// *AuctionPackage.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersAuctionPackagesSubscribeClientsCall) Do(opts ...googleapi.CallOption) (*AuctionPackage, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AuctionPackage{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersAuctionPackagesUnsubscribeCall struct {
	s                                *Service
	name                             string
	unsubscribeauctionpackagerequest *UnsubscribeAuctionPackageRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Unsubscribe: Unsubscribe from the auction package for the specified buyer.
// Once unsubscribed, the bidder will no longer receive a call out for the
// auction package deal ID and the specified buyer.
//
//   - name: Name of the auction package. Format:
//     `buyers/{accountId}/auctionPackages/{auctionPackageId}`.
func (r *BuyersAuctionPackagesService) Unsubscribe(name string, unsubscribeauctionpackagerequest *UnsubscribeAuctionPackageRequest) *BuyersAuctionPackagesUnsubscribeCall {
	c := &BuyersAuctionPackagesUnsubscribeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.unsubscribeauctionpackagerequest = unsubscribeauctionpackagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersAuctionPackagesUnsubscribeCall) Fields(s ...googleapi.Field) *BuyersAuctionPackagesUnsubscribeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersAuctionPackagesUnsubscribeCall) Context(ctx context.Context) *BuyersAuctionPackagesUnsubscribeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersAuctionPackagesUnsubscribeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersAuctionPackagesUnsubscribeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.unsubscribeauctionpackagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:unsubscribe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.auctionPackages.unsubscribe" call.
// Any non-2xx status code is an error. Response headers are in either
// *AuctionPackage.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersAuctionPackagesUnsubscribeCall) Do(opts ...googleapi.CallOption) (*AuctionPackage, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AuctionPackage{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersAuctionPackagesUnsubscribeClientsCall struct {
	s                         *Service
	auctionPackage            string
	unsubscribeclientsrequest *UnsubscribeClientsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// UnsubscribeClients: Unsubscribe from the auction package for the specified
// clients of the buyer. Unsubscribing a client that is not subscribed will
// have no effect.
//
//   - auctionPackage: Name of the auction package. Format:
//     `buyers/{accountId}/auctionPackages/{auctionPackageId}`.
func (r *BuyersAuctionPackagesService) UnsubscribeClients(auctionPackage string, unsubscribeclientsrequest *UnsubscribeClientsRequest) *BuyersAuctionPackagesUnsubscribeClientsCall {
	c := &BuyersAuctionPackagesUnsubscribeClientsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.auctionPackage = auctionPackage
	c.unsubscribeclientsrequest = unsubscribeclientsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersAuctionPackagesUnsubscribeClientsCall) Fields(s ...googleapi.Field) *BuyersAuctionPackagesUnsubscribeClientsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersAuctionPackagesUnsubscribeClientsCall) Context(ctx context.Context) *BuyersAuctionPackagesUnsubscribeClientsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersAuctionPackagesUnsubscribeClientsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersAuctionPackagesUnsubscribeClientsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.unsubscribeclientsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+auctionPackage}:unsubscribeClients")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"auctionPackage": c.auctionPackage,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.auctionPackages.unsubscribeClients" call.
// Any non-2xx status code is an error. Response headers are in either
// *AuctionPackage.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersAuctionPackagesUnsubscribeClientsCall) Do(opts ...googleapi.CallOption) (*AuctionPackage, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AuctionPackage{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsActivateCall struct {
	s                     *Service
	name                  string
	activateclientrequest *ActivateClientRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Activate: Activates an existing client. The state of the client will be
// updated to "ACTIVE". This method has no effect if the client is already in
// "ACTIVE" state.
//
// - name: Format: `buyers/{buyerAccountId}/clients/{clientAccountId}`.
func (r *BuyersClientsService) Activate(name string, activateclientrequest *ActivateClientRequest) *BuyersClientsActivateCall {
	c := &BuyersClientsActivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.activateclientrequest = activateclientrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsActivateCall) Fields(s ...googleapi.Field) *BuyersClientsActivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsActivateCall) Context(ctx context.Context) *BuyersClientsActivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsActivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsActivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.activateclientrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:activate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.activate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Client.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsActivateCall) Do(opts ...googleapi.CallOption) (*Client, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Client{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsCreateCall struct {
	s          *Service
	parent     string
	client     *Client
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new client.
//
// - parent: The name of the buyer. Format: `buyers/{accountId}`.
func (r *BuyersClientsService) Create(parent string, client *Client) *BuyersClientsCreateCall {
	c := &BuyersClientsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.client = client
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsCreateCall) Fields(s ...googleapi.Field) *BuyersClientsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsCreateCall) Context(ctx context.Context) *BuyersClientsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.client)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/clients")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Client.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsCreateCall) Do(opts ...googleapi.CallOption) (*Client, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Client{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsDeactivateCall struct {
	s                       *Service
	name                    string
	deactivateclientrequest *DeactivateClientRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Deactivate: Deactivates an existing client. The state of the client will be
// updated to "INACTIVE". This method has no effect if the client is already in
// "INACTIVE" state.
//
// - name: Format: `buyers/{buyerAccountId}/clients/{clientAccountId}`.
func (r *BuyersClientsService) Deactivate(name string, deactivateclientrequest *DeactivateClientRequest) *BuyersClientsDeactivateCall {
	c := &BuyersClientsDeactivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.deactivateclientrequest = deactivateclientrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsDeactivateCall) Fields(s ...googleapi.Field) *BuyersClientsDeactivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsDeactivateCall) Context(ctx context.Context) *BuyersClientsDeactivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsDeactivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsDeactivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deactivateclientrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:deactivate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.deactivate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Client.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsDeactivateCall) Do(opts ...googleapi.CallOption) (*Client, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Client{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a client with a given resource name.
//
// - name: Format: `buyers/{accountId}/clients/{clientAccountId}`.
func (r *BuyersClientsService) Get(name string) *BuyersClientsGetCall {
	c := &BuyersClientsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsGetCall) Fields(s ...googleapi.Field) *BuyersClientsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersClientsGetCall) IfNoneMatch(entityTag string) *BuyersClientsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsGetCall) Context(ctx context.Context) *BuyersClientsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Client.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsGetCall) Do(opts ...googleapi.CallOption) (*Client, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Client{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the clients for the current buyer.
//
// - parent: The name of the buyer. Format: `buyers/{accountId}`.
func (r *BuyersClientsService) List(parent string) *BuyersClientsListCall {
	c := &BuyersClientsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Query string using the
// Filtering Syntax
// (https://developers.google.com/authorized-buyers/apis/guides/list-filters)
// Supported fields for filtering are: * partnerClientId Use this field to
// filter the clients by the partnerClientId. For example, if the
// partnerClientId of the client is "1234", the value of this field should be
// `partnerClientId = "1234", in order to get only the client whose
// partnerClientId is "1234" in the response.
func (c *BuyersClientsListCall) Filter(filter string) *BuyersClientsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. If
// left blank, a default page size of 500 will be applied.
func (c *BuyersClientsListCall) PageSize(pageSize int64) *BuyersClientsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListClientsResponse.nextPageToken returned from the previous call to the
// list method.
func (c *BuyersClientsListCall) PageToken(pageToken string) *BuyersClientsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsListCall) Fields(s ...googleapi.Field) *BuyersClientsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersClientsListCall) IfNoneMatch(entityTag string) *BuyersClientsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsListCall) Context(ctx context.Context) *BuyersClientsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/clients")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListClientsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BuyersClientsListCall) Do(opts ...googleapi.CallOption) (*ListClientsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListClientsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersClientsListCall) Pages(ctx context.Context, f func(*ListClientsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersClientsPatchCall struct {
	s          *Service
	name       string
	client     *Client
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an existing client.
//
//   - name: Output only. The resource name of the client. Format:
//     `buyers/{accountId}/clients/{clientAccountId}`.
func (r *BuyersClientsService) Patch(name string, client *Client) *BuyersClientsPatchCall {
	c := &BuyersClientsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.client = client
	return c
}

// UpdateMask sets the optional parameter "updateMask": List of fields to be
// updated. If empty or unspecified, the service will update all fields
// populated in the update request excluding the output only fields and
// primitive fields with default value. Note that explicit field mask is
// required in order to reset a primitive field back to its default value, for
// example, false for boolean fields, 0 for integer fields. A special field
// mask consisting of a single path "*" can be used to indicate full
// replacement(the equivalent of PUT method), updatable fields unset or
// unspecified in the input will be cleared or set to default value. Output
// only fields will be ignored regardless of the value of updateMask.
func (c *BuyersClientsPatchCall) UpdateMask(updateMask string) *BuyersClientsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsPatchCall) Fields(s ...googleapi.Field) *BuyersClientsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsPatchCall) Context(ctx context.Context) *BuyersClientsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.client)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Client.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsPatchCall) Do(opts ...googleapi.CallOption) (*Client, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Client{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsUsersActivateCall struct {
	s                         *Service
	name                      string
	activateclientuserrequest *ActivateClientUserRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Activate: Activates an existing client user. The state of the client user
// will be updated from "INACTIVE" to "ACTIVE". This method has no effect if
// the client user is already in "ACTIVE" state. An error will be returned if
// the client user to activate is still in "INVITED" state.
//
//   - name: Format:
//     `buyers/{buyerAccountId}/clients/{clientAccountId}/clientUsers/{userId}`.
func (r *BuyersClientsUsersService) Activate(name string, activateclientuserrequest *ActivateClientUserRequest) *BuyersClientsUsersActivateCall {
	c := &BuyersClientsUsersActivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.activateclientuserrequest = activateclientuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsUsersActivateCall) Fields(s ...googleapi.Field) *BuyersClientsUsersActivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsUsersActivateCall) Context(ctx context.Context) *BuyersClientsUsersActivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsUsersActivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsUsersActivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.activateclientuserrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:activate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.users.activate" call.
// Any non-2xx status code is an error. Response headers are in either
// *ClientUser.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsUsersActivateCall) Do(opts ...googleapi.CallOption) (*ClientUser, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ClientUser{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsUsersCreateCall struct {
	s          *Service
	parent     string
	clientuser *ClientUser
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new client user in "INVITED" state. An email invitation
// will be sent to the new user, once accepted the user will become active.
//
//   - parent: The name of the client. Format:
//     `buyers/{accountId}/clients/{clientAccountId}`.
func (r *BuyersClientsUsersService) Create(parent string, clientuser *ClientUser) *BuyersClientsUsersCreateCall {
	c := &BuyersClientsUsersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.clientuser = clientuser
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsUsersCreateCall) Fields(s ...googleapi.Field) *BuyersClientsUsersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsUsersCreateCall) Context(ctx context.Context) *BuyersClientsUsersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsUsersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsUsersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.clientuser)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/users")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.users.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *ClientUser.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsUsersCreateCall) Do(opts ...googleapi.CallOption) (*ClientUser, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ClientUser{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsUsersDeactivateCall struct {
	s                           *Service
	name                        string
	deactivateclientuserrequest *DeactivateClientUserRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Deactivate: Deactivates an existing client user. The state of the client
// user will be updated from "ACTIVE" to "INACTIVE". This method has no effect
// if the client user is already in "INACTIVE" state. An error will be returned
// if the client user to deactivate is still in "INVITED" state.
//
//   - name: Format:
//     `buyers/{buyerAccountId}/clients/{clientAccountId}/clientUsers/{userId}`.
func (r *BuyersClientsUsersService) Deactivate(name string, deactivateclientuserrequest *DeactivateClientUserRequest) *BuyersClientsUsersDeactivateCall {
	c := &BuyersClientsUsersDeactivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.deactivateclientuserrequest = deactivateclientuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsUsersDeactivateCall) Fields(s ...googleapi.Field) *BuyersClientsUsersDeactivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsUsersDeactivateCall) Context(ctx context.Context) *BuyersClientsUsersDeactivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsUsersDeactivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsUsersDeactivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deactivateclientuserrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:deactivate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.users.deactivate" call.
// Any non-2xx status code is an error. Response headers are in either
// *ClientUser.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsUsersDeactivateCall) Do(opts ...googleapi.CallOption) (*ClientUser, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ClientUser{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsUsersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing client user. The client user will lose access to
// the Authorized Buyers UI. Note that if a client user is deleted, the user's
// access to the UI can't be restored unless a new client user is created and
// activated.
//
//   - name: Format:
//     `buyers/{buyerAccountId}/clients/{clientAccountId}/clientUsers/{userId}`.
func (r *BuyersClientsUsersService) Delete(name string) *BuyersClientsUsersDeleteCall {
	c := &BuyersClientsUsersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsUsersDeleteCall) Fields(s ...googleapi.Field) *BuyersClientsUsersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsUsersDeleteCall) Context(ctx context.Context) *BuyersClientsUsersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsUsersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsUsersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.users.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsUsersDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsUsersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves an existing client user.
//
//   - name: Format:
//     `buyers/{buyerAccountId}/clients/{clientAccountId}/clientUsers/{userId}`.
func (r *BuyersClientsUsersService) Get(name string) *BuyersClientsUsersGetCall {
	c := &BuyersClientsUsersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsUsersGetCall) Fields(s ...googleapi.Field) *BuyersClientsUsersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersClientsUsersGetCall) IfNoneMatch(entityTag string) *BuyersClientsUsersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsUsersGetCall) Context(ctx context.Context) *BuyersClientsUsersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsUsersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsUsersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.users.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ClientUser.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersClientsUsersGetCall) Do(opts ...googleapi.CallOption) (*ClientUser, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ClientUser{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersClientsUsersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all client users for a specified client.
//
//   - parent: The name of the client. Format:
//     `buyers/{buyerAccountId}/clients/{clientAccountId}`.
func (r *BuyersClientsUsersService) List(parent string) *BuyersClientsUsersListCall {
	c := &BuyersClientsUsersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. If
// left blank, a default page size of 500 will be applied.
func (c *BuyersClientsUsersListCall) PageSize(pageSize int64) *BuyersClientsUsersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListClientUsersResponse.nextPageToken returned from the previous call to the
// list method.
func (c *BuyersClientsUsersListCall) PageToken(pageToken string) *BuyersClientsUsersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersClientsUsersListCall) Fields(s ...googleapi.Field) *BuyersClientsUsersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersClientsUsersListCall) IfNoneMatch(entityTag string) *BuyersClientsUsersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersClientsUsersListCall) Context(ctx context.Context) *BuyersClientsUsersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersClientsUsersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersClientsUsersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/users")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.clients.users.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListClientUsersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BuyersClientsUsersListCall) Do(opts ...googleapi.CallOption) (*ListClientUsersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListClientUsersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersClientsUsersListCall) Pages(ctx context.Context, f func(*ListClientUsersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersFinalizedDealsAddCreativeCall struct {
	s                  *Service
	deal               string
	addcreativerequest *AddCreativeRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// AddCreative: Add creative to be used in the bidding process for a finalized
// deal. For programmatic guaranteed deals, it's recommended that you associate
// at least one approved creative with the deal before calling SetReadyToServe,
// to help reduce the number of bid responses filtered because they don't
// contain approved creatives. Creatives successfully added to a deal can be
// found in the Realtime-bidding Creatives API creative.deal_ids. This method
// only applies to programmatic guaranteed deals. Maximum number of 1000
// creatives can be added to a finalized deal.
//
//   - deal: Name of the finalized deal in the format of:
//     `buyers/{accountId}/finalizedDeals/{dealId}`.
func (r *BuyersFinalizedDealsService) AddCreative(deal string, addcreativerequest *AddCreativeRequest) *BuyersFinalizedDealsAddCreativeCall {
	c := &BuyersFinalizedDealsAddCreativeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.deal = deal
	c.addcreativerequest = addcreativerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersFinalizedDealsAddCreativeCall) Fields(s ...googleapi.Field) *BuyersFinalizedDealsAddCreativeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersFinalizedDealsAddCreativeCall) Context(ctx context.Context) *BuyersFinalizedDealsAddCreativeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersFinalizedDealsAddCreativeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersFinalizedDealsAddCreativeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addcreativerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+deal}:addCreative")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"deal": c.deal,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.finalizedDeals.addCreative" call.
// Any non-2xx status code is an error. Response headers are in either
// *FinalizedDeal.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersFinalizedDealsAddCreativeCall) Do(opts ...googleapi.CallOption) (*FinalizedDeal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FinalizedDeal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersFinalizedDealsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a finalized deal given its name.
//
// - name: Format: `buyers/{accountId}/finalizedDeals/{dealId}`.
func (r *BuyersFinalizedDealsService) Get(name string) *BuyersFinalizedDealsGetCall {
	c := &BuyersFinalizedDealsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersFinalizedDealsGetCall) Fields(s ...googleapi.Field) *BuyersFinalizedDealsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersFinalizedDealsGetCall) IfNoneMatch(entityTag string) *BuyersFinalizedDealsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersFinalizedDealsGetCall) Context(ctx context.Context) *BuyersFinalizedDealsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersFinalizedDealsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersFinalizedDealsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.finalizedDeals.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FinalizedDeal.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersFinalizedDealsGetCall) Do(opts ...googleapi.CallOption) (*FinalizedDeal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FinalizedDeal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersFinalizedDealsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists finalized deals. Use the URL path
// "/v1/buyers/{accountId}/finalizedDeals" to list finalized deals for the
// current buyer and its clients. Bidders can use the URL path
// "/v1/bidders/{accountId}/finalizedDeals" to list finalized deals for the
// bidder, its buyers and all their clients.
//
//   - parent: The buyer to list the finalized deals for, in the format:
//     `buyers/{accountId}`. When used to list finalized deals for a bidder, its
//     buyers and clients, in the format `bidders/{accountId}`.
func (r *BuyersFinalizedDealsService) List(parent string) *BuyersFinalizedDealsListCall {
	c := &BuyersFinalizedDealsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Optional query string using the
// Cloud API list filtering syntax
// (https://developers.google.com/authorized-buyers/apis/guides/list-filters)
// Supported columns for filtering are: * deal.displayName * deal.dealType *
// deal.createTime * deal.updateTime * deal.flightStartTime *
// deal.flightEndTime * deal.eligibleSeatIds * dealServingStatus
func (c *BuyersFinalizedDealsListCall) Filter(filter string) *BuyersFinalizedDealsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": An optional query string to
// sort finalized deals using the Cloud API sorting syntax
// (https://cloud.google.com/apis/design/design_patterns#sorting_order). If no
// sort order is specified, results will be returned in an arbitrary order.
// Supported columns for sorting are: * deal.displayName * deal.createTime *
// deal.updateTime * deal.flightStartTime * deal.flightEndTime *
// rtbMetrics.bidRequests7Days * rtbMetrics.bids7Days *
// rtbMetrics.adImpressions7Days * rtbMetrics.bidRate7Days *
// rtbMetrics.filteredBidRate7Days * rtbMetrics.mustBidRateCurrentMonth
func (c *BuyersFinalizedDealsListCall) OrderBy(orderBy string) *BuyersFinalizedDealsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. If requested more than 500,
// the server will return 500 results per page. If unspecified, the server will
// pick a default page size of 100.
func (c *BuyersFinalizedDealsListCall) PageSize(pageSize int64) *BuyersFinalizedDealsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token as
// returned from ListFinalizedDealsResponse.
func (c *BuyersFinalizedDealsListCall) PageToken(pageToken string) *BuyersFinalizedDealsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersFinalizedDealsListCall) Fields(s ...googleapi.Field) *BuyersFinalizedDealsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersFinalizedDealsListCall) IfNoneMatch(entityTag string) *BuyersFinalizedDealsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersFinalizedDealsListCall) Context(ctx context.Context) *BuyersFinalizedDealsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersFinalizedDealsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersFinalizedDealsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/finalizedDeals")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.finalizedDeals.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFinalizedDealsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BuyersFinalizedDealsListCall) Do(opts ...googleapi.CallOption) (*ListFinalizedDealsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFinalizedDealsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersFinalizedDealsListCall) Pages(ctx context.Context, f func(*ListFinalizedDealsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersFinalizedDealsPauseCall struct {
	s                         *Service
	name                      string
	pausefinalizeddealrequest *PauseFinalizedDealRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Pause: Pauses serving of the given finalized deal. This call only pauses the
// serving status, and does not affect other fields of the finalized deal.
// Calling this method for an already paused deal has no effect. This method
// only applies to programmatic guaranteed deals and preferred deals.
//
// - name: Format: `buyers/{accountId}/finalizedDeals/{dealId}`.
func (r *BuyersFinalizedDealsService) Pause(name string, pausefinalizeddealrequest *PauseFinalizedDealRequest) *BuyersFinalizedDealsPauseCall {
	c := &BuyersFinalizedDealsPauseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.pausefinalizeddealrequest = pausefinalizeddealrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersFinalizedDealsPauseCall) Fields(s ...googleapi.Field) *BuyersFinalizedDealsPauseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersFinalizedDealsPauseCall) Context(ctx context.Context) *BuyersFinalizedDealsPauseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersFinalizedDealsPauseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersFinalizedDealsPauseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.pausefinalizeddealrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:pause")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.finalizedDeals.pause" call.
// Any non-2xx status code is an error. Response headers are in either
// *FinalizedDeal.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersFinalizedDealsPauseCall) Do(opts ...googleapi.CallOption) (*FinalizedDeal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FinalizedDeal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersFinalizedDealsResumeCall struct {
	s                          *Service
	name                       string
	resumefinalizeddealrequest *ResumeFinalizedDealRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Resume: Resumes serving of the given finalized deal. Calling this method for
// an running deal has no effect. If a deal is initially paused by the seller,
// calling this method will not resume serving of the deal until the seller
// also resumes the deal. This method only applies to programmatic guaranteed
// deals and preferred deals.
//
// - name: Format: `buyers/{accountId}/finalizedDeals/{dealId}`.
func (r *BuyersFinalizedDealsService) Resume(name string, resumefinalizeddealrequest *ResumeFinalizedDealRequest) *BuyersFinalizedDealsResumeCall {
	c := &BuyersFinalizedDealsResumeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.resumefinalizeddealrequest = resumefinalizeddealrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersFinalizedDealsResumeCall) Fields(s ...googleapi.Field) *BuyersFinalizedDealsResumeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersFinalizedDealsResumeCall) Context(ctx context.Context) *BuyersFinalizedDealsResumeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersFinalizedDealsResumeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersFinalizedDealsResumeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.resumefinalizeddealrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:resume")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.finalizedDeals.resume" call.
// Any non-2xx status code is an error. Response headers are in either
// *FinalizedDeal.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersFinalizedDealsResumeCall) Do(opts ...googleapi.CallOption) (*FinalizedDeal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FinalizedDeal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersFinalizedDealsSetReadyToServeCall struct {
	s                      *Service
	deal                   string
	setreadytoserverequest *SetReadyToServeRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetReadyToServe: Sets the given finalized deal as ready to serve. By
// default, deals are set as ready to serve as soon as they're finalized. If
// you want to opt out of the default behavior, and manually indicate that
// deals are ready to serve, ask your Technical Account Manager to add you to
// the allowlist. If you choose to use this method, finalized deals belonging
// to the bidder and its child seats don't start serving until after you call
// `setReadyToServe`, and after the deals become active. For example, you can
// use this method to delay receiving bid requests until your creative is
// ready. This method only applies to programmatic guaranteed deals.
//
// - deal: Format: `buyers/{accountId}/finalizedDeals/{dealId}`.
func (r *BuyersFinalizedDealsService) SetReadyToServe(deal string, setreadytoserverequest *SetReadyToServeRequest) *BuyersFinalizedDealsSetReadyToServeCall {
	c := &BuyersFinalizedDealsSetReadyToServeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.deal = deal
	c.setreadytoserverequest = setreadytoserverequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersFinalizedDealsSetReadyToServeCall) Fields(s ...googleapi.Field) *BuyersFinalizedDealsSetReadyToServeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersFinalizedDealsSetReadyToServeCall) Context(ctx context.Context) *BuyersFinalizedDealsSetReadyToServeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersFinalizedDealsSetReadyToServeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersFinalizedDealsSetReadyToServeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setreadytoserverequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+deal}:setReadyToServe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"deal": c.deal,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.finalizedDeals.setReadyToServe" call.
// Any non-2xx status code is an error. Response headers are in either
// *FinalizedDeal.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersFinalizedDealsSetReadyToServeCall) Do(opts ...googleapi.CallOption) (*FinalizedDeal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FinalizedDeal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersProposalsAcceptCall struct {
	s                     *Service
	name                  string
	acceptproposalrequest *AcceptProposalRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Accept: Accepts the proposal at the given revision number. If the revision
// number in the request is behind the latest from the server, an error message
// will be returned. This call updates the Proposal.state from
// `BUYER_ACCEPTANCE_REQUESTED` to `FINALIZED`; it has no side effect if the
// Proposal.state is already `FINALIZED` and throws exception if the
// Proposal.state is not either `BUYER_ACCEPTANCE_REQUESTED` or `FINALIZED`.
// Accepting a proposal means the buyer understands and accepts the
// Proposal.terms_and_conditions proposed by the seller.
//
//   - name: Name of the proposal. Format:
//     `buyers/{accountId}/proposals/{proposalId}`.
func (r *BuyersProposalsService) Accept(name string, acceptproposalrequest *AcceptProposalRequest) *BuyersProposalsAcceptCall {
	c := &BuyersProposalsAcceptCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.acceptproposalrequest = acceptproposalrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsAcceptCall) Fields(s ...googleapi.Field) *BuyersProposalsAcceptCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsAcceptCall) Context(ctx context.Context) *BuyersProposalsAcceptCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsAcceptCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsAcceptCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.acceptproposalrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accept")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.accept" call.
// Any non-2xx status code is an error. Response headers are in either
// *Proposal.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersProposalsAcceptCall) Do(opts ...googleapi.CallOption) (*Proposal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Proposal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersProposalsAddNoteCall struct {
	s              *Service
	proposal       string
	addnoterequest *AddNoteRequest
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// AddNote: Creates a note for this proposal and sends to the seller. This
// method is not supported for proposals with DealType set to
// 'PRIVATE_AUCTION'.
//
//   - proposal: Name of the proposal. Format:
//     `buyers/{accountId}/proposals/{proposalId}`.
func (r *BuyersProposalsService) AddNote(proposal string, addnoterequest *AddNoteRequest) *BuyersProposalsAddNoteCall {
	c := &BuyersProposalsAddNoteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.proposal = proposal
	c.addnoterequest = addnoterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsAddNoteCall) Fields(s ...googleapi.Field) *BuyersProposalsAddNoteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsAddNoteCall) Context(ctx context.Context) *BuyersProposalsAddNoteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsAddNoteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsAddNoteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addnoterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+proposal}:addNote")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"proposal": c.proposal,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.addNote" call.
// Any non-2xx status code is an error. Response headers are in either
// *Proposal.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersProposalsAddNoteCall) Do(opts ...googleapi.CallOption) (*Proposal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Proposal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersProposalsCancelNegotiationCall struct {
	s                        *Service
	proposal                 string
	cancelnegotiationrequest *CancelNegotiationRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// CancelNegotiation: Cancels an ongoing negotiation on a proposal. This does
// not cancel or end serving for the deals if the proposal has been finalized.
// If the proposal has not been finalized before, calling this method will set
// the Proposal.state to `TERMINATED` and increment the
// Proposal.proposal_revision. If the proposal has been finalized before and is
// under renegotiation now, calling this method will reset the Proposal.state
// to `FINALIZED` and increment the Proposal.proposal_revision. This method
// does not support private auction proposals whose Proposal.deal_type is
// 'PRIVATE_AUCTION'.
//
//   - proposal: Name of the proposal. Format:
//     `buyers/{accountId}/proposals/{proposalId}`.
func (r *BuyersProposalsService) CancelNegotiation(proposal string, cancelnegotiationrequest *CancelNegotiationRequest) *BuyersProposalsCancelNegotiationCall {
	c := &BuyersProposalsCancelNegotiationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.proposal = proposal
	c.cancelnegotiationrequest = cancelnegotiationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsCancelNegotiationCall) Fields(s ...googleapi.Field) *BuyersProposalsCancelNegotiationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsCancelNegotiationCall) Context(ctx context.Context) *BuyersProposalsCancelNegotiationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsCancelNegotiationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsCancelNegotiationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.cancelnegotiationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+proposal}:cancelNegotiation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"proposal": c.proposal,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.cancelNegotiation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Proposal.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersProposalsCancelNegotiationCall) Do(opts ...googleapi.CallOption) (*Proposal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Proposal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersProposalsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a proposal using its resource name. The proposal is returned at
// the latest revision.
//
//   - name: Name of the proposal. Format:
//     `buyers/{accountId}/proposals/{proposalId}`.
func (r *BuyersProposalsService) Get(name string) *BuyersProposalsGetCall {
	c := &BuyersProposalsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsGetCall) Fields(s ...googleapi.Field) *BuyersProposalsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersProposalsGetCall) IfNoneMatch(entityTag string) *BuyersProposalsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsGetCall) Context(ctx context.Context) *BuyersProposalsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Proposal.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersProposalsGetCall) Do(opts ...googleapi.CallOption) (*Proposal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Proposal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersProposalsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists proposals. A filter expression using Cloud API list filtering
// syntax
// (https://developers.google.com/authorized-buyers/apis/guides/list-filters)
// may be specified to filter the results.
//
//   - parent: Parent that owns the collection of proposals Format:
//     `buyers/{accountId}`.
func (r *BuyersProposalsService) List(parent string) *BuyersProposalsListCall {
	c := &BuyersProposalsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Optional query string using the
// Cloud API list filtering syntax
// (https://developers.google.com/authorized-buyers/apis/guides/list-filters)
// Supported columns for filtering are: * displayName * dealType * updateTime *
// state
func (c *BuyersProposalsListCall) Filter(filter string) *BuyersProposalsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. If unspecified, the server
// will put a size of 500.
func (c *BuyersProposalsListCall) PageSize(pageSize int64) *BuyersProposalsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token as
// returned from ListProposalsResponse.
func (c *BuyersProposalsListCall) PageToken(pageToken string) *BuyersProposalsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsListCall) Fields(s ...googleapi.Field) *BuyersProposalsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersProposalsListCall) IfNoneMatch(entityTag string) *BuyersProposalsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsListCall) Context(ctx context.Context) *BuyersProposalsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/proposals")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListProposalsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BuyersProposalsListCall) Do(opts ...googleapi.CallOption) (*ListProposalsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListProposalsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersProposalsListCall) Pages(ctx context.Context, f func(*ListProposalsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersProposalsPatchCall struct {
	s          *Service
	nameid     string
	proposal   *Proposal
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the proposal at the given revision number. If the revision
// number in the request is behind the latest one kept in the server, an error
// message will be returned. See FieldMask for how to use FieldMask. Only
// fields specified in the UpdateProposalRequest.update_mask will be updated;
// Fields noted as 'Immutable' or 'Output only' yet specified in the
// UpdateProposalRequest.update_mask will be ignored and left unchanged.
// Updating a private auction proposal is not allowed and will result in an
// error.
//
//   - name: Immutable. The name of the proposal serving as a unique identifier.
//     Format: buyers/{accountId}/proposals/{proposalId}.
func (r *BuyersProposalsService) Patch(nameid string, proposal *Proposal) *BuyersProposalsPatchCall {
	c := &BuyersProposalsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.proposal = proposal
	return c
}

// UpdateMask sets the optional parameter "updateMask": List of fields to be
// updated. If empty or unspecified, the service will update all fields
// populated in the update request excluding the output only fields and
// primitive fields with default value. Note that explicit field mask is
// required in order to reset a primitive field back to its default value, for
// example, false for boolean fields, 0 for integer fields. A special field
// mask consisting of a single path "*" can be used to indicate full
// replacement(the equivalent of PUT method), updatable fields unset or
// unspecified in the input will be cleared or set to default value. Output
// only fields will be ignored regardless of the value of updateMask.
func (c *BuyersProposalsPatchCall) UpdateMask(updateMask string) *BuyersProposalsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsPatchCall) Fields(s ...googleapi.Field) *BuyersProposalsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsPatchCall) Context(ctx context.Context) *BuyersProposalsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.proposal)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Proposal.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersProposalsPatchCall) Do(opts ...googleapi.CallOption) (*Proposal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Proposal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersProposalsSendRfpCall struct {
	s              *Service
	buyer          string
	sendrfprequest *SendRfpRequest
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// SendRfp: Sends a request for proposal (RFP) to a publisher to initiate the
// negotiation regarding certain inventory. In the RFP, buyers can specify the
// deal type, deal terms, start and end dates, targeting, and a message to the
// publisher. Once the RFP is sent, a proposal in `SELLER_REVIEW_REQUESTED`
// state will be created and returned in the response. The publisher may review
// your request and respond with detailed deals in the proposal.
//
//   - buyer: The current buyer who is sending the RFP in the format:
//     `buyers/{accountId}`.
func (r *BuyersProposalsService) SendRfp(buyer string, sendrfprequest *SendRfpRequest) *BuyersProposalsSendRfpCall {
	c := &BuyersProposalsSendRfpCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.buyer = buyer
	c.sendrfprequest = sendrfprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsSendRfpCall) Fields(s ...googleapi.Field) *BuyersProposalsSendRfpCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsSendRfpCall) Context(ctx context.Context) *BuyersProposalsSendRfpCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsSendRfpCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsSendRfpCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.sendrfprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+buyer}/proposals:sendRfp")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"buyer": c.buyer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.sendRfp" call.
// Any non-2xx status code is an error. Response headers are in either
// *Proposal.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersProposalsSendRfpCall) Do(opts ...googleapi.CallOption) (*Proposal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Proposal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersProposalsDealsBatchUpdateCall struct {
	s                       *Service
	parent                  string
	batchupdatedealsrequest *BatchUpdateDealsRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// BatchUpdate: Batch updates multiple deals in the same proposal.
//
//   - parent: The name of the proposal containing the deals to batch update.
//     Format: buyers/{accountId}/proposals/{proposalId}.
func (r *BuyersProposalsDealsService) BatchUpdate(parent string, batchupdatedealsrequest *BatchUpdateDealsRequest) *BuyersProposalsDealsBatchUpdateCall {
	c := &BuyersProposalsDealsBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchupdatedealsrequest = batchupdatedealsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsDealsBatchUpdateCall) Fields(s ...googleapi.Field) *BuyersProposalsDealsBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsDealsBatchUpdateCall) Context(ctx context.Context) *BuyersProposalsDealsBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsDealsBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsDealsBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchupdatedealsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/deals:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.deals.batchUpdate" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchUpdateDealsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BuyersProposalsDealsBatchUpdateCall) Do(opts ...googleapi.CallOption) (*BatchUpdateDealsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchUpdateDealsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersProposalsDealsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a deal given its name. The deal is returned at its head revision.
//
// - name: Format: buyers/{accountId}/proposals/{proposalId}/deals/{dealId}.
func (r *BuyersProposalsDealsService) Get(name string) *BuyersProposalsDealsGetCall {
	c := &BuyersProposalsDealsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsDealsGetCall) Fields(s ...googleapi.Field) *BuyersProposalsDealsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersProposalsDealsGetCall) IfNoneMatch(entityTag string) *BuyersProposalsDealsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsDealsGetCall) Context(ctx context.Context) *BuyersProposalsDealsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsDealsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsDealsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.deals.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Deal.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersProposalsDealsGetCall) Do(opts ...googleapi.CallOption) (*Deal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Deal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersProposalsDealsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all deals in a proposal. To retrieve only the finalized revision
// deals regardless if a deal is being renegotiated, see the FinalizedDeals
// resource.
//
//   - parent: The name of the proposal containing the deals to retrieve. Format:
//     buyers/{accountId}/proposals/{proposalId}.
func (r *BuyersProposalsDealsService) List(parent string) *BuyersProposalsDealsListCall {
	c := &BuyersProposalsDealsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. If requested more than 500,
// the server will return 500 results per page. If unspecified, the server will
// pick a default page size of 100.
func (c *BuyersProposalsDealsListCall) PageSize(pageSize int64) *BuyersProposalsDealsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token as
// returned from ListDealsResponse.
func (c *BuyersProposalsDealsListCall) PageToken(pageToken string) *BuyersProposalsDealsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsDealsListCall) Fields(s ...googleapi.Field) *BuyersProposalsDealsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersProposalsDealsListCall) IfNoneMatch(entityTag string) *BuyersProposalsDealsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsDealsListCall) Context(ctx context.Context) *BuyersProposalsDealsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsDealsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsDealsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/deals")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.deals.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDealsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BuyersProposalsDealsListCall) Do(opts ...googleapi.CallOption) (*ListDealsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDealsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersProposalsDealsListCall) Pages(ctx context.Context, f func(*ListDealsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BuyersProposalsDealsPatchCall struct {
	s          *Service
	nameid     string
	deal       *Deal
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the given deal at the buyer known revision number. If the
// server revision has advanced since the passed-in proposal.proposal_revision
// an ABORTED error message will be returned. The revision number is
// incremented by the server whenever the proposal or its constituent deals are
// updated. Note: The revision number is kept at a proposal level. The buyer of
// the API is expected to keep track of the revision number after the last
// update operation and send it in as part of the next update request. This
// way, if there are further changes on the server (for example, seller making
// new updates), then the server can detect conflicts and reject the proposed
// changes.
//
//   - name: Immutable. The unique identifier of the deal. Auto-generated by the
//     server when a deal is created. Format:
//     buyers/{accountId}/proposals/{proposalId}/deals/{dealId}.
func (r *BuyersProposalsDealsService) Patch(nameid string, deal *Deal) *BuyersProposalsDealsPatchCall {
	c := &BuyersProposalsDealsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.deal = deal
	return c
}

// UpdateMask sets the optional parameter "updateMask": List of fields to be
// updated. If empty or unspecified, the service will update all fields
// populated in the update request excluding the output only fields and
// primitive fields with default value. Note that explicit field mask is
// required in order to reset a primitive field back to its default value, for
// example, false for boolean fields, 0 for integer fields. A special field
// mask consisting of a single path "*" can be used to indicate full
// replacement(the equivalent of PUT method), updatable fields unset or
// unspecified in the input will be cleared or set to default value. Output
// only fields will be ignored regardless of the value of updateMask.
func (c *BuyersProposalsDealsPatchCall) UpdateMask(updateMask string) *BuyersProposalsDealsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersProposalsDealsPatchCall) Fields(s ...googleapi.Field) *BuyersProposalsDealsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersProposalsDealsPatchCall) Context(ctx context.Context) *BuyersProposalsDealsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersProposalsDealsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersProposalsDealsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.deal)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.proposals.deals.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Deal.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BuyersProposalsDealsPatchCall) Do(opts ...googleapi.CallOption) (*Deal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Deal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersPublisherProfilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the requested publisher profile by name.
//
//   - name: Name of the publisher profile. Format:
//     `buyers/{buyerId}/publisherProfiles/{publisherProfileId}`.
func (r *BuyersPublisherProfilesService) Get(name string) *BuyersPublisherProfilesGetCall {
	c := &BuyersPublisherProfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersPublisherProfilesGetCall) Fields(s ...googleapi.Field) *BuyersPublisherProfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersPublisherProfilesGetCall) IfNoneMatch(entityTag string) *BuyersPublisherProfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersPublisherProfilesGetCall) Context(ctx context.Context) *BuyersPublisherProfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersPublisherProfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersPublisherProfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.publisherProfiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PublisherProfile.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BuyersPublisherProfilesGetCall) Do(opts ...googleapi.CallOption) (*PublisherProfile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PublisherProfile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type BuyersPublisherProfilesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists publisher profiles. The returned publisher profiles aren't in
// any defined order. The order of the results might change. A new publisher
// profile can appear in any place in the list of returned results.
//
//   - parent: Parent that owns the collection of publisher profiles Format:
//     `buyers/{buyerId}`.
func (r *BuyersPublisherProfilesService) List(parent string) *BuyersPublisherProfilesListCall {
	c := &BuyersPublisherProfilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Optional query string using the
// [Cloud API list filtering]
// (https://developers.google.com/authorized-buyers/apis/guides/list-filters)
// syntax.
func (c *BuyersPublisherProfilesListCall) Filter(filter string) *BuyersPublisherProfilesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. If requested more than 500,
// the server will return 500 results per page. If unspecified, the server will
// pick a default page size of 100.
func (c *BuyersPublisherProfilesListCall) PageSize(pageSize int64) *BuyersPublisherProfilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token as
// returned from a previous ListPublisherProfilesResponse.
func (c *BuyersPublisherProfilesListCall) PageToken(pageToken string) *BuyersPublisherProfilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BuyersPublisherProfilesListCall) Fields(s ...googleapi.Field) *BuyersPublisherProfilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BuyersPublisherProfilesListCall) IfNoneMatch(entityTag string) *BuyersPublisherProfilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BuyersPublisherProfilesListCall) Context(ctx context.Context) *BuyersPublisherProfilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BuyersPublisherProfilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BuyersPublisherProfilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/publisherProfiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.buyers.publisherProfiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPublisherProfilesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BuyersPublisherProfilesListCall) Do(opts ...googleapi.CallOption) (*ListPublisherProfilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPublisherProfilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BuyersPublisherProfilesListCall) Pages(ctx context.Context, f func(*ListPublisherProfilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
