// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/apps/drive/activity/v2/target.proto

package activity

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This item is deprecated; please see `DriveFolder.Type` instead.
//
// Deprecated: Do not use.
type DriveItem_Folder_Type int32

const (
	// This item is deprecated; please see `DriveFolder.Type` instead.
	DriveItem_Folder_TYPE_UNSPECIFIED DriveItem_Folder_Type = 0
	// This item is deprecated; please see `DriveFolder.Type` instead.
	DriveItem_Folder_MY_DRIVE_ROOT DriveItem_Folder_Type = 1
	// This item is deprecated; please see `DriveFolder.Type` instead.
	DriveItem_Folder_TEAM_DRIVE_ROOT DriveItem_Folder_Type = 2
	// This item is deprecated; please see `DriveFolder.Type` instead.
	DriveItem_Folder_STANDARD_FOLDER DriveItem_Folder_Type = 3
)

// Enum value maps for DriveItem_Folder_Type.
var (
	DriveItem_Folder_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MY_DRIVE_ROOT",
		2: "TEAM_DRIVE_ROOT",
		3: "STANDARD_FOLDER",
	}
	DriveItem_Folder_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MY_DRIVE_ROOT":    1,
		"TEAM_DRIVE_ROOT":  2,
		"STANDARD_FOLDER":  3,
	}
)

func (x DriveItem_Folder_Type) Enum() *DriveItem_Folder_Type {
	p := new(DriveItem_Folder_Type)
	*p = x
	return p
}

func (x DriveItem_Folder_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DriveItem_Folder_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_target_proto_enumTypes[0].Descriptor()
}

func (DriveItem_Folder_Type) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_target_proto_enumTypes[0]
}

func (x DriveItem_Folder_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DriveItem_Folder_Type.Descriptor instead.
func (DriveItem_Folder_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{3, 1, 0}
}

// The type of a Drive folder.
type DriveItem_DriveFolder_Type int32

const (
	// The folder type is unknown.
	DriveItem_DriveFolder_TYPE_UNSPECIFIED DriveItem_DriveFolder_Type = 0
	// The folder is the root of a user's MyDrive.
	DriveItem_DriveFolder_MY_DRIVE_ROOT DriveItem_DriveFolder_Type = 1
	// The folder is the root of a shared drive.
	DriveItem_DriveFolder_SHARED_DRIVE_ROOT DriveItem_DriveFolder_Type = 2
	// The folder is a standard, non-root, folder.
	DriveItem_DriveFolder_STANDARD_FOLDER DriveItem_DriveFolder_Type = 3
)

// Enum value maps for DriveItem_DriveFolder_Type.
var (
	DriveItem_DriveFolder_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MY_DRIVE_ROOT",
		2: "SHARED_DRIVE_ROOT",
		3: "STANDARD_FOLDER",
	}
	DriveItem_DriveFolder_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":  0,
		"MY_DRIVE_ROOT":     1,
		"SHARED_DRIVE_ROOT": 2,
		"STANDARD_FOLDER":   3,
	}
)

func (x DriveItem_DriveFolder_Type) Enum() *DriveItem_DriveFolder_Type {
	p := new(DriveItem_DriveFolder_Type)
	*p = x
	return p
}

func (x DriveItem_DriveFolder_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DriveItem_DriveFolder_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_activity_v2_target_proto_enumTypes[1].Descriptor()
}

func (DriveItem_DriveFolder_Type) Type() protoreflect.EnumType {
	return &file_google_apps_drive_activity_v2_target_proto_enumTypes[1]
}

func (x DriveItem_DriveFolder_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DriveItem_DriveFolder_Type.Descriptor instead.
func (DriveItem_DriveFolder_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{3, 3, 0}
}

// Information about the target of activity.
//
// For more information on how activity history is shared with users, see
// [Activity history
// visibility](https://developers.google.com/drive/activity/v2#activityhistory).
type Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of target object.
	//
	// Types that are assignable to Object:
	//
	//	*Target_DriveItem
	//	*Target_Drive
	//	*Target_FileComment
	Object isTarget_Object `protobuf_oneof:"object"`
	// This field is deprecated; please use the `drive` field instead.
	//
	// Deprecated: Do not use.
	TeamDrive *TeamDrive `protobuf:"bytes,2,opt,name=team_drive,json=teamDrive,proto3" json:"team_drive,omitempty"`
}

func (x *Target) Reset() {
	*x = Target{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target) ProtoMessage() {}

func (x *Target) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target.ProtoReflect.Descriptor instead.
func (*Target) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{0}
}

func (m *Target) GetObject() isTarget_Object {
	if m != nil {
		return m.Object
	}
	return nil
}

func (x *Target) GetDriveItem() *DriveItem {
	if x, ok := x.GetObject().(*Target_DriveItem); ok {
		return x.DriveItem
	}
	return nil
}

func (x *Target) GetDrive() *Drive {
	if x, ok := x.GetObject().(*Target_Drive); ok {
		return x.Drive
	}
	return nil
}

func (x *Target) GetFileComment() *FileComment {
	if x, ok := x.GetObject().(*Target_FileComment); ok {
		return x.FileComment
	}
	return nil
}

// Deprecated: Do not use.
func (x *Target) GetTeamDrive() *TeamDrive {
	if x != nil {
		return x.TeamDrive
	}
	return nil
}

type isTarget_Object interface {
	isTarget_Object()
}

type Target_DriveItem struct {
	// The target is a Drive item.
	DriveItem *DriveItem `protobuf:"bytes,1,opt,name=drive_item,json=driveItem,proto3,oneof"`
}

type Target_Drive struct {
	// The target is a shared drive.
	Drive *Drive `protobuf:"bytes,5,opt,name=drive,proto3,oneof"`
}

type Target_FileComment struct {
	// The target is a comment on a Drive file.
	FileComment *FileComment `protobuf:"bytes,3,opt,name=file_comment,json=fileComment,proto3,oneof"`
}

func (*Target_DriveItem) isTarget_Object() {}

func (*Target_Drive) isTarget_Object() {}

func (*Target_FileComment) isTarget_Object() {}

// A lightweight reference to the target of activity.
type TargetReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of target object.
	//
	// Types that are assignable to Object:
	//
	//	*TargetReference_DriveItem
	//	*TargetReference_Drive
	Object isTargetReference_Object `protobuf_oneof:"object"`
	// This field is deprecated; please use the `drive` field instead.
	//
	// Deprecated: Do not use.
	TeamDrive *TeamDriveReference `protobuf:"bytes,2,opt,name=team_drive,json=teamDrive,proto3" json:"team_drive,omitempty"`
}

func (x *TargetReference) Reset() {
	*x = TargetReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetReference) ProtoMessage() {}

func (x *TargetReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetReference.ProtoReflect.Descriptor instead.
func (*TargetReference) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{1}
}

func (m *TargetReference) GetObject() isTargetReference_Object {
	if m != nil {
		return m.Object
	}
	return nil
}

func (x *TargetReference) GetDriveItem() *DriveItemReference {
	if x, ok := x.GetObject().(*TargetReference_DriveItem); ok {
		return x.DriveItem
	}
	return nil
}

func (x *TargetReference) GetDrive() *DriveReference {
	if x, ok := x.GetObject().(*TargetReference_Drive); ok {
		return x.Drive
	}
	return nil
}

// Deprecated: Do not use.
func (x *TargetReference) GetTeamDrive() *TeamDriveReference {
	if x != nil {
		return x.TeamDrive
	}
	return nil
}

type isTargetReference_Object interface {
	isTargetReference_Object()
}

type TargetReference_DriveItem struct {
	// The target is a Drive item.
	DriveItem *DriveItemReference `protobuf:"bytes,1,opt,name=drive_item,json=driveItem,proto3,oneof"`
}

type TargetReference_Drive struct {
	// The target is a shared drive.
	Drive *DriveReference `protobuf:"bytes,3,opt,name=drive,proto3,oneof"`
}

func (*TargetReference_DriveItem) isTargetReference_Object() {}

func (*TargetReference_Drive) isTargetReference_Object() {}

// A comment on a file.
type FileComment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The comment in the discussion thread. This identifier is an opaque string
	// compatible with the Drive API; see
	// https://developers.google.com/drive/v3/reference/comments/get
	LegacyCommentId string `protobuf:"bytes,1,opt,name=legacy_comment_id,json=legacyCommentId,proto3" json:"legacy_comment_id,omitempty"`
	// The discussion thread to which the comment was added. This identifier is an
	// opaque string compatible with the Drive API and references the first
	// comment in a discussion; see
	// https://developers.google.com/drive/v3/reference/comments/get
	LegacyDiscussionId string `protobuf:"bytes,2,opt,name=legacy_discussion_id,json=legacyDiscussionId,proto3" json:"legacy_discussion_id,omitempty"`
	// The link to the discussion thread containing this comment, for example,
	// `https://docs.google.com/DOCUMENT_ID/edit?disco=THREAD_ID`.
	LinkToDiscussion string `protobuf:"bytes,3,opt,name=link_to_discussion,json=linkToDiscussion,proto3" json:"link_to_discussion,omitempty"`
	// The Drive item containing this comment.
	Parent *DriveItem `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *FileComment) Reset() {
	*x = FileComment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileComment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileComment) ProtoMessage() {}

func (x *FileComment) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileComment.ProtoReflect.Descriptor instead.
func (*FileComment) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{2}
}

func (x *FileComment) GetLegacyCommentId() string {
	if x != nil {
		return x.LegacyCommentId
	}
	return ""
}

func (x *FileComment) GetLegacyDiscussionId() string {
	if x != nil {
		return x.LegacyDiscussionId
	}
	return ""
}

func (x *FileComment) GetLinkToDiscussion() string {
	if x != nil {
		return x.LinkToDiscussion
	}
	return ""
}

func (x *FileComment) GetParent() *DriveItem {
	if x != nil {
		return x.Parent
	}
	return nil
}

// A Drive item, such as a file or folder.
type DriveItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target Drive item. The format is `items/ITEM_ID`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The title of the Drive item.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// This field is deprecated; please use the `driveFile` field instead.
	//
	// Deprecated: Do not use.
	File *DriveItem_File `protobuf:"bytes,3,opt,name=file,proto3" json:"file,omitempty"`
	// This field is deprecated; please use the `driveFolder` field instead.
	//
	// Deprecated: Do not use.
	Folder *DriveItem_Folder `protobuf:"bytes,4,opt,name=folder,proto3" json:"folder,omitempty"`
	// If present, this describes the type of the Drive item.
	//
	// Types that are assignable to ItemType:
	//
	//	*DriveItem_DriveFile_
	//	*DriveItem_DriveFolder_
	ItemType isDriveItem_ItemType `protobuf_oneof:"item_type"`
	// The MIME type of the Drive item.  See
	// https://developers.google.com/drive/v3/web/mime-types.
	MimeType string `protobuf:"bytes,6,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Information about the owner of this Drive item.
	Owner *Owner `protobuf:"bytes,7,opt,name=owner,proto3" json:"owner,omitempty"`
}

func (x *DriveItem) Reset() {
	*x = DriveItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DriveItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DriveItem) ProtoMessage() {}

func (x *DriveItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DriveItem.ProtoReflect.Descriptor instead.
func (*DriveItem) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{3}
}

func (x *DriveItem) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DriveItem) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

// Deprecated: Do not use.
func (x *DriveItem) GetFile() *DriveItem_File {
	if x != nil {
		return x.File
	}
	return nil
}

// Deprecated: Do not use.
func (x *DriveItem) GetFolder() *DriveItem_Folder {
	if x != nil {
		return x.Folder
	}
	return nil
}

func (m *DriveItem) GetItemType() isDriveItem_ItemType {
	if m != nil {
		return m.ItemType
	}
	return nil
}

func (x *DriveItem) GetDriveFile() *DriveItem_DriveFile {
	if x, ok := x.GetItemType().(*DriveItem_DriveFile_); ok {
		return x.DriveFile
	}
	return nil
}

func (x *DriveItem) GetDriveFolder() *DriveItem_DriveFolder {
	if x, ok := x.GetItemType().(*DriveItem_DriveFolder_); ok {
		return x.DriveFolder
	}
	return nil
}

func (x *DriveItem) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *DriveItem) GetOwner() *Owner {
	if x != nil {
		return x.Owner
	}
	return nil
}

type isDriveItem_ItemType interface {
	isDriveItem_ItemType()
}

type DriveItem_DriveFile_ struct {
	// The Drive item is a file.
	DriveFile *DriveItem_DriveFile `protobuf:"bytes,8,opt,name=drive_file,json=driveFile,proto3,oneof"`
}

type DriveItem_DriveFolder_ struct {
	// The Drive item is a folder. Includes information about the type of
	// folder.
	DriveFolder *DriveItem_DriveFolder `protobuf:"bytes,9,opt,name=drive_folder,json=driveFolder,proto3,oneof"`
}

func (*DriveItem_DriveFile_) isDriveItem_ItemType() {}

func (*DriveItem_DriveFolder_) isDriveItem_ItemType() {}

// Information about the owner of a Drive item.
type Owner struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the Drive item.
	//
	// Types that are assignable to Owner:
	//
	//	*Owner_User
	//	*Owner_Drive
	Owner isOwner_Owner `protobuf_oneof:"owner"`
	// This field is deprecated; please use the `drive` field instead.
	//
	// Deprecated: Do not use.
	TeamDrive *TeamDriveReference `protobuf:"bytes,2,opt,name=team_drive,json=teamDrive,proto3" json:"team_drive,omitempty"`
	// The domain of the Drive item owner.
	Domain *Domain `protobuf:"bytes,3,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *Owner) Reset() {
	*x = Owner{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Owner) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Owner) ProtoMessage() {}

func (x *Owner) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Owner.ProtoReflect.Descriptor instead.
func (*Owner) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{4}
}

func (m *Owner) GetOwner() isOwner_Owner {
	if m != nil {
		return m.Owner
	}
	return nil
}

func (x *Owner) GetUser() *User {
	if x, ok := x.GetOwner().(*Owner_User); ok {
		return x.User
	}
	return nil
}

func (x *Owner) GetDrive() *DriveReference {
	if x, ok := x.GetOwner().(*Owner_Drive); ok {
		return x.Drive
	}
	return nil
}

// Deprecated: Do not use.
func (x *Owner) GetTeamDrive() *TeamDriveReference {
	if x != nil {
		return x.TeamDrive
	}
	return nil
}

func (x *Owner) GetDomain() *Domain {
	if x != nil {
		return x.Domain
	}
	return nil
}

type isOwner_Owner interface {
	isOwner_Owner()
}

type Owner_User struct {
	// The user that owns the Drive item.
	User *User `protobuf:"bytes,1,opt,name=user,proto3,oneof"`
}

type Owner_Drive struct {
	// The drive that owns the item.
	Drive *DriveReference `protobuf:"bytes,4,opt,name=drive,proto3,oneof"`
}

func (*Owner_User) isOwner_Owner() {}

func (*Owner_Drive) isOwner_Owner() {}

// This item is deprecated; please see `Drive` instead.
//
// Deprecated: Do not use.
type TeamDrive struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field is deprecated; please see `Drive.name` instead.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field is deprecated; please see `Drive.title` instead.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// This field is deprecated; please see `Drive.root` instead.
	Root *DriveItem `protobuf:"bytes,3,opt,name=root,proto3" json:"root,omitempty"`
}

func (x *TeamDrive) Reset() {
	*x = TeamDrive{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TeamDrive) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TeamDrive) ProtoMessage() {}

func (x *TeamDrive) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TeamDrive.ProtoReflect.Descriptor instead.
func (*TeamDrive) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{5}
}

func (x *TeamDrive) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TeamDrive) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *TeamDrive) GetRoot() *DriveItem {
	if x != nil {
		return x.Root
	}
	return nil
}

// Information about a shared drive.
type Drive struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the shared drive. The format is
	// `COLLECTION_ID/DRIVE_ID`. Clients should not assume a specific collection
	// ID for this resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The title of the shared drive.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// The root of this shared drive.
	Root *DriveItem `protobuf:"bytes,3,opt,name=root,proto3" json:"root,omitempty"`
}

func (x *Drive) Reset() {
	*x = Drive{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Drive) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Drive) ProtoMessage() {}

func (x *Drive) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Drive.ProtoReflect.Descriptor instead.
func (*Drive) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{6}
}

func (x *Drive) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Drive) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Drive) GetRoot() *DriveItem {
	if x != nil {
		return x.Root
	}
	return nil
}

// A lightweight reference to a Drive item, such as a file or folder.
type DriveItemReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target Drive item. The format is `items/ITEM_ID`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The title of the Drive item.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// This field is deprecated; please use the `driveFile` field instead.
	//
	// Deprecated: Do not use.
	File *DriveItem_File `protobuf:"bytes,3,opt,name=file,proto3" json:"file,omitempty"`
	// This field is deprecated; please use the `driveFolder` field instead.
	//
	// Deprecated: Do not use.
	Folder *DriveItem_Folder `protobuf:"bytes,4,opt,name=folder,proto3" json:"folder,omitempty"`
	// If present, this describes the type of the Drive item.
	//
	// Types that are assignable to ItemType:
	//
	//	*DriveItemReference_DriveFile
	//	*DriveItemReference_DriveFolder
	ItemType isDriveItemReference_ItemType `protobuf_oneof:"item_type"`
}

func (x *DriveItemReference) Reset() {
	*x = DriveItemReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DriveItemReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DriveItemReference) ProtoMessage() {}

func (x *DriveItemReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DriveItemReference.ProtoReflect.Descriptor instead.
func (*DriveItemReference) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{7}
}

func (x *DriveItemReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DriveItemReference) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

// Deprecated: Do not use.
func (x *DriveItemReference) GetFile() *DriveItem_File {
	if x != nil {
		return x.File
	}
	return nil
}

// Deprecated: Do not use.
func (x *DriveItemReference) GetFolder() *DriveItem_Folder {
	if x != nil {
		return x.Folder
	}
	return nil
}

func (m *DriveItemReference) GetItemType() isDriveItemReference_ItemType {
	if m != nil {
		return m.ItemType
	}
	return nil
}

func (x *DriveItemReference) GetDriveFile() *DriveItem_DriveFile {
	if x, ok := x.GetItemType().(*DriveItemReference_DriveFile); ok {
		return x.DriveFile
	}
	return nil
}

func (x *DriveItemReference) GetDriveFolder() *DriveItem_DriveFolder {
	if x, ok := x.GetItemType().(*DriveItemReference_DriveFolder); ok {
		return x.DriveFolder
	}
	return nil
}

type isDriveItemReference_ItemType interface {
	isDriveItemReference_ItemType()
}

type DriveItemReference_DriveFile struct {
	// The Drive item is a file.
	DriveFile *DriveItem_DriveFile `protobuf:"bytes,8,opt,name=drive_file,json=driveFile,proto3,oneof"`
}

type DriveItemReference_DriveFolder struct {
	// The Drive item is a folder. Includes information about the type of
	// folder.
	DriveFolder *DriveItem_DriveFolder `protobuf:"bytes,9,opt,name=drive_folder,json=driveFolder,proto3,oneof"`
}

func (*DriveItemReference_DriveFile) isDriveItemReference_ItemType() {}

func (*DriveItemReference_DriveFolder) isDriveItemReference_ItemType() {}

// This item is deprecated; please see `DriveReference` instead.
//
// Deprecated: Do not use.
type TeamDriveReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field is deprecated; please see `DriveReference.name` instead.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field is deprecated; please see `DriveReference.title` instead.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
}

func (x *TeamDriveReference) Reset() {
	*x = TeamDriveReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TeamDriveReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TeamDriveReference) ProtoMessage() {}

func (x *TeamDriveReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TeamDriveReference.ProtoReflect.Descriptor instead.
func (*TeamDriveReference) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{8}
}

func (x *TeamDriveReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TeamDriveReference) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

// A lightweight reference to a shared drive.
type DriveReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the shared drive. The format is
	// `COLLECTION_ID/DRIVE_ID`. Clients should not assume a specific collection
	// ID for this resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The title of the shared drive.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
}

func (x *DriveReference) Reset() {
	*x = DriveReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DriveReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DriveReference) ProtoMessage() {}

func (x *DriveReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DriveReference.ProtoReflect.Descriptor instead.
func (*DriveReference) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{9}
}

func (x *DriveReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DriveReference) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

// This item is deprecated; please see `DriveFile` instead.
//
// Deprecated: Do not use.
type DriveItem_File struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DriveItem_File) Reset() {
	*x = DriveItem_File{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DriveItem_File) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DriveItem_File) ProtoMessage() {}

func (x *DriveItem_File) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DriveItem_File.ProtoReflect.Descriptor instead.
func (*DriveItem_File) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{3, 0}
}

// This item is deprecated; please see `DriveFolder` instead.
//
// Deprecated: Do not use.
type DriveItem_Folder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field is deprecated; please see `DriveFolder.type` instead.
	Type DriveItem_Folder_Type `protobuf:"varint,6,opt,name=type,proto3,enum=google.apps.drive.activity.v2.DriveItem_Folder_Type" json:"type,omitempty"`
}

func (x *DriveItem_Folder) Reset() {
	*x = DriveItem_Folder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DriveItem_Folder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DriveItem_Folder) ProtoMessage() {}

func (x *DriveItem_Folder) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DriveItem_Folder.ProtoReflect.Descriptor instead.
func (*DriveItem_Folder) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{3, 1}
}

func (x *DriveItem_Folder) GetType() DriveItem_Folder_Type {
	if x != nil {
		return x.Type
	}
	return DriveItem_Folder_TYPE_UNSPECIFIED
}

// A Drive item which is a file.
type DriveItem_DriveFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DriveItem_DriveFile) Reset() {
	*x = DriveItem_DriveFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DriveItem_DriveFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DriveItem_DriveFile) ProtoMessage() {}

func (x *DriveItem_DriveFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DriveItem_DriveFile.ProtoReflect.Descriptor instead.
func (*DriveItem_DriveFile) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{3, 2}
}

// A Drive item which is a folder.
type DriveItem_DriveFolder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of Drive folder.
	Type DriveItem_DriveFolder_Type `protobuf:"varint,6,opt,name=type,proto3,enum=google.apps.drive.activity.v2.DriveItem_DriveFolder_Type" json:"type,omitempty"`
}

func (x *DriveItem_DriveFolder) Reset() {
	*x = DriveItem_DriveFolder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DriveItem_DriveFolder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DriveItem_DriveFolder) ProtoMessage() {}

func (x *DriveItem_DriveFolder) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_activity_v2_target_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DriveItem_DriveFolder.ProtoReflect.Descriptor instead.
func (*DriveItem_DriveFolder) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_activity_v2_target_proto_rawDescGZIP(), []int{3, 3}
}

func (x *DriveItem_DriveFolder) GetType() DriveItem_DriveFolder_Type {
	if x != nil {
		return x.Type
	}
	return DriveItem_DriveFolder_TYPE_UNSPECIFIED
}

var File_google_apps_drive_activity_v2_target_proto protoreflect.FileDescriptor

var file_google_apps_drive_activity_v2_target_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x32, 0x2f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x1a, 0x29, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xb9, 0x02, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x49, 0x0a,
	0x0a, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x48, 0x00, 0x52, 0x09, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x3c, 0x0a, 0x05, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x48, 0x00, 0x52,
	0x05, 0x64, 0x72, 0x69, 0x76, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65,
	0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0a, 0x74, 0x65, 0x61, 0x6d, 0x5f,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x61, 0x6d,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x74, 0x65, 0x61, 0x6d, 0x44,
	0x72, 0x69, 0x76, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x8c,
	0x02, 0x0a, 0x0f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x52, 0x0a, 0x0a, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x45, 0x0a, 0x05, 0x64, 0x72, 0x69, 0x76, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x05, 0x64, 0x72, 0x69, 0x76, 0x65, 0x12, 0x54, 0x0a,
	0x0a, 0x74, 0x65, 0x61, 0x6d, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x65, 0x61, 0x6d, 0x44, 0x72, 0x69, 0x76, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x74, 0x65, 0x61, 0x6d, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xdb, 0x01,
	0x0a, 0x0b, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a,
	0x11, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79,
	0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x6c, 0x65, 0x67,
	0x61, 0x63, 0x79, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x44,
	0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x6c,
	0x69, 0x6e, 0x6b, 0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x6f, 0x44,
	0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49,
	0x74, 0x65, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xec, 0x06, 0x0a, 0x09,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x12, 0x45, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x46, 0x69, 0x6c, 0x65,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65,
	0x49, 0x74, 0x65, 0x6d, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0a, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x48,
	0x00, 0x52, 0x09, 0x64, 0x72, 0x69, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x59, 0x0a, 0x0c,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x44, 0x72, 0x69,
	0x76, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x1a, 0x0a, 0x0a, 0x04, 0x46, 0x69, 0x6c, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0xb5, 0x01, 0x0a,
	0x06, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x48, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x2e,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x22, 0x5d, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x0d, 0x4d, 0x59, 0x5f, 0x44, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x52, 0x4f, 0x4f, 0x54,
	0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x45, 0x41, 0x4d, 0x5f, 0x44, 0x52, 0x49, 0x56, 0x45,
	0x5f, 0x52, 0x4f, 0x4f, 0x54, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x4e, 0x44,
	0x41, 0x52, 0x44, 0x5f, 0x46, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x10, 0x03, 0x1a, 0x02, 0x18, 0x01,
	0x3a, 0x02, 0x18, 0x01, 0x1a, 0x0b, 0x0a, 0x09, 0x44, 0x72, 0x69, 0x76, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x1a, 0xb9, 0x01, 0x0a, 0x0b, 0x44, 0x72, 0x69, 0x76, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x12, 0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x22, 0x5b, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11,
	0x0a, 0x0d, 0x4d, 0x59, 0x5f, 0x44, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x52, 0x4f, 0x4f, 0x54, 0x10,
	0x01, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x44, 0x52, 0x49, 0x56,
	0x45, 0x5f, 0x52, 0x4f, 0x4f, 0x54, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x4e,
	0x44, 0x41, 0x52, 0x44, 0x5f, 0x46, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x10, 0x03, 0x42, 0x0b, 0x0a,
	0x09, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xa7, 0x02, 0x0a, 0x05, 0x4f,
	0x77, 0x6e, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x48, 0x00, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12,
	0x45, 0x0a, 0x05, 0x64, 0x72, 0x69, 0x76, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x72, 0x69, 0x76, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52,
	0x05, 0x64, 0x72, 0x69, 0x76, 0x65, 0x12, 0x54, 0x0a, 0x0a, 0x74, 0x65, 0x61, 0x6d, 0x5f, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x61, 0x6d, 0x44,
	0x72, 0x69, 0x76, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x09, 0x74, 0x65, 0x61, 0x6d, 0x44, 0x72, 0x69, 0x76, 0x65, 0x12, 0x3d, 0x0a, 0x06,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x22, 0x77, 0x0a, 0x09, 0x54, 0x65, 0x61, 0x6d, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x72,
	0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49,
	0x74, 0x65, 0x6d, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x6f, 0x0a,
	0x05, 0x44, 0x72, 0x69, 0x76, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x12, 0x3c, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x22, 0x8f,
	0x03, 0x0a, 0x12, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12,
	0x45, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d,
	0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0a, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65,
	0x6d, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x09, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x59, 0x0a, 0x0c, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x72, 0x69, 0x76, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x46, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x42, 0x0b, 0x0a, 0x09, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x22, 0x42, 0x0a, 0x12, 0x54, 0x65, 0x61, 0x6d, 0x44, 0x72, 0x69, 0x76, 0x65, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x3a, 0x02, 0x18, 0x01, 0x22, 0x3a, 0x0a, 0x0e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x42, 0xc0, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x32, 0x42, 0x0b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x70,
	0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2f, 0x76, 0x32, 0x3b, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0xa2, 0x02, 0x04, 0x47,
	0x41, 0x44, 0x41, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70,
	0x73, 0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x56, 0x32, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70,
	0x73, 0x5c, 0x44, 0x72, 0x69, 0x76, 0x65, 0x5c, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x5c, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_drive_activity_v2_target_proto_rawDescOnce sync.Once
	file_google_apps_drive_activity_v2_target_proto_rawDescData = file_google_apps_drive_activity_v2_target_proto_rawDesc
)

func file_google_apps_drive_activity_v2_target_proto_rawDescGZIP() []byte {
	file_google_apps_drive_activity_v2_target_proto_rawDescOnce.Do(func() {
		file_google_apps_drive_activity_v2_target_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_drive_activity_v2_target_proto_rawDescData)
	})
	return file_google_apps_drive_activity_v2_target_proto_rawDescData
}

var file_google_apps_drive_activity_v2_target_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_apps_drive_activity_v2_target_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_apps_drive_activity_v2_target_proto_goTypes = []interface{}{
	(DriveItem_Folder_Type)(0),      // 0: google.apps.drive.activity.v2.DriveItem.Folder.Type
	(DriveItem_DriveFolder_Type)(0), // 1: google.apps.drive.activity.v2.DriveItem.DriveFolder.Type
	(*Target)(nil),                  // 2: google.apps.drive.activity.v2.Target
	(*TargetReference)(nil),         // 3: google.apps.drive.activity.v2.TargetReference
	(*FileComment)(nil),             // 4: google.apps.drive.activity.v2.FileComment
	(*DriveItem)(nil),               // 5: google.apps.drive.activity.v2.DriveItem
	(*Owner)(nil),                   // 6: google.apps.drive.activity.v2.Owner
	(*TeamDrive)(nil),               // 7: google.apps.drive.activity.v2.TeamDrive
	(*Drive)(nil),                   // 8: google.apps.drive.activity.v2.Drive
	(*DriveItemReference)(nil),      // 9: google.apps.drive.activity.v2.DriveItemReference
	(*TeamDriveReference)(nil),      // 10: google.apps.drive.activity.v2.TeamDriveReference
	(*DriveReference)(nil),          // 11: google.apps.drive.activity.v2.DriveReference
	(*DriveItem_File)(nil),          // 12: google.apps.drive.activity.v2.DriveItem.File
	(*DriveItem_Folder)(nil),        // 13: google.apps.drive.activity.v2.DriveItem.Folder
	(*DriveItem_DriveFile)(nil),     // 14: google.apps.drive.activity.v2.DriveItem.DriveFile
	(*DriveItem_DriveFolder)(nil),   // 15: google.apps.drive.activity.v2.DriveItem.DriveFolder
	(*User)(nil),                    // 16: google.apps.drive.activity.v2.User
	(*Domain)(nil),                  // 17: google.apps.drive.activity.v2.Domain
}
var file_google_apps_drive_activity_v2_target_proto_depIdxs = []int32{
	5,  // 0: google.apps.drive.activity.v2.Target.drive_item:type_name -> google.apps.drive.activity.v2.DriveItem
	8,  // 1: google.apps.drive.activity.v2.Target.drive:type_name -> google.apps.drive.activity.v2.Drive
	4,  // 2: google.apps.drive.activity.v2.Target.file_comment:type_name -> google.apps.drive.activity.v2.FileComment
	7,  // 3: google.apps.drive.activity.v2.Target.team_drive:type_name -> google.apps.drive.activity.v2.TeamDrive
	9,  // 4: google.apps.drive.activity.v2.TargetReference.drive_item:type_name -> google.apps.drive.activity.v2.DriveItemReference
	11, // 5: google.apps.drive.activity.v2.TargetReference.drive:type_name -> google.apps.drive.activity.v2.DriveReference
	10, // 6: google.apps.drive.activity.v2.TargetReference.team_drive:type_name -> google.apps.drive.activity.v2.TeamDriveReference
	5,  // 7: google.apps.drive.activity.v2.FileComment.parent:type_name -> google.apps.drive.activity.v2.DriveItem
	12, // 8: google.apps.drive.activity.v2.DriveItem.file:type_name -> google.apps.drive.activity.v2.DriveItem.File
	13, // 9: google.apps.drive.activity.v2.DriveItem.folder:type_name -> google.apps.drive.activity.v2.DriveItem.Folder
	14, // 10: google.apps.drive.activity.v2.DriveItem.drive_file:type_name -> google.apps.drive.activity.v2.DriveItem.DriveFile
	15, // 11: google.apps.drive.activity.v2.DriveItem.drive_folder:type_name -> google.apps.drive.activity.v2.DriveItem.DriveFolder
	6,  // 12: google.apps.drive.activity.v2.DriveItem.owner:type_name -> google.apps.drive.activity.v2.Owner
	16, // 13: google.apps.drive.activity.v2.Owner.user:type_name -> google.apps.drive.activity.v2.User
	11, // 14: google.apps.drive.activity.v2.Owner.drive:type_name -> google.apps.drive.activity.v2.DriveReference
	10, // 15: google.apps.drive.activity.v2.Owner.team_drive:type_name -> google.apps.drive.activity.v2.TeamDriveReference
	17, // 16: google.apps.drive.activity.v2.Owner.domain:type_name -> google.apps.drive.activity.v2.Domain
	5,  // 17: google.apps.drive.activity.v2.TeamDrive.root:type_name -> google.apps.drive.activity.v2.DriveItem
	5,  // 18: google.apps.drive.activity.v2.Drive.root:type_name -> google.apps.drive.activity.v2.DriveItem
	12, // 19: google.apps.drive.activity.v2.DriveItemReference.file:type_name -> google.apps.drive.activity.v2.DriveItem.File
	13, // 20: google.apps.drive.activity.v2.DriveItemReference.folder:type_name -> google.apps.drive.activity.v2.DriveItem.Folder
	14, // 21: google.apps.drive.activity.v2.DriveItemReference.drive_file:type_name -> google.apps.drive.activity.v2.DriveItem.DriveFile
	15, // 22: google.apps.drive.activity.v2.DriveItemReference.drive_folder:type_name -> google.apps.drive.activity.v2.DriveItem.DriveFolder
	0,  // 23: google.apps.drive.activity.v2.DriveItem.Folder.type:type_name -> google.apps.drive.activity.v2.DriveItem.Folder.Type
	1,  // 24: google.apps.drive.activity.v2.DriveItem.DriveFolder.type:type_name -> google.apps.drive.activity.v2.DriveItem.DriveFolder.Type
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_apps_drive_activity_v2_target_proto_init() }
func file_google_apps_drive_activity_v2_target_proto_init() {
	if File_google_apps_drive_activity_v2_target_proto != nil {
		return
	}
	file_google_apps_drive_activity_v2_actor_proto_init()
	file_google_apps_drive_activity_v2_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_apps_drive_activity_v2_target_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Target); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TargetReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileComment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DriveItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Owner); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TeamDrive); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Drive); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DriveItemReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TeamDriveReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DriveReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DriveItem_File); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DriveItem_Folder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DriveItem_DriveFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_activity_v2_target_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DriveItem_DriveFolder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_apps_drive_activity_v2_target_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Target_DriveItem)(nil),
		(*Target_Drive)(nil),
		(*Target_FileComment)(nil),
	}
	file_google_apps_drive_activity_v2_target_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*TargetReference_DriveItem)(nil),
		(*TargetReference_Drive)(nil),
	}
	file_google_apps_drive_activity_v2_target_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*DriveItem_DriveFile_)(nil),
		(*DriveItem_DriveFolder_)(nil),
	}
	file_google_apps_drive_activity_v2_target_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Owner_User)(nil),
		(*Owner_Drive)(nil),
	}
	file_google_apps_drive_activity_v2_target_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*DriveItemReference_DriveFile)(nil),
		(*DriveItemReference_DriveFolder)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_drive_activity_v2_target_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_drive_activity_v2_target_proto_goTypes,
		DependencyIndexes: file_google_apps_drive_activity_v2_target_proto_depIdxs,
		EnumInfos:         file_google_apps_drive_activity_v2_target_proto_enumTypes,
		MessageInfos:      file_google_apps_drive_activity_v2_target_proto_msgTypes,
	}.Build()
	File_google_apps_drive_activity_v2_target_proto = out.File
	file_google_apps_drive_activity_v2_target_proto_rawDesc = nil
	file_google_apps_drive_activity_v2_target_proto_goTypes = nil
	file_google_apps_drive_activity_v2_target_proto_depIdxs = nil
}
