// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/synonymset.proto

package contentwarehouse

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents a list of synonyms for a given context.
// For example a context "sales" could contain:
// Synonym 1: sale, invoice, bill, order
// Synonym 2: money, credit, finance, payment
// Synonym 3: shipping, freight, transport
// Each SynonymSets should be disjoint
type SynonymSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the SynonymSet
	// This is mandatory for google.api.resource.
	// Format:
	// projects/{project_number}/locations/{location}/synonymSets/{context}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a freeform field. Example contexts can be "sales," "engineering,"
	// "real estate," "accounting," etc.
	// The context can be supplied during search requests.
	Context string `protobuf:"bytes,2,opt,name=context,proto3" json:"context,omitempty"`
	// List of Synonyms for the context.
	Synonyms []*SynonymSet_Synonym `protobuf:"bytes,3,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
}

func (x *SynonymSet) Reset() {
	*x = SynonymSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_synonymset_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SynonymSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynonymSet) ProtoMessage() {}

func (x *SynonymSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_synonymset_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynonymSet.ProtoReflect.Descriptor instead.
func (*SynonymSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDescGZIP(), []int{0}
}

func (x *SynonymSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SynonymSet) GetContext() string {
	if x != nil {
		return x.Context
	}
	return ""
}

func (x *SynonymSet) GetSynonyms() []*SynonymSet_Synonym {
	if x != nil {
		return x.Synonyms
	}
	return nil
}

// Represents a list of words given by the customer
// All these words are synonyms of each other.
type SynonymSet_Synonym struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For example: sale, invoice, bill, order
	Words []string `protobuf:"bytes,1,rep,name=words,proto3" json:"words,omitempty"`
}

func (x *SynonymSet_Synonym) Reset() {
	*x = SynonymSet_Synonym{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_synonymset_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SynonymSet_Synonym) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynonymSet_Synonym) ProtoMessage() {}

func (x *SynonymSet_Synonym) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_synonymset_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynonymSet_Synonym.ProtoReflect.Descriptor instead.
func (*SynonymSet_Synonym) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SynonymSet_Synonym) GetWords() []string {
	if x != nil {
		return x.Words
	}
	return nil
}

var File_google_cloud_contentwarehouse_v1_synonymset_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x9d, 0x02, 0x0a, 0x0a, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x50, 0x0a,
	0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x2e, 0x53, 0x79,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x1a,
	0x1f, 0x0a, 0x07, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x6f,
	0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73,
	0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65,
	0x74, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x79, 0x6e, 0x6f, 0x6e,
	0x79, 0x6d, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x7d,
	0x42, 0x8b, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72,
	0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x53, 0x79, 0x6e, 0x6f, 0x6e,
	0x79, 0x6d, 0x53, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDescData = file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_synonymset_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_contentwarehouse_v1_synonymset_proto_goTypes = []interface{}{
	(*SynonymSet)(nil),         // 0: google.cloud.contentwarehouse.v1.SynonymSet
	(*SynonymSet_Synonym)(nil), // 1: google.cloud.contentwarehouse.v1.SynonymSet.Synonym
}
var file_google_cloud_contentwarehouse_v1_synonymset_proto_depIdxs = []int32{
	1, // 0: google.cloud.contentwarehouse.v1.SynonymSet.synonyms:type_name -> google.cloud.contentwarehouse.v1.SynonymSet.Synonym
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_synonymset_proto_init() }
func file_google_cloud_contentwarehouse_v1_synonymset_proto_init() {
	if File_google_cloud_contentwarehouse_v1_synonymset_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_synonymset_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SynonymSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_synonymset_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SynonymSet_Synonym); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_synonymset_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_synonymset_proto_depIdxs,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_synonymset_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_synonymset_proto = out.File
	file_google_cloud_contentwarehouse_v1_synonymset_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_synonymset_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_synonymset_proto_depIdxs = nil
}
